/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class PartitionedRegionLocalMaxMemoryDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static String prPrefix = null;
    static int MAX_REGIONS = 1;
    int localMaxMemory = 1;
    VM[] vm = new VM[4];

    public PartitionedRegionLocalMaxMemoryDUnitTest(String name) {
        super(name);
    }

    public void testLocalMaxMemoryInPartitionedRegion() {
        Host host = Host.getHost(0);
        this.vm[0] = host.getVM(0);
        this.vm[1] = host.getVM(1);
        this.vm[2] = null;
        this.vm[3] = null;
        prPrefix = "testLocalMaxMemoryInPartitionedRegion";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 2;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 1;
        boolean redundancy = true;
        System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 1, false);
        System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(3600000));
        this.putFromOneVm(this.vm[0], true);
        this.putFromOneVm(this.vm[0], false);
        this.destroyRegion(this.vm[0]);
    }

    public void testLocalMaxMemoryInPartitionedRegionWithEviction() {
        Host host = Host.getHost(0);
        this.vm[0] = host.getVM(0);
        this.vm[1] = host.getVM(1);
        this.vm[2] = null;
        this.vm[3] = null;
        prPrefix = "testLocalMaxMemoryInPartitionedRegion";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 2;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 1;
        boolean redundancy = true;
        System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 1, true);
        System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(3600000));
        this.putFromOneVm(this.vm[0], true);
        this.putFromOneVm(this.vm[0], true);
        this.destroyRegion(this.vm[0]);
    }

    private void putFromOneVm(VM vm, boolean objectFlg) {
        vm.invoke(this.putObjectInPartitionRegion(objectFlg));
    }

    private CacheSerializableRunnable putObjectInPartitionRegion(final boolean objectFlg) {
        CacheSerializableRunnable putObject = new CacheSerializableRunnable("putObject"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionLocalMaxMemoryDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/testLocalMaxMemoryInPartitionedRegion0");
                TestCase.assertNotNull((String)("Name of region : " + pr.getName()), (Object)pr);
                int i = 0;
                if (objectFlg) {
                    long size = 0L;
                    while ((size = pr.getDataStore().currentAllocatedMemory()) < 0x100000L) {
                        cache.getLogger().info("size: " + size);
                        DeltaTestImpl.TestObject1 obj = new DeltaTestImpl.TestObject1("testObject1" + i, 10);
                        pr.put((Object)obj, (Object)obj);
                        ++i;
                    }
                    TestCase.assertEquals((int)1, (int)pr.getDataStore().localBucket2RegionMap.size());
                    DistributedTestCase.getLogWriter().info("putObjectInPartitionRegion() - Put operation done successfully");
                } else {
                    String expectedExceptions = PartitionedRegionStorageException.class.getName();
                    PartitionedRegionLocalMaxMemoryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                    try {
                        DeltaTestImpl.TestObject1 kv = new DeltaTestImpl.TestObject1("testObject1" + i, 21);
                        pr.put((Object)kv, (Object)kv);
                        TestCase.fail((String)"Bucket gets created even if no memory is available");
                    }
                    catch (PartitionedRegionStorageException e) {
                        DistributedTestCase.getLogWriter().info("putObjectInPartitionRegion()- got correct PartitionedRegionStorageException while creating bucket when no memory is available");
                    }
                    PartitionedRegionLocalMaxMemoryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                }
            }
        };
        return putObject;
    }

    private void createPartitionRegion(List vmList, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy, boolean evict) {
        for (VM vm : vmList) {
            vm.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, redundancy, localMaxMemory, evict));
        }
    }

    private List addNodeToList(int startIndexForNode, int endIndexForNode) {
        ArrayList<VM> localvmList = new ArrayList<VM>();
        for (int i = startIndexForNode; i < endIndexForNode; ++i) {
            localvmList.add(this.vm[i]);
        }
        return localvmList;
    }

    private void createVMs(Host host) {
        for (int i = 0; i < 4; ++i) {
            this.vm[i] = host.getVM(i);
        }
    }

    private void destroyRegion(VM vm) {
        CacheSerializableRunnable destroyObj = new CacheSerializableRunnable("destroyObj"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionLocalMaxMemoryDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/testLocalMaxMemoryInPartitionedRegion0");
                TestCase.assertNotNull((String)("Name of region : " + pr.getName()), (Object)pr);
                pr.destroyRegion();
            }
        };
        vm.invoke(destroyObj);
    }
}

