/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionSystemMemberRegionListenerDUnitTest;
import com.gemstone.gemfire.internal.concurrent.AR;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.HostHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionedRegionHARedundancyMgmtDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static final int TOTAL_NUM_BUCKETS = 11;
    static AR singleToneAdmin = CFactory.createAR();

    public PartitionedRegionHARedundancyMgmtDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoResourceAlertThrottle() throws Exception {
        DistributedTestCase.ExpectedException ee;
        VM adminVM;
        block6: {
            Host host = Host.getHost(0);
            VM accessor = host.getVM(0);
            adminVM = host.getVM(3);
            final String prPrefix = this.getUniqueName();
            boolean redundancy = false;
            long throttleTimeNanos = PRHARedundancyProvider.INSUFFICIENT_LOGGING_THROTTLE_TIME;
            Runnable assertOneWarning = this.createWarningAlertRunnable(1);
            ee = null;
            AsyncInvocation slowPuts = null;
            try {
                Boolean b = (Boolean)adminVM.invoke(this.createAdminVMCreationCallable());
                PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)b);
                accessor.invoke(this.createPRWithRetryTimeoutPropSet(prPrefix, 0, 0, 3600000));
                ee = PartitionedRegionHARedundancyMgmtDUnitTest.addExpectedException(PartitionedRegionStorageException.class.getName());
                slowPuts = accessor.invokeAsync(new CacheSerializableRunnable("Slow failing put"){

                    @Override
                    public void run2() throws CacheException {
                        Cache cache = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                        Region pr = cache.getRegion(prPrefix);
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(200L);
                                    pr.put((Object)"key", (Object)"val");
                                }
                            }
                            catch (PartitionedRegionStorageException partitionedRegionStorageException) {
                                continue;
                            }
                            catch (InterruptedException unexpected) {
                                TestCase.fail((String)"interrupted");
                                continue;
                            }
                            catch (CacheClosedException quit) {
                            }
                            catch (RegionDestroyedException quit) {
                            }
                            break;
                        }
                    }
                });
                adminVM.invoke(assertOneWarning);
                long start = NanoTimer.getTime();
                adminVM.invoke(assertOneWarning);
                long delta = NanoTimer.getTime() - start;
                delta = TimeUnit.NANOSECONDS.toMillis(delta);
                throttleTimeNanos = TimeUnit.NANOSECONDS.toMillis(throttleTimeNanos);
                if (delta < throttleTimeNanos && throttleTimeNanos - delta < 10L) {
                    PartitionedRegionHARedundancyMgmtDUnitTest.fail((String)("Alert throttle failed, delta=" + delta + "ns, throttletime=" + throttleTimeNanos + "ns"));
                }
                if (slowPuts == null) break block6;
                accessor.invoke(new CacheSerializableRunnable("destroy " + prPrefix, prPrefix){
                    final /* synthetic */ String val$prPrefix;
                    {
                        this.val$prPrefix = string;
                        super(name);
                    }

                    @Override
                    public void run2() throws CacheException {
                        PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache().getRegion(this.val$prPrefix).destroyRegion();
                    }
                });
            }
            catch (Throwable throwable) {
                if (slowPuts != null) {
                    accessor.invoke(new /* invalid duplicate definition of identical inner class */);
                    DistributedTestCase.join(slowPuts, 5000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
                }
                if (ee != null) {
                    ee.remove();
                }
                adminVM.invoke(this.createCleanUpAdminDS());
                throw throwable;
            }
            DistributedTestCase.join(slowPuts, 5000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
        }
        if (ee != null) {
            ee.remove();
        }
        adminVM.invoke(this.createCleanUpAdminDS());
    }

    public void testInsufficientResourceAlerts() throws Exception {
        this.runInsufficientResourceAlerts(false);
    }

    public void testInsufficientResourceAlertsWithTimeoutProperty() throws Exception {
        this.runInsufficientResourceAlerts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInsufficientResourceAlerts(boolean useTimeout) throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM adminVM = host.getVM(3);
        DistributedTestCase.ExpectedException ee = null;
        try {
            final String prPrefix = this.getUniqueName();
            SerializableCallable assertBucketCreation = this.createAssertBucketCreation(prPrefix);
            int retryTime = 600000;
            boolean redundancy = true;
            CacheSerializableRunnable createAccessor = this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 0, 600000);
            CacheSerializableRunnable createPR = this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 10, 600000);
            ee = this.runNoDSAndOneDSTest(adminVM, accessor, datastore1, createAccessor, createPR, assertBucketCreation, useTimeout);
            datastore2.invoke(createPR);
            long begin = System.currentTimeMillis();
            while (true) {
                try {
                    datastore2.invoke(assertBucketCreation);
                }
                catch (RuntimeException e) {
                    if (System.currentTimeMillis() - begin < 30000L) {
                        Thread.sleep(100L);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            SerializableCallable assertNoRedundancyRisk = new SerializableCallable("assertNoRedundancyAtRisk"){

                public Object call() throws Exception {
                    Cache c = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                    PartitionedRegion pr = (PartitionedRegion)c.getRegion(prPrefix);
                    TestCase.assertEquals((int)0, (int)pr.getPrStats().getLowRedundancyBucketCount());
                    return Boolean.TRUE;
                }
            };
            accessor.invoke(assertNoRedundancyRisk);
            datastore1.invoke(assertNoRedundancyRisk);
            datastore2.invoke(assertNoRedundancyRisk);
        }
        finally {
            if (ee != null) {
                ee.remove();
            }
            try {
                this.unsetTestMode();
            }
            finally {
                adminVM.invoke(this.createCleanUpAdminDS());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsufficientResourceAlertsWithEnforceUniqueStorageAllocation() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM adminVM = host.getVM(3);
        DistributedTestCase.ExpectedException ee = null;
        try {
            CacheSerializableRunnable enforceUniqueStorage = new CacheSerializableRunnable("setEnforceUniqueHostStorageAllocation"){

                @Override
                public void run2() throws CacheException {
                    Properties props = new Properties();
                    props.setProperty("enforce-unique-host", "true");
                    PartitionedRegionHARedundancyMgmtDUnitTest.this.getSystem(props);
                }
            };
            accessor.invoke(enforceUniqueStorage);
            datastore1.invoke(enforceUniqueStorage);
            datastore2.invoke(enforceUniqueStorage);
            String prPrefix = this.getUniqueName();
            SerializableCallable assertBucketCreation = this.createAssertBucketCreation(prPrefix);
            int retryTime = 600000;
            boolean redundancy = true;
            CacheSerializableRunnable createAccessor = this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 0, 600000);
            CacheSerializableRunnable createPR = this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 10, 600000);
            ee = this.runNoDSAndOneDSTest(adminVM, accessor, datastore1, createAccessor, createPR, assertBucketCreation, false);
            datastore2.invoke(createPR);
            datastore2.invoke(this.createAssertNoBucketCreation(prPrefix));
            SerializableCallable assertRedundancyRisk = this.createAssertRedundancyRisk(prPrefix);
            accessor.invoke(assertRedundancyRisk);
            datastore1.invoke(assertRedundancyRisk);
            datastore2.invoke(assertRedundancyRisk);
        }
        catch (Throwable throwable) {
            CacheSerializableRunnable allowNonUniqueStorage = new CacheSerializableRunnable("unsetEnforceUniqueHostStorageAllocation"){

                @Override
                public void run2() throws CacheException {
                    CacheTestCase.disconnectFromDS();
                }
            };
            accessor.invoke(allowNonUniqueStorage);
            datastore1.invoke(allowNonUniqueStorage);
            datastore2.invoke(allowNonUniqueStorage);
            if (ee != null) {
                ee.remove();
            }
            try {
                this.unsetTestMode();
            }
            finally {
                adminVM.invoke(this.createCleanUpAdminDS());
            }
            throw throwable;
        }
        CacheSerializableRunnable allowNonUniqueStorage = new /* invalid duplicate definition of identical inner class */;
        accessor.invoke(allowNonUniqueStorage);
        datastore1.invoke(allowNonUniqueStorage);
        datastore2.invoke(allowNonUniqueStorage);
        if (ee != null) {
            ee.remove();
        }
        try {
            this.unsetTestMode();
        }
        finally {
            adminVM.invoke(this.createCleanUpAdminDS());
        }
    }

    private DistributedTestCase.ExpectedException runNoDSAndOneDSTest(VM adminVM, VM accessor, VM datastore1, Runnable createAccessor, Runnable createPR, SerializableCallable assertBucketCreation, final boolean testDataStoreRecoveryTimeout) throws Exception {
        this.setTestMode();
        Boolean b = (Boolean)adminVM.invoke(this.createAdminVMCreationCallable());
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)b);
        final String prPrefix = this.getUniqueName();
        accessor.invoke(createAccessor);
        DistributedTestCase.ExpectedException ee = PartitionedRegionHARedundancyMgmtDUnitTest.addExpectedException(PRHARedundancyProvider.SUFFICIENT_STORES_MSG.toLocalizedString());
        CacheSerializableRunnable createABucket = new CacheSerializableRunnable("create a bucket"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache c = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                Region r = c.getRegion(prPrefix);
                TestCase.assertNotNull((Object)r);
                try {
                    Long dataStoreRecoveryTimeout = new Long(300L);
                    long startTime = NanoTimer.getTime();
                    if (testDataStoreRecoveryTimeout) {
                        PRHARedundancyProvider.DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS = dataStoreRecoveryTimeout;
                    }
                    try {
                        r.put((Object)new Integer(1), (Object)Boolean.TRUE);
                    }
                    catch (PartitionedRegionStorageException boom) {
                        if (testDataStoreRecoveryTimeout) {
                            long duration = TimeUnit.NANOSECONDS.toMillis(NanoTimer.getTime() - startTime);
                            TestCase.assertTrue((String)("Duration is too long: " + duration + " ms"), (duration <= dataStoreRecoveryTimeout * 2L ? 1 : 0) != 0);
                            DistributedTestCase.getLogWriter().info("Duration is: " + TimeUnit.NANOSECONDS.toMillis(duration) + " ms when recovery timeout is set to " + dataStoreRecoveryTimeout);
                        }
                        throw boom;
                    }
                    if (testDataStoreRecoveryTimeout) {
                        long duration = NanoTimer.getTime() - startTime;
                        TestCase.assertTrue((duration >= dataStoreRecoveryTimeout ? 1 : 0) != 0);
                    }
                }
                finally {
                    if (testDataStoreRecoveryTimeout) {
                        PRHARedundancyProvider.DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS = null;
                    }
                }
            }
        };
        Runnable checkForWarningAlert = this.createWarningAlertRunnable(1);
        AsyncInvocation getAlert = adminVM.invokeAsync(checkForWarningAlert);
        PartitionedRegionHARedundancyMgmtDUnitTest.pause(30000);
        AsyncInvocation pendingBucketCreation = accessor.invokeAsync(createABucket);
        DistributedTestCase.join(getAlert, 30000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((!getAlert.isAlive() ? 1 : 0) != 0);
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((!getAlert.exceptionOccurred() ? 1 : 0) != 0);
        DistributedTestCase.join(pendingBucketCreation, 30000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)pendingBucketCreation.exceptionOccurred());
        Throwable t = pendingBucketCreation.getException();
        PartitionedRegionHARedundancyMgmtDUnitTest.assertEquals(PartitionedRegionStorageException.class, t.getClass());
        String msg = t.getMessage();
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((msg.lastIndexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) >= 0 ? 1 : 0) != 0);
        datastore1.invoke(createPR);
        b = (Boolean)datastore1.invoke(this.createAssertNoBucketCreation(prPrefix));
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)b);
        getAlert = adminVM.invokeAsync(checkForWarningAlert);
        accessor.invoke(createABucket);
        datastore1.invoke(assertBucketCreation);
        SerializableCallable assertRedundancyRisk = this.createAssertRedundancyRisk(prPrefix);
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)((Boolean)accessor.invoke(assertRedundancyRisk)));
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((boolean)((Boolean)datastore1.invoke(assertRedundancyRisk)));
        DistributedTestCase.join(getAlert, 30000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((!getAlert.isAlive() ? 1 : 0) != 0);
        PartitionedRegionHARedundancyMgmtDUnitTest.assertTrue((!getAlert.exceptionOccurred() ? 1 : 0) != 0);
        return ee;
    }

    private Runnable createWarningAlertRunnable(final int expectedAlerts) {
        return new SerializableRunnable("checkForWarningAlert"){

            @Override
            public void run() {
                AdminDistributedSystem ads = (AdminDistributedSystem)singleToneAdmin.get();
                TestCase.assertNotNull((Object)ads);
                PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener tal = PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener.getInstance();
                try {
                    tal.waitForEventsWithSeverity(expectedAlerts, 900);
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted");
                }
                Alert[] al = tal.getAlerts();
                int numMatches = 0;
                LogWriter l = DistributedTestCase.getLogWriter();
                for (int i = 0; i < al.length; ++i) {
                    String msg = al[i].getMessage();
                    l.info("Alert found with message: " + msg);
                    if (msg == null || msg.lastIndexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) < 0) continue;
                    ++numMatches;
                }
                TestCase.assertEquals((int)expectedAlerts, (int)numMatches);
                tal.resetList();
            }
        };
    }

    private SerializableCallable createAdminVMCreationCallable() {
        return new SerializableCallable("createAdminVM"){

            public Object call() throws Exception {
                AdminDistributedSystem adminDS = PartitionedRegionHARedundancyMgmtDUnitTest.this.createAdminDistributedSystem(AlertLevel.WARNING);
                PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener tal = PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener.getInstance();
                tal.resetList();
                adminDS.addAlertListener((AlertListener)tal);
                TestCase.assertEquals((int)0, (int)tal.getAlertCount());
                singleToneAdmin.set((Object)adminDS);
                return Boolean.TRUE;
            }
        };
    }

    private SerializableCallable createCleanUpAdminDS() {
        return new SerializableCallable("cleanUpAdminDS"){

            public Object call() throws Exception {
                AdminDistributedSystem ads;
                PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener tal = PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener.getInstance();
                if (tal != null) {
                    tal.resetList();
                }
                if ((ads = (AdminDistributedSystem)singleToneAdmin.get()) != null) {
                    ads.disconnect();
                }
                DistributionManager.isDedicatedAdminVM = false;
                CacheTestCase.disconnectFromDS();
                return Boolean.TRUE;
            }
        };
    }

    private SerializableCallable createAssertRedundancyRisk(final String prPrefix) {
        return new SerializableCallable("assertRedundancyAtRisk"){

            public Object call() throws Exception {
                Cache c = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)c.getRegion(prPrefix);
                TestCase.assertEquals((int)1, (int)pr.getPrStats().getLowRedundancyBucketCount());
                return Boolean.TRUE;
            }
        };
    }

    private SerializableCallable createAssertNoBucketCreation(final String prPrefix) {
        return new SerializableCallable("assertNoBucketCreation"){

            public Object call() throws Exception {
                Cache c = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)c.getRegion(prPrefix);
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((int)0, (int)pr.getDataStore().getBucketsManaged());
                return Boolean.TRUE;
            }
        };
    }

    private SerializableCallable createAssertBucketCreation(final String prPrefix) {
        return new SerializableCallable("assertBucketCreation"){

            public Object call() throws Exception {
                Cache c = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)c.getRegion(prPrefix);
                TestCase.assertEquals((int)1, (int)pr.getDataStore().getBucketsManaged());
                return Boolean.TRUE;
            }
        };
    }

    private void setTestMode() {
        PartitionedRegionHARedundancyMgmtDUnitTest.invokeInEveryVM(new SerializableCallable("setTestMode"){

            public Object call() throws Exception {
                PRHARedundancyProvider.TEST_MODE = true;
                return Boolean.TRUE;
            }
        });
    }

    private void unsetTestMode() {
        PartitionedRegionHARedundancyMgmtDUnitTest.invokeInEveryVM(new SerializableCallable("unsetTestMode"){

            public Object call() throws Exception {
                PRHARedundancyProvider.TEST_MODE = false;
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedundancyMgmtInPartitionedRegion() throws Throwable {
        AdminDistributedSystem adminDS = null;
        try {
            Host host = Host.getHost(0);
            VM dataStore0 = host.getVM(0);
            VM dataStore1 = host.getVM(1);
            VM dataStore2 = host.getVM(2);
            adminDS = this.createAdminDistributedSystem(AlertLevel.WARNING);
            PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener tal = PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener.getInstance();
            tal.resetList();
            adminDS.addAlertListener((AlertListener)tal);
            PartitionedRegionHARedundancyMgmtDUnitTest.assertEquals((int)0, (int)tal.getAlertCount());
            final String prPrefix = this.getUniqueName();
            boolean startIndexForKey = false;
            int endIndexForKey = 11;
            boolean redundancy = true;
            int localMaxMemory = 200;
            int smallRetryTimeout = 20000;
            dataStore0.invoke(this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 200, 20000));
            this.putInPRFromOneVm(dataStore0, 0, 11, prPrefix);
            tal.waitForEventsWithSeverity(11, 900);
            Alert[] al = tal.getAlerts();
            int numMatches = 0;
            LogWriter l = PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter();
            for (int i = 0; i < al.length; ++i) {
                String msg = al[i].getMessage();
                l.info("Alert found with message: " + msg);
                if (msg == null || msg.lastIndexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) < 0) continue;
                ++numMatches;
            }
            PartitionedRegionHARedundancyMgmtDUnitTest.assertEquals((int)11, (int)numMatches);
            dataStore0.invoke(this.validateBuckets(11, prPrefix));
            dataStore1.invoke(this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 200, 3600000));
            dataStore0.invoke(this.validateBuckets(11, prPrefix));
            dataStore1.invoke(this.validateBuckets(11, prPrefix));
            dataStore0.invoke(new SerializableRunnable("validate contents"){

                @Override
                public void run() {
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache().getRegion("/" + prPrefix);
                    TestCase.assertNotNull((String)"This region cannot be null", (Object)pr);
                    for (int j = pr.getRedundantCopies() - 1; j >= 0; --j) {
                        List be = null;
                        try {
                            be = pr.getAllBucketEntries(j);
                        }
                        catch (ForceReattemptException e) {
                            DistributedTestCase.fail("surprise exception", e);
                        }
                        BucketDump e1 = null;
                        BucketDump e2 = null;
                        Iterator beI = be.iterator();
                        while (beI.hasNext()) {
                            if (e2 != null && e1 != null && !e1.equals(e2) && !e2.equals((Object)e1)) {
                                StringBuffer sb = new StringBuffer("e1 contents:\n");
                                for (Map.Entry me : e1.getValues().entrySet()) {
                                    sb.append(me.getKey() + "=>" + me.getValue() + "\n");
                                }
                                sb.append("e2 contents:\n");
                                for (Map.Entry me : e2.getValues().entrySet()) {
                                    sb.append(me.getKey() + "=>" + me.getValue() + "\n");
                                }
                                DistributedTestCase.getLogWriter().info(sb.toString());
                                TestCase.assertTrue((String)("e1  " + e1 + " not equal to " + e2), (boolean)false);
                            }
                            e2 = e1;
                            e1 = (BucketDump)beI.next();
                        }
                    }
                }
            });
            dataStore2.invoke(this.createPRWithRetryTimeoutPropSet(prPrefix, 1, 200, 3600000));
            dataStore2.invoke(this.validateBuckets(0, prPrefix));
            dataStore0.invoke(new CacheSerializableRunnable("destroyRegion"){

                @Override
                public void run2() throws CacheException {
                    Cache cache = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + prPrefix);
                    TestCase.assertNotNull((Object)pr);
                    pr.destroyRegion();
                }
            });
        }
        finally {
            PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener tal;
            if (adminDS != null) {
                adminDS.disconnect();
            }
            if ((tal = PartitionedRegionSystemMemberRegionListenerDUnitTest.TestAlertListener.getInstance()) != null) {
                tal.resetList();
            }
            DistributionManager.isDedicatedAdminVM = false;
            PartitionedRegionHARedundancyMgmtDUnitTest.disconnectFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AdminDistributedSystem createAdminDistributedSystem(final AlertLevel alertLevel) throws AdminException {
        DistributionConfig config2 = this.getSystem().getConfig();
        PartitionedRegionHARedundancyMgmtDUnitTest.assertFalse((config2.getMcastPort() == 10334 ? 1 : 0) != 0);
        String address = HostHelper.getHostAddress(config2.getMcastAddress());
        int port = config2.getMcastPort();
        String locators = "";
        if (config2.getLocators().length() > 0) {
            locators = config2.getLocators();
            PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter().info("Using Locators: " + locators);
        }
        PartitionedRegionHARedundancyMgmtDUnitTest.disconnectFromDS();
        boolean setupFailed = true;
        try {
            DistributionManager.isDedicatedAdminVM = true;
            PartitionedRegionHARedundancyMgmtDUnitTest.assertFalse((boolean)this.isConnectedToDS());
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
            config.setMcastAddress(address);
            config.setMcastPort(port);
            config.setLocators(locators);
            config.setRemoteCommand("rsh -n {HOST} {CMD}");
            final AdminDistributedSystemImpl ret = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
            ret.connect(PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter().convertToLogWriterI18n());
            if (!ret.getAlertLevel().equals((Object)alertLevel)) {
                ret.setAlertLevel(alertLevel);
            }
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return ret.isConnected();
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
            final DistributedMember adminMemberId = ret.getDistributedMember();
            CacheSerializableRunnable verifyRegistration = new CacheSerializableRunnable("Verify listener for " + this.getName()){

                @Override
                public void run2() throws CacheException {
                    InternalDistributedSystem ds = PartitionedRegionHARedundancyMgmtDUnitTest.this.getSystem();
                    int waitTime = 100;
                    long maxWaitFail = 60000L;
                    long startTime = System.currentTimeMillis();
                    while (!ds.hasAlertListenerFor(adminMemberId, alertLevel.getSeverity())) {
                        if (System.currentTimeMillis() - startTime > 60000L) {
                            TestCase.fail((String)("Waited over 60000 ms for " + this + " to complete"));
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            TestCase.fail((String)("Interrupted waiting in " + this));
                        }
                    }
                }
            };
            PartitionedRegionHARedundancyMgmtDUnitTest.invokeInEveryVM(verifyRegistration);
            setupFailed = false;
            AdminDistributedSystemImpl adminDistributedSystemImpl = ret;
            return adminDistributedSystemImpl;
        }
        finally {
            if (setupFailed) {
                PartitionedRegionHARedundancyMgmtDUnitTest.disconnectAllFromDS();
            }
        }
    }

    private CacheSerializableRunnable validateBuckets(final int exptNumBuckets, final String prefix) {
        return new CacheSerializableRunnable("validateBucketNumbers"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + prefix);
                TestCase.assertNotNull((String)"This region cannot be null", (Object)pr);
                long start = System.currentTimeMillis();
                while (exptNumBuckets != pr.getDataStore().localBucket2RegionMap.size()) {
                    if (System.currentTimeMillis() - start > 30000L) {
                        TestCase.fail((String)("Found unexpected number of buckets " + pr.getDataStore().localBucket2RegionMap.size() + ", expected " + exptNumBuckets + " buckets are: " + pr.getDataStore().localBucket2RegionMap.keySet()));
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        TestCase.fail((String)"Interrupted");
                    }
                }
            }
        };
    }

    private void putInPRFromOneVm(VM vm0, int startIndexForKey, int endIndexForKey, String rName) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 2;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.putFromOneVm(startIndexForKey, endIndexForKey, rName));
        async[1] = vm0.invokeAsync(this.putFromOneVm(startIndexForKey + 11, endIndexForKey + 11, rName));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionHARedundancyMgmtDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            Throwable t = async[count].getException();
            if (t.getClass().equals(PartitionedRegionStorageException.class)) {
                throw t;
            }
            PartitionedRegionHARedundancyMgmtDUnitTest.fail("putInPRFromOneVM has exception in async run " + count, t);
        }
    }

    private CacheSerializableRunnable putFromOneVm(final int startIndexForKey, final int endIndexForKey, final String prefix) {
        CacheSerializableRunnable putFromVm = new CacheSerializableRunnable("putFromOneVm"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                String expectedExceptions = PartitionedRegionStorageException.class.getName();
                PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                DistributedTestCase.getLogWriter().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                Region pr = cache.getRegion(prefix);
                TestCase.assertNotNull((String)("This region is null : " + pr.getName()), (Object)pr);
                for (int k = startIndexForKey; k < endIndexForKey; ++k) {
                    Integer key = new Integer(k);
                    pr.put((Object)key, (Object)(prefix + k));
                }
                DistributedTestCase.getLogWriter().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
            }
        };
        return putFromVm;
    }

    CacheSerializableRunnable createPRWithRetryTimeoutPropSet(final String prPrefix, final int redundancy, final int maxMemory, final int retryTimeout) {
        return new CacheSerializableRunnable("createPRWithTotalNumBucketPropSet"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHARedundancyMgmtDUnitTest.this.getCache();
                System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(retryTimeout));
                Region partitionedregion = cache.createRegion(prPrefix, PartitionedRegionHARedundancyMgmtDUnitTest.this.createRegionAttrs(redundancy, maxMemory));
                TestCase.assertNotNull((Object)partitionedregion);
                TestCase.assertFalse((boolean)partitionedregion.isDestroyed());
                System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(3600000));
            }
        };
    }

    protected RegionAttributes createRegionAttrs(int red, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PARTITION);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(red).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(11).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }
}

