/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionedRegionHADUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    Properties props = new Properties();
    static volatile int regionCnt = 0;
    static final int MAX_REGIONS = 1;
    final int totalNumBuckets = 5;

    public PartitionedRegionHADUnitTest(String name) {
        super(name);
    }

    public void testBucketFailOverDuringCacheClose() throws Exception {
        final String regionName = this.getUniqueName();
        final Boolean value = new Boolean(true);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("createRegion"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                final CountDownLatch rebalancingFinished = new CountDownLatch(1);
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new InternalResourceManager.ResourceObserverAdapter(){

                    public void rebalancingOrRecoveryFinished(Region region) {
                        rebalancingFinished.countDown();
                    }
                });
                try {
                    Region partitionedregion = cache.createRegion(regionName, PartitionedRegionHADUnitTest.this.createRegionAttributesForPR(1, 20));
                    if (!rebalancingFinished.await(60000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"Redundancy recovery did not happen within 60 seconds");
                    }
                    TestCase.assertNotNull((Object)partitionedregion);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
                finally {
                    InternalResourceManager.setResourceObserver(null);
                }
            }
        };
        vm2.invoke(createPR);
        vm3.invoke(createPR);
        vm3.invoke(new CacheSerializableRunnable("createPRBuckets"){

            @Override
            public void run2() throws CacheException {
                int numEntries;
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                TestCase.assertTrue((boolean)pr.isEmpty());
                for (int i = numEntries = pr.getTotalNumberOfBuckets() * 2; i >= 0; --i) {
                    Integer k = new Integer(i);
                    pr.put((Object)k, (Object)value);
                }
                TestCase.assertEquals((int)(numEntries + 1), (int)pr.size());
                TestCase.assertEquals((int)pr.getRegionAdvisor().getBucketSet().size(), (int)pr.getTotalNumberOfBuckets());
            }
        });
        CacheSerializableRunnable existsEntryCheck = new CacheSerializableRunnable("PRExistsEntryCheck"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                for (int i = pr.getTotalNumberOfBuckets() * 2; i >= 0; --i) {
                    Integer k = new Integer(i);
                    TestCase.assertTrue((String)("containsKey for key=" + k), (boolean)pr.containsKey((Object)k));
                    TestCase.assertEquals((String)("get for key=" + k), (Object)value, (Object)pr.get((Object)k));
                }
            }
        };
        vm3.invoke(existsEntryCheck);
        vm2.invoke(existsEntryCheck);
        CacheSerializableRunnable closeCache = new CacheSerializableRunnable("PRCloseCache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                cache.close();
            }
        };
        vm2.invoke(closeCache);
        vm3.invoke(existsEntryCheck);
        vm0.invoke(createPR);
        vm0.invoke(existsEntryCheck);
        vm3.invoke(closeCache);
        vm0.invoke(existsEntryCheck);
        vm1.invoke(createPR);
        vm1.invoke(existsEntryCheck);
        vm0.invoke(existsEntryCheck);
    }

    public void testGrabBackupBuckets() throws Throwable {
        Host host = Host.getHost(0);
        VM dataStore0 = host.getVM(0);
        VM dataStore2 = host.getVM(2);
        VM accessor = host.getVM(3);
        boolean redundantCopies = true;
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                final CountDownLatch recoveryDone = new CountDownLatch(1);
                InternalResourceManager.ResourceObserverAdapter waitForRecovery = new InternalResourceManager.ResourceObserverAdapter(){

                    public void rebalancingOrRecoveryFinished(Region region) {
                        recoveryDone.countDown();
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)waitForRecovery);
                try {
                    Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                    System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
                    for (int i = 0; i < 1; ++i) {
                        cache.createRegion(PartitionedRegionHADUnitTest.PR_PREFIX + i, PartitionedRegionHADUnitTest.this.createRegionAttributesForPR(1, 200));
                    }
                    System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(3600000));
                    if (!recoveryDone.await(60L, TimeUnit.SECONDS)) {
                        TestCase.fail((String)"recovery didn't happen in 60 seconds");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("recovery wait interrupted", e);
                }
                finally {
                    InternalResourceManager.setResourceObserver(null);
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(PartitionedRegionHADUnitTest.PR_PREFIX + i, PartitionedRegionHADUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        dataStore0.invoke(createPRs);
        final String expectedExceptions = PartitionedRegionStorageException.class.getName();
        CacheSerializableRunnable addExpectedExceptions = new CacheSerializableRunnable("addExpectedExceptions"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionHADUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                DistributedTestCase.getLogWriter().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
            }
        };
        CacheSerializableRunnable removeExpectedExceptions = new CacheSerializableRunnable("removeExpectedExceptions"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                PartitionedRegionHADUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
            }
        };
        CacheSerializableRunnable dataStore0Puts = new CacheSerializableRunnable("dataStore0PutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 10; ++k) {
                        pr.put((Object)(j + PartitionedRegionHADUnitTest.PR_PREFIX + k), (Object)(PartitionedRegionHADUnitTest.PR_PREFIX + k));
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        };
        CacheSerializableRunnable dataStore1Puts = new CacheSerializableRunnable("dataStore1PutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 10; k < 20; ++k) {
                        pr.put((Object)(j + PartitionedRegionHADUnitTest.PR_PREFIX + k), (Object)(PartitionedRegionHADUnitTest.PR_PREFIX + k));
                    }
                    DistributedTestCase.getLogWriter().info("VM1 Done put successfully for PR = PR" + j);
                }
            }
        };
        dataStore0.invoke(addExpectedExceptions);
        AsyncInvocation async0 = dataStore0.invokeAsync(dataStore0Puts);
        DistributedTestCase.join(async0, 30000L, PartitionedRegionHADUnitTest.getLogWriter());
        dataStore0.invoke(removeExpectedExceptions);
        PartitionedRegionHADUnitTest.assertFalse((boolean)async0.exceptionOccurred());
        dataStore2.invoke(createPRs);
        async0 = dataStore0.invokeAsync(dataStore0Puts);
        DistributedTestCase.join(async0, 30000L, PartitionedRegionHADUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            PartitionedRegionHADUnitTest.fail("async0 failed", async0.getException());
        }
        accessor.invoke(createAccessor);
        for (int c = 0; c < 1; ++c) {
            final Integer ri = new Integer(c);
            SerializableCallable validateLocalBucket2RegionMapSize = new SerializableCallable("validateLocalBucket2RegionMapSize"){

                public Object call() throws Exception {
                    short size = 0;
                    Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + ri);
                    if (pr.getDataStore() != null) {
                        size = pr.getDataStore().getBucketsManaged();
                    }
                    return new Integer(size);
                }
            };
            SerializableCallable validateBucketsOnNode = new SerializableCallable("validateBucketOnNode"){

                public Object call() throws Exception {
                    int containsNode = 0;
                    Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + ri);
                    Iterator it = pr.getRegionAdvisor().getBucketSet().iterator();
                    try {
                        while (it.hasNext()) {
                            Integer bucketId = (Integer)it.next();
                            Set nodeList = pr.getRegionAdvisor().getBucketOwners(bucketId.intValue());
                            if (nodeList != null && nodeList.contains(pr.getMyId())) {
                                ++containsNode;
                                continue;
                            }
                            PartitionedRegionHADUnitTest.this.getCache().getLogger().fine("I don't contain member " + pr.getMyId());
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    return new Integer(containsNode);
                }
            };
            int vm2LBRsize = (Integer)dataStore2.invoke(validateLocalBucket2RegionMapSize);
            int vm3LBRsize = (Integer)accessor.invoke(validateLocalBucket2RegionMapSize);
            PartitionedRegionHADUnitTest.assertFalse((vm2LBRsize == 0 ? 1 : 0) != 0);
            PartitionedRegionHADUnitTest.assertFalse((vm3LBRsize != 0 ? 1 : 0) != 0);
            int vm2B2Nsize = (Integer)dataStore2.invoke(validateBucketsOnNode);
            PartitionedRegionHADUnitTest.getLogWriter().info("vm2B2Nsize = " + vm2B2Nsize);
            PartitionedRegionHADUnitTest.assertEquals((int)vm2B2Nsize, (int)vm2LBRsize);
        }
    }

    public void testBucketsScope() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String PR_ZeroRedundancy = "PR_ZeroRedundancy";
        String PR_SingleRedundancy = "PR_SingleRedundancy";
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegionWithZeroRed"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                cache.createRegion("PR_ZeroRedundancy", PartitionedRegionHADUnitTest.this.createRegionAttributesForPR(0, 200));
                cache.createRegion("PR_SingleRedundancy", PartitionedRegionHADUnitTest.this.createRegionAttributesForPR(1, 200));
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm0.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                String regionName = "PR_ZeroRedundancy";
                Region pr = cache.getRegion("/" + regionName);
                TestCase.assertNotNull((Object)pr);
                for (int k = 0; k < 10; ++k) {
                    pr.put((Object)(k + ""), (Object)(k + ""));
                }
                cache.getLogger().fine("VM0 Done put successfully for PR = " + regionName);
                regionName = "PR_SingleRedundancy";
                Region pr1 = cache.getRegion("/" + regionName);
                TestCase.assertNotNull((Object)pr1);
                for (int k = 0; k < 10; ++k) {
                    pr1.put((Object)(k + ""), (Object)(k + ""));
                }
                cache.getLogger().fine("VM0 Done put successfully for PR = " + regionName);
            }
        });
        CacheSerializableRunnable validateBucketScope = new CacheSerializableRunnable("validateBucketScope"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionHADUnitTest.this.getCache();
                String regionName = "PR_ZeroRedundancy";
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + regionName);
                for (BucketRegion bucket : pr.getDataStore().localBucket2RegionMap.values()) {
                    TestCase.assertTrue((boolean)bucket.getAttributes().getScope().isDistributedAck());
                }
                regionName = "PR_SingleRedundancy";
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("/" + regionName);
                for (Region bucket : pr1.getDataStore().localBucket2RegionMap.values()) {
                    TestCase.assertEquals((Object)DataPolicy.REPLICATE, (Object)bucket.getAttributes().getDataPolicy());
                }
            }
        };
        vm0.invoke(validateBucketScope);
        vm1.invoke(validateBucketScope);
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }
}

