/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EvictionStatsDUnitTest;
import java.util.Properties;

public class OffHeapEvictionStatsDUnitTest
extends EvictionStatsDUnitTest {
    public OffHeapEvictionStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties properties = super.getDistributedSystemProperties();
        properties.setProperty("off-heap-memory-size", "100m");
        return properties;
    }

    @Override
    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            OffHeapEvictionStatsDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(this.getDistributedSystemProperties());
            cache = CacheFactory.create((DistributedSystem)ds);
            OffHeapEvictionStatsDUnitTest.assertNotNull((Object)cache);
            OffHeapEvictionStatsDUnitTest.getLogWriter().info("cache= " + cache);
            OffHeapEvictionStatsDUnitTest.getLogWriter().info("cache closed= " + cache.isClosed());
            cache.getResourceManager().setEvictionOffHeapPercentage(20.0f);
            OffHeapEvictionStatsDUnitTest.getLogWriter().info("eviction= " + cache.getResourceManager().getEvictionOffHeapPercentage());
            OffHeapEvictionStatsDUnitTest.getLogWriter().info("critical= " + cache.getResourceManager().getCriticalOffHeapPercentage());
        }
        catch (Exception e) {
            OffHeapEvictionStatsDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    @Override
    public boolean isOffHeapEnabled() {
        return true;
    }
}

