/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Iterator;
import junit.framework.TestCase;

public class IteratorDUnitTest
extends CacheTestCase {
    public IteratorDUnitTest(String name) {
        super(name);
    }

    public void testKeysIteratorOnLR() throws Exception {
        String regionName = this.getUniqueName();
        Region r = this.getGemfireCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
        r.put((Object)"key", (Object)"value");
        r.put((Object)"key2", (Object)"value2");
        r.put((Object)"key3", (Object)"value3");
        LocalRegion lr = (LocalRegion)r;
        lr.getRegionMap().getEntry((Object)"key").setValue((RegionEntryContext)lr, (Object)Token.REMOVED_PHASE1);
        Iterator it = r.keySet().iterator();
        int numKeys = 0;
        while (it.hasNext()) {
            it.next();
            ++numKeys;
        }
        IteratorDUnitTest.assertEquals((int)2, (int)numKeys);
    }

    public void testKeysIteratorOnPR() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        final String regionName = this.getUniqueName();
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                IteratorDUnitTest.this.getGemfireCache().createRegionFactory(RegionShortcut.PARTITION_PROXY).create(regionName);
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = IteratorDUnitTest.this.getGemfireCache().createRegionFactory(RegionShortcut.PARTITION).create(regionName);
                r.put((Object)"key", (Object)"value");
                r.put((Object)"key2", (Object)"value2");
                r.put((Object)"key3", (Object)"value3");
                PartitionedRegion pr = (PartitionedRegion)r;
                BucketRegion br = pr.getBucketRegion((Object)"key");
                TestCase.assertNotNull((Object)br);
                br.getRegionMap().getEntry((Object)"key").setValue((RegionEntryContext)pr, (Object)Token.REMOVED_PHASE1);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = IteratorDUnitTest.this.getGemfireCache().getRegion(regionName);
                Iterator it = r.keySet().iterator();
                int numKeys = 0;
                while (it.hasNext()) {
                    it.next();
                    ++numKeys;
                }
                TestCase.assertEquals((int)2, (int)numKeys);
                return null;
            }
        });
    }
}

