/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.internal.util.TransformUtils;
import com.gemstone.gemfire.internal.util.Transformer;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.ClassBuilder;

public class IncrementalBackupDUnitTest
extends CacheTestCase {
    private static final int DATA_INCREMENT = 10000;
    private int dataStart = 0;
    private int dataEnd = this.dataStart + 10000;
    private static final String OPLOG_REGEX = ".*\\.[kdc]rf$";
    private final SerializableRunnable createRegions = new SerializableRunnable(){

        @Override
        public void run() {
            Cache cache = IncrementalBackupDUnitTest.this.getCache(new CacheFactory().set("log-level", DistributedTestCase.getDUnitLogLevel()));
            cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("fooStore");
            cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("barStore");
            IncrementalBackupDUnitTest.this.getRegionFactory(cache).setDiskStoreName("fooStore").create("fooRegion");
            IncrementalBackupDUnitTest.this.getRegionFactory(cache).setDiskStoreName("barStore").create("barRegion");
        }
    };
    private static final FileFilter backupDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().startsWith("20");
        }
    };

    protected RegionFactory<Integer, String> getRegionFactory(Cache cache) {
        return cache.createRegionFactory(RegionShortcut.PARTITION_PERSISTENT);
    }

    public IncrementalBackupDUnitTest(String name) {
        super(name);
    }

    private void log(String message) {
        IncrementalBackupDUnitTest.getLogWriter().info("[IncrementalBackupDUnitTest] " + message);
    }

    private static File getBaselineDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "baseline");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getIncremental2Dir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "incremental2");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getIncrementalDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "incremental");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getVMDir(VM vm) {
        return (File)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)new File(CacheTestCase.getDiskDirs()[0], "../.."));
            }
        });
    }

    private Set<PersistentID> getMissingMembers(VM vm) {
        return (Set)vm.invoke(new SerializableCallable("getMissingMembers"){

            public Object call() {
                return AdminDistributedSystemImpl.getMissingPersistentMembers((DM)IncrementalBackupDUnitTest.this.getSystem().getDistributionManager());
            }
        });
    }

    private BackupStatus baseline(VM vm) {
        return (BackupStatus)vm.invoke(new SerializableCallable("Backup all members."){

            public Object call() {
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)IncrementalBackupDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    BackupStatus backupStatus = adminDS.backupAllMembers(IncrementalBackupDUnitTest.getBaselineDir());
                    return backupStatus;
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    private BackupStatus incremental(VM vm) {
        return (BackupStatus)vm.invoke(new SerializableCallable("Backup all members."){

            public Object call() {
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)IncrementalBackupDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    BackupStatus backupStatus = adminDS.backupAllMembers(IncrementalBackupDUnitTest.getIncrementalDir(), IncrementalBackupDUnitTest.getBaselineBackupDir());
                    return backupStatus;
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    private BackupStatus incremental2(VM vm) {
        return (BackupStatus)vm.invoke(new SerializableCallable("Backup all members."){

            public Object call() {
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)IncrementalBackupDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    BackupStatus backupStatus = adminDS.backupAllMembers(IncrementalBackupDUnitTest.getIncremental2Dir(), IncrementalBackupDUnitTest.getIncrementalBackupDir());
                    return backupStatus;
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    private String getMemberId(VM vm) {
        return (String)vm.invoke(new SerializableCallable("getMemberId"){

            public Object call() throws Exception {
                return IncrementalBackupDUnitTest.this.getCache().getDistributedSystem().getDistributedMember().toString().replaceAll("[^\\w]+", "_");
            }
        });
    }

    private void closeCache(VM closeVM) {
        closeVM.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                IncrementalBackupDUnitTest.this.getCache().close();
            }
        });
    }

    private PersistentID getPersistentID(VM vm, final String diskStoreName) {
        PersistentID id = (PersistentID)vm.invoke(new SerializableCallable(){

            public Object call() {
                PersistentID id = null;
                Collection diskStores = ((GemFireCacheImpl)IncrementalBackupDUnitTest.this.getCache()).listDiskStores();
                for (DiskStoreImpl diskStore : diskStores) {
                    if (!diskStore.getName().equals(diskStoreName)) continue;
                    id = diskStore.getPersistentID();
                    break;
                }
                return id;
            }
        });
        return id;
    }

    private PersistentID getPersistentID(VM vm) {
        return this.getPersistentID(vm, "fooStore");
    }

    private PersistentID disconnect(VM disconnectVM, final VM testVM) {
        final PersistentID id = (PersistentID)disconnectVM.invoke(new SerializableCallable(){

            public Object call() {
                PersistentID id = null;
                Collection diskStores = ((GemFireCacheImpl)IncrementalBackupDUnitTest.this.getCache()).listDiskStores();
                for (DiskStoreImpl diskStore : diskStores) {
                    if (!diskStore.getName().equals("fooStore")) continue;
                    id = diskStore.getPersistentID();
                    break;
                }
                IncrementalBackupDUnitTest.this.getSystem().disconnect();
                return id;
            }
        });
        final HashSet missingMembers = new HashSet();
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                missingMembers.clear();
                missingMembers.addAll(IncrementalBackupDUnitTest.this.getMissingMembers(testVM));
                return missingMembers.contains(id);
            }

            @Override
            public String description() {
                return "[IncrementalBackupDUnitTest] Waiting for missing member " + id;
            }
        }, 10000L, 500L, false);
        return id;
    }

    private void openCache(VM vm) {
        vm.invoke(this.createRegions);
    }

    private void waitForBackup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Collection backupInProgress = ((GemFireCacheImpl)IncrementalBackupDUnitTest.this.getCache()).listDiskStores();
                LinkedList<DiskStoreImpl> backupCompleteList = new LinkedList<DiskStoreImpl>();
                while (backupCompleteList.size() < backupInProgress.size()) {
                    for (DiskStoreImpl diskStore : backupInProgress) {
                        if (null != diskStore.getInProgressBackup() || backupCompleteList.contains(diskStore)) continue;
                        backupCompleteList.add(diskStore);
                    }
                }
            }
        });
    }

    private BackupStatus performBaseline() {
        return this.baseline(Host.getHost(0).getVM(1));
    }

    private BackupStatus performIncremental() {
        return this.incremental(Host.getHost(0).getVM(1));
    }

    private BackupStatus performIncremental2() {
        return this.incremental2(Host.getHost(0).getVM(1));
    }

    private static File getBaselineBackupDir() {
        File[] dirs = IncrementalBackupDUnitTest.getBaselineDir().listFiles(backupDirFilter);
        IncrementalBackupDUnitTest.assertEquals((int)1, (int)dirs.length);
        return dirs[0];
    }

    private static File getIncrementalBackupDir() {
        File[] dirs = IncrementalBackupDUnitTest.getIncrementalDir().listFiles(backupDirFilter);
        IncrementalBackupDUnitTest.assertEquals((int)1, (int)dirs.length);
        return dirs[0];
    }

    private static File getIncremental2BackupDir() {
        File[] dirs = IncrementalBackupDUnitTest.getIncremental2Dir().listFiles(backupDirFilter);
        IncrementalBackupDUnitTest.assertEquals((int)1, (int)dirs.length);
        return dirs[0];
    }

    private File getBackupDirForMember(File rootDir, final String memberId) {
        File[] dateDirs = rootDir.listFiles(backupDirFilter);
        IncrementalBackupDUnitTest.assertEquals((int)1, (int)dateDirs.length);
        File[] memberDirs = dateDirs[0].listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().indexOf(memberId) != -1;
            }
        });
        IncrementalBackupDUnitTest.assertEquals((int)1, (int)memberDirs.length);
        return memberDirs[0];
    }

    private void createDataRegions() {
        Host host = Host.getHost(0);
        int numberOfVms = host.getVMCount();
        for (int i = 0; i < numberOfVms; ++i) {
            this.openCache(host.getVM(i));
        }
    }

    private int execute(String command) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        final Process process = builder.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    do {
                        line = reader.readLine();
                        IncrementalBackupDUnitTest.this.log(line);
                    } while (null != line);
                    reader.close();
                }
                catch (IOException e) {
                    IncrementalBackupDUnitTest.this.log("Excecute: error while reading standard in: " + e.getMessage());
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String line = null;
                    while (null != (line = reader.readLine())) {
                    }
                    reader.close();
                }
                catch (IOException e) {
                    IncrementalBackupDUnitTest.this.log("Execute: error while reading standard error: " + e.getMessage());
                }
            }
        }).start();
        int result = process.waitFor();
        return result;
    }

    private void performRestore(File memberDir, File backupDir) throws Exception {
        List ifFiles = FileUtil.findAll((File)memberDir, (String)".*\\.if$");
        for (Object file : ifFiles) {
            ((File)file).delete();
        }
        List oplogs = FileUtil.findAll((File)memberDir, (String)OPLOG_REGEX);
        for (File file : oplogs) {
            file.delete();
        }
        File restoreScript = new File(backupDir, "restore.sh");
        if (!restoreScript.exists()) {
            restoreScript = new File(backupDir, "restore.bat");
        }
        IncrementalBackupDUnitTest.assertTrue((boolean)restoreScript.exists());
        IncrementalBackupDUnitTest.assertEquals((int)0, (int)this.execute(restoreScript.getAbsolutePath()));
    }

    private void markAsIncomplete(VM vm) throws IOException {
        File backupDir = this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), this.getMemberId(vm));
        IncrementalBackupDUnitTest.assertTrue((boolean)backupDir.exists());
        File incomplete = new File(backupDir, "INCOMPLETE_BACKUP");
        incomplete.createNewFile();
    }

    private void loadMoreData() {
        Region fooRegion = this.getCache().getRegion("fooRegion");
        for (int i = this.dataStart; i < this.dataEnd; ++i) {
            fooRegion.put((Object)i, (Object)Integer.toString(i));
        }
        Region barRegion = this.getCache().getRegion("barRegion");
        for (int i = this.dataStart; i < this.dataEnd; ++i) {
            barRegion.put((Object)i, (Object)Integer.toString(i));
        }
        this.dataStart += 10000;
        this.dataEnd += 10000;
    }

    private void assertBackupStatus(BackupStatus backupStatus) {
        Map backupMap = backupStatus.getBackedUpDiskStores();
        IncrementalBackupDUnitTest.assertFalse((boolean)backupMap.isEmpty());
        for (DistributedMember member : backupMap.keySet()) {
            for (PersistentID id : (Set)backupMap.get(member)) {
                IncrementalBackupDUnitTest.assertNotNull((Object)id.getHost());
                IncrementalBackupDUnitTest.assertNotNull((Object)id.getUUID());
                IncrementalBackupDUnitTest.assertNotNull((Object)id.getDirectory());
            }
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createDataRegions();
        this.createRegions.run();
        this.loadMoreData();
        this.log("Data region created and populated.");
    }

    @Override
    public void tearDown2() throws Exception {
        FileUtil.delete((File)IncrementalBackupDUnitTest.getIncremental2Dir());
        FileUtil.delete((File)IncrementalBackupDUnitTest.getIncrementalDir());
        FileUtil.delete((File)IncrementalBackupDUnitTest.getBaselineDir());
        super.tearDown2();
    }

    public void testIncrementalBackup() throws Exception {
        String memberId = this.getMemberId(Host.getHost(0).getVM(1));
        File memberDir = this.getVMDir(Host.getHost(0).getVM(1));
        IncrementalBackupDUnitTest.assertNotNull((Object)memberDir);
        List memberOplogFiles = FileUtil.findAll((File)memberDir, (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberOplogFiles.isEmpty());
        this.assertBackupStatus(this.performBaseline());
        this.waitForBackup(Host.getHost(0).getVM(1));
        List memberBaselineOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberBaselineOplogs.isEmpty());
        LinkedList memberBaselineOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberBaselineOplogs, memberBaselineOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        this.loadMoreData();
        this.assertBackupStatus(this.performIncremental());
        this.waitForBackup(Host.getHost(0).getVM(1));
        List memberIncrementalOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncrementalDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberIncrementalOplogs.isEmpty());
        LinkedList memberIncrementalOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberIncrementalOplogs, memberIncrementalOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        this.log("BASELINE OPLOGS = " + memberBaselineOplogNames);
        this.log("INCREMENTAL OPLOGS = " + memberIncrementalOplogNames);
        for (String oplog : memberBaselineOplogNames) {
            IncrementalBackupDUnitTest.assertFalse((boolean)memberIncrementalOplogNames.contains(oplog));
        }
        this.loadMoreData();
        this.assertBackupStatus(this.performIncremental2());
        this.waitForBackup(Host.getHost(0).getVM(1));
        List memberIncremental2Oplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncremental2Dir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberIncremental2Oplogs.isEmpty());
        LinkedList memberIncremental2OplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberIncremental2Oplogs, memberIncremental2OplogNames, (Transformer)TransformUtils.fileNameTransformer);
        this.log("INCREMENTAL 2 OPLOGS = " + memberIncremental2OplogNames);
        for (String oplog : memberBaselineOplogNames) {
            IncrementalBackupDUnitTest.assertFalse((boolean)memberIncremental2OplogNames.contains(oplog));
        }
        for (String oplog : memberIncrementalOplogNames) {
            IncrementalBackupDUnitTest.assertFalse((boolean)memberIncremental2OplogNames.contains(oplog));
        }
        PersistentID id = this.getPersistentID(Host.getHost(0).getVM(1));
        this.closeCache(Host.getHost(0).getVM(1));
        this.performRestore(new File(id.getDirectory()), this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncremental2Dir(), memberId));
        List restoredOplogs = FileUtil.findAll((File)new File(id.getDirectory()), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)restoredOplogs.isEmpty());
        LinkedList restoredOplogNames = new LinkedList();
        TransformUtils.transform((Collection)restoredOplogs, restoredOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        for (String oplog : memberBaselineOplogNames) {
            IncrementalBackupDUnitTest.assertTrue((boolean)restoredOplogNames.contains(oplog));
        }
        for (String oplog : memberIncrementalOplogNames) {
            IncrementalBackupDUnitTest.assertTrue((boolean)restoredOplogNames.contains(oplog));
        }
        for (String oplog : memberIncremental2OplogNames) {
            IncrementalBackupDUnitTest.assertTrue((boolean)restoredOplogNames.contains(oplog));
        }
        this.openCache(Host.getHost(0).getVM(1));
    }

    public void testMissingMemberInBaseline() throws Exception {
        final PersistentID missingMember = this.disconnect(Host.getHost(0).getVM(0), Host.getHost(0).getVM(1));
        BackupStatus baselineStatus = this.performBaseline();
        this.assertBackupStatus(baselineStatus);
        IncrementalBackupDUnitTest.assertNotNull((Object)baselineStatus.getOfflineDiskStores());
        IncrementalBackupDUnitTest.assertEquals((int)2, (int)baselineStatus.getOfflineDiskStores().size());
        List missingMemberOplogFiles = FileUtil.findAll((File)new File(missingMember.getDirectory()), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)missingMemberOplogFiles.isEmpty());
        this.openCache(Host.getHost(0).getVM(0));
        final HashSet missingMembers = new HashSet();
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                missingMembers.clear();
                missingMembers.addAll(IncrementalBackupDUnitTest.this.getMissingMembers(Host.getHost(0).getVM(1)));
                return !missingMembers.contains(missingMember);
            }

            @Override
            public String description() {
                return "[testMissingMemberInBasline] Wait for missing member.";
            }
        }, 10000L, 500L, false);
        IncrementalBackupDUnitTest.assertEquals((int)0, (int)missingMembers.size());
        BackupStatus incrementalStatus = this.performIncremental();
        this.assertBackupStatus(incrementalStatus);
        IncrementalBackupDUnitTest.assertNotNull((Object)incrementalStatus.getOfflineDiskStores());
        IncrementalBackupDUnitTest.assertEquals((int)0, (int)incrementalStatus.getOfflineDiskStores().size());
        String memberId = this.getMemberId(Host.getHost(0).getVM(0));
        IncrementalBackupDUnitTest.assertNotNull((Object)memberId);
        File incrementalMemberDir = this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncrementalDir(), memberId);
        List backupOplogFiles = FileUtil.findAll((File)incrementalMemberDir, (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)backupOplogFiles.isEmpty());
        LinkedList missingMemberOplogNames = new LinkedList();
        TransformUtils.transform((Collection)missingMemberOplogFiles, missingMemberOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        LinkedList backupOplogNames = new LinkedList();
        TransformUtils.transform((Collection)backupOplogFiles, backupOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        IncrementalBackupDUnitTest.assertTrue((boolean)backupOplogNames.containsAll(missingMemberOplogNames));
    }

    public void testIncompleteInBaseline() throws Exception {
        String memberId = this.getMemberId(Host.getHost(0).getVM(1));
        this.assertBackupStatus(this.performBaseline());
        List memberBaselineOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberBaselineOplogs.isEmpty());
        LinkedList memberBaselineOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberBaselineOplogs, memberBaselineOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        this.markAsIncomplete(Host.getHost(0).getVM(1));
        this.assertBackupStatus(this.performIncremental());
        List memberIncrementalOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncrementalDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberIncrementalOplogs.isEmpty());
        LinkedList memberIncrementalOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberIncrementalOplogs, memberIncrementalOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        for (String oplog : memberBaselineOplogNames) {
            IncrementalBackupDUnitTest.assertTrue((boolean)memberIncrementalOplogNames.contains(oplog));
        }
    }

    public void testMissingBaseline() throws Exception {
        String memberId = this.getMemberId(Host.getHost(0).getVM(1));
        this.assertBackupStatus(this.performBaseline());
        List memberBaselineOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberBaselineOplogs.isEmpty());
        LinkedList memberBaselineOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberBaselineOplogs, memberBaselineOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        SerializableCallable callable = new SerializableCallable("Backup all members."){
            private File baselineDir;
            {
                this.baselineDir = IncrementalBackupDUnitTest.getBaselineBackupDir();
            }

            public Object call() {
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)IncrementalBackupDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    BackupStatus backupStatus = adminDS.backupAllMembers(IncrementalBackupDUnitTest.getIncrementalDir(), this.baselineDir);
                    return backupStatus;
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        };
        FileUtil.delete((File)IncrementalBackupDUnitTest.getBaselineDir());
        Host.getHost(0).getVM(1).invoke(callable);
        List memberIncrementalOplogs = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getIncrementalDir(), memberId), (String)OPLOG_REGEX);
        IncrementalBackupDUnitTest.assertFalse((boolean)memberIncrementalOplogs.isEmpty());
        LinkedList memberIncrementalOplogNames = new LinkedList();
        TransformUtils.transform((Collection)memberIncrementalOplogs, memberIncrementalOplogNames, (Transformer)TransformUtils.fileNameTransformer);
        for (String oplog : memberBaselineOplogNames) {
            IncrementalBackupDUnitTest.assertTrue((boolean)memberIncrementalOplogNames.contains(oplog));
        }
    }

    public void testBackupUserDeployedJarFiles() throws Exception {
        String jarName = "BackupJarDeploymentDUnit";
        String jarNameRegex = ".*BackupJarDeploymentDUnit.*";
        ClassBuilder classBuilder = new ClassBuilder();
        final byte[] classBytes = classBuilder.createJarFromName("BackupJarDeploymentDUnit");
        VM vm0 = Host.getHost(0).getVM(0);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                JarDeployer deployer = new JarDeployer();
                deployer.deploy(new String[]{"BackupJarDeploymentDUnit"}, (byte[][])new byte[][]{classBytes});
                return null;
            }
        });
        this.assertBackupStatus(this.baseline(vm0));
        List memberDeployedJarFiles = FileUtil.findAll((File)this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), this.getMemberId(vm0)), (String)".*BackupJarDeploymentDUnit.*");
        IncrementalBackupDUnitTest.assertFalse((boolean)memberDeployedJarFiles.isEmpty());
        PersistentID id = this.getPersistentID(vm0);
        this.closeCache(vm0);
        String vmDir = (String)vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return System.getProperty("user.dir");
            }
        });
        File backupDir = this.getBackupDirForMember(IncrementalBackupDUnitTest.getBaselineDir(), this.getMemberId(vm0));
        vm0.bounce();
        FileUtil.deleteMatching((File)new File(vmDir), (String)"^vf.gf#BackupJarDeploymentDUnit.*#\\d++$");
        this.performRestore(new File(id.getDirectory()), backupDir);
        List restoredJars = FileUtil.findAll((File)new File(vmDir), (String)".*BackupJarDeploymentDUnit.*");
        IncrementalBackupDUnitTest.assertFalse((boolean)restoredJars.isEmpty());
        LinkedList restoredJarNames = new LinkedList();
        TransformUtils.transform((Collection)memberDeployedJarFiles, restoredJarNames, (Transformer)TransformUtils.fileNameTransformer);
        for (String name : restoredJarNames) {
            IncrementalBackupDUnitTest.assertTrue((name.indexOf("BackupJarDeploymentDUnit") != -1 ? 1 : 0) != 0);
        }
        this.openCache(vm0);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                JarDeployer deployer = new JarDeployer();
                for (JarClassLoader jarClassLoader : deployer.findJarClassLoaders()) {
                    if (!jarClassLoader.getJarName().startsWith("BackupJarDeploymentDUnit")) continue;
                    deployer.undeploy(jarClassLoader.getJarName());
                }
                return null;
            }
        });
        FileUtil.deleteMatching((File)new File(vmDir), (String)"^vf.gf#BackupJarDeploymentDUnit.*#\\d++$");
    }
}

