/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.AsyncInvocation;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;

public class ConcurrentDestroySubRegionDUnitTest
extends CacheTestCase {
    public ConcurrentDestroySubRegionDUnitTest(String name) {
        super(name);
    }

    public void test() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        for (int i = 0; i < 200; ++i) {
            SerializableRunnable createParent = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    AttributesFactory af = new AttributesFactory();
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    Region region = cache.createRegion("region", af.create());
                }
            };
            vm0.invoke(createParent);
            vm1.invoke(createParent);
            SerializableRunnable createChild = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion("region");
                    if (region != null) {
                        AttributesFactory af = new AttributesFactory();
                        af.setScope(Scope.DISTRIBUTED_ACK);
                        af.setDataPolicy(DataPolicy.REPLICATE);
                        Region region2 = region.createSubregion("subregion", af.create());
                    }
                }
            };
            vm0.invoke(createChild);
            SerializableRunnable destroyParent = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion("/region");
                    region.destroyRegion();
                }
            };
            AsyncInvocation future = vm0.invokeAsync(destroyParent);
            try {
                vm1.invoke(createChild);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof RegionDestroyedException)) {
                    ConcurrentDestroySubRegionDUnitTest.fail("Wrong exception", e);
                }
                RegionDestroyedException rde = (RegionDestroyedException)e.getCause();
                ConcurrentDestroySubRegionDUnitTest.assertEquals((String)("Error on loop " + i), (String)"/region", (String)rde.getRegionFullPath());
            }
            future.getResult(60000L);
        }
    }

    public void testPartitionedRegion() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        for (int i = 0; i < 50; ++i) {
            SerializableRunnable createParent = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    AttributesFactory af = new AttributesFactory();
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    Region region = cache.createRegion("region", af.create());
                }
            };
            vm0.invoke(createParent);
            vm1.invoke(createParent);
            SerializableRunnable createChild = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion("region");
                    if (region != null) {
                        AttributesFactory af = new AttributesFactory();
                        af.setDataPolicy(DataPolicy.PARTITION);
                        Region region2 = region.createSubregion("subregion", af.create());
                    }
                }
            };
            vm0.invoke(createChild);
            SerializableRunnable destroyParent = new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = ConcurrentDestroySubRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion("/region");
                    region.destroyRegion();
                }
            };
            AsyncInvocation future = vm0.invokeAsync(destroyParent);
            try {
                vm1.invoke(createChild);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof RegionDestroyedException)) {
                    ConcurrentDestroySubRegionDUnitTest.fail("Wrong exception", e);
                }
                RegionDestroyedException rde = (RegionDestroyedException)e.getCause();
                ConcurrentDestroySubRegionDUnitTest.assertEquals((String)("Error on loop " + i), (String)"/region", (String)rde.getRegionFullPath());
            }
            future.getResult(60000L);
        }
    }
}

