/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class ClearDAckDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static Region paperWork;
    static CacheTransactionManager cacheTxnMgr;
    static boolean IsAfterClear;
    static boolean flag;
    static DistributedMember vm0ID;
    static DistributedMember vm1ID;
    private static CacheObserver origObserver;

    public ClearDAckDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0ID = (DistributedMember)vm0.invoke(ClearDAckDUnitTest.class, "createCacheVM0");
        vm1ID = (DistributedMember)vm1.invoke(ClearDAckDUnitTest.class, "createCacheVM1");
        ClearDAckDUnitTest.getLogWriter().info("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(ClearDAckDUnitTest.class, "closeCache");
        vm1.invoke(ClearDAckDUnitTest.class, "resetClearCallBack");
        vm1.invoke(ClearDAckDUnitTest.class, "closeCache");
        vm2.invoke(ClearDAckDUnitTest.class, "closeCache");
        cache = null;
        ClearDAckDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static long getRegionVersion(DistributedMember memberID) {
        return ((LocalRegion)region).getVersionVector().getVersionForMember((VersionSource)memberID);
    }

    public static void resetClearCallBack() {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance((CacheObserver)origObserver);
    }

    public static DistributedMember createCacheVM0() {
        try {
            ClearDAckDUnitTest.getLogWriter().info("I am vm0");
            ds = new ClearDAckDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            ClearDAckDUnitTest.getLogWriter().info("vm0 map region: " + region);
            paperWork = cache.createRegion("paperWork", attr);
            return cache.getDistributedSystem().getDistributedMember();
        }
        catch (CacheException ex) {
            throw new RuntimeException("createCacheVM0 exception", ex);
        }
    }

    public static DistributedMember createCacheVM1() {
        try {
            ClearDAckDUnitTest.getLogWriter().info("I am vm1");
            ds = new ClearDAckDUnitTest("temp").getSystem(props);
            CacheObserverImpl observer = new CacheObserverImpl();
            origObserver = CacheObserverHolder.setInstance((CacheObserver)observer);
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            ClearDAckDUnitTest.getLogWriter().info("vm1 map region: " + region);
            paperWork = cache.createRegion("paperWork", attr);
            return cache.getDistributedSystem().getDistributedMember();
        }
        catch (CacheException ex) {
            throw new RuntimeException("createCacheVM1 exception", ex);
        }
    }

    public static void createCacheVM2AndLocalClear() {
        try {
            ClearDAckDUnitTest.getLogWriter().info("I am vm2");
            ds = new ClearDAckDUnitTest("temp").getSystem(props);
            CacheObserverImpl observer = new CacheObserverImpl();
            origObserver = CacheObserverHolder.setInstance((CacheObserver)observer);
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.NORMAL);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            ClearDAckDUnitTest.getLogWriter().info("vm2 map region: " + region);
            paperWork = cache.createRegion("paperWork", attr);
            region.put((Object)"vm2Key", (Object)"vm2Value");
            region.localClear();
        }
        catch (CacheException ex) {
            throw new RuntimeException("createCacheVM1 exception", ex);
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testClearMultiVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[1];
        for (int i = 1; i < 4; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(ClearDAckDUnitTest.class, "putMethod", objArr);
        }
        ClearDAckDUnitTest.getLogWriter().info("Did all puts successfully");
        long regionVersion = (Long)vm1.invoke(ClearDAckDUnitTest.class, "getRegionVersion", new Object[]{vm0ID});
        vm0.invoke(ClearDAckDUnitTest.class, "clearMethod");
        boolean flag = vm1.invokeBoolean(ClearDAckDUnitTest.class, "getVM1Flag");
        ClearDAckDUnitTest.getLogWriter().fine("Flag in VM1=" + flag);
        ClearDAckDUnitTest.assertTrue((boolean)flag);
        long newRegionVersion = (Long)vm1.invoke(ClearDAckDUnitTest.class, "getRegionVersion", new Object[]{vm0ID});
        ClearDAckDUnitTest.assertEquals((String)("expected clear() to increment region version by 1 for " + vm0ID), (long)(regionVersion + 1L), (long)newRegionVersion);
        VM vm2 = host.getVM(2);
        vm2.invoke(ClearDAckDUnitTest.class, "createCacheVM2AndLocalClear");
        flag = vm1.invokeBoolean(ClearDAckDUnitTest.class, "getVM1Flag");
        ClearDAckDUnitTest.getLogWriter().fine("Flag in VM1=" + flag);
        ClearDAckDUnitTest.assertFalse((boolean)flag);
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        if (ob != null) {
            String str = "first";
            obj = region.put(ob, (Object)str);
        }
        return obj;
    }

    public static void clearMethod() {
        try {
            long start = System.currentTimeMillis();
            region.clear();
            long end = System.currentTimeMillis();
            long diff = end - start;
            ClearDAckDUnitTest.getLogWriter().info("Clear Thread proceeded before receiving the ack message in (milli seconds): " + diff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getVM1Flag() {
        boolean result = IsAfterClear;
        IsAfterClear = false;
        return result;
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        IsAfterClear = false;
        flag = false;
    }

    public static class CacheObserverImpl
    extends CacheObserverAdapter {
        public void afterRegionClear(RegionEvent event) {
            IsAfterClear = true;
        }
    }
}

