/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DistributedCacheTestCase;
import com.gemstone.gemfire.internal.cache.EventListenersBlackboard;
import dunit.DistributedTestCase;
import dunit.Host;
import java.io.Serializable;
import junit.framework.TestCase;

public class CacheEventListenerTest
extends DistributedCacheTestCase {
    static final String REGION_NAME = "CacheEventListenerTest";
    static final Scope SCOPE = Scope.DISTRIBUTED_ACK;
    static volatile Object newValue;
    static volatile Object oldValue;
    volatile int expectedCreateInv;
    volatile int expectedUpdateInv;

    public CacheEventListenerTest(String name) {
        super(name);
    }

    public void testObjectAddedReplaced() throws CacheException, InterruptedException {
        Object vmNewValue;
        Object vmOldValue;
        int i;
        String name = "testObjectAddedReplaced";
        int numVMs = Host.getHost(0).getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                TestCase.assertEquals((Object)Operation.CREATE, (Object)event.getOperation());
                Assert.assertTrue((event.getOldValue() == null ? 1 : 0) != 0);
                CacheEventListenerTest.this.getBlackboard().incNumInvocations1();
                TestCase.assertEquals((String)"newValue is wrong", (Object)new Integer(0), (Object)event.getNewValue());
                TestCase.assertNull((String)"oldValue not null", (Object)event.getOldValue());
                if (event.getSerializedOldValue() != null) {
                    TestCase.assertEquals((Object)event.getOldValue(), (Object)event.getSerializedOldValue().getDeserializedValue());
                }
                if (event.getSerializedNewValue() != null) {
                    TestCase.assertEquals((Object)event.getNewValue(), (Object)event.getSerializedNewValue().getDeserializedValue());
                }
                DistributedTestCase.getLogWriter().info("create event new value is: " + event.getNewValue());
            }

            @Override
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterUpdate on listener; name=" + event.getKey());
                TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                TestCase.assertEquals((Object)Operation.UPDATE, (Object)event.getOperation());
                Assert.assertTrue((event.getOldValue() != null ? 1 : 0) != 0);
                if (event.getSerializedOldValue() != null) {
                    TestCase.assertEquals((Object)event.getOldValue(), (Object)event.getSerializedOldValue().getDeserializedValue());
                }
                if (event.getSerializedNewValue() != null) {
                    TestCase.assertEquals((Object)event.getNewValue(), (Object)event.getSerializedNewValue().getDeserializedValue());
                }
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
                CacheEventListenerTest.this.getBlackboard().incNumInvocations2();
                DistributedTestCase.getLogWriter().info("update event new value is: " + newValue);
                DistributedTestCase.getLogWriter().info("update event old value is: " + oldValue);
            }
        };
        Object[] args = new Object[]{name, listener};
        this.expectedCreateInv = 1;
        this.expectedUpdateInv = 0;
        LogWriter log = CacheEventListenerTest.getLogWriter();
        log.info("TESTOBJECTADDEDREPLACED: creating entry in controller");
        CacheEventListenerTest.createEntry(name, listener);
        log.info("TESTOBJECTADDEDREPLACED: done creating entry in controller");
        CacheSerializableRunnable verify = new CacheSerializableRunnable("verify"){

            @Override
            public void run2() {
                TestCase.assertEquals((String)"Wrong number of 'afterCreate' listener invocations", (long)CacheEventListenerTest.this.expectedCreateInv, (long)CacheEventListenerTest.this.getBlackboard().getNumInvocations1());
                TestCase.assertEquals((String)"Wrong number of 'afterUpdate' listener invocations", (long)CacheEventListenerTest.this.expectedUpdateInv, (long)CacheEventListenerTest.this.getBlackboard().getNumInvocations2());
            }
        };
        log.info("TESTOBJECTADDEDREPLACED: verifying");
        verify.runRepeatingIfNecessary(5000L);
        log.info("TESTOBJECTADDEDREPLACED: done verifying");
        Host host = Host.getHost(0);
        int vmCount = host.getVMCount();
        for (int i2 = 0; i2 < vmCount; ++i2) {
            log.info("TESTOBJECTADDEDREPLACED: invoking create in VM " + i2);
            host.getVM(i2).invoke(this.getClass(), "createEntry", args);
            log.info("TESTOBJECTADDEDREPLACED: done create in VM " + i2);
            ++this.expectedCreateInv;
            this.expectedUpdateInv += i2 + 1;
            log.info("TESTOBJECTADDEDREPLACED: verifying callbacks for VM " + i2);
            verify.runRepeatingIfNecessary(5000L);
            log.info("TESTOBJECTADDEDREPLACED: done verifying callbacks for VM " + i2);
        }
        CacheEventListenerTest.assertEquals((String)"newValue is wrong", (Object)new Integer(0), (Object)newValue);
        CacheEventListenerTest.assertEquals((String)"oldValue is wrong", (Object)new Integer(0), (Object)oldValue);
        int replaceValue = 1;
        CacheEventListenerTest.replaceEntry(name, new Integer(replaceValue));
        this.expectedUpdateInv += numVMs;
        verify.runRepeatingIfNecessary(5000L);
        CacheEventListenerTest.assertEquals((String)"oldValue is wrong", (Object)new Integer(replaceValue - 1), (Object)CacheEventListenerTest.getOldValue());
        CacheEventListenerTest.assertEquals((String)"newValue is wrong", (Object)new Integer(replaceValue), (Object)CacheEventListenerTest.getNewValue());
        for (i = 0; i < vmCount; ++i) {
            vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            CacheEventListenerTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(replaceValue - 1), (Object)vmOldValue);
            CacheEventListenerTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)new Integer(replaceValue), (Object)vmNewValue);
        }
        host.getVM(0).invoke(this.getClass(), "replaceEntry", new Object[]{name, new Integer(++replaceValue)});
        this.expectedUpdateInv += numVMs;
        verify.runRepeatingIfNecessary(5000L);
        CacheEventListenerTest.assertEquals((String)"oldValue is wrong", (Object)new Integer(replaceValue - 1), (Object)CacheEventListenerTest.getOldValue());
        try {
            CacheEventListenerTest.assertEquals((String)"newValue is wrong", (Object)new Integer(replaceValue), (Object)CacheEventListenerTest.getNewValue());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Error e) {
            CacheEventListenerTest.getLogWriter().severe((Throwable)e);
            throw e;
        }
        for (i = 0; i < vmCount; ++i) {
            vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            CacheEventListenerTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(replaceValue - 1), (Object)vmOldValue);
            CacheEventListenerTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)new Integer(replaceValue), (Object)vmNewValue);
        }
    }

    public void testObjectInvalidated() throws CacheException, InterruptedException {
        int ttl = 5;
        String name = "testObjectInvalidated";
        Host host = Host.getHost(0);
        final int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterInvalidate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking tests invalidated listener");
                if (event.isOriginRemote()) {
                    TestCase.assertTrue((!event.getDistributedMember().equals(CacheEventListenerTest.this.getSystem().getDistributedMember()) ? 1 : 0) != 0);
                } else {
                    TestCase.assertEquals((Object)CacheEventListenerTest.this.getSystem().getDistributedMember(), (Object)event.getDistributedMember());
                }
                TestCase.assertEquals((Object)Operation.EXPIRE_INVALIDATE, (Object)event.getOperation());
                CacheEventListenerTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }
        };
        Object[] args = new Object[]{name, new Integer(ttl), ExpirationAction.INVALIDATE, listener};
        CacheEventListenerTest.createEntry(name, ttl, ExpirationAction.INVALIDATE, listener);
        long start = System.currentTimeMillis();
        this.forEachVMInvoke("createEntry", args);
        long time = System.currentTimeMillis() - start;
        CacheEventListenerTest.assertEquals((String)("Test timing intolerance: entry creation took " + time + "ms. Increase expiration time in test"), (long)0L, (long)this.getBlackboard().getNumInvocations1());
        CacheEventListenerTest.getLogWriter().info("Sleeping for " + ttl + " seconds");
        Thread.sleep(ttl * 1000);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CacheEventListenerTest.this.getBlackboard().getNumInvocations1() >= (long)numVMs;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        CacheEventListenerTest.assertNull((Object)CacheEventListenerTest.getRegion().getSubregion(name).get((Object)name));
        CacheEventListenerTest.assertNull((Object)newValue);
        CacheEventListenerTest.assertEquals((Object)new Integer(0), (Object)oldValue);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            CacheEventListenerTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(0), (Object)vmOldValue);
            CacheEventListenerTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
    }

    public void testObjectDestroyed() throws CacheException, InterruptedException {
        int ttl = 3;
        String name = "testObjectDestroyed";
        Host host = Host.getHost(0);
        final int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }

            @Override
            public void afterDestroy(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking objectDestroyed listener");
                if (event.isOriginRemote()) {
                    TestCase.assertTrue((!event.getDistributedMember().equals(CacheEventListenerTest.this.getSystem().getDistributedMember()) ? 1 : 0) != 0);
                } else {
                    TestCase.assertEquals((Object)CacheEventListenerTest.this.getSystem().getDistributedMember(), (Object)event.getDistributedMember());
                }
                TestCase.assertEquals((Object)Operation.EXPIRE_DESTROY, (Object)event.getOperation());
                CacheEventListenerTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }
        };
        Object[] args = new Object[]{name, new Integer(ttl), ExpirationAction.DESTROY, listener};
        CacheEventListenerTest.createEntry(name, ttl, ExpirationAction.DESTROY, listener);
        this.forEachVMInvoke("createEntry", args);
        CacheEventListenerTest.getLogWriter().info("Sleeping for " + ttl + " seconds");
        Thread.sleep(ttl * 1000);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CacheEventListenerTest.this.getBlackboard().getNumInvocations1() >= (long)numVMs;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        CacheEventListenerTest.assertNull((Object)newValue);
        CacheEventListenerTest.assertEquals((Object)new Integer(0), (Object)oldValue);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            CacheEventListenerTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(0), (Object)vmOldValue);
            CacheEventListenerTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
    }

    public void testInvalidatedViaExpiration() throws CacheException, InterruptedException {
        int ttl = 6;
        String name = "testUnloadedViaExpiration";
        Host host = Host.getHost(0);
        final int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }

            @Override
            public void afterInvalidate(EntryEvent event) {
                Object key = event.getKey();
                boolean isPresentLocally = event.getRegion().getEntry(key).getValue() != null;
                String s = "Invoking test's invalidate listener (via expiration) isPresentLocally=" + isPresentLocally + "; newValue=" + event.getNewValue();
                DistributedTestCase.getLogWriter().info(s);
                TestCase.assertTrue((!event.isOriginRemote() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)CacheEventListenerTest.this.getSystem().getDistributedMember(), (Object)event.getDistributedMember());
                TestCase.assertEquals((Object)Operation.EXPIRE_LOCAL_INVALIDATE, (Object)event.getOperation());
                CacheEventListenerTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }
        };
        Object[] args = new Object[]{"testUnloadedViaExpiration", new Integer(ttl), ExpirationAction.LOCAL_INVALIDATE, listener};
        CacheEventListenerTest.createEntry("testUnloadedViaExpiration", ttl, ExpirationAction.LOCAL_INVALIDATE, listener);
        this.forEachVMInvoke("createEntry", args);
        CacheEventListenerTest.getLogWriter().info("Sleeping for " + ttl + " seconds");
        Thread.sleep(ttl * 1000);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CacheEventListenerTest.this.getBlackboard().getNumInvocations1() >= (long)numVMs;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        CacheEventListenerTest.assertEquals((long)numVMs, (long)this.getBlackboard().getNumInvocations1());
        Region region = CacheEventListenerTest.getRegion().getSubregion("testUnloadedViaExpiration");
        CacheEventListenerTest.assertNotNull((Object)region);
        Region.Entry entry = region.getEntry((Object)"testUnloadedViaExpiration");
        CacheEventListenerTest.assertNotNull((Object)entry);
        CacheEventListenerTest.assertNull((String)"is present locally", (Object)entry.getValue());
        CacheEventListenerTest.assertEquals((Object)new Integer(0), (Object)oldValue);
        CacheEventListenerTest.assertNull((Object)newValue);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            CacheEventListenerTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(0), (Object)vmOldValue);
            CacheEventListenerTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
    }

    private static void createEntry(String name, int ttl, ExpirationAction action, GenericListener l) throws CacheException {
        Region region = CacheEventListenerTest.getRegion();
        AttributesFactory factory = new AttributesFactory(region.getAttributes());
        factory.setStatisticsEnabled(true);
        factory.setEntryTimeToLive(new ExpirationAttributes(ttl, action));
        factory.setScope(SCOPE);
        factory.setCacheListener((CacheListener)l);
        Region sub = region.createSubregion(name, factory.create());
        sub.create((Object)name, (Object)new Integer(0), (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static void createEntry(String name, GenericListener l) throws CacheException {
        CacheEventListenerTest.createEntry(name, 0, ExpirationAction.INVALIDATE, l);
    }

    private static void replaceEntry(String name, Object value) throws CacheException {
        Region region = CacheEventListenerTest.getRegion();
        Region sub = region.getSubregion(name);
        CacheEventListenerTest.assertNotNull((Object)sub);
        sub.put((Object)name, value, (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static Object getNewValue() {
        return newValue;
    }

    private static Object getOldValue() {
        return oldValue;
    }

    private static Region getRegion() throws CacheException {
        Region root = CacheEventListenerTest.getRootRegion();
        Region region = root.getSubregion(REGION_NAME);
        if (region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(SCOPE);
            region = root.createSubregion(REGION_NAME, factory.create());
        }
        return region;
    }

    protected EventListenersBlackboard getBlackboard() {
        return EventListenersBlackboard.getInstance();
    }

    public static class GenericListener
    extends CacheListenerAdapter
    implements Serializable {
        public void close() {
        }

        public void afterCreate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterCreate");
        }

        public void afterInvalidate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterInvalidated");
        }

        public void afterDestroy(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterDestroy");
        }

        public void afterUpdate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterUpdate");
        }

        public void afterRegionInvalidate(RegionEvent revt) {
            TestCase.fail((String)"Unexpected listener callback: afterRegionInvalidate");
        }

        public void afterRegionDestroy(RegionEvent revt) {
        }
    }
}

