/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.CreateRegionProcessor;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.UpdateOperation;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;

public class Bug43522DUnit
extends CacheTestCase {
    protected static final String REGION_NAME = "region";
    private static volatile boolean exceptionFound = false;

    public Bug43522DUnit(String name) {
        super(name);
    }

    public void testBug1() throws Exception {
        SerializableRunnable createRegionAcc = new SerializableRunnable("Create non persistent empty region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.EMPTY);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore1 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore2 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                LocalRegion lr = (LocalRegion)rf.create(Bug43522DUnit.REGION_NAME);
                ((AbstractRegionMap)lr.getRegionMap()).testOnlySetIndexUpdater(new IndexUpdater(){

                    public void unlockForIndexGII() throws LockNotHeldException {
                    }

                    public void unlockForGII() throws LockNotHeldException {
                    }

                    public void postEventCleanup(EntryEventImpl event) {
                    }

                    public void postEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry, boolean success) {
                    }

                    public void onEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
                        boolean throwEEE = false;
                        Object oldVal = event.getOldValue();
                        Object newVal = event.getNewValue();
                        Long lastModifiedFromOrigin = (Long)event.getContextObject();
                        if (lastModifiedFromOrigin == null || lastModifiedFromOrigin.longValue() != entry.getLastModified()) {
                            throwEEE = true;
                        } else if (oldVal instanceof byte[] && newVal instanceof byte[] || oldVal instanceof byte[][] && newVal instanceof byte[][]) {
                            if (oldVal instanceof byte[]) {
                                throwEEE = ((byte[])oldVal).length != ((byte[])newVal).length || !Arrays.equals((byte[])oldVal, (byte[])newVal);
                            } else if (((byte[][])oldVal).length == ((byte[][])newVal).length) {
                                int len = ((byte[][])oldVal).length;
                                for (int i = 0; i < len; ++i) {
                                    boolean bl = throwEEE = !Arrays.equals(((byte[][])oldVal)[i], ((byte[][])newVal)[i]);
                                    if (!throwEEE) {
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                throwEEE = true;
                            }
                        } else {
                            throwEEE = true;
                        }
                        if (throwEEE) {
                            throw new EntryExistsException(event.getKey().toString(), event.getOldValue());
                        }
                    }

                    public boolean needsRecovery() {
                        return false;
                    }

                    public boolean lockForIndexGII() throws TimeoutException {
                        return false;
                    }

                    public void lockForGII() throws TimeoutException {
                    }

                    public boolean clearIndexes(LocalRegion region, boolean lockForGII, boolean holdIndexLock, Iterator<?> bucketEntriesIter, boolean destroyOffline) {
                        return false;
                    }

                    public void releaseIndexLock(LocalRegion region) {
                    }

                    public void onOverflowToDisk(RegionEntry entry) {
                    }

                    public void onFaultInFromDisk(RegionEntry entry) {
                    }

                    public boolean hasRemoteOperations(Operation op) {
                        return false;
                    }

                    public boolean avoidSerialExecutor(Operation op) {
                        return false;
                    }

                    public boolean handleSuspectEvents() {
                        return false;
                    }

                    public void unlockForGII(boolean forWrite) throws LockNotHeldException {
                    }
                });
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof UpdateOperation.UpdateMessage) {
                            UpdateOperation.UpdateMessage mssg = (UpdateOperation.UpdateMessage)message;
                            LogWriter logger = Bug43522DUnit.this.getCache().getLogger();
                            try {
                                GemFireCacheImpl cache = Bug43522DUnit.this.getGemfireCache();
                                GemFireCacheImpl.setGFXDSystemForTests();
                                LocalRegion lr = (LocalRegion)cache.getRegion(mssg.regionPath);
                                AbstractRegionEntry entry = (AbstractRegionEntry)lr.basicGetEntry(mssg.key);
                                logger.info("last modified time of entry =" + entry.getLastModified());
                                logger.info("last modified time from message =" + (mssg.lastModified - dm.getCacheTimeOffset()));
                                TestCase.assertEquals((long)entry.getLastModified(), (long)(mssg.lastModified - dm.getCacheTimeOffset()));
                                logger.info("About to sleep");
                                Thread.sleep(25000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        DistributionMessageObserver dmoClient = new DistributionMessageObserver(){

            public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
            }

            public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof CreateRegionProcessor.CreateRegionMessage) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Cache cache = Bug43522DUnit.this.getCache();
                            Region region = cache.getRegion(Bug43522DUnit.REGION_NAME);
                            try {
                                region.create((Object)6, (Object)new byte[]{1, -1, 122, 78, 65, -65, 71});
                            }
                            catch (Exception e) {
                                exceptionFound = true;
                            }
                        }
                    });
                    th.start();
                    try {
                        th.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
            }
        };
        Bug43522DUnit.disconnectFromDS();
        DistributionMessageObserver.setInstance((DistributionMessageObserver)dmoClient);
        vm0.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else if (message instanceof UpdateOperation.UpdateMessage) {
                            GemFireCacheImpl.setGFXDSystemForTests();
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        vm0.invoke(createRegionStore1);
        createRegionAcc.run();
        vm1.invoke(createRegionStore2);
        Thread.sleep(30000L);
        Bug43522DUnit.assertFalse((boolean)exceptionFound);
    }

    public void testBug2() throws Exception {
        SerializableRunnable createRegionAcc = new SerializableRunnable("Create non persistent empty region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.EMPTY);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore1 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore2 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                LocalRegion lr = (LocalRegion)rf.create(Bug43522DUnit.REGION_NAME);
                ((AbstractRegionMap)lr.getRegionMap()).testOnlySetIndexUpdater(new IndexUpdater(){

                    public void unlockForIndexGII() throws LockNotHeldException {
                    }

                    public void unlockForGII() throws LockNotHeldException {
                    }

                    public void postEventCleanup(EntryEventImpl event) {
                    }

                    public void postEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry, boolean success) {
                    }

                    public void onEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
                        boolean throwEEE = false;
                        Object oldVal = event.getOldValue();
                        Object newVal = event.getNewValue();
                        Long lastModifiedFromOrigin = (Long)event.getContextObject();
                        if (lastModifiedFromOrigin == null || lastModifiedFromOrigin.longValue() != entry.getLastModified()) {
                            throwEEE = true;
                        } else if (oldVal instanceof byte[] && newVal instanceof byte[] || oldVal instanceof byte[][] && newVal instanceof byte[][]) {
                            if (oldVal instanceof byte[]) {
                                throwEEE = ((byte[])oldVal).length != ((byte[])newVal).length || !Arrays.equals((byte[])oldVal, (byte[])newVal);
                            } else if (((byte[][])oldVal).length == ((byte[][])newVal).length) {
                                int len = ((byte[][])oldVal).length;
                                for (int i = 0; i < len; ++i) {
                                    boolean bl = throwEEE = !Arrays.equals(((byte[][])oldVal)[i], ((byte[][])newVal)[i]);
                                    if (!throwEEE) {
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                throwEEE = true;
                            }
                        } else {
                            throwEEE = true;
                        }
                        if (throwEEE) {
                            throw new EntryExistsException(event.getKey().toString(), event.getOldValue());
                        }
                    }

                    public boolean needsRecovery() {
                        return false;
                    }

                    public boolean lockForIndexGII() throws TimeoutException {
                        return false;
                    }

                    public void lockForGII() throws TimeoutException {
                    }

                    public boolean clearIndexes(LocalRegion region, boolean lockForGII, boolean holdIndexLock, Iterator<?> bucketEntriesIter, boolean destroyOffline) {
                        return false;
                    }

                    public void releaseIndexLock(LocalRegion region) {
                    }

                    public void onOverflowToDisk(RegionEntry entry) {
                    }

                    public void onFaultInFromDisk(RegionEntry entry) {
                    }

                    public boolean hasRemoteOperations(Operation op) {
                        return false;
                    }

                    public boolean avoidSerialExecutor(Operation op) {
                        return false;
                    }

                    public boolean handleSuspectEvents() {
                        return false;
                    }

                    public void unlockForGII(boolean forWrite) throws LockNotHeldException {
                    }
                });
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof UpdateOperation.UpdateMessage) {
                            UpdateOperation.UpdateMessage mssg = (UpdateOperation.UpdateMessage)message;
                            LogWriter logger = Bug43522DUnit.this.getCache().getLogger();
                            try {
                                GemFireCacheImpl cache = Bug43522DUnit.this.getGemfireCache();
                                GemFireCacheImpl.setGFXDSystemForTests();
                                LocalRegion lr = (LocalRegion)cache.getRegion(mssg.regionPath);
                                AbstractRegionEntry entry = (AbstractRegionEntry)lr.basicGetEntry(mssg.key);
                                logger.info("last modified time of entry =" + entry.getLastModified());
                                logger.info("last modified time from message =" + (mssg.lastModified - dm.getCacheTimeOffset()));
                                TestCase.assertEquals((long)entry.getLastModified(), (long)(mssg.lastModified - dm.getCacheTimeOffset()));
                                logger.info("About to sleep");
                                Thread.sleep(25000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        DistributionMessageObserver dmoClient = new DistributionMessageObserver(){

            public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
            }

            public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof CreateRegionProcessor.CreateRegionMessage) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Cache cache = Bug43522DUnit.this.getCache();
                            Region region = cache.getRegion(Bug43522DUnit.REGION_NAME);
                            try {
                                region.create((Object)6, (Object)new byte[][]{{1, -1, 122, 78, 65, -65, 71}, {0, -1, 122, 79, 65, -65, 71}, {1, -1, 121, 78, 65, -65, 71}});
                            }
                            catch (Exception e) {
                                exceptionFound = true;
                            }
                        }
                    });
                    th.start();
                    try {
                        th.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
            }
        };
        Bug43522DUnit.disconnectFromDS();
        DistributionMessageObserver.setInstance((DistributionMessageObserver)dmoClient);
        vm0.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else if (message instanceof UpdateOperation.UpdateMessage) {
                            GemFireCacheImpl.setGFXDSystemForTests();
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        vm0.invoke(createRegionStore1);
        createRegionAcc.run();
        vm1.invoke(createRegionStore2);
        Thread.sleep(30000L);
        Bug43522DUnit.assertFalse((boolean)exceptionFound);
    }

    public void testBugForPutAll() throws Exception {
        SerializableRunnable createRegionAcc = new SerializableRunnable("Create non persistent empty region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.EMPTY);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore1 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(Bug43522DUnit.REGION_NAME);
            }
        };
        SerializableRunnable createRegionStore2 = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Bug43522DUnit.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                LocalRegion lr = (LocalRegion)rf.create(Bug43522DUnit.REGION_NAME);
                ((AbstractRegionMap)lr.getRegionMap()).testOnlySetIndexUpdater(new IndexUpdater(){

                    public void unlockForIndexGII() throws LockNotHeldException {
                    }

                    public void unlockForGII() throws LockNotHeldException {
                    }

                    public void postEventCleanup(EntryEventImpl event) {
                    }

                    public void postEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry, boolean success) {
                    }

                    public void onEvent(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
                        boolean throwEEE = false;
                        Object oldVal = event.getOldValue();
                        Object newVal = event.getNewValue();
                        Long lastModifiedFromOrigin = (Long)event.getContextObject();
                        if (lastModifiedFromOrigin == null || lastModifiedFromOrigin.longValue() != entry.getLastModified()) {
                            throwEEE = true;
                        } else if (oldVal instanceof byte[] && newVal instanceof byte[] || oldVal instanceof byte[][] && newVal instanceof byte[][]) {
                            if (oldVal instanceof byte[]) {
                                throwEEE = ((byte[])oldVal).length != ((byte[])newVal).length || !Arrays.equals((byte[])oldVal, (byte[])newVal);
                            } else if (((byte[][])oldVal).length == ((byte[][])newVal).length) {
                                int len = ((byte[][])oldVal).length;
                                for (int i = 0; i < len; ++i) {
                                    boolean bl = throwEEE = !Arrays.equals(((byte[][])oldVal)[i], ((byte[][])newVal)[i]);
                                    if (!throwEEE) {
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                throwEEE = true;
                            }
                        } else {
                            throwEEE = true;
                        }
                        if (throwEEE) {
                            throw new EntryExistsException(event.getKey().toString(), event.getOldValue());
                        }
                    }

                    public boolean needsRecovery() {
                        return false;
                    }

                    public boolean lockForIndexGII() throws TimeoutException {
                        return false;
                    }

                    public void lockForGII() throws TimeoutException {
                    }

                    public boolean clearIndexes(LocalRegion region, boolean lockForGII, boolean holdIndexLock, Iterator<?> bucketEntriesIter, boolean destroyOffline) {
                        return false;
                    }

                    public void releaseIndexLock(LocalRegion region) {
                    }

                    public void onOverflowToDisk(RegionEntry entry) {
                    }

                    public void onFaultInFromDisk(RegionEntry entry) {
                    }

                    public boolean hasRemoteOperations(Operation op) {
                        return false;
                    }

                    public boolean avoidSerialExecutor(Operation op) {
                        return false;
                    }

                    public boolean handleSuspectEvents() {
                        return false;
                    }

                    public void unlockForGII(boolean forWrite) throws LockNotHeldException {
                    }
                });
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof DistributedPutAllOperation.PutAllMessage) {
                            LogWriter logger = Bug43522DUnit.this.getCache().getLogger();
                            try {
                                GemFireCacheImpl.setGFXDSystemForTests();
                                logger.info("About to sleep");
                                Thread.sleep(25000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        DistributionMessageObserver dmoClient = new DistributionMessageObserver(){

            public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
            }

            public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof CreateRegionProcessor.CreateRegionMessage) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Cache cache = Bug43522DUnit.this.getCache();
                            HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>();
                            byte[] data = new byte[]{1, 2, 3, 4, 5, 6};
                            for (int i = 1; i < 10; ++i) {
                                map.put(i, data);
                            }
                            Region region = cache.getRegion(Bug43522DUnit.REGION_NAME);
                            try {
                                region.putAll(map);
                            }
                            catch (Exception e) {
                                exceptionFound = true;
                            }
                        }
                    });
                    th.start();
                    try {
                        th.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
            }
        };
        Bug43522DUnit.disconnectFromDS();
        DistributionMessageObserver.setInstance((DistributionMessageObserver)dmoClient);
        vm0.invoke(new SerializableRunnable("Add Message observer"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver dmo = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else if (message instanceof UpdateOperation.UpdateMessage) {
                            GemFireCacheImpl.setGFXDSystemForTests();
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)dmo);
                Bug43522DUnit.this.getCache();
            }
        });
        vm0.invoke(createRegionStore1);
        createRegionAcc.run();
        vm1.invoke(createRegionStore2);
        Thread.sleep(30000L);
        Bug43522DUnit.assertFalse((boolean)exceptionFound);
    }
}

