/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientPartitionAdvisor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Bug42010StatsDUnitTest
extends CacheTestCase {
    private static final String Region_Name = "42010";
    private VM member0 = null;
    private VM member1 = null;
    private VM member2 = null;
    private VM member3 = null;
    private static Region region = null;
    private static Region customerRegion = null;
    private static Region orderRegion = null;
    private static Region shipmentRegion = null;
    private static Region regionWithResolver = null;
    private static Cache cache = null;
    private static final int locatorPort = 12345;
    private static Locator locator = null;
    private static long metaDataRefreshCount;
    private static long nonSingleHopsCount;
    private static long metaDataRefreshCount_Customer;
    private static long nonSingleHopsCount_Customer;
    private static long metaDataRefreshCount_Order;
    private static long nonSingleHopsCount_Order;
    private static long metaDataRefreshCount_Shipment;
    private static long nonSingleHopsCount_Shipment;

    public Bug42010StatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.member0 = host.getVM(0);
        this.member1 = host.getVM(1);
        this.member2 = host.getVM(2);
        this.member3 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            this.member0.invoke(Bug42010StatsDUnitTest.class, "closeCache");
            this.member1.invoke(Bug42010StatsDUnitTest.class, "closeCache");
            this.member2.invoke(Bug42010StatsDUnitTest.class, "closeCache");
            this.member3.invoke(Bug42010StatsDUnitTest.class, "closeCache");
            Bug42010StatsDUnitTest.closeCache();
            super.tearDown2();
            this.member0 = null;
            this.member1 = null;
            this.member2 = null;
            this.member3 = null;
            cache = null;
            Bug42010StatsDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    cache = null;
                }
            });
        }
        finally {
            Bug42010StatsDUnitTest.unregisterAllDataSerializersFromAllVms();
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void test_clientStats_PR() {
        VM server1 = this.member0;
        VM server2 = this.member1;
        VM server3 = this.member2;
        VM client1 = this.member3;
        Integer port0 = (Integer)this.member0.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 113, "No_Colocation"});
        Integer port1 = (Integer)this.member1.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 113, "No_Colocation"});
        Integer port2 = (Integer)this.member2.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 113, "No_Colocation"});
        client1.invoke(Bug42010StatsDUnitTest.class, "createClient", new Object[]{port0, port1, port2, "No_Colocation"});
        Bug42010StatsDUnitTest.createClient(port0, port1, port2, "No_Colocation");
        client1.invoke(Bug42010StatsDUnitTest.class, "createPR", new Object[]{"FirstClient", "No_Colocation"});
        Bug42010StatsDUnitTest.createPR("SecondClient", "No_Colocation");
        client1.invoke(Bug42010StatsDUnitTest.class, "getPR", new Object[]{"FirstClient", "No_Colocation"});
        Bug42010StatsDUnitTest.getPR("SecondClient", "No_Colocation");
        client1.invoke(Bug42010StatsDUnitTest.class, "updatePR", new Object[]{"FirstClient", "No_Colocation"});
    }

    public void test_clientStatsColocation_PR() {
        VM server1 = this.member0;
        VM server2 = this.member1;
        VM server3 = this.member2;
        VM client1 = this.member3;
        Integer port0 = (Integer)this.member0.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 4, "Colocation"});
        Integer port1 = (Integer)this.member1.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 4, "Colocation"});
        Integer port2 = (Integer)this.member2.invoke(Bug42010StatsDUnitTest.class, "createServerForStats", new Object[]{0, 4, "Colocation"});
        client1.invoke(Bug42010StatsDUnitTest.class, "createClient", new Object[]{port0, port1, port2, "Colocation"});
        Bug42010StatsDUnitTest.createClient(port0, port1, port2, "Colocation");
        client1.invoke(Bug42010StatsDUnitTest.class, "createPR", new Object[]{"FirstClient", "Colocation"});
        client1.invoke(Bug42010StatsDUnitTest.class, "getPR", new Object[]{"FirstClient", "Colocation"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0, int port1, int port2, String colocation) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        Bug42010StatsDUnitTest test = new Bug42010StatsDUnitTest("Bug42010StatsDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug42010StatsDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).addServer("localhost", port1).addServer("localhost", port2).setSubscriptionEnabled(false).create(Region_Name);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        Bug42010StatsDUnitTest.createRegionInClientCache(p.getName(), colocation);
    }

    public static int createServerForStats(int redundantCopies, int totalNoofBuckets, String colocation) {
        Bug42010StatsDUnitTest test = new Bug42010StatsDUnitTest("Bug42010StatsDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            Bug42010StatsDUnitTest.fail("Failed to start server ", e);
        }
        if (colocation.equals("No_Colocation")) {
            if (totalNoofBuckets == 0) {
                AttributesFactory attr = new AttributesFactory();
                attr.setScope(Scope.DISTRIBUTED_ACK);
                attr.setDataPolicy(DataPolicy.REPLICATE);
                region = cache.createRegion(Region_Name, attr.create());
                Bug42010StatsDUnitTest.assertNotNull((Object)region);
                Bug42010StatsDUnitTest.getLogWriter().info("Distributed Region 42010 created Successfully :" + region.toString());
            } else {
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(paf.create());
                region = cache.createRegion(Region_Name, attr.create());
                Bug42010StatsDUnitTest.assertNotNull((Object)region);
                Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region 42010 created Successfully :" + region.toString());
            }
        } else {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            AttributesFactory attr = new AttributesFactory();
            attr.setPartitionAttributes(paf.create());
            customerRegion = cache.createRegion("CUSTOMER", attr.create());
            Bug42010StatsDUnitTest.assertNotNull((Object)customerRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            attr = new AttributesFactory();
            attr.setPartitionAttributes(paf.create());
            orderRegion = cache.createRegion("ORDER", attr.create());
            Bug42010StatsDUnitTest.assertNotNull((Object)orderRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            attr = new AttributesFactory();
            attr.setPartitionAttributes(paf.create());
            shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
            Bug42010StatsDUnitTest.assertNotNull((Object)shipmentRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        }
        return port;
    }

    private static void createRegionInClientCache(String poolName, String colocation) {
        if (colocation.equals("No_Colocation")) {
            AttributesFactory factory = new AttributesFactory();
            factory.setPoolName(poolName);
            factory.setDataPolicy(DataPolicy.EMPTY);
            RegionAttributes attrs = factory.create();
            region = cache.createRegion(Region_Name, attrs);
            Bug42010StatsDUnitTest.assertNotNull((Object)region);
            Bug42010StatsDUnitTest.getLogWriter().info("Region 42010 created Successfully :" + region.toString());
        } else {
            AttributesFactory factory = new AttributesFactory();
            factory.setPoolName(poolName);
            RegionAttributes attrs = factory.create();
            customerRegion = cache.createRegion("CUSTOMER", attrs);
            Bug42010StatsDUnitTest.assertNotNull((Object)customerRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
            factory = new AttributesFactory();
            factory.setPoolName(poolName);
            attrs = factory.create();
            orderRegion = cache.createRegion("ORDER", attrs);
            Bug42010StatsDUnitTest.assertNotNull((Object)orderRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
            factory = new AttributesFactory();
            factory.setPoolName(poolName);
            attrs = factory.create();
            shipmentRegion = cache.createRegion("SHIPMENT", attrs);
            Bug42010StatsDUnitTest.assertNotNull((Object)shipmentRegion);
            Bug42010StatsDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        }
    }

    public static void createPR(String FromClient, String colocation) {
        if (colocation.equals("No_Colocation")) {
            if (FromClient.equals("FirstClient")) {
                for (int i = 0; i < 113; ++i) {
                    region.create((Object)new Integer(i), (Object)("create" + i));
                }
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                Bug42010StatsDUnitTest.assertEquals((int)0, (int)regionMetaData.size());
                for (int i = 113; i < 226; ++i) {
                    region.create((Object)new Integer(i), (Object)("create" + i));
                }
                cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                Bug42010StatsDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
                Bug42010StatsDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                metaDataRefreshCount = ((LocalRegion)region).getCachePerfStats().getMetaDataRefreshCount();
                nonSingleHopsCount = ((LocalRegion)region).getCachePerfStats().getNonSingleHopsCount();
                Bug42010StatsDUnitTest.assertTrue((metaDataRefreshCount != 0L ? 1 : 0) != 0);
                Bug42010StatsDUnitTest.assertTrue((nonSingleHopsCount != 0L ? 1 : 0) != 0);
            } else {
                for (int i = 0; i < 226; ++i) {
                    region.create((Object)new Integer(i), (Object)("create" + i));
                }
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                Bug42010StatsDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
                Bug42010StatsDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                metaDataRefreshCount = ((LocalRegion)region).getCachePerfStats().getMetaDataRefreshCount();
                nonSingleHopsCount = ((LocalRegion)region).getCachePerfStats().getNonSingleHopsCount();
                Bug42010StatsDUnitTest.assertTrue((metaDataRefreshCount != 0L ? 1 : 0) != 0);
                Bug42010StatsDUnitTest.assertTrue((nonSingleHopsCount != 0L ? 1 : 0) != 0);
            }
        } else {
            for (int i = 0; i <= 20; ++i) {
                CustId custid = new CustId(i);
                Customer customer = new Customer("name" + i, "Address" + i);
                customerRegion.put((Object)custid, (Object)customer);
                for (int j = 1; j <= 10; ++j) {
                    int oid = i * 10 + j;
                    OrderId orderId = new OrderId(oid, custid);
                    Order order = new Order("OREDR" + oid);
                    orderRegion.put((Object)orderId, (Object)order);
                    for (int k = 1; k <= 10; ++k) {
                        int sid = oid * 10 + k;
                        ShipmentId shipmentId = new ShipmentId(sid, orderId);
                        Shipment shipment = new Shipment("Shipment" + sid);
                        shipmentRegion.put((Object)shipmentId, (Object)shipment);
                    }
                }
            }
            ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
            Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
            Bug42010StatsDUnitTest.assertEquals((int)3, (int)regionMetaData.size());
            Bug42010StatsDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion.getFullPath()));
            ClientPartitionAdvisor prMetaData_Customer = (ClientPartitionAdvisor)regionMetaData.get(customerRegion.getFullPath());
            metaDataRefreshCount_Customer = ((LocalRegion)customerRegion).getCachePerfStats().getMetaDataRefreshCount();
            nonSingleHopsCount_Customer = ((LocalRegion)customerRegion).getCachePerfStats().getNonSingleHopsCount();
            Bug42010StatsDUnitTest.assertTrue((metaDataRefreshCount_Customer != 0L ? 1 : 0) != 0);
            Bug42010StatsDUnitTest.assertTrue((nonSingleHopsCount_Customer != 0L ? 1 : 0) != 0);
            ClientPartitionAdvisor prMetaData_Order = (ClientPartitionAdvisor)regionMetaData.get(orderRegion.getFullPath());
            metaDataRefreshCount_Order = ((LocalRegion)orderRegion).getCachePerfStats().getMetaDataRefreshCount();
            nonSingleHopsCount_Order = ((LocalRegion)orderRegion).getCachePerfStats().getNonSingleHopsCount();
            Bug42010StatsDUnitTest.assertTrue((metaDataRefreshCount_Order == 0L ? 1 : 0) != 0);
            Bug42010StatsDUnitTest.assertTrue((nonSingleHopsCount_Order != 0L ? 1 : 0) != 0);
            ClientPartitionAdvisor prMetaData_Shipment = (ClientPartitionAdvisor)regionMetaData.get(shipmentRegion.getFullPath());
            metaDataRefreshCount_Shipment = ((LocalRegion)shipmentRegion).getCachePerfStats().getMetaDataRefreshCount();
            nonSingleHopsCount_Shipment = ((LocalRegion)shipmentRegion).getCachePerfStats().getNonSingleHopsCount();
            Bug42010StatsDUnitTest.assertTrue((metaDataRefreshCount_Shipment == 0L ? 1 : 0) != 0);
            Bug42010StatsDUnitTest.assertTrue((nonSingleHopsCount_Shipment != 0L ? 1 : 0) != 0);
        }
    }

    public static void getPR(String FromClient, String colocation) {
        if (colocation.equals("No_Colocation")) {
            if (FromClient.equals("FirstClient")) {
                for (int i = 0; i < 226; ++i) {
                    region.get((Object)new Integer(i));
                }
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                Bug42010StatsDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount, (long)((LocalRegion)region).getCachePerfStats().getMetaDataRefreshCount());
                Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount, (long)((LocalRegion)region).getCachePerfStats().getNonSingleHopsCount());
            } else {
                for (int i = 0; i < 226; ++i) {
                    region.get((Object)new Integer(i));
                }
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                Bug42010StatsDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount, (long)((LocalRegion)region).getCachePerfStats().getMetaDataRefreshCount());
                Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount, (long)((LocalRegion)region).getCachePerfStats().getNonSingleHopsCount());
            }
        } else {
            for (int i = 0; i <= 20; ++i) {
                CustId custid = new CustId(i);
                customerRegion.get((Object)custid);
                for (int j = 1; j <= 10; ++j) {
                    int oid = i * 10 + j;
                    OrderId orderId = new OrderId(oid, custid);
                    orderRegion.get((Object)orderId);
                    for (int k = 1; k <= 10; ++k) {
                        int sid = oid * 10 + k;
                        ShipmentId shipmentId = new ShipmentId(sid, orderId);
                        shipmentRegion.get((Object)shipmentId);
                    }
                }
            }
            ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
            Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
            Bug42010StatsDUnitTest.assertEquals((int)3, (int)regionMetaData.size());
            Bug42010StatsDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion.getFullPath()));
            ClientPartitionAdvisor prMetaData_Customer = (ClientPartitionAdvisor)regionMetaData.get(customerRegion.getFullPath());
            Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount_Customer, (long)((LocalRegion)customerRegion).getCachePerfStats().getMetaDataRefreshCount());
            Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount_Customer, (long)((LocalRegion)customerRegion).getCachePerfStats().getNonSingleHopsCount());
            ClientPartitionAdvisor prMetaData_Order = (ClientPartitionAdvisor)regionMetaData.get(orderRegion.getFullPath());
            Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount_Order, (long)((LocalRegion)orderRegion).getCachePerfStats().getMetaDataRefreshCount());
            Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount_Order, (long)((LocalRegion)orderRegion).getCachePerfStats().getNonSingleHopsCount());
            ClientPartitionAdvisor prMetaData_Shipment = (ClientPartitionAdvisor)regionMetaData.get(shipmentRegion.getFullPath());
            Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount_Shipment, (long)((LocalRegion)shipmentRegion).getCachePerfStats().getMetaDataRefreshCount());
            Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount_Shipment, (long)((LocalRegion)shipmentRegion).getCachePerfStats().getNonSingleHopsCount());
        }
    }

    public static void updatePR(String FromClient, String colocation) {
        if (colocation.equals("No_Colocation") && FromClient.equals("FirstClient")) {
            for (int i = 0; i < 226; ++i) {
                region.put((Object)new Integer(i), (Object)("Update" + i));
            }
            ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
            Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
            Bug42010StatsDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
            ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
            Bug42010StatsDUnitTest.assertEquals((long)metaDataRefreshCount, (long)((LocalRegion)region).getCachePerfStats().getMetaDataRefreshCount());
            Bug42010StatsDUnitTest.assertEquals((long)nonSingleHopsCount, (long)((LocalRegion)region).getCachePerfStats().getNonSingleHopsCount());
        }
    }
}

