/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.SearchLoadAndWriteProcessor;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;

public class Bug40299DUnitTest
extends CacheTestCase {
    protected static String regionName = "TestRegion";
    static Properties props = new Properties();
    protected static DistributedSystem distributedSystem = null;
    private static VM vm0 = null;
    protected static Cache cache = null;

    public Bug40299DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
    }

    @Override
    public void tearDown2() throws Exception {
        vm0.invoke(this.destroyRegion());
        super.tearDown2();
    }

    private CacheSerializableRunnable createCacheForVM0() {
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() {
                try {
                    distributedSystem = new Bug40299DUnitTest("vm0_diskReg").getSystem(props);
                    TestCase.assertTrue((distributedSystem != null ? 1 : 0) != 0);
                    cache = CacheFactory.create((DistributedSystem)distributedSystem);
                    TestCase.assertTrue((cache != null ? 1 : 0) != 0);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    File dir = new File("testingDirectoryDefault");
                    dir.mkdir();
                    dir.deleteOnExit();
                    File[] dirs = new File[]{dir};
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setDiskSynchronous(false);
                    factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirsAndSizes(dirs, new int[]{Integer.MAX_VALUE}).setQueueSize(1).setMaxOplogSize(60L).setAutoCompact(false).setTimeInterval(1000L).create("Bug40299DUnitTest").getName());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)2, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    RegionAttributes attr = factory.create();
                    cache.createRegion(regionName, attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)"Error Creating cache / region ");
                }
            }
        };
        return createCache;
    }

    private CacheSerializableRunnable putSomeEntries() {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("putSomeEntries"){

            @Override
            public void run2() {
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                Region rgn = cache.getRegion(regionName);
                for (int i = 0; i < 7; ++i) {
                    rgn.put((Object)("key" + i), (Object)new Long(i));
                }
            }
        };
        return puts;
    }

    private CacheSerializableRunnable concurrentNetSearchGetAndClear() {
        CacheSerializableRunnable getAndClear = new CacheSerializableRunnable("concurrentNetSearchGetAndClear"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() {
                block9: {
                    TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                    Region rgn = cache.getRegion(regionName);
                    TestCase.assertTrue((String)("Region size expected to be 7 but is " + rgn.size()), (rgn.size() == 7 ? 1 : 0) != 0);
                    Thread getThread1 = null;
                    LocalRegion lr = (LocalRegion)rgn;
                    lr.getDiskRegion().acquireWriteLock();
                    try {
                        getThread1 = new Thread(new getThread((LocalRegion)rgn));
                        getThread1.start();
                        Thread.sleep(1000L);
                        RegionEventImpl regionEvent = new RegionEventImpl((Region)lr, Operation.REGION_CLEAR, null, false, (DistributedMember)lr.getMyId(), lr.generateEventID());
                        lr.cmnClearRegion(regionEvent, true, false);
                    }
                    catch (InterruptedException e) {
                        if (cache.getLogger().fineEnabled()) {
                            cache.getLogger().fine("InterruptedException in run of localClearThread");
                        }
                    }
                    finally {
                        ((LocalRegion)rgn).getDiskRegion().releaseWriteLock();
                    }
                    try {
                        getThread1.join();
                    }
                    catch (InterruptedException ie) {
                        if (!cache.getLogger().fineEnabled()) break block9;
                        cache.getLogger().fine("InterruptedException in join of getThread");
                    }
                }
            }
        };
        return getAndClear;
    }

    private CacheSerializableRunnable verifyRegionNotDestroyed() {
        CacheSerializableRunnable verifyR = new CacheSerializableRunnable("verifyRegionNotDestroyed"){

            @Override
            public void run2() {
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                Region region = cache.getRegion(regionName);
                TestCase.assertTrue((String)"Region was destroyed", (region != null ? 1 : 0) != 0);
            }
        };
        return verifyR;
    }

    private CacheSerializableRunnable destroyRegion() {
        CacheSerializableRunnable destroyR = new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() {
                try {
                    TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                    Region rgn = cache.getRegion(regionName);
                    rgn.localDestroyRegion();
                    cache.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return destroyR;
    }

    public void testQueryGetWithClear() {
        vm0.invoke(this.createCacheForVM0());
        vm0.invoke(this.putSomeEntries());
        vm0.invoke(this.concurrentNetSearchGetAndClear());
        vm0.invoke(this.verifyRegionNotDestroyed());
    }

    protected class getThread
    implements Runnable {
        LocalRegion region = null;

        getThread(LocalRegion rgn) {
            this.region = rgn;
        }

        @Override
        public void run() {
            SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
            processor.initialize(this.region, (Object)"key1", null);
            processor.testNetSearchMessageDoGet(this.region.getName(), (Object)"key1", 1500, 1500, 1500);
        }
    }
}

