/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.AbstractOplogDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskRegionHelperFactory;
import com.gemstone.gemfire.internal.cache.DiskRegionProperties;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.concurrent.CustomEntryConcurrentHashMap;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class Bug39079DUnitTest
extends CacheTestCase {
    protected static String regionName = "IGNORE_EXCEPTION_Bug39079";
    static Properties props = new Properties();
    private static VM vm0 = null;
    private static VM vm1 = null;
    private static String REGION_NAME = "IGNORE_EXCEPTION_testBridgeServerStoppingInSynchPersistOnlyForIOExceptionCase";
    private static Cache gemfirecache = null;
    private static Region region;
    protected static File[] dirs;
    private static final int maxEntries = 10000;

    public Bug39079DUnitTest(String name) {
        super(name);
        File file1 = new File(name + "1");
        file1.mkdir();
        file1.deleteOnExit();
        File file2 = new File(name + "2");
        file2.mkdir();
        file2.deleteOnExit();
        dirs = new File[2];
        Bug39079DUnitTest.dirs[0] = file1;
        Bug39079DUnitTest.dirs[1] = file2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm0.invoke(Bug39079DUnitTest.class, "ignorePreAllocate", new Object[]{Boolean.TRUE});
        vm1.invoke(Bug39079DUnitTest.class, "ignorePreAllocate", new Object[]{Boolean.TRUE});
    }

    private CacheSerializableRunnable createCacheForVM0() {
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() {
                try {
                    new Bug39079DUnitTest("vm0_diskReg").getSystem();
                    TestCase.assertTrue((Bug39079DUnitTest.this.getCache() != null ? 1 : 0) != 0);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setDiskSynchronous(false);
                    factory.setDiskStoreName(Bug39079DUnitTest.this.getCache().createDiskStoreFactory().setDiskDirs(dirs).create("Bug39079DUnitTest").getName());
                    RegionAttributes attr = factory.create();
                    Bug39079DUnitTest.this.getCache().createRegion(regionName, attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)"Error Creating cache / region ");
                }
            }
        };
        return createCache;
    }

    private CacheSerializableRunnable createCacheForVM1() {
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() {
                try {
                    new Bug39079DUnitTest("vm1_diskReg").getSystem();
                    TestCase.assertTrue((String)"cache found null", (Bug39079DUnitTest.this.getCache() != null ? 1 : 0) != 0);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setDiskSynchronous(false);
                    factory.setDiskStoreName(Bug39079DUnitTest.this.getCache().createDiskStoreFactory().setDiskDirs(dirs).create("Bug39079DUnitTest").getName());
                    RegionAttributes attr = factory.create();
                    Bug39079DUnitTest.this.getCache().createRegion(regionName, attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Error Creating cache / region " + ex));
                }
            }
        };
        return createCache;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        Bug39079DUnitTest.disconnectAllFromDS();
        vm0.invoke(Bug39079DUnitTest.class, "ignorePreAllocate", new Object[]{Boolean.FALSE});
        vm1.invoke(Bug39079DUnitTest.class, "ignorePreAllocate", new Object[]{Boolean.FALSE});
    }

    static void ignorePreAllocate(boolean flag) throws Exception {
        DiskStoreImpl.SET_IGNORE_PREALLOCATE = flag;
    }

    public void testGIIDiskAccessException() {
        vm0.invoke(this.createCacheForVM0());
        vm1.invoke(this.createCacheForVM1());
        this.getSystem();
        Bug39079DUnitTest.assertTrue((this.getCache() != null ? 1 : 0) != 0);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        factory.setDiskSynchronous(false);
        factory.setDiskStoreName(this.getCache().createDiskStoreFactory().setDiskDirs(dirs).create("Bug39079DUnitTest").getName());
        RegionAttributes attr = factory.create();
        Region rgn = this.getCache().createRegion(regionName, attr);
        for (int i = 0; i < 100; ++i) {
            rgn.put((Object)new Integer(i), (Object)new Integer(i));
        }
        rgn.close();
        DistributedRegion distRegion = new DistributedRegion(regionName, attr, null, (GemFireCacheImpl)this.getCache(), new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null));
        ((AbstractRegionMap)distRegion.entries).setEntryFactory(TestAbstractDiskRegionEntry.getEntryFactory());
        rgn = null;
        try {
            rgn = ((GemFireCacheImpl)this.getCache()).createVMRegion(regionName, attr, new InternalRegionArguments().setInternalMetaRegion((LocalRegion)distRegion).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null));
        }
        catch (DiskAccessException diskAccessException) {
        }
        catch (Exception e) {
            Bug39079DUnitTest.fail((String)(" test failed because of exception =" + e.toString()));
        }
        Bug39079DUnitTest.assertTrue((rgn == null || rgn.isDestroyed() ? 1 : 0) != 0);
    }

    public void testBridgeServerStoppingInSynchPersistOnlyForIOExceptionCase() throws Exception {
        Integer port = (Integer)vm0.invoke(Bug39079DUnitTest.class, "createServerCache");
        vm1.invoke(Bug39079DUnitTest.class, "createClientCache", new Object[]{Bug39079DUnitTest.getServerHostName(vm0.getHost()), port});
        vm0.invoke(Bug39079DUnitTest.class, "validateRuningBridgeServerList");
        vm0.invoke(Bug39079DUnitTest.class, "closeCache");
        vm1.invoke(Bug39079DUnitTest.class, "closeCache");
    }

    public static Integer createServerCache() throws Exception {
        new Bug39079DUnitTest("temp").createCache(new Properties());
        DiskRegionProperties props = new DiskRegionProperties();
        props.setRegionName(REGION_NAME);
        props.setOverflow(true);
        props.setRolling(true);
        props.setDiskDirs(dirs);
        props.setPersistBackup(true);
        region = DiskRegionHelperFactory.getSyncPersistOnlyRegion((Cache)gemfirecache, (DiskRegionProperties)props, (Scope)Scope.DISTRIBUTED_ACK);
        Bug39079DUnitTest.assertNotNull((Object)region);
        BridgeServer bs1 = gemfirecache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        bs1.setPort(port);
        bs1.start();
        return new Integer(bs1.getPort());
    }

    public static void closeCache() {
        if (gemfirecache != null && !gemfirecache.isClosed()) {
            gemfirecache.close();
            gemfirecache.getDistributedSystem().disconnect();
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Bug39079DUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        gemfirecache = CacheFactory.create((DistributedSystem)ds);
        Bug39079DUnitTest.assertNotNull((Object)gemfirecache);
    }

    private static void validateRuningBridgeServerList() throws Exception {
        try {
            region.create((Object)"key1", (Object)new byte[16]);
            region.create((Object)"key2", (Object)new byte[16]);
            FileChannel oplogFileChannel = ((LocalRegion)region).getDiskRegion().testHook_getChild().getFileChannel();
            try {
                oplogFileChannel.close();
                region.put((Object)"key2", (Object)new byte[16]);
            }
            catch (DiskAccessException diskAccessException) {
            }
            catch (IOException e) {
                Bug39079DUnitTest.fail("test failed due to ", e);
            }
            Bug39079DUnitTest.assertTrue((boolean)region.isDestroyed());
            region = null;
            List bsRunning = gemfirecache.getBridgeServers();
            Bug39079DUnitTest.assertTrue((boolean)bsRunning.isEmpty());
        }
        finally {
            if (region != null) {
                region.destroyRegion();
            }
        }
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        new Bug39079DUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new Bug39079DUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setThreadLocalConnections(true).setMinConnections(0).setReadTimeout(20000).setRetryAttempts(1).create("Bug39079DUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region r = gemfirecache.createRegion(REGION_NAME, attrs);
        r.registerInterest((Object)"ALL_KEYS");
    }

    static {
        dirs = null;
    }

    static class TestAbstractDiskRegionEntry
    extends AbstractOplogDiskRegionEntry {
        private static RegionEntryFactory factory = new RegionEntryFactory(){

            public final RegionEntry createEntry(RegionEntryContext r, Object key, Object value) {
                throw new DiskAccessException((Throwable)new IOException("Test Exception"));
            }

            public final Class getEntryClass() {
                return TestAbstractDiskRegionEntry.class;
            }

            public RegionEntryFactory makeVersioned() {
                return this;
            }

            public RegionEntryFactory makeOnHeap() {
                return this;
            }
        };
        private Object key;
        private volatile Object value;

        protected TestAbstractDiskRegionEntry(RegionEntryContext r, Object key, Object value) {
            super(r, value);
            this.key = key;
        }

        public void processVersionTag(EntryEvent ev) {
        }

        public void setValue(LocalRegion r, Object v) throws RegionClearedException {
            throw new DiskAccessException((Throwable)new IOException("Test Exception"));
        }

        public static RegionEntryFactory getEntryFactory() {
            return factory;
        }

        public Object getRawKey() {
            return this.key;
        }

        protected void _setRawKey(Object key) {
            this.key = key;
        }

        protected Object getValueField() {
            return this.value;
        }

        protected void setValueField(Object v) {
            this.value = v;
        }

        public DiskId getDiskId() {
            return null;
        }

        public int updateAsyncEntrySize(EnableLRU capacityController) {
            return 0;
        }

        public int getEntryHash() {
            return 0;
        }

        public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
            return null;
        }

        public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        }

        public void setDiskId(RegionEntry oldRe) {
        }

        protected void initialize(RegionEntryContext context, Object value) {
        }

        protected long getlastModifiedField() {
            return 0L;
        }

        protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
            return false;
        }

        protected void setEntryHash(int v) {
        }
    }
}

