/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class Bug37241DUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    static VM server1 = null;
    static VM server2 = null;
    private static final String REGION_NAME = "Bug37241DUnitTest_region";
    static final String expectedReplyException = ReplyException.class.getName();
    static final String expectedException = IllegalStateException.class.getName();

    public Bug37241DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
    }

    public void testBug37241ForNewDiskRegion() {
        server1.invoke(Bug37241DUnitTest.class, "createRegionOnServer1");
        try {
            server2.invoke(Bug37241DUnitTest.class, "createRegionOnServer2", new Object[]{Scope.DISTRIBUTED_ACK});
        }
        catch (Exception e) {
            server2.invoke(Bug37241DUnitTest.class, "ignoreExceptionInLogs");
            server2.invoke(Bug37241DUnitTest.class, "checkForCleanup");
        }
    }

    public void testBug37241ForRecreatedDiskRegion() {
        server1.invoke(Bug37241DUnitTest.class, "createRegionOnServer1");
        server2.invoke(Bug37241DUnitTest.class, "createRegionOnServer2", new Object[]{Scope.GLOBAL});
        server2.invoke(Bug37241DUnitTest.class, "closeRegion");
        try {
            server2.invoke(Bug37241DUnitTest.class, "createRegionOnServer2", new Object[]{Scope.DISTRIBUTED_ACK});
        }
        catch (Exception e) {
            server2.invoke(Bug37241DUnitTest.class, "ignoreExceptionInLogs");
            server2.invoke(Bug37241DUnitTest.class, "checkForCleanupAfterRecreation");
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Bug37241DUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug37241DUnitTest.assertNotNull((Object)cache);
    }

    public static void createRegionOnServer1() throws Exception {
        new Bug37241DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        File[] dirs = new File[2];
        File file1 = new File("server1_disk1");
        File file2 = new File("server1_disk2");
        file1.mkdir();
        file2.mkdir();
        dirs[0] = file1;
        dirs[1] = file2;
        factory.setDiskSynchronous(false);
        factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("Bug37241DUnitTest").getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void createRegionOnServer2(Scope scope) throws Exception {
        new Bug37241DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        File[] dirs = new File[2];
        File file1 = new File("server2_disk1");
        File file2 = new File("server2_disk2");
        file1.mkdir();
        file2.mkdir();
        dirs[0] = file1;
        dirs[1] = file2;
        factory.setDiskSynchronous(false);
        factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("Bug37241DUnitTest").getName());
        Bug37241DUnitTest.getLogWriter().info("<ExpectedException action=add>" + expectedReplyException + "</ExpectedException>");
        Bug37241DUnitTest.getLogWriter().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
        cache.getLogger().info("<ExpectedException action=add>" + expectedReplyException + "</ExpectedException>");
        cache.getLogger().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void checkForCleanup() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cache.getLogger().info("checkForCleanup=" + Arrays.asList(new File("server2_disk2").listFiles()));
        Bug37241DUnitTest.assertEquals((int)0, (int)new File("server2_disk2").listFiles().length);
    }

    public static void checkForCleanupAfterRecreation() {
        Bug37241DUnitTest.checkForCleanup();
    }

    public static void ignoreExceptionInLogs() {
        cache.getLogger().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
        cache.getLogger().info("<ExpectedException action=remove>" + expectedReplyException + "</ExpectedException>");
        Bug37241DUnitTest.getLogWriter().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
        Bug37241DUnitTest.getLogWriter().info("<ExpectedException action=remove>" + expectedReplyException + "</ExpectedException>");
    }

    public static void closeRegion() {
        Cache cache = CacheFactory.getAnyInstance();
        Region region = cache.getRegion("/Bug37241DUnitTest_region");
        region.close();
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        server1.invoke(Bug37241DUnitTest.class, "closeCache");
        server2.invoke(Bug37241DUnitTest.class, "closeCache");
    }
}

