/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.junit.Test;
import util.ClassBuilder;

public class JarDeployerDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    static FileLock savedFileLock = null;
    private final ClassBuilder classBuilder = new ClassBuilder();
    boolean okayToResume;

    public JarDeployerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        JarDeployer jarDeployer = new JarDeployer();
        for (JarClassLoader jarClassLoader : jarDeployer.findJarClassLoaders()) {
            if (!jarClassLoader.getJarName().startsWith("JarDeployerDUnit")) continue;
            jarDeployer.undeploy(jarClassLoader.getJarName());
        }
        for (String functionName : FunctionService.getRegisteredFunctions().keySet()) {
            if (!functionName.startsWith("JarDeployerDUnit")) continue;
            FunctionService.unregisterFunction((String)functionName);
        }
        JarDeployerDUnitTest.disconnectAllFromDS();
        this.deleteSavedJarFiles();
        super.tearDown2();
    }

    @Test
    public void testDeployFileAndChange() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        File jarFile = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDFACA");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDFACA");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        if (!jarFile.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file not found where expected: " + jarFile.getName()));
        }
        if (!this.doesFileMatchBytes(jarFile, jarBytes)) {
            JarDeployerDUnitTest.fail((String)("Contents of JAR file do not match those provided: " + jarFile.getName()));
        }
        jarFile = this.getNextVersionJarFile(jarFile);
        jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDFACB");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        if (!jarFile.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file not found where expected: " + jarFile.getName()));
        }
        if (!this.doesFileMatchBytes(jarFile, jarBytes)) {
            JarDeployerDUnitTest.fail((String)("Contents of JAR file do not match those provided: " + jarFile.getName()));
        }
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDFACB");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDFACA");
            JarDeployerDUnitTest.fail((String)"Class should not be found on Classpath: JarDeployerDUnitDFACA");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeployNoUpdateWhenNoChange() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        File jarFile = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDNUWNC");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        if (!jarFile.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file not found where expected: " + jarFile.getName()));
        }
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        if (!jarFile.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file not found where expected: " + jarFile.getName()));
        }
        if ((jarFile = this.getNextVersionJarFile(jarFile)).exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file should not have been created: " + jarFile.getName()));
        }
    }

    @Test
    public void testDeployExclusiveLock() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        VM vm = Host.getHost(0).getVM(0);
        final File jarFile1 = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDELA");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDELA");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        JarDeployerDUnitTest.assertNotNull((Object)ClassPathLoader.getLatest().getResource("JarDeployerDUnitDELA.class"));
        vm.invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream outStream = null;
                FileLock fileLock = null;
                try {
                    outStream = new FileOutputStream(jarFile1, true);
                    fileLock = outStream.getChannel().tryLock(0L, 1L, false);
                    if (fileLock != null) {
                        TestCase.fail((String)("Should not have been able to obtain exclusive lock on file:" + jarFile1.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fnfex) {
                    DistributedTestCase.fail("JAR file not found where expected", fnfex);
                }
                catch (IOException ioex) {
                    DistributedTestCase.fail("IOException when trying to obtain exclusive lock", ioex);
                }
                finally {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException ioex) {
                            TestCase.fail((String)"Could not close lock file output stream");
                        }
                    }
                    if (fileLock != null) {
                        try {
                            fileLock.channel().close();
                        }
                        catch (IOException ioex) {
                            TestCase.fail((String)"Could not close lock file channel");
                        }
                    }
                }
            }
        });
    }

    @Test
    public void testDeploySharedLock() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        VM vm = Host.getHost(0).getVM(0);
        final File jarFile1 = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDSLA");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDSLA");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                if (!jarFile1.exists()) {
                    TestCase.fail((String)("JAR file not found where expected: " + jarFile1.getName()));
                }
                try {
                    savedFileLock = JarDeployerDUnitTest.this.acquireSharedLock(jarFile1);
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"Unable to acquire the shared file lock");
                }
            }
        });
        jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDSLB");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDSLB");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitC");
            JarDeployerDUnitTest.fail((String)"Class should not be found on Classpath: JarDeployerDUniDSLA");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!jarFile1.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file should not have been deleted: " + jarFile1.getName()));
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    JarDeployerDUnitTest.this.releaseLock(savedFileLock, jarFile1);
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"Unable to release the shared file lock");
                }
            }
        });
    }

    @Test
    public void testUndeploySharedLock() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        VM vm = Host.getHost(0).getVM(0);
        final File jarFile1 = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitUSL");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitUSL");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                if (!jarFile1.exists()) {
                    TestCase.fail((String)("JAR file not found where expected: " + jarFile1.getName()));
                }
                try {
                    savedFileLock = JarDeployerDUnitTest.this.acquireSharedLock(jarFile1);
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"Unable to acquire the shared file lock");
                }
            }
        });
        jarDeployer.undeploy("JarDeployerDUnit.jar");
        if (!jarFile1.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file should not have been deleted: " + jarFile1.getName()));
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    JarDeployerDUnitTest.this.releaseLock(savedFileLock, jarFile1);
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"Unable to release the shared file lock");
                }
            }
        });
    }

    @Test
    public void testDeployUpdateByAnotherVM() throws IOException, ClassNotFoundException {
        File jarFile3;
        JarDeployer jarDeployer = new JarDeployer();
        File currentDir = new File(".").getAbsoluteFile();
        VM vm = Host.getHost(0).getVM(0);
        final File jarFile1 = this.getFirstVersionForTest(currentDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDUBAVMA");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDUBAVMA");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        final File jarFile2 = this.getNextVersionJarFile(jarFile1);
        final byte[] vmJarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDUBAVMB");
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                if (!jarFile1.exists()) {
                    TestCase.fail((String)("JAR file not found where expected: " + jarFile1.getName()));
                }
                try {
                    JarDeployerDUnitTest.this.writeJarBytesToFile(jarFile2, vmJarBytes);
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"Could not write JAR File");
                }
            }
        });
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{vmJarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDUBAVMB");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDUBAVMA");
            JarDeployerDUnitTest.fail((String)"Class should not be found on Classpath: JarDeployerDUnitDUBAVMA");
        }
        catch (ClassNotFoundException cnfex) {
            // empty catch block
        }
        if (!jarFile2.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file should not have been deleted: " + jarFile2.getName()));
        }
        if ((jarFile3 = this.getNextVersionJarFile(jarFile2)).exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file should not have been created: " + jarFile3.getName()));
        }
    }

    @Test
    public void testLoadPreviouslyDeployedJars() throws IOException {
        File parentJarFile = new File("vf.gf#JarDeployerDUnitAParent.jar#1");
        File usesJarFile = new File("vf.gf#JarDeployerDUnitUses.jar#1");
        File functionJarFile = new File("vf.gf#JarDeployerDUnitFunction.jar#1");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package jddunit.parent;");
        stringBuffer.append("public class JarDeployerDUnitParent {");
        stringBuffer.append("public String getValueParent() {");
        stringBuffer.append("return \"PARENT\";}}");
        byte[] jarBytes = this.classBuilder.createJarFromClassContent("jddunit/parent/JarDeployerDUnitParent", stringBuffer.toString());
        FileOutputStream outStream = new FileOutputStream(parentJarFile);
        outStream.write(jarBytes);
        outStream.close();
        stringBuffer = new StringBuffer();
        stringBuffer.append("package jddunit.uses;");
        stringBuffer.append("public class JarDeployerDUnitUses {");
        stringBuffer.append("public String getValueUses() {");
        stringBuffer.append("return \"USES\";}}");
        jarBytes = this.classBuilder.createJarFromClassContent("jddunit/uses/JarDeployerDUnitUses", stringBuffer.toString());
        outStream = new FileOutputStream(usesJarFile);
        outStream.write(jarBytes);
        outStream.close();
        stringBuffer = new StringBuffer();
        stringBuffer.append("package jddunit.function;");
        stringBuffer.append("import jddunit.parent.JarDeployerDUnitParent;");
        stringBuffer.append("import jddunit.uses.JarDeployerDUnitUses;");
        stringBuffer.append("import com.gemstone.gemfire.cache.execute.Function;");
        stringBuffer.append("import com.gemstone.gemfire.cache.execute.FunctionContext;");
        stringBuffer.append("public class JarDeployerDUnitFunction  extends JarDeployerDUnitParent implements Function {");
        stringBuffer.append("private JarDeployerDUnitUses uses = new JarDeployerDUnitUses();");
        stringBuffer.append("public boolean hasResult() {return true;}");
        stringBuffer.append("public void execute(FunctionContext context) {context.getResultSender().lastResult(getValueParent() + \":\" + uses.getValueUses());}");
        stringBuffer.append("public String getId() {return \"JarDeployerDUnitFunction\";}");
        stringBuffer.append("public boolean optimizeForWrite() {return false;}");
        stringBuffer.append("public boolean isHA() {return false;}}");
        ClassBuilder functionClassBuilder = new ClassBuilder();
        functionClassBuilder.addToClassPath(parentJarFile.getAbsolutePath());
        functionClassBuilder.addToClassPath(usesJarFile.getAbsolutePath());
        jarBytes = functionClassBuilder.createJarFromClassContent("jddunit/function/JarDeployerDUnitFunction", stringBuffer.toString());
        outStream = new FileOutputStream(functionJarFile);
        outStream.write(jarBytes);
        outStream.close();
        InternalDistributedSystem distributedSystem = this.getSystem();
        this.getCache();
        Execution execution = FunctionService.onMember((DistributedSystem)distributedSystem, (DistributedMember)distributedSystem.getDistributedMember());
        ResultCollector resultCollector = execution.execute("JarDeployerDUnitFunction");
        List result = (List)resultCollector.getResult();
        JarDeployerDUnitTest.assertEquals((String)"PARENT:USES", (String)((String)result.get(0)));
    }

    @Test
    public void testDeployToAlternateDirectory() throws IOException, ClassNotFoundException {
        File alternateDir = new File("JarDeployerDUnit");
        alternateDir.mkdir();
        Properties properties = new Properties();
        properties.put("deploy-working-dir", alternateDir.getAbsolutePath());
        InternalDistributedSystem distributedSystem = this.getSystem(properties);
        JarDeployer jarDeployer = new JarDeployer(null, distributedSystem.getConfig().getDeployWorkingDir());
        File jarFile = this.getFirstVersionForTest(alternateDir, "JarDeployerDUnit.jar");
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDTAC");
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        try {
            ClassPathLoader.getLatest().forName("JarDeployerDUnitDTAC");
        }
        catch (ClassNotFoundException cnfex) {
            JarDeployerDUnitTest.fail((String)"JAR file not correctly added to Classpath");
        }
        if (!jarFile.exists()) {
            JarDeployerDUnitTest.fail((String)("JAR file not found where expected: " + jarFile.getName()));
        }
        if (!this.doesFileMatchBytes(jarFile, jarBytes)) {
            JarDeployerDUnitTest.fail((String)("Contents of JAR file do not match those provided: " + jarFile.getName()));
        }
    }

    @Test
    public void testDeployToInvalidDirectory() throws IOException, ClassNotFoundException {
        File alternateDir = new File("JarDeployerDUnit");
        FileUtil.delete((File)new File("JarDeployerDUnit"));
        final JarDeployer jarDeployer = new JarDeployer(null, alternateDir);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitDTID");
        try {
            jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
            JarDeployerDUnitTest.fail((String)"Exception should have been thrown due to missing deployment directory.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                }
                catch (InterruptedException iex) {
                    TestCase.fail((String)"Interrupted while waiting.");
                }
                catch (BrokenBarrierException bbex) {
                    TestCase.fail((String)"Broken barrier.");
                }
                try {
                    jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
                }
                catch (IOException ioex) {
                    TestCase.fail((String)"IOException received unexpectedly.");
                }
                catch (ClassNotFoundException cnfex) {
                    TestCase.fail((String)"ClassNotFoundException received unexpectedly.");
                }
            }
        };
        thread.start();
        try {
            barrier.await();
            Thread.sleep(500L);
            alternateDir.mkdir();
            thread.join();
        }
        catch (InterruptedException iex) {
            JarDeployerDUnitTest.fail((String)"Interrupted while waiting.");
        }
        catch (BrokenBarrierException bbex) {
            JarDeployerDUnitTest.fail((String)"Broken barrier.");
        }
    }

    @Test
    public void testSuspendAndResume() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        byte[] jarBytes = this.classBuilder.createJarFromName("JarDeployerDUnitSAR");
        final JarDeployer suspendingJarDeployer = new JarDeployer();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    suspendingJarDeployer.suspendAll();
                    latch.countDown();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JarDeployerDUnitTest.this.okayToResume = true;
                suspendingJarDeployer.resumeAll();
            }
        };
        thread.start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        jarDeployer.deploy(new String[]{"JarDeployerDUnit.jar"}, (byte[][])new byte[][]{jarBytes});
        if (!this.okayToResume) {
            JarDeployerDUnitTest.fail((String)"JarDeployer did not suspend as expected");
        }
    }

    @Test
    public void testZeroLengthFile() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        try {
            jarDeployer.deploy(new String[]{"JarDeployerDUnitZLF.jar"}, (byte[][])new byte[][]{new byte[0]});
            JarDeployerDUnitTest.fail((String)"Zero length files are not deployable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            jarDeployer.deploy(new String[]{"JarDeployerDUnitZLF1.jar", "JarDeployerDUnitZLF2.jar"}, (byte[][])new byte[][]{this.classBuilder.createJarFromName("JarDeployerDUnitZLF1"), new byte[0]});
            JarDeployerDUnitTest.fail((String)"Zero length files are not deployable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidJarFile() throws IOException, ClassNotFoundException {
        JarDeployer jarDeployer = new JarDeployer();
        try {
            jarDeployer.deploy(new String[]{"JarDeployerDUnitIJF.jar"}, (byte[][])new byte[][]{"INVALID JAR CONTENT".getBytes()});
            JarDeployerDUnitTest.fail((String)"Non-JAR files are not deployable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            jarDeployer.deploy(new String[]{"JarDeployerDUnitIJF1.jar", "JarDeployerDUnitIJF2.jar"}, (byte[][])new byte[][]{this.classBuilder.createJarFromName("JarDeployerDUnitIJF1"), "INVALID JAR CONTENT".getBytes()});
            JarDeployerDUnitTest.fail((String)"Non-JAR files are not deployable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        VM vm = Host.getHost(0).getVM(1);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                File invalidFile = new File("vf.gf#JarDeployerDUnitIJF.jar#3");
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(invalidFile, "rw");
                    randomAccessFile.write("GARBAGE".getBytes(), 0, 7);
                    randomAccessFile.close();
                }
                catch (IOException ioex) {
                    DistributedTestCase.fail("Error trying to create garbage file for test", ioex);
                }
                JarDeployerDUnitTest.this.getSystem();
                JarDeployerDUnitTest.this.getCache();
                if (invalidFile.exists()) {
                    TestCase.fail((String)"Invalid JAR file should have been deleted at startup");
                }
            }
        });
    }

    FileLock acquireSharedLock(File file) throws IOException {
        FileLock fileLock = new FileInputStream(file).getChannel().lock(0L, 1L, true);
        return fileLock;
    }

    void releaseLock(FileLock fileLock, File lockFile) throws IOException {
        if (lockFile == null) {
            return;
        }
        try {
            if (fileLock != null) {
                fileLock.release();
                fileLock.channel().close();
            }
        }
        finally {
            if (!lockFile.delete()) {
                lockFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesFileMatchBytes(File file, byte[] bytes) throws IOException {
        int index;
        if (file.length() != (long)bytes.length) {
            return false;
        }
        try (FileInputStream inStream = new FileInputStream(file);){
            for (index = 0; index < bytes.length; ++index) {
                if ((byte)((InputStream)inStream).read() == bytes[index]) continue;
                break;
            }
        }
        return index >= bytes.length;
    }

    private void deleteSavedJarFiles() throws IOException {
        FileUtil.deleteMatching((File)new File("."), (String)"^vf.gf#JarDeployerDUnit.*#\\d++$");
        FileUtil.delete((File)new File("JarDeployerDUnit"));
    }

    private File getFirstVersionForTest(File saveDirfile, String jarFilename) {
        File[] oldJarFiles = this.findSortedOldVersionsOfJar(saveDirfile, jarFilename);
        if (oldJarFiles.length == 0) {
            return new File(saveDirfile, "vf.gf#" + jarFilename + "#1");
        }
        return this.getNextVersionJarFile(oldJarFiles[0]);
    }

    private File getNextVersionJarFile(File oldJarFile) {
        Matcher matcher = JarDeployer.versionedPattern.matcher(oldJarFile.getName());
        matcher.find();
        String newFileName = matcher.group(1) + "#" + (Integer.parseInt(matcher.group(2)) + 1);
        return new File(oldJarFile.getParentFile(), newFileName);
    }

    private File[] findSortedOldVersionsOfJar(File saveDirfile, String jarFilename) {
        final Pattern pattern = Pattern.compile("^vf.gf#" + jarFilename + "#\\d++$");
        File[] oldJarFiles = saveDirfile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return pattern.matcher(name).matches();
            }
        });
        Arrays.sort(oldJarFiles, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                int file1Version = JarDeployerDUnitTest.this.extractVersionFromFilename(file1);
                int file2Version = JarDeployerDUnitTest.this.extractVersionFromFilename(file2);
                return file2Version - file1Version;
            }
        });
        return oldJarFiles;
    }

    int extractVersionFromFilename(File file) {
        Matcher matcher = JarDeployer.versionedPattern.matcher(file.getName());
        matcher.find();
        return Integer.parseInt(matcher.group(2));
    }

    void writeJarBytesToFile(File jarFile, byte[] jarBytes) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        ((OutputStream)outStream).write(jarBytes);
        ((OutputStream)outStream).close();
    }
}

