/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.tcpserver;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpServer;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.stack.GossipClient;
import com.gemstone.org.jgroups.stack.IpAddress;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TcpServerBackwardCompatDUnitDisabledTest
extends DistributedTestCase {
    public TcpServerBackwardCompatDUnitDisabledTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TcpServerBackwardCompatDUnitDisabledTest.disconnectAllFromDS();
        TcpServerBackwardCompatDUnitDisabledTest.invokeInEveryVM(new CacheSerializableRunnable("Set TcpServer.isTesting true"){

            @Override
            public void run2() throws CacheException {
                TcpServer.isTesting = true;
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        TcpServerBackwardCompatDUnitDisabledTest.invokeInEveryVM(new CacheSerializableRunnable("Set TcpServer.isTesting true"){

            @Override
            public void run2() throws CacheException {
                TcpServer.isTesting = false;
            }
        });
        super.tearDown2();
    }

    public void testGossipVersionBackwardCompatibility() {
        Host host = Host.getHost(0);
        VM locator0 = host.getVM(0);
        final VM locator1 = host.getVM(1);
        VM locatorRestart0 = host.getVM(2);
        VM member = host.getVM(3);
        final int port0 = AvailablePort.getRandomAvailablePort((int)0);
        final File logFile0 = new File(this.getUniqueName() + "-locator" + port0 + ".log");
        int port = AvailablePort.getRandomAvailablePort((int)0);
        while (port == port0) {
            port = AvailablePort.getRandomAvailablePort((int)0);
        }
        final int port1 = port;
        final File logFile1 = new File(this.getUniqueName() + "-locator" + port1 + ".log");
        String locators = host.getHostName() + "[" + port0 + "]," + host.getHostName() + "[" + port1 + "]";
        final Properties props = new Properties();
        props.setProperty("locators", locators);
        props.setProperty("mcast-port", "0");
        locator0.invoke(new CacheSerializableRunnable("Starting first locator on port " + port0){

            @Override
            public void run2() throws CacheException {
                try {
                    TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.TESTVERSION - 100, Version.CURRENT_GFE_ORDINAL);
                    Locator.startLocatorAndDS((int)port0, (File)logFile0, (Properties)props);
                }
                catch (IOException e) {
                    DistributedTestCase.fail("Locator1 start failed with Gossip Version: " + TcpServer.GOSSIPVERSION + "!", e);
                }
            }
        });
        member.invoke(new CacheSerializableRunnable("Start a member"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.disconnectFromDS();
                TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.TESTVERSION - 100, Version.CURRENT_GFE_ORDINAL);
                InternalDistributedSystem.connect((Properties)props);
            }
        });
        locator1.invoke(new CacheSerializableRunnable("Starting second locator on port " + port1){

            @Override
            public void run2() throws CacheException {
                try {
                    TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.TESTVERSION -= 100, Version.CURRENT_GFE_ORDINAL);
                    TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.OLDTESTVERSION -= 100, Version.GFE_57.ordinal());
                    TestCase.assertEquals((String)"Gossip Version and Test version are not same", (int)1002, (int)TcpServer.TESTVERSION);
                    TestCase.assertEquals((String)"Previous Gossip Version and Test version are not same", (int)1001, (int)TcpServer.OLDTESTVERSION);
                    Locator.startLocatorAndDS((int)port1, (File)logFile1, (Properties)props);
                    final GossipClient client = new GossipClient(new IpAddress(InetAddress.getLocalHost(), port1), 500L);
                    client.register("mygroup1", (Address)new IpAddress(InetAddress.getLocalHost(), port1), 5000L, false);
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            try {
                                Vector members = client.getMembers("mygroup1", (Address)new IpAddress(InetAddress.getLocalHost(), port0), true, 5000L);
                                return members.size() == 2;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)"unexpected exception");
                                return false;
                            }
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 1000L, 200L, true);
                    Vector members = client.getMembers("mygroup1", (Address)new IpAddress(InetAddress.getLocalHost(), port0), true, 5000L);
                    Assert.assertEquals((int)2, (int)members.size());
                    Assert.assertTrue((boolean)members.contains(new IpAddress(InetAddress.getLocalHost(), port0)));
                    Assert.assertTrue((boolean)members.contains(new IpAddress(InetAddress.getLocalHost(), port1)));
                }
                catch (IOException e) {
                    DistributedTestCase.fail("Locator1 start failed with Gossip Version: " + TcpServer.GOSSIPVERSION + "!", e);
                }
            }
        });
        locator0.invoke(new CacheSerializableRunnable("Stopping first locator"){

            @Override
            public void run2() throws CacheException {
                Locator.getLocator().stop();
                DistributedTestCase.disconnectFromDS();
            }
        });
        locatorRestart0.invoke(new CacheSerializableRunnable("Restarting first locator on port " + port0){

            @Override
            public void run2() throws CacheException {
                try {
                    TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.TESTVERSION -= 100, Version.CURRENT_GFE_ORDINAL);
                    TcpServer.getGossipVersionMapForTestOnly().put(TcpServer.OLDTESTVERSION -= 100, Version.GFE_57.ordinal());
                    TestCase.assertEquals((String)"Gossip Version and Test version are not same", (int)1002, (int)TcpServer.TESTVERSION);
                    TestCase.assertEquals((String)"Previous Gossip Version and Test version are not same", (int)1001, (int)TcpServer.OLDTESTVERSION);
                    Locator.startLocatorAndDS((int)port0, (File)logFile0, (Properties)props);
                    GossipClient client2 = new GossipClient(new IpAddress(InetAddress.getLocalHost(), port1), 500L);
                    Vector members = client2.getMembers("mygroup1", (Address)new IpAddress(InetAddress.getLocalHost(), port1), true, 5000L);
                    Assert.assertEquals((int)2, (int)members.size());
                    DistributedTestCase.getLogWriter().info(members.get(0) + " " + members.get(1));
                    for (IpAddress ipAddr : members) {
                        int port = ipAddr.getPort();
                        String hostname = ipAddr.getIpAddress().getHostAddress();
                        int pid = ipAddr.getProcessId();
                        Assert.assertTrue((String)(" " + ipAddr), (port == port0 || port == port1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)(" " + ipAddr), (boolean)hostname.equals(InetAddress.getLocalHost().getHostAddress()));
                        Assert.assertTrue((String)(" " + ipAddr), (pid == locator1.getPid() ? 1 : 0) != 0);
                    }
                }
                catch (IOException e) {
                    DistributedTestCase.fail("Locator0 start failed with Gossip Version: " + TcpServer.GOSSIPVERSION + "!", e);
                }
            }
        });
    }
}

