/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.protocols.FD_SOCK;
import com.gemstone.org.jgroups.protocols.PingWaiter;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.stack.Protocol;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class LocatorTest
extends DistributedTestCase {
    private static final String WAIT1_MS_NAME = "LocatorTest.WAIT1_MS";
    private static final int WAIT1_MS_DEFAULT = 40000;
    private static final int WAIT1_MS = Integer.getInteger("LocatorTest.WAIT1_MS", 40000);
    private static final String WAIT2_MS_NAME = "LocatorTest.WAIT2_MS";
    private static final int WAIT2_MS_DEFAULT = 5000;
    private static final int WAIT2_MS = Integer.getInteger("LocatorTest.WAIT2_MS", 5000);
    private int port1;
    private int port2;
    static boolean beforeFailureNotificationReceived;
    static boolean afterFailureNotificationReceived;

    public LocatorTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.port1 = -1;
        this.port2 = -1;
    }

    @Override
    public void tearDown2() {
        if (this.port1 > 0) {
            this.deleteStateFile(this.port1);
        }
        if (this.port2 > 0) {
            this.deleteStateFile(this.port2);
        }
    }

    private void deleteStateFile(int port) {
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCollocatedLocatorWithSecurity() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.port1 = AvailablePort.getRandomAvailablePort((int)0);
        String locators = LocatorTest.getServerHostName(host) + "[" + this.port1 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("start-locator", locators);
        properties.put("log-level", LocatorTest.getDUnitLogLevel());
        properties.put("security-peer-auth-init", "com.gemstone.gemfire.distributed.AuthInitializer.create");
        properties.put("security-peer-authenticator", "com.gemstone.gemfire.distributed.MyAuthenticator.create");
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)properties);
        InternalDistributedMember mbr = system.getDistributedMember();
        LocatorTest.assertEquals((String)"expected the VM to have NORMAL vmKind", (int)10, (int)system.getDistributedMember().getVmKind());
        properties.remove("start-locator");
        properties.put("locators", locators);
        SerializableRunnable startSystem = new SerializableRunnable("start system"){

            @Override
            public void run() {
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)properties);
            }
        };
        vm1.invoke(startSystem);
        vm2.invoke(startSystem);
        Cache cache = CacheFactory.create((DistributedSystem)system);
        Region r = cache.createRegionFactory(RegionShortcut.REPLICATE).create("test region");
        LocatorTest.assertNotNull((String)"expected to create a region", (Object)r);
        DistributedLockService service = DistributedLockService.create((String)"test service", (DistributedSystem)system);
        service.becomeLockGrantor();
        service.lock((Object)"foo0", 0L, 0L);
        vm1.invoke(new SerializableRunnable("get the lock service and lock something"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.create((String)"test service", (DistributedSystem)DistributedTestCase.system);
                service.lock((Object)"foo1", 0L, 0L);
            }
        });
        vm2.invoke(new SerializableRunnable("get the lock service and lock something"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.create((String)"test service", (DistributedSystem)DistributedTestCase.system);
                service.lock((Object)"foo2", 0L, 0L);
            }
        });
        system.disconnect();
        try {
            vm1.invoke(new SerializableRunnable("ensure grantor failover"){

                @Override
                public void run() {
                    final DistributedLockService service = DistributedLockService.getServiceNamed((String)"test service");
                    service.lock((Object)"foo3", 0L, 0L);
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return service.isLockGrantor();
                        }

                        @Override
                        public String description() {
                            return "waiting to become lock grantor after shutting down locator/grantor";
                        }
                    }, 10000L, 1000L, true);
                    TestCase.assertTrue((boolean)service.isLockGrantor());
                }
            });
            properties.put("start-locator", locators);
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)properties);
            LocatorTest.assertEquals((String)"should be the coordinator", (Object)system.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)system));
            NetView view = MembershipManagerHelper.getMembershipManager((DistributedSystem)system).getView();
            LocatorTest.getLogWriter().info("view after becoming coordinator is " + view);
            LocatorTest.assertNotSame((String)("should not be the first member in the view (" + view + ")"), (Object)system.getDistributedMember(), (Object)view.get(0));
            service = DistributedLockService.create((String)"test service", (DistributedSystem)system);
            vm2.invoke(new SerializableRunnable("get the lock service and lock something"){

                @Override
                public void run() {
                    DistributedLockService service = DistributedLockService.getServiceNamed((String)"test service");
                    service.lock((Object)"foo4", 0L, 0L);
                }
            });
            LocatorTest.assertFalse((String)"should not have become lock grantor", (boolean)service.isLockGrantor());
            properties.remove("start-locator");
            vm3.invoke(startSystem);
            vm3.invoke(new SerializableRunnable("get the lock service and lock something(2)"){

                @Override
                public void run() {
                    DistributedLockService service = DistributedLockService.create((String)"test service", (DistributedSystem)DistributedTestCase.system);
                    service.lock((Object)"foo5", 0L, 0L);
                }
            });
        }
        finally {
            LocatorTest.disconnectAllFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_BUG51468testBug30341() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM loc1 = host.getVM(1);
        VM loc2 = host.getVM(2);
        this.port1 = port1 = AvailablePort.getRandomAvailablePort((int)0);
        this.port2 = port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "false");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        properties.put("log-level", LocatorTest.getDUnitLogLevel());
        SerializableCallable startLocator1 = new SerializableCallable("start locator1"){

            public Object call() throws Exception {
                try {
                    System.setProperty("p2p.joinTimeout", "5000");
                    PingWaiter.TEST_HOOK_IGNORE_REQUIRED_RESPONSE = true;
                    Locator myLocator = Locator.startLocatorAndDS((int)port1, (File)new File("testBug30341Locator1.log"), (Properties)properties);
                    myLocator.stop();
                }
                catch (SystemConnectException e) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                finally {
                    PingWaiter.TEST_HOOK_IGNORE_REQUIRED_RESPONSE = false;
                    System.getProperties().remove("p2p.joinTimeout");
                }
                return Boolean.FALSE;
            }
        };
        SerializableCallable startLocator2 = new SerializableCallable("start locator2"){

            public Object call() throws Exception {
                try {
                    System.setProperty("p2p.joinTimeout", "5000");
                    Locator myLocator = Locator.startLocatorAndDS((int)port2, (File)new File("testBug30341Locator2.log"), (Properties)properties);
                    myLocator.stop();
                }
                catch (SystemConnectException e) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                finally {
                    System.getProperties().remove("p2p.joinTimeout");
                }
                return Boolean.FALSE;
            }
        };
        AsyncInvocation async1 = null;
        AsyncInvocation async2 = null;
        try {
            async1 = loc1.invokeAsync(startLocator1);
            async2 = loc2.invokeAsync(startLocator2);
        }
        finally {
            if (async1 != null) {
                async1.join(60000L);
                if (async1.isAlive()) {
                    LocatorTest.dumpAllStacks();
                }
                if (async2 != null) {
                    async2.join();
                    Object result1 = async1.getReturnValue();
                    if (result1 instanceof Exception) {
                        throw (Exception)result1;
                    }
                    Object result2 = async2.getReturnValue();
                    if (result2 instanceof Exception) {
                        throw (Exception)result2;
                    }
                    if (!((Boolean)result1).booleanValue()) {
                        LocatorTest.fail((String)"locator1 started but shouldn't have");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeadMemberSelection() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.port1 = AvailablePort.getRandomAvailablePort((int)0);
        String locators = LocatorTest.getServerHostName(host) + "[" + this.port1 + "]";
        Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "true");
        properties.put("disable-auto-reconnect", "true");
        File logFile = new File(this.getUniqueName() + "-locator.log");
        if (logFile.exists()) {
            logFile.delete();
        }
        Locator locator = Locator.startLocatorAndDS((int)this.port1, (File)logFile, (Properties)properties);
        try {
            DistributedSystem sys = locator.getDistributedSystem();
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            properties.put("log-file", "testLeadMemberSelection_vm1.log");
            properties.put("name", "vm1");
            DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem1, sys, 5000L);
            properties.put("log-file", "testLeadMemberSelection_vm2.log");
            properties.put("name", "vm2");
            DistributedMember mem2 = (DistributedMember)vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem1, sys, 5000L);
            properties.put("log-file", "testLeadMemberSelection_vm3.log");
            properties.put("name", "vm3");
            DistributedMember mem3 = (DistributedMember)vm3.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem1, sys, 5000L);
            vm1.invoke(disconnect);
            MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).waitForDeparture(mem1);
            this.assertLeadMember(mem2, sys, 5000L);
            properties.put("log-file", "testLeadMemberSelection_vm1.log");
            properties.put("name", "vm1");
            mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem2, sys, 5000L);
            vm2.invoke(disconnect);
            MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).waitForDeparture(mem2);
            this.assertLeadMember(mem3, sys, 5000L);
            vm1.invoke(disconnect);
            MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).waitForDeparture(mem1);
            this.assertLeadMember(mem3, sys, 5000L);
            vm3.invoke(disconnect);
            MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).waitForDeparture(mem3);
            this.assertLeadMember(null, sys, 5000L);
        }
        finally {
            locator.stop();
        }
    }

    private void assertLeadMember(final DistributedMember member, final DistributedSystem sys, long timeout) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                DistributedMember lead = MembershipManagerHelper.getLeadMember((DistributedSystem)sys);
                if (member != null) {
                    return member.equals(lead);
                }
                return lead == null;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, timeout, 200L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeadAndCoordFailure() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM locvm = host.getVM(3);
        Locator locator = null;
        this.port1 = port1 = AvailablePort.getRandomAvailablePort((int)0);
        this.port2 = port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "true");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        try {
            final String uname = this.getUniqueName();
            File logFile = new File(uname + "-locator1-" + port1 + ".log");
            locator = Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)properties);
            final DistributedSystem sys = locator.getDistributedSystem();
            sys.getLogWriter().info("<ExpectedException action=add>java.net.ConnectException</ExpectedException>");
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
            locvm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    File lf = new File(uname + "-locator2-" + port2 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)lf, (Properties)properties);
                    }
                    catch (IOException ios) {
                        DistributedTestCase.fail("Unable to start locator2", ios);
                    }
                }
            });
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable crashLocator = new SerializableRunnable("Crash locator"){

                @Override
                public void run() {
                    Locator loc = (Locator)Locator.getLocators().iterator().next();
                    DistributedSystem msys = loc.getDistributedSystem();
                    MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
                    MembershipManagerHelper.playDead((DistributedSystem)msys);
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    Protocol udp = c.getProtocolStack().findProtocol("UDP");
                    udp.stop();
                    udp.passUp(new Event(46, (Object)new Exception("killing locator's ds")));
                    try {
                        MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    loc.stop();
                    MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem1, sys, 5000L);
            LocatorTest.assertEquals((Object)sys.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            this.crashDistributedSystem(vm2);
            locvm.invoke(crashLocator);
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm1.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            DistributionManager dm = (DistributionManager)((InternalDistributedSystem)sys).getDistributionManager();
            MyMembershipListener listener = new MyMembershipListener();
            dm.addMembershipListener((MembershipListener)listener);
            this.crashDistributedSystem(vm1);
            LocatorTest.getLogWriter().info("waiting for remaining vms to disconnect due to partition detection");
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !sys.isConnected();
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 24000L, 200L, true);
            if (sys.isConnected()) {
                LocatorTest.fail((String)"Distributed system did not disconnect as expected - network partition detection is broken");
            }
            LocatorTest.assertTrue((String)"expected quorumLost to be invoked", (boolean)listener.quorumLostInvoked);
        }
        finally {
            if (locator != null) {
                locator.stop();
            }
            LocalLogWriter bLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
            bLogger.info("<ExpectedException action=remove>service failure</ExpectedException>");
            bLogger.info("<ExpectedException action=remove>java.net.ConnectException</ExpectedException>");
            bLogger.info("<ExpectedException action=remove>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
            LocatorTest.disconnectAllFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuorumLossNotification() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM locvm3 = host.getVM(3);
        Locator locator = null;
        int port1 = AvailablePort.getRandomAvailablePort((int)0);
        final int port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "false");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        try {
            final String uname = this.getUniqueName();
            File logFile = new File(uname + "-locator1-" + port1 + ".log");
            locator = Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)properties);
            DistributedSystem sys = locator.getDistributedSystem();
            locvm3.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    File lf = new File(uname + "-locator2-" + port2 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)lf, (Properties)properties);
                    }
                    catch (IOException ios) {
                        DistributedTestCase.fail("Unable to start locator2", ios);
                    }
                }
            });
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable crashLocator = new SerializableRunnable("Crash locator"){

                @Override
                public void run() {
                    Locator loc = (Locator)Locator.getLocators().iterator().next();
                    DistributedSystem msys = loc.getDistributedSystem();
                    MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
                    MembershipManagerHelper.playDead((DistributedSystem)msys);
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    Protocol udp = c.getProtocolStack().findProtocol("UDP");
                    udp.stop();
                    udp.passUp(new Event(46, (Object)new Exception("killing locators ds")));
                    try {
                        MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            this.assertLeadMember(mem1, sys, 5000L);
            LocatorTest.assertEquals((Object)sys.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            this.crashDistributedSystem(vm2);
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm1.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            DistributionManager dm = (DistributionManager)((InternalDistributedSystem)sys).getDistributionManager();
            final MyMembershipListener listener = new MyMembershipListener();
            dm.addMembershipListener((MembershipListener)listener);
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
            try {
                GMS.TEST_HOOK_SLOW_VIEW_CASTING = 10;
                locvm3.invoke(crashLocator);
                this.crashDistributedSystem(vm1);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return !listener.quorumLostInvoked;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 24000L, 200L, true);
            }
            finally {
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
            }
            if (sys.isConnected()) {
                locator.stop();
            }
            try {
                String line;
                FileReader fr = new FileReader(logFile);
                LineNumberReader in = new LineNumberReader(fr);
                boolean found = false;
                while ((line = in.readLine()) != null) {
                    if (!line.contains("Possible loss of quorum due to the loss of") || !line.startsWith("[severe")) continue;
                    LocatorTest.getLogWriter().info("Found severe-level quorum loss notification as expected on line " + in.getLineNumber());
                    found = true;
                    break;
                }
                LocatorTest.assertTrue((String)("expected severe-level quorum loss notification in " + logFile.getName()), (boolean)found);
            }
            catch (IOException e) {
                LocatorTest.fail("unexpected exception", e);
            }
        }
        finally {
            if (locator != null) {
                locator.stop();
            }
            LocatorTest.disconnectAllFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeadFailureAndCoordShutdown() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM locvm = host.getVM(3);
        Locator locator = null;
        this.port1 = port1 = AvailablePort.getRandomAvailablePort((int)0);
        this.port2 = port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "true");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        SerializableRunnable stopLocator = this.getStopLocatorRunnable();
        try {
            final String uname = this.getUniqueName();
            File logFile = new File(uname + "-locator1-" + port1 + ".log");
            locator = Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)properties);
            DistributedSystem sys = locator.getDistributedSystem();
            locvm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    File lf = new File(uname + "-locator2-" + port2 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)lf, (Properties)properties);
                        MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
                    }
                    catch (IOException ios) {
                        DistributedTestCase.fail("Unable to start locator2", ios);
                    }
                }
            });
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable crashSystem = new SerializableRunnable("Crash system"){

                @Override
                public void run() {
                    InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                    msys.getLogWriter().info("<ExpectedException action=add>service failure</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ConnectException</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
                    MembershipManagerHelper.playDead((DistributedSystem)msys);
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    Protocol udp = c.getProtocolStack().findProtocol("UDP");
                    udp.stop();
                    udp.passUp(new Event(46, (Object)new Exception("killing members ds")));
                    try {
                        MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            DistributedMember mem2 = (DistributedMember)vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            LocatorTest.assertEquals((Object)mem1, (Object)MembershipManagerHelper.getLeadMember((DistributedSystem)sys));
            LocatorTest.assertEquals((Object)sys.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
            vm1.invoke(crashSystem);
            LocatorTest.pause(8000);
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)LocatorTest.isSystemConnected());
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm2.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)locvm.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            locator.stop();
            if (!Locator.getLocators().isEmpty()) {
                LocatorTest.getLogWriter().warning("found locator " + Locator.getLocators().iterator().next());
            }
            LocatorTest.assertTrue((String)"locator is not stopped", (boolean)Locator.getLocators().isEmpty());
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm2.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)locvm.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertEquals((String)"This test sometimes fails.  If the log contains 'failed to collect all ACKs' it is a false failure.", (Object)mem2, (Object)vm2.invoke(LocatorTest.class, "getLeadMember", new Object[0]));
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                }
            };
            vm2.invoke(disconnect);
            locvm.invoke(stopLocator);
        }
        finally {
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
            if (locator != null) {
                locator.stop();
            }
            locvm.invoke(stopLocator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceDisconnectAndPeerShutdownCause() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM locvm = host.getVM(3);
        Locator locator = null;
        this.port1 = port1 = AvailablePort.getRandomAvailablePort((int)0);
        this.port2 = port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "true");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        SerializableRunnable stopLocator = this.getStopLocatorRunnable();
        try {
            final String uname = this.getUniqueName();
            File logFile = new File(uname + "-locator1-" + port1 + ".log");
            locator = Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)properties);
            DistributedSystem sys = locator.getDistributedSystem();
            locvm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    File lf = new File(uname + "-locator2-" + port2 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)lf, (Properties)properties);
                    }
                    catch (IOException ios) {
                        DistributedTestCase.fail("Unable to start locator2", ios);
                    }
                }
            });
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable crashSystem = new SerializableRunnable("Crash system"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                    msys.getLogWriter().info("<ExpectedException action=add>service failure</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ConnectException</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>Possible loss of quorum</ExpectedException>");
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    JChannelTestHook hook = new JChannelTestHook();
                    MembershipManagerHelper.addTestHook((DistributedSystem)msys, (com.gemstone.org.jgroups.debug.JChannelTestHook)hook);
                    try {
                        MembershipManagerHelper.playDead((DistributedSystem)msys);
                        Protocol udp = c.getProtocolStack().findProtocol("UDP");
                        udp.stop();
                        udp.passUp(new Event(46, (Object)new ForcedDisconnectException("killing members ds")));
                        c.setClosed(true);
                        try {
                            MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        MembershipManagerHelper.removeTestHook((DistributedSystem)msys, (com.gemstone.org.jgroups.debug.JChannelTestHook)hook);
                        hook.reset();
                    }
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            final DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            DistributedMember mem2 = (DistributedMember)vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            LocatorTest.assertEquals((Object)mem1, (Object)MembershipManagerHelper.getLeadMember((DistributedSystem)sys));
            LocatorTest.assertEquals((Object)sys.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)LocatorTest.isSystemConnected());
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm2.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)locvm.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            vm2.invokeAsync(crashSystem);
            LocatorTest.pause(1000);
            vm2.invoke(new SerializableRunnable("Request Member Removal"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                    JGroupMembershipManager jmm = MembershipManagerHelper.getMembershipManager((DistributedSystem)msys);
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    try {
                        msys.getLogWriter().info("<ExpectedException action=add>Membership: requesting removal of </ExpectedException>");
                        jmm.requestMemberRemoval(mem1, "test reasons");
                        msys.getLogWriter().info("<ExpectedException action=remove>Membership: requesting removal of </ExpectedException>");
                        TestCase.fail((String)"It should have thrown exception in requestMemberRemoval");
                    }
                    catch (DistributedSystemDisconnectedException e) {
                        Throwable cause = e.getCause();
                        TestCase.assertTrue((String)("This should have been ForceDisconnectException but found " + cause), (boolean)(cause instanceof ForcedDisconnectException));
                    }
                    finally {
                        c.getProtocolStack().stop();
                        c.getProtocolStack().destroy();
                    }
                }
            });
            locvm.invoke(stopLocator);
            locator.stop();
            if (!Locator.getLocators().isEmpty()) {
                LocatorTest.getLogWriter().warning("found locator " + Locator.getLocators().iterator().next());
            }
            LocatorTest.assertTrue((String)"locator is not stopped", (boolean)Locator.getLocators().isEmpty());
        }
        finally {
            if (locator != null) {
                locator.stop();
            }
            locvm.invoke(stopLocator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeadShutdownAndCoordFailure() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM locvm = host.getVM(3);
        Locator locator = null;
        this.port1 = port1 = AvailablePort.getRandomAvailablePort((int)0);
        this.port2 = port2 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = LocatorTest.getServerHostName(host);
        String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("locators", locators);
        properties.put("enable-network-partition-detection", "true");
        properties.put("disable-auto-reconnect", "true");
        properties.put("member-timeout", "2000");
        SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

            @Override
            public void run() {
                InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                if (sys != null && sys.isConnected()) {
                    sys.disconnect();
                }
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
            }
        };
        SerializableRunnable expectedException = new SerializableRunnable("Add expected exceptions"){

            @Override
            public void run() {
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
            }
        };
        try {
            final String uname = this.getUniqueName();
            locvm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    File lf = new File(uname + "-locator1-" + port1 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)lf, (Properties)properties);
                    }
                    catch (IOException ios) {
                        DistributedTestCase.fail("Unable to start locator1", ios);
                    }
                }
            });
            File logFile = new File(uname + "-locator2-" + port2 + ".log");
            locator = Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)properties);
            DistributedSystem sys = locator.getDistributedSystem();
            sys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
            Object[] connectArgs = new Object[]{properties};
            SerializableRunnable crashLocator = new SerializableRunnable("Crash locator"){

                @Override
                public void run() {
                    Locator loc = (Locator)Locator.getLocators().iterator().next();
                    DistributedSystem msys = loc.getDistributedSystem();
                    msys.getLogWriter().info("<ExpectedException action=add>service failure</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
                    msys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ConnectException</ExpectedException>");
                    MembershipManagerHelper.playDead((DistributedSystem)msys);
                    JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                    Protocol udp = c.getProtocolStack().findProtocol("UDP");
                    udp.stop();
                    udp.passUp(new Event(46, (Object)new Exception("killing locator's ds")));
                    try {
                        MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    loc.stop();
                }
            };
            LocatorTest.assertTrue((MembershipManagerHelper.getLeadMember((DistributedSystem)sys) == null ? 1 : 0) != 0);
            DistributedMember mem1 = (DistributedMember)vm1.invoke(this.getClass(), "getDistributedMember", connectArgs);
            vm1.invoke(expectedException);
            DistributedMember mem2 = (DistributedMember)vm2.invoke(this.getClass(), "getDistributedMember", connectArgs);
            DistributedMember loc1Mbr = (DistributedMember)locvm.invoke(this.getClass(), "getLocatorDistributedMember", new Object[0]);
            this.assertLeadMember(mem1, sys, 5000L);
            LocatorTest.assertEquals((Object)loc1Mbr, (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            locvm.invoke(crashLocator);
            LocatorTest.pause(10000);
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)sys.isConnected());
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm1.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm2.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            vm1.invoke(disconnect);
            LocatorTest.pause(10000);
            LocatorTest.assertTrue((String)"Distributed system should not have disconnected", (boolean)vm2.invokeBoolean(LocatorTest.class, "isSystemConnected"));
            LocatorTest.assertEquals((Object)sys.getDistributedMember(), (Object)MembershipManagerHelper.getCoordinator((DistributedSystem)sys));
            LocatorTest.assertEquals((Object)mem2, (Object)MembershipManagerHelper.getLeadMember((DistributedSystem)sys));
        }
        finally {
            vm2.invoke(disconnect);
            if (locator != null) {
                locator.stop();
            }
            locvm.invoke(this.getStopLocatorRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoLocator() {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        String locators = LocatorTest.getServerHostName(host) + "[" + port + "]";
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", locators);
        String expected = "java.net.ConnectException";
        String addExpected = "<ExpectedException action=add>java.net.ConnectException</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>java.net.ConnectException</ExpectedException>";
        LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
        bgexecLogger.info("<ExpectedException action=add>java.net.ConnectException</ExpectedException>");
        boolean exceptionOccurred = true;
        try {
            DistributedSystem.connect((Properties)props);
            exceptionOccurred = false;
        }
        catch (DistributionException distributionException) {
        }
        catch (GemFireConfigException ex) {
            String s = ex.getMessage();
            LocatorTest.assertTrue((s.indexOf("Locator does not exist") >= 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            LocatorTest.fail("Failed with unexpected exception", ex);
        }
        finally {
            bgexecLogger.info("<ExpectedException action=remove>java.net.ConnectException</ExpectedException>");
        }
        if (!exceptionOccurred) {
            LocatorTest.fail((String)"Should have thrown a GemFireConfigException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneLocator() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final int port = AvailablePort.getRandomAvailablePort((int)0);
        final String locators = LocatorTest.getServerHostName(host) + "[" + port + "]";
        final String uniqueName = this.getUniqueName();
        vm0.invoke(new SerializableRunnable("Start locator " + locators){

            @Override
            public void run() {
                File logFile = new File(uniqueName + "-locator" + port + ".log");
                try {
                    Properties locProps = new Properties();
                    locProps.setProperty("mcast-port", "0");
                    Locator.startLocatorAndDS((int)port, (File)logFile, (Properties)locProps);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port, ex);
                }
            }
        });
        try {
            SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

                @Override
                public void run() {
                    Properties props = new Properties();
                    props.setProperty("mcast-port", "0");
                    props.setProperty("locators", locators);
                    DistributedSystem.connect((Properties)props);
                }
            };
            vm1.invoke(connect);
            vm2.invoke(connect);
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
            config.setLogFile(this.getUniqueName() + "-admin.log");
            config.setLogLevel("info");
            AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
            admin.connect();
            LocatorTest.assertTrue((boolean)admin.waitToBeConnected(2000L));
            LocatorTest.assertEquals((int)3, (int)admin.getSystemMemberApplications().length);
            final DistributedMember coord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
            LocatorTest.getLogWriter().info("coordinator before termination of locator is " + coord);
            vm0.invoke(this.getStopLocatorRunnable());
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !coord.equals(MembershipManagerHelper.getCoordinator((DistributedSystem)DistributedTestCase.system));
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
            DistributedMember newCoord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
            LocatorTest.getLogWriter().info("coordinator after shutdown of locator was " + newCoord);
            if (coord.equals(newCoord)) {
                LocatorTest.fail((String)"another member should have become coordinator after the locator was stopped");
            }
            admin.disconnect();
            system.disconnect();
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                }
            };
            vm1.invoke(disconnect);
            vm2.invoke(disconnect);
        }
        finally {
            vm0.invoke(this.getStopLocatorRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneStoppedLocator() throws Exception {
        LocatorTest.disconnectAllFromDS();
        String expected = "java.net.ConnectException";
        String addExpected = "<ExpectedException action=add>java.net.ConnectException</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>java.net.ConnectException</ExpectedException>";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        String locators = LocatorTest.getServerHostName(host) + "[" + port + "]";
        vm0.invoke(this.getStartSBLocatorRunnable(port, this.getUniqueName() + "1"));
        try {
            System.setProperty("JGroups.DEBUG", "true");
            final Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = LocatorTest.this.getSystem(props);
                    sys.getLogWriter().info("<ExpectedException action=add>java.net.ConnectException</ExpectedException>");
                }
            };
            vm1.invoke(connect);
            vm2.invoke(connect);
            system = this.getSystem(props);
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
            config.setLogFile(this.getUniqueName() + "-admin.log");
            config.setLogLevel("info");
            system.getLogWriter().info("<ExpectedException action=add>java.net.ConnectException</ExpectedException>");
            AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
            admin.connect();
            LocatorTest.assertTrue((boolean)admin.waitToBeConnected(2000L));
            LocatorTest.assertEquals((int)3, (int)admin.getSystemMemberApplications().length);
            LocatorTest.assertTrue((boolean)LocatorTest.waitUntilFDConnected(30000L));
            final DistributedMember coord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
            LocatorTest.getLogWriter().info("coordinator before termination of locator is " + coord);
            vm0.invoke(this.getStopLocatorRunnable());
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !coord.equals(MembershipManagerHelper.getCoordinator((DistributedSystem)DistributedTestCase.system));
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
            DistributedMember newCoord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
            LocatorTest.getLogWriter().info("coordinator after shutdown of locator was " + newCoord);
            if (newCoord == null || coord.equals(newCoord)) {
                LocatorTest.fail((String)("another member should have become coordinator after the locator was stopped: " + newCoord));
            }
            vm0.invoke(this.getStartSBLocatorRunnable(port, this.getUniqueName() + "2"));
            final DistributedMember tempCoord = newCoord;
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !tempCoord.equals(MembershipManagerHelper.getCoordinator((DistributedSystem)DistributedTestCase.system));
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
            admin.disconnect();
            system.disconnect();
            LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
            bgexecLogger.info("<ExpectedException action=remove>java.net.ConnectException</ExpectedException>");
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                    LocalLogWriter bLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
                    bLogger.info("<ExpectedException action=remove>java.net.ConnectException</ExpectedException>");
                }
            };
            vm1.invoke(disconnect);
            vm2.invoke(disconnect);
            vm0.invoke(this.getStopLocatorRunnable());
        }
        finally {
            vm0.invoke(this.getStopLocatorRunnable());
            System.getProperties().remove("JGroups.DEBUG");
        }
    }

    public static void setShortRefreshWait() {
        System.setProperty("p2p.gossipRefreshRate", "2000");
    }

    public static void resetRefreshWait() {
        System.getProperties().remove("p2p.gossipRefreshRate");
    }

    public static boolean isSystemConnected() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        return sys != null && sys.isConnected();
    }

    public static boolean anyNormalFDDisconnects() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.isConnected()) {
            FD_SOCK fdProtocol = (FD_SOCK)MembershipManagerHelper.getJChannel((DistributedSystem)sys).getProtocolStack().findProtocol("FD_SOCK");
            if (fdProtocol.normalDisconnectCount > 0) {
                LocatorTest.getLogWriter().warning("Found " + fdProtocol.normalDisconnectCount + " normal-status disconnects have happened.  Expected none since other members crashed");
                return true;
            }
        }
        return false;
    }

    public static boolean waitUntilFDConnected(long timeout) {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.isConnected()) {
            FD_SOCK fdProtocol = (FD_SOCK)MembershipManagerHelper.getJChannel((DistributedSystem)sys).getProtocolStack().findProtocol("FD_SOCK");
            long endTime = System.currentTimeMillis() + timeout;
            while (!fdProtocol.isConnectedToPingDest && System.currentTimeMillis() < endTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return fdProtocol.isConnectedToPingDest;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleLocators() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.port1 = port1 = freeTCPPorts[0];
        this.port2 = port2 = freeTCPPorts[1];
        String host0 = LocatorTest.getServerHostName(host);
        final String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final Properties dsProps = new Properties();
        dsProps.setProperty("locators", locators);
        dsProps.setProperty("mcast-port", "0");
        final String uniqueName = this.getUniqueName();
        vm0.invoke(new SerializableRunnable("Start locator on " + port1){

            @Override
            public void run() {
                File logFile = new File(uniqueName + "-locator" + port1 + ".log");
                try {
                    Locator.startLocatorAndDS((int)port1, (File)logFile, (Properties)dsProps);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port1, ex);
                }
            }
        });
        try {
            vm3.invoke(new SerializableRunnable("Start locator on " + port2){

                @Override
                public void run() {
                    File logFile = new File(uniqueName + "-locator" + port2 + ".log");
                    try {
                        Locator.startLocatorAndDS((int)port2, (File)logFile, (Properties)dsProps);
                    }
                    catch (IOException ex) {
                        DistributedTestCase.fail("While starting locator on port " + port2, ex);
                    }
                }
            });
            try {
                SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

                    @Override
                    public void run() {
                        Properties props = new Properties();
                        props.setProperty("mcast-port", "0");
                        props.setProperty("locators", locators);
                        DistributedSystem.connect((Properties)props);
                    }
                };
                vm1.invoke(connect);
                vm2.invoke(connect);
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", locators);
                system = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
                DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
                config.setLogFile(this.getUniqueName() + "-admin.log");
                config.setLogLevel("info");
                final AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                admin.connect();
                LocatorTest.assertTrue((boolean)admin.waitToBeConnected(2000L));
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        try {
                            return admin.getSystemMemberApplications().length >= 3;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)"unexpected exception");
                            return false;
                        }
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 2000L, 200L, true);
                LocatorTest.assertEquals((int)3, (int)admin.getSystemMemberApplications().length);
                admin.disconnect();
                system.disconnect();
                SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                    @Override
                    public void run() {
                        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                        if (sys != null && sys.isConnected()) {
                            sys.disconnect();
                        }
                    }
                };
                vm1.invoke(disconnect);
                vm2.invoke(disconnect);
            }
            finally {
                vm3.invoke(this.getStopLocatorRunnable());
            }
        }
        finally {
            vm0.invoke(this.getStopLocatorRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleMcastLocators() throws Exception {
        int port2;
        int port1;
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        AdminDistributedSystem admin = null;
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.port1 = port1 = freeTCPPorts[0];
        this.port2 = port2 = freeTCPPorts[1];
        final int mcastport = AvailablePort.getRandomAvailablePort((int)1);
        String host0 = LocatorTest.getServerHostName(host);
        final String locators = host0 + "[" + port1 + "]," + host0 + "[" + port2 + "]";
        final String uniqueName = this.getUniqueName();
        vm0.invoke(new SerializableRunnable("Start locator on " + port1){

            @Override
            public void run() {
                File logFile = new File(uniqueName + "-locator" + port1 + ".log");
                try {
                    Properties props = new Properties();
                    props.setProperty("mcast-port", String.valueOf(mcastport));
                    props.setProperty("locators", locators);
                    Locator.startLocatorAndDS((int)port1, (File)logFile, null, (Properties)props);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port1, ex);
                }
            }
        });
        vm3.invoke(new SerializableRunnable("Start locator on " + port2){

            @Override
            public void run() {
                File logFile = new File(uniqueName + "-locator" + port2 + ".log");
                try {
                    Properties props = new Properties();
                    props.setProperty("mcast-port", String.valueOf(mcastport));
                    props.setProperty("locators", locators);
                    Locator.startLocatorAndDS((int)port2, (File)logFile, null, (Properties)props);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port2, ex);
                }
            }
        });
        SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(mcastport));
                props.setProperty("locators", locators);
                DistributedSystem.connect((Properties)props);
            }
        };
        try {
            vm1.invoke(connect);
            vm2.invoke(connect);
            Properties props = new Properties();
            props.setProperty("mcast-port", String.valueOf(mcastport));
            props.setProperty("locators", locators);
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
            config.setLogFile(this.getUniqueName() + "-admin.log");
            config.setLogLevel("info");
            admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
            admin.connect();
            LocatorTest.assertTrue((boolean)admin.waitToBeConnected((long)WAIT1_MS));
            final AdminDistributedSystem ad = admin;
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    try {
                        return ad.getSystemMemberApplications().length == 3;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("unexpected exception", e);
                        return false;
                    }
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, WAIT2_MS, 200L, true);
            admin.disconnect();
            system.disconnect();
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                }
            };
            vm1.invoke(disconnect);
            vm2.invoke(disconnect);
        }
        finally {
            SerializableRunnable stop = this.getStopLocatorRunnable();
            vm0.invoke(stop);
            vm3.invoke(stop);
            if (admin != null) {
                admin.disconnect();
            }
            if (system != null) {
                system.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectToOwnLocator() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.port1 = AvailablePort.getRandomAvailablePort((int)0);
        File logFile = new File(this.getUniqueName() + "-locator" + this.port1 + ".log");
        Locator locator = Locator.startLocator((int)this.port1, (File)logFile);
        try {
            String locators = LocatorTest.getServerHostName(host) + "[" + this.port1 + "]";
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
            system.disconnect();
        }
        finally {
            locator.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocatorForcesDetection() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        Locator locator = null;
        try {
            this.port1 = AvailablePort.getRandomAvailablePort((int)0);
            String locators = LocatorTest.getServerHostName(host) + "[" + this.port1 + "]";
            final Properties properties = new Properties();
            properties.put("mcast-port", "0");
            properties.put("locators", locators);
            properties.put("enable-network-partition-detection", "true");
            properties.put("disable-auto-reconnect", "true");
            File logFile = new File(this.getUniqueName() + "-locatorA-" + this.port1 + ".log");
            locator = Locator.startLocatorAndDS((int)this.port1, (File)logFile, (Properties)properties);
            final Properties properties2 = new Properties();
            properties2.put("mcast-port", "0");
            properties2.put("locators", locators);
            properties2.put("enable-network-partition-detection", "false");
            properties.put("disable-auto-reconnect", "true");
            vm1.invoke(new SerializableRunnable("try, but fail to connect"){

                @Override
                public void run() {
                    DistributedSystem s = null;
                    try {
                        s = DistributedSystem.connect((Properties)properties2);
                        boolean enabled = ((InternalDistributedSystem)s).getConfig().getEnableNetworkPartitionDetection();
                        s.disconnect();
                        if (!enabled) {
                            TestCase.fail((String)"should not have been able to connect with different enable-network-partition-detection settings");
                        }
                    }
                    catch (GemFireConfigException e) {
                        TestCase.fail((String)"should have been able to connect and have enable-network-partion-detection enabled");
                    }
                }
            });
            locator.stop();
            logFile = new File(this.getUniqueName() + "-locatorB-" + this.port1 + ".log");
            locator = Locator.startLocatorAndDS((int)this.port1, (File)logFile, (Properties)properties2);
            vm1.invoke(new SerializableRunnable("try, but fail to connect(2)"){

                @Override
                public void run() {
                    DistributedSystem s = null;
                    try {
                        s = DistributedSystem.connect((Properties)properties);
                        s.disconnect();
                        TestCase.fail((String)"should not have been able to connect with different enable-network-partition-detection settings");
                    }
                    catch (GemFireConfigException gemFireConfigException) {
                        // empty catch block
                    }
                }
            });
            locator.stop();
            locator = null;
        }
        finally {
            if (locator != null) {
                locator.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostingMultipleLocators() throws Exception {
        LocatorTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.port1 = AvailablePort.getRandomAvailablePort((int)0);
        File logFile1 = new File(this.getUniqueName() + "-locator" + this.port1 + ".log");
        Locator locator1 = Locator.startLocator((int)this.port1, (File)logFile1);
        try {
            int port2 = AvailablePort.getRandomAvailablePort((int)0);
            File logFile2 = new File(this.getUniqueName() + "-locator" + port2 + ".log");
            try {
                Locator locator2 = Locator.startLocator((int)port2, (File)logFile2);
                LocatorTest.fail((String)"expected second locator start to fail.");
            }
            catch (IllegalStateException locator2) {
                // empty catch block
            }
            String host0 = LocatorTest.getServerHostName(host);
            final String locators = host0 + "[" + this.port1 + "]," + host0 + "[" + port2 + "]";
            SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

                @Override
                public void run() {
                    Properties props = new Properties();
                    props.setProperty("mcast-port", "0");
                    props.setProperty("locators", locators);
                    DistributedSystem.connect((Properties)props);
                }
            };
            connect.run();
            SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null && sys.isConnected()) {
                        sys.disconnect();
                    }
                }
            };
            disconnect.run();
        }
        finally {
            locator1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartLocator() throws Exception {
        LocatorTest.disconnectAllFromDS();
        this.port1 = AvailablePort.getRandomAvailablePort((int)0);
        File logFile = new File(this.getUniqueName() + "-locator" + this.port1 + ".log");
        File stateFile = new File("locator" + this.port1 + "state.dat");
        VM vm0 = Host.getHost(0).getVM(0);
        final Properties p = new Properties();
        p.setProperty("locators", Host.getHost(0).getHostName() + "[" + this.port1 + "]");
        p.setProperty("mcast-port", "0");
        if (stateFile.exists()) {
            stateFile.delete();
        }
        LocatorTest.getLogWriter().info("Starting locator");
        Locator locator = Locator.startLocatorAndDS((int)this.port1, (File)logFile, (Properties)p);
        try {
            SerializableRunnable connect = new SerializableRunnable("Connect to locator on port " + this.port1){

                @Override
                public void run() {
                    DistributedSystem.connect((Properties)p);
                }
            };
            vm0.invoke(connect);
            int count = ((InternalLocator)locator).getLocatorHandler().getMemberCount();
            Assert.assertTrue((count == 2 ? 1 : 0) != 0, (Object)("The number of members in the discovery set should be 2 but is " + count));
            LocatorTest.getLogWriter().info("Stopping locator");
            locator.stop();
            LocatorTest.getLogWriter().info("Starting locator");
            locator = Locator.startLocatorAndDS((int)this.port1, (File)logFile, (Properties)p);
            count = ((InternalLocator)locator).getLocatorHandler().getMemberCount();
            Assert.assertTrue((count > 1 ? 1 : 0) != 0, (Object)("The number of members in the discovery set should be > 1 but is " + count + "; locator recovery failed!"));
            vm0.invoke(new SerializableRunnable("disconnect"){

                @Override
                public void run() {
                    DistributedSystem.connect((Properties)p).disconnect();
                }
            });
        }
        finally {
            locator.stop();
        }
    }

    public static DistributedMember getDistributedMember(Properties props) {
        DistributedSystem sys = DistributedSystem.connect((Properties)props);
        sys.getLogWriter().info("<ExpectedException action=add>service failure</ExpectedException>");
        sys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ConnectException</ExpectedException>");
        sys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
        return DistributedSystem.connect((Properties)props).getDistributedMember();
    }

    public static DistributedMember getLocatorDistributedMember() {
        return ((Locator)Locator.getLocators().iterator().next()).getDistributedSystem().getDistributedMember();
    }

    public static DistributedMember getLeadMember() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        return MembershipManagerHelper.getLeadMember((DistributedSystem)sys);
    }

    private SerializableRunnable getStopLocatorRunnable() {
        return new SerializableRunnable("stop locator"){

            @Override
            public void run() {
                System.getProperties().remove("JGroups.DEBUG");
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
                Locator loc = Locator.getLocator();
                if (loc != null) {
                    loc.stop();
                    TestCase.assertFalse((boolean)Locator.hasLocator());
                }
            }
        };
    }

    private SerializableRunnable getStartSBLocatorRunnable(final int port, final String name) {
        return new SerializableRunnable("Start locator on port " + port){

            @Override
            public void run() {
                File logFile = new File(name + "-locator" + port + ".log");
                try {
                    System.setProperty("gemfire.disable-floating-coordinator", "true");
                    System.setProperty("p2p.joinTimeout", "1000");
                    System.setProperty("JGroups.DEBUG", "true");
                    Properties locProps = new Properties();
                    locProps.setProperty("mcast-port", "0");
                    locProps.setProperty("log-level", "fine");
                    Locator.startLocatorAndDS((int)port, (File)logFile, (Properties)locProps);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port, ex);
                }
                finally {
                    System.getProperties().remove("gemfire.disable-floating-coordinator");
                    System.getProperties().remove("p2p.joinTimeout");
                }
            }
        };
    }

    protected void nukeJChannel(DistributedSystem sys) {
        sys.getLogWriter().info("<ExpectedException action=add>service failure</ExpectedException>");
        sys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ConnectException</ExpectedException>");
        sys.getLogWriter().info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
        try {
            MembershipManagerHelper.playDead((DistributedSystem)sys);
            JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)sys);
            Protocol udp = c.getProtocolStack().findProtocol("UDP");
            udp.stop();
            udp.passUp(new Event(46, (Object)new Exception("killing locator's ds")));
            MembershipManagerHelper.getJChannel((DistributedSystem)sys).waitForClose();
        }
        catch (DistributedSystemDisconnectedException c) {
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        sys.getLogWriter().info("<ExpectedException action=remove>service failure</ExpectedException>");
        sys.getLogWriter().info("<ExpectedException action=remove>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
    }

    class MyMembershipListener
    implements MembershipListener {
        boolean quorumLostInvoked;

        MyMembershipListener() {
        }

        public void memberJoined(InternalDistributedMember id) {
        }

        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        }

        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
        }

        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            this.quorumLostInvoked = true;
            DistributedTestCase.getLogWriter().info("quorumLost invoked in test code");
        }
    }

    class JChannelTestHook
    implements com.gemstone.org.jgroups.debug.JChannelTestHook {
        volatile boolean unboundedWait = true;

        JChannelTestHook() {
        }

        public void reset() {
            this.unboundedWait = false;
        }

        public void beforeChannelClosing(String string, Throwable cause) {
            InternalDistributedSystem.getAnyInstance().getLogWriter().info("Inside JChannelTestHook.beforeChannelClosing with " + cause);
            if (cause instanceof ForcedDisconnectException) {
                while (this.unboundedWait) {
                    DistributedTestCase.pause(500);
                }
            }
        }
    }
}

