/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractLocatorLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.process.FileAlreadyExistsException;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.org.jgroups.util.GFLogWriter;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class LocatorLauncherLocalDUnitTest
extends AbstractLocatorLauncherDUnitTestCase {
    public LocatorLauncherLocalDUnitTest(String name) {
        super(name);
    }

    @Override
    protected final void subSetUp1() throws Exception {
        LocatorLauncherLocalDUnitTest.disconnectAllFromDS();
        System.setProperty("gemfire.test.ProcessType.TEST_PREFIX", this.getUniqueName() + "-");
        this.subSetUp2();
    }

    @Override
    protected final void subTearDown1() throws Exception {
        LocatorLauncherLocalDUnitTest.disconnectAllFromDS();
        System.clearProperty("gemfire.test.ProcessType.TEST_PREFIX");
        this.subTearDown2();
    }

    protected void subSetUp2() throws Exception {
    }

    protected void subTearDown2() throws Exception {
    }

    protected AbstractLauncher.Status getExpectedStopStatusForNotRunning() {
        return AbstractLauncher.Status.NOT_RESPONDING;
    }

    public void testBuilderSetProperties() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                failure = null;
                this.launcher = new LocatorLauncher.Builder().setForce(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).set("disable-auto-reconnect", "true").set("log-level", "config").set("mcast-port", "0").build();
                LocatorLauncherLocalDUnitTest.assertNotNull((Object)this.launcher);
                try {
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.start().getStatus());
                    this.waitForLocatorToStart(this.launcher, true);
                    InternalLocator locator = this.launcher.getLocator();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)locator);
                    DistributedSystem distributedSystem = locator.getDistributedSystem();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)distributedSystem);
                    LocatorLauncherLocalDUnitTest.assertEquals((String)"true", (String)distributedSystem.getProperties().getProperty("disable-auto-reconnect"));
                    LocatorLauncherLocalDUnitTest.assertEquals((String)"0", (String)distributedSystem.getProperties().getProperty("mcast-port"));
                    LocatorLauncherLocalDUnitTest.assertEquals((String)"config", (String)distributedSystem.getProperties().getProperty("log-level"));
                    LocatorLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)distributedSystem.getProperties().getProperty("name"));
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                LocatorLauncherLocalDUnitTest.assertNull((Object)this.launcher.getLocator());
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testGetAllHostedLocators() throws Exception {
        int whichvm;
        InternalDistributedSystem system = this.getSystem();
        final String dunitLocator = system.getConfig().getLocators();
        LocatorLauncherLocalDUnitTest.assertNotNull((Object)dunitLocator);
        LocatorLauncherLocalDUnitTest.assertFalse((boolean)dunitLocator.isEmpty());
        final int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(4);
        int i = 0;
        while (i < 4) {
            final int whichvm2 = i++;
            Host.getHost(0).getVM(whichvm2).invoke(new SerializableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        System.setProperty("gemfire.locators", dunitLocator);
                        System.setProperty("gemfire.mcast-port", "0");
                        String name = LocatorLauncherLocalDUnitTest.this.getUniqueName() + "-" + whichvm2;
                        File subdir = new File(name);
                        subdir.mkdir();
                        TestCase.assertTrue((subdir.exists() && subdir.isDirectory() ? 1 : 0) != 0);
                        LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(name).setPort(Integer.valueOf(ports[whichvm2])).setRedirectOutput(Boolean.valueOf(true)).setWorkingDirectory(name);
                        LocatorLauncherLocalDUnitTest.this.launcher = builder.build();
                        TestCase.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)LocatorLauncherLocalDUnitTest.this.launcher.start().getStatus());
                        LocatorLauncherLocalDUnitTest.this.waitForLocatorToStart(LocatorLauncherLocalDUnitTest.this.launcher, 300000L, 10L, true);
                    }
                    finally {
                        System.clearProperty("gemfire.locators");
                        System.clearProperty("gemfire.mcast-port");
                    }
                }
            });
        }
        String host = SocketCreator.getLocalHost().getHostAddress();
        final HashSet<String> locators = new HashSet<String>();
        locators.add(host + "[" + dunitLocator.substring(dunitLocator.indexOf("[") + 1, dunitLocator.indexOf("]")) + "]");
        for (int port : ports) {
            locators.add(host + "[" + port + "]");
        }
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        Set locatorIds = dm.getLocatorDistributionManagerIds();
        LocatorLauncherLocalDUnitTest.assertEquals((int)5, (int)locatorIds.size());
        Map hostedLocators = dm.getAllHostedLocators();
        LocatorLauncherLocalDUnitTest.assertTrue((!hostedLocators.isEmpty() ? 1 : 0) != 0);
        LocatorLauncherLocalDUnitTest.assertEquals((int)5, (int)hostedLocators.size());
        for (InternalDistributedMember member : hostedLocators.keySet()) {
            LocatorLauncherLocalDUnitTest.assertEquals((int)1, (int)((Collection)hostedLocators.get(member)).size());
            String hostedLocator = (String)((Collection)hostedLocators.get(member)).iterator().next();
            LocatorLauncherLocalDUnitTest.assertTrue((String)(locators + " does not contain " + hostedLocator), (boolean)locators.contains(hostedLocator));
        }
        for (whichvm = 0; whichvm < 4; ++whichvm) {
            Host.getHost(0).getVM(whichvm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributionManager dm = (DistributionManager)InternalDistributedSystem.getAnyInstance().getDistributionManager();
                    InternalDistributedMember self = dm.getDistributionManagerId();
                    Set locatorIds = dm.getLocatorDistributionManagerIds();
                    TestCase.assertTrue((boolean)locatorIds.contains(self));
                    Map hostedLocators = dm.getAllHostedLocators();
                    TestCase.assertTrue((String)("hit bug #46324: " + hostedLocators + " is missing " + InternalLocator.getLocatorStrings() + " for " + self), (boolean)hostedLocators.containsKey(self));
                }
            });
        }
        for (whichvm = 0; whichvm < 4; ++whichvm) {
            Host.getHost(0).getVM(whichvm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributionManager dm = (DistributionManager)InternalDistributedSystem.getAnyInstance().getDistributionManager();
                    Set locatorIds = dm.getLocatorDistributionManagerIds();
                    TestCase.assertEquals((int)5, (int)locatorIds.size());
                    Map hostedLocators = dm.getAllHostedLocators();
                    TestCase.assertTrue((!hostedLocators.isEmpty() ? 1 : 0) != 0);
                    TestCase.assertEquals((int)5, (int)hostedLocators.size());
                    for (InternalDistributedMember member : hostedLocators.keySet()) {
                        TestCase.assertEquals((int)1, (int)((Collection)hostedLocators.get(member)).size());
                        String hostedLocator = (String)((Collection)hostedLocators.get(member)).iterator().next();
                        TestCase.assertTrue((String)(locators + " does not contain " + hostedLocator), (boolean)locators.contains(hostedLocator));
                    }
                }
            });
        }
    }

    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        LocatorLauncherLocalDUnitTest.assertTrue((boolean)factory.isAttachAPIFound());
        LocatorLauncherLocalDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertTrue((boolean)factory.isAttachAPIFound());
            }
        });
    }

    public void testStartCreatesPidFile() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertNotNull((Object)this.launcher);
                failure = null;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.status().getStatus());
                    this.pidFile = new File(builder.getWorkingDirectory(), ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherLocalDUnitTest.assertEquals((int)LocatorLauncherLocalDUnitTest.getPid(), (int)pid);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.status().getStatus());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartDeletesStaleControlFiles() throws Throwable {
        Throwable failure;
        block9: {
            block8: {
                block7: {
                    this.stopRequestFile = new File(ProcessType.LOCATOR.getStopRequestFileName());
                    this.stopRequestFile.createNewFile();
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.stopRequestFile.exists());
                    this.statusRequestFile = new File(ProcessType.LOCATOR.getStatusRequestFileName());
                    this.statusRequestFile.createNewFile();
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.statusRequestFile.exists());
                    this.statusFile = new File(ProcessType.LOCATOR.getStatusFileName());
                    this.statusFile.createNewFile();
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.statusFile.exists());
                    LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    this.launcher.start();
                    failure = null;
                    try {
                        this.waitForLocatorToStart(this.launcher);
                    }
                    catch (Throwable e) {
                        LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block7;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherLocalDUnitTest.assertEquals((int)LocatorLauncherLocalDUnitTest.getPid(), (int)pid);
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.stopRequestFile.exists());
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.statusRequestFile.exists());
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.statusFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartOverwritesStalePidFile() throws Throwable {
        Throwable failure;
        block9: {
            block8: {
                block7: {
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertFalse((String)"Integer.MAX_VALUE shouldn't be the same as local pid 2147483647", (Integer.MAX_VALUE == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.writePid(this.pidFile, Integer.MAX_VALUE);
                    LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    this.launcher.start();
                    failure = null;
                    try {
                        this.waitForLocatorToStart(this.launcher);
                    }
                    catch (Throwable e) {
                        LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block7;
                        failure = e;
                    }
                }
                try {
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherLocalDUnitTest.assertEquals((int)LocatorLauncherLocalDUnitTest.getPid(), (int)pid);
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingForceOverwritesExistingPidFile() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                LocatorLauncherLocalDUnitTest.assertTrue((String)(this.getUniqueName() + " is broken if PID == Integer.MAX_VALUE"), (ProcessUtils.identifyPid() != Integer.MAX_VALUE ? 1 : 0) != 0);
                this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                int realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                LocatorLauncherLocalDUnitTest.assertFalse((realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                this.writePid(this.pidFile, realPid);
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setForce(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                LocatorLauncherLocalDUnitTest.assertTrue((boolean)builder.getForce());
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.launcher.isForcing());
                this.launcher.start();
                failure = null;
                try {
                    this.waitForLocatorToStart(this.launcher);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherLocalDUnitTest.assertEquals((int)LocatorLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithDefaultPortInUseFails() throws Throwable {
        Throwable failure;
        block15: {
            block14: {
                block13: {
                    RuntimeException expected;
                    block12: {
                        this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.locatorPort, 50, null, (GFLogWriter)LocatorLauncherLocalDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                        LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.socket.isBound());
                        LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.socket.isClosed());
                        LocatorLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.locatorPort, (int)0));
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)System.getProperty("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT"));
                        LocatorLauncherLocalDUnitTest.assertEquals((int)this.locatorPort, (int)Integer.valueOf(System.getProperty("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT")));
                        LocatorLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.locatorPort, (int)0));
                        LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                        this.launcher = builder.build();
                        LocatorLauncherLocalDUnitTest.assertEquals((int)this.locatorPort, (int)this.launcher.getPort());
                        failure = null;
                        expected = null;
                        try {
                            this.launcher.start();
                            String property = System.getProperty("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT");
                            LocatorLauncherLocalDUnitTest.assertNotNull((Object)property);
                            LocatorLauncherLocalDUnitTest.assertEquals((int)this.locatorPort, (int)Integer.valueOf(property));
                            LocatorLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.locatorPort, (int)0));
                            LocatorLauncherLocalDUnitTest.assertEquals((int)this.locatorPort, (int)this.launcher.getPort());
                            LocatorLauncherLocalDUnitTest.assertEquals((int)this.locatorPort, (int)this.socket.getLocalPort());
                            LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.socket.isBound());
                            LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.socket.isClosed());
                            LocatorLauncherLocalDUnitTest.fail((String)"LocatorLauncher start should have thrown RuntimeException caused by BindException");
                        }
                        catch (RuntimeException e) {
                            expected = e;
                            LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        }
                        catch (Throwable e) {
                            LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                            if (failure != null) break block12;
                            failure = e;
                        }
                    }
                    try {
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected);
                        Throwable cause = expected.getCause();
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)cause);
                        LocatorLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof BindException));
                    }
                    catch (Throwable e) {
                        LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block13;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertFalse((String)("Pid file should not exist: " + this.pidFile), (boolean)this.pidFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherLocalDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block14;
                    failure = e;
                }
            }
            LocatorLauncher.LocatorState status = null;
            try {
                status = this.launcher.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
                LocatorLauncherLocalDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block15;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithExistingPidFileFails() throws Throwable {
        Throwable failure;
        block12: {
            LocatorLauncher.LocatorState status;
            block11: {
                RuntimeException expected;
                int realPid;
                block10: {
                    realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                    LocatorLauncherLocalDUnitTest.assertFalse((String)("Remote pid shouldn't be the same as local pid " + realPid), (realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    this.writePid(this.pidFile, realPid);
                    LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    failure = null;
                    expected = null;
                    try {
                        this.launcher.start();
                        LocatorLauncherLocalDUnitTest.fail((String)"LocatorLauncher start should have thrown RuntimeException caused by FileAlreadyExistsException");
                    }
                    catch (RuntimeException e) {
                        expected = e;
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        LocatorLauncherLocalDUnitTest.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("A PID file already exists and a Locator may be running in"));
                        LocatorLauncherLocalDUnitTest.assertEquals(RuntimeException.class, expected.getClass());
                    }
                    catch (Throwable e) {
                        LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                status = null;
                try {
                    status = this.launcher.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected);
                    Throwable cause = expected.getCause();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)cause);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof FileAlreadyExistsException));
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)cause.getMessage().contains("Pid file already exists: "));
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)cause.getMessage().contains("vf.gf.locator.pid for process " + realPid));
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            try {
                this.delete(this.pidFile);
                AbstractLauncher.Status theStatus = status.getStatus();
                LocatorLauncherLocalDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.STARTING ? 1 : 0) != 0);
                LocatorLauncherLocalDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.ONLINE ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingPort() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                failure = null;
                int freeTCPPort = AvailablePortHelper.getRandomAvailableTCPPort();
                LocatorLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)freeTCPPort, (int)0));
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(freeTCPPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                this.launcher = builder.build();
                int pid = 0;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherLocalDUnitTest.assertEquals((int)LocatorLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)this.locatorPort, (int)0));
                    LocatorLauncher.LocatorState status = this.launcher.status();
                    String portString = status.getPort();
                    LocatorLauncherLocalDUnitTest.assertEquals((String)("Port should be \"" + freeTCPPort + "\" instead of " + portString), (String)String.valueOf(freeTCPPort), (String)portString);
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingPortInUseFails() throws Throwable {
        Throwable failure;
        block15: {
            block14: {
                block13: {
                    RuntimeException expected;
                    block12: {
                        int freeTCPPort = AvailablePort.getRandomAvailablePort((int)0);
                        this.socket = SocketCreator.getDefaultInstance().createServerSocket(freeTCPPort, 50, null, (GFLogWriter)LocatorLauncherLocalDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                        LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(freeTCPPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                        this.launcher = builder.build();
                        failure = null;
                        expected = null;
                        try {
                            this.launcher.start();
                            LocatorLauncherLocalDUnitTest.fail((String)"LocatorLauncher start should have thrown RuntimeException caused by BindException");
                        }
                        catch (RuntimeException e) {
                            expected = e;
                            LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        }
                        catch (Throwable e) {
                            LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                            if (failure != null) break block12;
                            failure = e;
                        }
                    }
                    try {
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)expected);
                        Throwable cause = expected.getCause();
                        LocatorLauncherLocalDUnitTest.assertNotNull((Object)cause);
                        LocatorLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof BindException));
                    }
                    catch (Throwable e) {
                        LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block13;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertFalse((String)("Pid file should not exist: " + this.pidFile), (boolean)this.pidFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherLocalDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block14;
                    failure = e;
                }
            }
            LocatorLauncher.LocatorState status = null;
            try {
                status = this.launcher.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
                LocatorLauncherLocalDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block15;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingPid() throws Throwable {
        Throwable failure;
        block10: {
            LocatorLauncher pidLauncher;
            block9: {
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                pidLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)pidLauncher);
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    LocatorLauncher.LocatorState actualStatus = pidLauncher.status();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)actualStatus);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    LocatorLauncherLocalDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    LocatorLauncherLocalDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((String)new File(System.getProperty("user.dir")).getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)(new File(System.getProperty("user.dir")).getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block9;
                    failure = e;
                }
            }
            if (pidLauncher == null) {
                try {
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                    this.waitForFileToDelete(this.pidFile);
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure == null) {
                        failure = e;
                    }
                    break block10;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block10;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block10: {
            LocatorLauncher dirLauncher;
            block9: {
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                dirLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    String workingDir = new File(System.getProperty("user.dir")).getCanonicalPath();
                    dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(workingDir).build();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)dirLauncher);
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)dirLauncher.isRunning());
                    LocatorLauncher.LocatorState actualStatus = dirLauncher.status();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)actualStatus);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    LocatorLauncherLocalDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    LocatorLauncherLocalDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((String)new File(System.getProperty("user.dir")).getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)(new File(System.getProperty("user.dir")).getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    LocatorLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block9;
                    failure = e;
                }
            }
            if (dirLauncher == null) {
                try {
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                    this.waitForFileToDelete(this.pidFile);
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure == null) {
                        failure = e;
                    }
                    break block10;
                }
            }
            try {
                LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block10;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingPid() throws Throwable {
        Throwable failure;
        block8: {
            block7: {
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                LocatorLauncher pidLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)pidLauncher);
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    LocatorLauncher.LocatorState locatorState = pidLauncher.stop();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)locatorState.getStatus());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block7;
                    failure = e;
                }
            }
            try {
                this.launcher.stop();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block8;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block8: {
            block7: {
                LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setMemberName(this.getUniqueName()).setPort(Integer.valueOf(this.locatorPort)).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                LocatorLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                LocatorLauncher dirLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    LocatorLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    String workingDir = new File(System.getProperty("user.dir")).getCanonicalPath();
                    dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(workingDir).build();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)dirLauncher);
                    LocatorLauncherLocalDUnitTest.assertFalse((boolean)dirLauncher.isRunning());
                    LocatorLauncher.LocatorState locatorState = dirLauncher.stop();
                    LocatorLauncherLocalDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)locatorState.getStatus());
                }
                catch (Throwable e) {
                    LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block7;
                    failure = e;
                }
            }
            try {
                this.launcher.stop();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block8;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

