/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncherDUnitTestCase;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.gemfire.management.MemberMXBean;
import dunit.DistributedTestCase;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;

public class LauncherMemberMXBeanDUnitTest
extends AbstractLauncherDUnitTestCase {
    public LauncherMemberMXBeanDUnitTest(String name) {
        super(name);
    }

    @Override
    protected void subSetUp() throws Exception {
    }

    @Override
    protected void subTearDown() throws Exception {
    }

    public void testQueryForMemberMXBean() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("name", this.getUniqueName());
        this.getSystem(props);
        this.getCache();
        final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        final ObjectName pattern = ObjectName.getInstance("GemFire:type=Member,*");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, null);
                return !mbeanNames.isEmpty();
            }

            @Override
            public String description() {
                return "waiting for MemberMXBean to be registered";
            }
        };
        LauncherMemberMXBeanDUnitTest.waitForCriterion(wc, 10000L, 10L, false);
        Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, null);
        LauncherMemberMXBeanDUnitTest.assertFalse((boolean)mbeanNames.isEmpty());
        LauncherMemberMXBeanDUnitTest.assertEquals((String)("mbeanNames=" + mbeanNames), (int)1, (int)mbeanNames.size());
        ObjectName objectName = mbeanNames.iterator().next();
        MemberMXBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, MemberMXBean.class, false);
        LauncherMemberMXBeanDUnitTest.assertNotNull((Object)mbean);
        LauncherMemberMXBeanDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)mbean.getProcessId());
        LauncherMemberMXBeanDUnitTest.assertEquals((String)this.getUniqueName(), (String)mbean.getName());
        LauncherMemberMXBeanDUnitTest.assertEquals((String)this.getUniqueName(), (String)mbean.getMember());
    }

    public void testQueryForMemberMXBeanWithProcessId() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("name", this.getUniqueName());
        this.getSystem(props);
        this.getCache();
        final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        final ObjectName pattern = ObjectName.getInstance("GemFire:type=Member,*");
        final QueryExp constraint = Query.eq(Query.attr("ProcessId"), Query.value(ProcessUtils.identifyPid()));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, constraint);
                return !mbeanNames.isEmpty();
            }

            @Override
            public String description() {
                return "waiting for MemberMXBean to be registered";
            }
        };
        LauncherMemberMXBeanDUnitTest.waitForCriterion(wc, 10000L, 10L, false);
        Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, constraint);
        LauncherMemberMXBeanDUnitTest.assertFalse((boolean)mbeanNames.isEmpty());
        LauncherMemberMXBeanDUnitTest.assertEquals((int)1, (int)mbeanNames.size());
        ObjectName objectName = mbeanNames.iterator().next();
        MemberMXBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, MemberMXBean.class, false);
        LauncherMemberMXBeanDUnitTest.assertNotNull((Object)mbean);
        LauncherMemberMXBeanDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)mbean.getProcessId());
        LauncherMemberMXBeanDUnitTest.assertEquals((String)this.getUniqueName(), (String)mbean.getName());
        LauncherMemberMXBeanDUnitTest.assertEquals((String)this.getUniqueName(), (String)mbean.getMember());
    }

    public void testQueryForMemberMXBeanWithMemberName() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("name", this.getUniqueName());
        this.getSystem(props);
        this.getCache();
        final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        final ObjectName pattern = ObjectName.getInstance("GemFire:type=Member,*");
        final QueryExp constraint = Query.eq(Query.attr("Name"), Query.value(this.getUniqueName()));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, constraint);
                return !mbeanNames.isEmpty();
            }

            @Override
            public String description() {
                return "waiting for MemberMXBean to be registered";
            }
        };
        LauncherMemberMXBeanDUnitTest.waitForCriterion(wc, 10000L, 10L, false);
        Set<ObjectName> mbeanNames = mbeanServer.queryNames(pattern, constraint);
        LauncherMemberMXBeanDUnitTest.assertFalse((boolean)mbeanNames.isEmpty());
        LauncherMemberMXBeanDUnitTest.assertEquals((int)1, (int)mbeanNames.size());
        ObjectName objectName = mbeanNames.iterator().next();
        MemberMXBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, MemberMXBean.class, false);
        LauncherMemberMXBeanDUnitTest.assertNotNull((Object)mbean);
        LauncherMemberMXBeanDUnitTest.assertEquals((String)this.getUniqueName(), (String)mbean.getMember());
    }
}

