/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.ServerLauncher;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.io.File;
import junit.framework.TestCase;

public abstract class AbstractServerLauncherDUnitTestCase
extends AbstractLauncherDUnitTestCase {
    protected volatile transient int serverPort;
    protected volatile transient ServerLauncher launcher;
    protected volatile transient File cacheXmlFile;

    public AbstractServerLauncherDUnitTestCase(String name) {
        super(name);
    }

    @Override
    public final void subSetUp() throws Exception {
        System.setProperty("gemfire.mcast-port", Integer.toString(0));
        final int port = AvailablePortHelper.getRandomAvailableTCPPort();
        AbstractServerLauncherDUnitTestCase.overrideDefaultPort(port);
        AbstractServerLauncherDUnitTestCase.invokeInEveryVM(new SerializableRunnable("overrideDefaultPort"){

            @Override
            public void run() {
                AbstractServerLauncherDUnitTestCase.overrideDefaultPort(port);
            }
        });
        this.serverPort = port;
        this.subSetUp1();
    }

    @Override
    public final void subTearDown() throws Exception {
        System.clearProperty("gemfire.mcast-port");
        System.clearProperty("cache-xml-file");
        this.cleanupServerLauncher();
        this.delete(this.cacheXmlFile);
        this.cacheXmlFile = null;
        this.serverPort = 0;
        AbstractServerLauncherDUnitTestCase.restoreDefaultPort();
        AbstractServerLauncherDUnitTestCase.invokeInEveryVM(new SerializableRunnable("restoreDefaultPort"){

            @Override
            public void run() {
                AbstractServerLauncherDUnitTestCase.restoreDefaultPort();
            }
        });
        this.subTearDown1();
    }

    protected abstract void subSetUp1() throws Exception;

    protected abstract void subTearDown1() throws Exception;

    protected void cleanupServerLauncher() {
        try {
            if (this.launcher != null) {
                this.launcher.stop();
                this.launcher = null;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void waitForServerToStart(final ServerLauncher launcher, long timeout, long interval, boolean throwOnTimeout) {
        AbstractServerLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    ServerLauncher.ServerState serverState = launcher.status();
                    TestCase.assertNotNull((Object)serverState);
                    return AbstractLauncher.Status.ONLINE.equals((Object)serverState.getStatus());
                }
                catch (RuntimeException e) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "waiting for local Server to start: " + launcher.status();
            }
        }, timeout, interval, throwOnTimeout);
    }

    protected void waitForServerToStart(ServerLauncher launcher, boolean throwOnTimeout) {
        this.waitForServerToStart(launcher, 300000L, 100L, throwOnTimeout);
    }

    protected void waitForServerToStart(ServerLauncher launcher, long timeout, boolean throwOnTimeout) {
        this.waitForServerToStart(launcher, timeout, 100L, throwOnTimeout);
    }

    protected void waitForServerToStart(ServerLauncher launcher) {
        this.waitForServerToStart(launcher, 300000L, 100L, true);
    }

    protected static void overrideDefaultPort(int port) {
        System.setProperty("gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT", String.valueOf(port));
    }

    protected static void restoreDefaultPort() {
        System.clearProperty("gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT");
    }
}

