/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.RegionMembershipListenerDUnitTest;
import com.gemstone.gemfire.distributed.DistributedMember;
import dunit.VM;
import java.util.List;

public class PartitionedRegionMembershipListenerDUnitTest
extends RegionMembershipListenerDUnitTest {
    private transient RegionMembershipListenerDUnitTest.MyRML myPRListener;
    private transient Region prr;

    public PartitionedRegionMembershipListenerDUnitTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes createSubRegionAttributes(CacheListener[] cacheListeners) {
        AttributesFactory af = new AttributesFactory();
        if (cacheListeners != null) {
            af.initCacheListeners(cacheListeners);
        }
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setRedundantCopies(0).create());
        return af.create();
    }

    @Override
    protected List<DistributedMember> assertInitialMembers(DistributedMember otherId) {
        List<DistributedMember> l = super.assertInitialMembers(otherId);
        PartitionedRegionMembershipListenerDUnitTest.assertTrue((boolean)this.myPRListener.lastOpWasInitialMembers());
        PartitionedRegionMembershipListenerDUnitTest.assertEquals(l, (Object)this.myPRListener.getInitialMembers());
        return l;
    }

    @Override
    protected void closeRoots() {
        super.closeRoots();
        this.prr.close();
    }

    @Override
    protected void createRootRegionWithListener(String rName) throws CacheException {
        super.createRootRegionWithListener(rName);
        int to = this.getOpTimeout();
        this.myPRListener = new RegionMembershipListenerDUnitTest.MyRML(to);
        AttributesFactory af = new AttributesFactory();
        af.initCacheListeners(new CacheListener[]{this.myPRListener});
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setRedundantCopies(0).create());
        this.prr = this.createRootRegion(rName + "-pr", af.create());
    }

    @Override
    protected void createRootOtherVm(final String rName) {
        super.createRootOtherVm(rName);
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create PR root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setRedundantCopies(0).create());
                PartitionedRegionMembershipListenerDUnitTest.this.createRootRegion(rName + "-pr", af.create());
            }
        });
    }

    @Override
    protected void destroyRootOtherVm(final String rName) {
        super.destroyRootOtherVm(rName);
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("local destroy PR root"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionMembershipListenerDUnitTest.this.getRootRegion(rName + "-pr").localDestroyRegion();
            }
        });
    }

    @Override
    protected void closeRootOtherVm(final String rName) {
        super.closeRootOtherVm(rName);
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("close PR root"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionMembershipListenerDUnitTest.this.getRootRegion(rName + "-pr").close();
            }
        });
    }

    @Override
    protected void assertOpWasCreate() {
        super.assertOpWasCreate();
        PartitionedRegionMembershipListenerDUnitTest.assertTrue((boolean)this.myPRListener.lastOpWasCreate());
    }

    @Override
    protected void assertOpWasDeparture() {
        super.assertOpWasDeparture();
        PartitionedRegionMembershipListenerDUnitTest.assertTrue((boolean)this.myPRListener.lastOpWasDeparture());
        PartitionedRegionMembershipListenerDUnitTest.assertEventStuff(this.myPRListener.getLastEvent(), this.otherId, this.prr);
    }
}

