/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.PureLogWriter;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.log.AnyLogWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionedRegionDUnitTest
extends MultiVMRegionTestCase {
    static int oldLogLevel;
    static String oldVerbose;
    public static boolean InvalidateInvoked;

    public PartitionedRegionDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean supportsSubregions() {
        return false;
    }

    @Override
    protected boolean supportsNetLoad() {
        return false;
    }

    @Override
    protected boolean supportsReplication() {
        return false;
    }

    @Override
    protected boolean supportsLocalDestroyAndLocalInvalidate() {
        return false;
    }

    @Override
    public void testCacheLoaderModifyingArgument() throws InterruptedException {
    }

    @Override
    public void testLocalAndRemoteCacheWriters() throws InterruptedException {
    }

    @Override
    public void testLocalCacheLoader() {
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setEarlyAck(false);
        factory.setPartitionAttributes(new PartitionAttributesFactory().create());
        return factory.create();
    }

    protected RegionAttributes getNonPRRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEarlyAck(false);
        return factory.create();
    }

    public static int setLogLevel(LogWriter l, int logLevl) {
        int ret = -1;
        if (l instanceof PureLogWriter) {
            PureLogWriter pl = (PureLogWriter)l;
            ret = pl.getLevel();
            pl.setLevel(logLevl);
        } else if (l instanceof AnyLogWriter) {
            AnyLogWriter al = (AnyLogWriter)l;
            ret = al.getLevel();
            al.setLevel(logLevl);
        }
        return ret;
    }

    void setVMInfoLogLevel() {
        SerializableRunnable runnable = new SerializableRunnable(){

            @Override
            public void run() {
                oldVerbose = System.getProperty("DistributionManager.VERBOSE", "false");
                System.setProperty("DistributionManager.VERBOSE", "false");
                DistributionManager.VERBOSE = false;
                oldLogLevel = PartitionedRegionDUnitTest.setLogLevel(PartitionedRegionDUnitTest.this.getCache().getLogger(), 800);
            }
        };
        for (int i = 0; i < 4; ++i) {
            Host.getHost(0).getVM(i).invoke(runnable);
        }
    }

    void resetVMLogLevel() {
        SerializableRunnable runnable = new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("DistributionManager.VERBOSE", oldVerbose);
                DistributionManager.VERBOSE = oldVerbose.equals("true");
                PartitionedRegionDUnitTest.setLogLevel(PartitionedRegionDUnitTest.this.getCache().getLogger(), oldLogLevel);
            }
        };
        for (int i = 0; i < 4; ++i) {
            Host.getHost(0).getVM(i).invoke(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionInvalidationWithAdjunctMessages() throws Exception {
        final String name = this.getUniqueName();
        VM vm1 = Host.getHost(0).getVM(1);
        Cache cache = this.getCache();
        RegionFactory fact = this.getCache().createRegionFactory(RegionShortcut.PARTITION);
        Region pr = fact.create(name + "Region");
        pr.put((Object)"Object1", (Object)"Value1");
        vm1.invoke(new SerializableRunnable("create PR"){

            @Override
            public void run() {
                RegionFactory fact = PartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION);
                fact.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                fact.addCacheListener((CacheListener)new CacheListenerAdapter(){

                    public void afterInvalidate(EntryEvent event) {
                        DistributedTestCase.getLogWriter().info("afterInvalidate invoked with " + event);
                        InvalidateInvoked = true;
                    }
                });
                fact.create(name + "Region");
            }
        });
        try {
            pr.invalidateRegion();
            PartitionedRegionDUnitTest.assertTrue((String)"vm1 should have invoked the listener for an invalidateRegion operation", (boolean)((Boolean)vm1.invoke(new SerializableCallable("getStatus"){

                public Object call() {
                    return InvalidateInvoked;
                }
            })));
        }
        finally {
            PartitionedRegionDUnitTest.disconnectAllFromDS();
        }
    }

    public void testIncompatibleSubregions() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-PR";
        vm0.invoke(new SerializableRunnable("Create partitioned Region"){

            @Override
            public void run() {
                try {
                    PartitionedRegionDUnitTest.this.createRegion(name, "INCOMPATIBLE_ROOT", PartitionedRegionDUnitTest.this.getRegionAttributes());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create non-partitioned Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(PartitionedRegionDUnitTest.this.getNonPRRegionAttributes());
                    try {
                        PartitionedRegionDUnitTest.this.createRegion(name, "INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned Region", ex);
                }
            }
        });
    }

    private void setupExtendedTest(final String regionName, final int numVals) {
        Host host = Host.getHost(0);
        SerializableRunnable createPR = new SerializableRunnable("createPartitionedRegion"){

            @Override
            public void run() {
                try {
                    PartitionedRegionDUnitTest.this.createRegion(regionName, "root", PartitionedRegionDUnitTest.this.getRegionAttributes());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        for (int i = 1; i < 4; ++i) {
            host.getVM(i).invoke(createPR);
        }
        VM vm0 = host.getVM(0);
        vm0.invoke(new SerializableRunnable("Populate Partitioned Region"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Region region = null;
                try {
                    region = PartitionedRegionDUnitTest.this.createRegion(regionName, "root", PartitionedRegionDUnitTest.this.getRegionAttributes());
                    region.getCache().getLogger().info("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
                    Random rand = new Random(System.currentTimeMillis());
                    for (int i = 0; i < numVals; ++i) {
                        boolean created = false;
                        while (!created) {
                            try {
                                int val = rand.nextInt(100000000);
                                String key = String.valueOf(val);
                                region.create((Object)key, (Object)new Integer(val));
                                created = true;
                            }
                            catch (EntryExistsException entryExistsException) {}
                        }
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("while creating or populating partitioned region", ex);
                }
                finally {
                    if (region != null) {
                        region.getCache().getLogger().info("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtendedKeysValues() {
        final String regionName = this.getUniqueName();
        int numEntries = 20000;
        this.setVMInfoLogLevel();
        try {
            this.setupExtendedTest(regionName, 20000);
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            vm0.invoke(new SerializableRunnable("exercise Region.values"){

                @Override
                public void run() {
                    try {
                        Region region = PartitionedRegionDUnitTest.this.getRootRegion().getSubregion(regionName);
                        Collection values = region.values();
                        Set keys = region.keySet();
                        Set entries = region.entrySet();
                        TestCase.assertEquals((String)"value collection size was not the expected value", (int)20000, (int)values.size());
                        TestCase.assertEquals((String)"key set size was not the expected value", (int)20000, (int)keys.size());
                        TestCase.assertEquals((String)"entry set size was not the expected value", (int)20000, (int)entries.size());
                        TestCase.assertEquals((String)"region size was not the expected value", (int)20000, (int)region.size());
                        Iterator valuesIt = values.iterator();
                        Iterator keysIt = keys.iterator();
                        Iterator entriesIt = entries.iterator();
                        for (int i = 0; i < 20000; ++i) {
                            TestCase.assertTrue((boolean)valuesIt.hasNext());
                            Integer value = (Integer)valuesIt.next();
                            TestCase.assertNotNull((String)"value was null", (Object)value);
                            TestCase.assertTrue((boolean)keysIt.hasNext());
                            String key = (String)keysIt.next();
                            TestCase.assertNotNull((String)"key was null", (Object)key);
                            TestCase.assertTrue((boolean)entriesIt.hasNext());
                            Region.Entry entry = (Region.Entry)entriesIt.next();
                            TestCase.assertNotNull((String)"entry was null", (Object)entry);
                            TestCase.assertNotNull((String)"entry key was null", (Object)entry.getKey());
                            TestCase.assertNotNull((String)"entry value was null", (Object)entry.getValue());
                        }
                        TestCase.assertTrue((String)"should have been end of values iteration", (!valuesIt.hasNext() ? 1 : 0) != 0);
                        TestCase.assertTrue((String)"should have been end of keys iteration", (!keysIt.hasNext() ? 1 : 0) != 0);
                        TestCase.assertTrue((String)"should have been end of entries iteration", (!entriesIt.hasNext() ? 1 : 0) != 0);
                    }
                    catch (Exception ex) {
                        try {
                            PartitionedRegionDUnitTest.this.getRootRegion().getSubregion(regionName).destroyRegion();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DistributedTestCase.fail("Unexpected exception", ex);
                    }
                }
            });
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    @Override
    public void testDefinedEntryUpdated() {
        this.unimplemented();
    }

    @Override
    public void testRemoteCacheListener() {
        this.unimplemented();
    }

    @Override
    public void testEntryUserAttribute() {
        this.unimplemented();
    }

    @Override
    public void testInvalidateRegion() {
        this.unimplemented();
    }

    @Override
    public void testLocalDestroyRegion() {
        this.unimplemented();
    }

    @Override
    public void testLocalInvalidateRegion() {
        this.unimplemented();
    }

    @Override
    public void testSnapshot() {
        this.unimplemented();
    }

    @Override
    public void testRootSnapshot() {
        this.unimplemented();
    }

    private void unimplemented() {
    }

    public void testBadHash() {
        final String regionName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPR = new SerializableRunnable("createPartitionedRegion"){

            @Override
            public void run() {
                try {
                    PartitionedRegionDUnitTest.this.createRegion(regionName, "root", PartitionedRegionDUnitTest.this.getRegionAttributes());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm0.invoke(createPR);
        vm1.invoke(createPR);
        vm0.invoke(new SerializableRunnable("Populate 1"){

            @Override
            public void run() {
                Region region = PartitionedRegionDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    String st = Integer.toString(i);
                    PoisonedKey pk = new PoisonedKey(st);
                    region.create((Object)pk, (Object)st);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Read 1"){

            @Override
            public void run() {
                Region region = PartitionedRegionDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    String st = Integer.toString(i);
                    PoisonedKey pk = new PoisonedKey(st);
                    TestCase.assertTrue((String)"Keys screwed up too early", (boolean)region.get((Object)pk).equals(st));
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Populate 2"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Region region = PartitionedRegionDUnitTest.this.getRootRegion().getSubregion(regionName);
                PoisonedKey.poisoned = true;
                try {
                    for (int i = 10; i < 20; ++i) {
                        String st = Integer.toString(i);
                        PoisonedKey pk = new PoisonedKey(st);
                        region.create((Object)pk, (Object)st);
                    }
                }
                catch (PartitionedRegionException e) {
                    PoisonedKey.poisonDetected = true;
                }
                finally {
                    PoisonedKey.poisoned = false;
                }
            }
        });
        boolean success = vm0.invokeBoolean(PoisonedKey.class, "poisonFound");
        PartitionedRegionDUnitTest.assertTrue((String)"Hash mismatch not found", (boolean)success);
    }

    static {
        InvalidateInvoked = false;
    }

    static class PoisonedKey
    implements Serializable {
        static volatile boolean poisoned = false;
        static volatile boolean poisonDetected = false;
        final String k;

        public static boolean poisonFound() {
            boolean result = poisonDetected;
            poisonDetected = false;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            int result = this.k.hashCode();
            Class<PoisonedKey> clazz = PoisonedKey.class;
            synchronized (PoisonedKey.class) {
                if (poisoned) {
                    result += new Random().nextInt();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
        }

        PoisonedKey(String s) {
            this.k = s;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof PoisonedKey)) {
                return false;
            }
            PoisonedKey po = (PoisonedKey)o;
            if (this.k == null) {
                return po.k == null;
            }
            return this.k.equals(po.k);
        }
    }
}

