/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import dunit.Host;
import dunit.VM;
import java.util.concurrent.locks.Lock;
import junit.framework.TestCase;

public class GlobalLockingTest
extends CacheTestCase {
    public static Region region_testBug32356;

    public GlobalLockingTest(String name) {
        super(name);
    }

    protected RegionAttributes getGlobalAttrs() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        return factory.create();
    }

    protected Region getOrCreateRootRegion() {
        Region root = this.getRootRegion();
        if (root == null) {
            try {
                root = this.createRootRegion(this.getGlobalAttrs());
            }
            catch (RegionExistsException ex) {
                GlobalLockingTest.fail((String)"Huh?");
            }
            catch (TimeoutException ex) {
                GlobalLockingTest.fail((String)ex.toString());
            }
        }
        return root;
    }

    public void testBug32356() throws Exception {
        int vm;
        GlobalLockingTest.getLogWriter().fine("[testBug32356]");
        Host host = Host.getHost(0);
        final String name = this.getUniqueName();
        final String key = "32356";
        GlobalLockingTest.getLogWriter().fine("[testBug32356] lock/unlock '32356' in all vms");
        int i = 0;
        while (i < 4) {
            vm = i++;
            host.getVM(vm).invoke(new CacheSerializableRunnable("testBug32356_step1"){

                @Override
                public void run2() throws CacheException {
                    region_testBug32356 = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                    Lock lock = region_testBug32356.getDistributedLock(key);
                    lock.lock();
                    lock.unlock();
                }
            });
        }
        GlobalLockingTest.getLogWriter().fine("[testBug32356] attempt try-lock of zero wait time in all vms");
        i = 0;
        while (i < 4) {
            vm = i++;
            host.getVM(vm).invoke(new CacheSerializableRunnable("testBug32356_step2"){

                @Override
                public void run2() throws CacheException {
                    Lock lock = region_testBug32356.getDistributedLock(key);
                    TestCase.assertTrue((String)"Found bug 32356", (boolean)lock.tryLock());
                    lock.unlock();
                }
            });
        }
    }

    public void testNonGlobalRegion() throws CacheException {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory(this.getGlobalAttrs());
        factory.setScope(Scope.LOCAL);
        Region region = this.getOrCreateRootRegion().createSubregion(name + "LOCAL", factory.create());
        try {
            region.getDistributedLock((Object)"obj");
            GlobalLockingTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        factory.setScope(Scope.DISTRIBUTED_ACK);
        region = this.getOrCreateRootRegion().createSubregion(name + "DACK", factory.create());
        try {
            region.getDistributedLock((Object)"obj");
            GlobalLockingTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        region = this.getOrCreateRootRegion().createSubregion(name + "DNOACK", factory.create());
        try {
            region.getDistributedLock((Object)"obj");
            GlobalLockingTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSingleVMLockUnlock() throws CacheException {
        String name = this.getUniqueName() + "-GLOBAL";
        Region region = this.getOrCreateRootRegion().createSubregion(name, this.getGlobalAttrs());
        Lock lock = region.getDistributedLock((Object)"obj");
        lock.lock();
        lock.unlock();
    }

    public void testIsLockGrantorAttribute() throws Exception {
        String name = this.getUniqueName() + "-testIsLockGrantorAttribute";
        AttributesFactory factory = new AttributesFactory(this.getGlobalAttrs());
        factory.setLockGrantor(true);
        Region region = this.getOrCreateRootRegion().createSubregion(name, factory.create());
        GlobalLockingTest.assertEquals((String)"Setting isLockGrantor failed to result in becoming lock grantor", (boolean)true, (boolean)((DistributedRegion)region).getLockService().isLockGrantor());
    }

    public void testCreateLockTimeout() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName();
        final Integer key = new Integer(5);
        vm0.invoke(new CacheSerializableRunnable("Get lock"){

            @Override
            public void run2() throws CacheException {
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                Lock lock = r.getDistributedLock(key);
                lock.lock();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Lock timeout creating entry"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                try {
                    r.create(key, (Object)"the value");
                    TestCase.fail((String)"create() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testPutLockTimeout() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName();
        final Integer key = new Integer(5);
        vm0.invoke(new CacheSerializableRunnable("Get lock"){

            @Override
            public void run2() throws CacheException {
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                Lock lock = r.getDistributedLock(key);
                lock.lock();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Lock timeout putting entry"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                try {
                    r.put(key, (Object)"the value");
                    TestCase.fail((String)"put() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testLoadLockTimeout() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName();
        final Integer key = new Integer(5);
        vm0.invoke(new CacheSerializableRunnable("Get lock"){

            @Override
            public void run2() throws CacheException {
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                Lock lock = r.getDistributedLock(key);
                lock.lock();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Lock timeout local loader"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                r.getAttributesMutator().setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        throw new CacheLoaderException("Made it into the loader!");
                    }

                    public void close() {
                    }
                });
                try {
                    r.get(key);
                    TestCase.fail((String)"get() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testInvalidateLockTimeout() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName();
        final Integer key = new Integer(5);
        vm0.invoke(new CacheSerializableRunnable("Get lock"){

            @Override
            public void run2() throws CacheException {
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                Lock lock = r.getDistributedLock(key);
                lock.lock();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Lock timeout invalidating entry"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                try {
                    r.invalidate(key);
                    TestCase.fail((String)"invalidate() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testDestroyLockTimeout() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName();
        final Integer key = new Integer(5);
        vm0.invoke(new CacheSerializableRunnable("Get lock"){

            @Override
            public void run2() throws CacheException {
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                Lock lock = r.getDistributedLock(key);
                lock.lock();
                r.put(key, (Object)"value");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Lock timeout destroying entry"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                r.get(key);
                try {
                    r.destroy(key);
                    TestCase.fail((String)"destroy() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testLockGetPut() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-GLOBAL";
        final Integer key = new Integer(5);
        Region r = this.getOrCreateRootRegion().createSubregion(name, this.getGlobalAttrs());
        Lock lock = r.getDistributedLock((Object)key);
        lock.lock();
        r.create((Object)key, (Object)"value 1");
        GlobalLockingTest.assertEquals((Object)"value 1", (Object)r.get((Object)key));
        vm0.invoke(new CacheSerializableRunnable("Unsuccessful locking operation"){

            @Override
            public void run2() throws CacheException {
                try {
                    GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                    Region r2 = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                    TestCase.assertEquals((Object)"value 1", (Object)r2.get(key));
                    r2.put(key, (Object)"wrong value");
                    TestCase.fail((String)"put() should have thrown TimeoutException");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        r.put((Object)key, (Object)"value 2");
        lock.unlock();
        vm1.invoke(new CacheSerializableRunnable("Successful locking operation"){

            @Override
            public void run2() throws CacheException {
                GlobalLockingTest.this.getOrCreateRootRegion().getCache().setLockTimeout(2);
                Region r2 = GlobalLockingTest.this.getOrCreateRootRegion().createSubregion(name, GlobalLockingTest.this.getGlobalAttrs());
                TestCase.assertEquals((Object)"value 2", (Object)r2.get(key));
                r2.put(key, (Object)"value 3");
            }
        });
        GlobalLockingTest.assertEquals((Object)"value 3", (Object)r.get((Object)key));
    }

    public void testRegionDistributedLockSimple() throws CacheException {
        String name = this.getUniqueName();
        Region r = this.getOrCreateRootRegion().createSubregion(name, this.getGlobalAttrs());
        Lock lock = r.getRegionDistributedLock();
        lock.lock();
        lock.unlock();
    }
}

