/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheXml70Test;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;

public class CacheXml75Test
extends CacheXml70Test {
    private static final long serialVersionUID = 225193925777688541L;

    public CacheXml75Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testResourceManagerThresholds() throws Exception {
        CacheCreation cache = new CacheCreation();
        float low = 90.0f;
        float high = 95.0f;
        try {
            System.setProperty("gemfire.off-heap-memory-size", "1m");
            ResourceManagerCreation rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(90.0f);
            rmc.setCriticalOffHeapPercentage(95.0f);
            cache.setResourceManagerCreation(rmc);
            this.testXml(cache);
            Cache c = this.getCache();
            CacheXml75Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionOffHeapPercentage()));
            CacheXml75Test.assertEquals((Object)Float.valueOf(95.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalOffHeapPercentage()));
            CacheXml75Test.closeCache();
            rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(90.0f);
            rmc.setCriticalOffHeapPercentage(91.0f);
            cache.setResourceManagerCreation(rmc);
            this.testXml(cache);
            c = this.getCache();
            CacheXml75Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionOffHeapPercentage()));
            CacheXml75Test.assertEquals((Object)Float.valueOf(91.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalOffHeapPercentage()));
            CacheXml75Test.closeCache();
            rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(95.0f);
            rmc.setCriticalOffHeapPercentage(90.0f);
            cache.setResourceManagerCreation(rmc);
            try {
                this.testXml(cache);
                CacheXml75Test.assertTrue((boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                CacheXml75Test.closeCache();
            }
            rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(0.0f);
            rmc.setCriticalOffHeapPercentage(90.0f);
            cache.setResourceManagerCreation(rmc);
            this.testXml(cache);
            c = this.getCache();
            CacheXml75Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionOffHeapPercentage()));
            CacheXml75Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalOffHeapPercentage()));
            CacheXml75Test.closeCache();
            rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(90.0f);
            rmc.setCriticalOffHeapPercentage(0.0f);
            cache.setResourceManagerCreation(rmc);
            this.testXml(cache);
            c = this.getCache();
            CacheXml75Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionOffHeapPercentage()));
            CacheXml75Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalOffHeapPercentage()));
            CacheXml75Test.closeCache();
            rmc = new ResourceManagerCreation();
            rmc.setEvictionOffHeapPercentage(0.0f);
            rmc.setCriticalOffHeapPercentage(0.0f);
            cache.setResourceManagerCreation(rmc);
            this.testXml(cache);
            c = this.getCache();
            CacheXml75Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionOffHeapPercentage()));
            CacheXml75Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalOffHeapPercentage()));
        }
        finally {
            System.clearProperty("gemfire.off-heap-memory-size");
        }
    }

    @Override
    protected String getGemFireVersion() {
        return "7_5";
    }

    public void testCompressor() {
        String regionName = "testCompressor";
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setCompressor((Compressor)SnappyCompressor.getDefaultInstance());
        cache.createRegion("testCompressor", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml75Test.assertNotNull((Object)c);
        Region regionAfter = c.getRegion("testCompressor");
        CacheXml75Test.assertNotNull((Object)regionAfter);
        CacheXml75Test.assertTrue((boolean)SnappyCompressor.getDefaultInstance().equals((Object)regionAfter.getAttributes().getCompressor()));
        regionAfter.localDestroyRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnableOffHeapMemory() {
        try {
            System.setProperty("gemfire.off-heap-memory-size", "1m");
            String regionName = "testEnableOffHeapMemory";
            CacheCreation cache = new CacheCreation();
            RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
            attrs.setEnableOffHeapMemory(true);
            CacheXml75Test.assertEquals((boolean)true, (boolean)attrs.getEnableOffHeapMemory());
            Region regionBefore = cache.createRegion("testEnableOffHeapMemory", (RegionAttributes)attrs);
            CacheXml75Test.assertNotNull((Object)regionBefore);
            CacheXml75Test.assertEquals((boolean)true, (boolean)regionBefore.getAttributes().getEnableOffHeapMemory());
            this.testXml(cache);
            Cache c = this.getCache();
            CacheXml75Test.assertNotNull((Object)c);
            Region regionAfter = c.getRegion("testEnableOffHeapMemory");
            CacheXml75Test.assertNotNull((Object)regionAfter);
            CacheXml75Test.assertEquals((boolean)true, (boolean)regionAfter.getAttributes().getEnableOffHeapMemory());
            CacheXml75Test.assertEquals((boolean)true, (boolean)((LocalRegion)regionAfter).getEnableOffHeapMemory());
            regionAfter.localDestroyRegion();
        }
        finally {
            System.clearProperty("gemfire.off-heap-memory-size");
        }
    }

    public void testEnableOffHeapMemoryRootRegionWithoutOffHeapMemoryThrowsException() {
        String regionName = this.getUniqueName();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEnableOffHeapMemory(true);
        CacheXml75Test.assertEquals((boolean)true, (boolean)attrs.getEnableOffHeapMemory());
        Region regionBefore = cache.createRegion(regionName, (RegionAttributes)attrs);
        CacheXml75Test.assertNotNull((Object)regionBefore);
        CacheXml75Test.assertEquals((boolean)true, (boolean)regionBefore.getAttributes().getEnableOffHeapMemory());
        try {
            this.testXml(cache);
        }
        catch (IllegalStateException e) {
            String msg = "The region /" + regionName + " was configured to use off heap memory but no off heap memory was configured.";
            CacheXml75Test.assertEquals((String)msg, (String)e.getMessage());
        }
    }

    public void testEnableOffHeapMemorySubRegionWithoutOffHeapMemoryThrowsException() {
        String rootRegionName = this.getUniqueName();
        String subRegionName = "subRegion";
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation rootRegionAttrs = new RegionAttributesCreation(cache);
        CacheXml75Test.assertEquals((boolean)false, (boolean)rootRegionAttrs.getEnableOffHeapMemory());
        Region rootRegionBefore = cache.createRegion(rootRegionName, (RegionAttributes)rootRegionAttrs);
        CacheXml75Test.assertNotNull((Object)rootRegionBefore);
        CacheXml75Test.assertEquals((boolean)false, (boolean)rootRegionBefore.getAttributes().getEnableOffHeapMemory());
        RegionAttributesCreation subRegionAttrs = new RegionAttributesCreation(cache);
        subRegionAttrs.setEnableOffHeapMemory(true);
        CacheXml75Test.assertEquals((boolean)true, (boolean)subRegionAttrs.getEnableOffHeapMemory());
        Region subRegionBefore = rootRegionBefore.createSubregion("subRegion", (RegionAttributes)subRegionAttrs);
        CacheXml75Test.assertNotNull((Object)subRegionBefore);
        CacheXml75Test.assertEquals((boolean)true, (boolean)subRegionBefore.getAttributes().getEnableOffHeapMemory());
        try {
            this.testXml(cache);
        }
        catch (IllegalStateException e) {
            String msg = "The region /" + rootRegionName + "/" + "subRegion" + " was configured to use off heap memory but no off heap memory was configured.";
            CacheXml75Test.assertEquals((String)msg, (String)e.getMessage());
        }
    }

    public void testCacheServerDisableTcpNoDelay() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer cs = cache.addCacheServer();
        cs.setTcpNoDelay(false);
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testCacheServerEnableTcpNoDelay() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer cs = cache.addCacheServer();
        cs.setTcpNoDelay(true);
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
    }
}

