/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayConflictHelper;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.TimestampedEntryEvent;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.cache30.CacheXml66Test;
import com.gemstone.gemfire.cache30.MyGatewayEventFilter1;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter1;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter2;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.AsyncEventQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ParallelGatewaySenderCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.SerialGatewaySenderCreation;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CacheXml70Test
extends CacheXml66Test {
    private static final long serialVersionUID = 225193925777688541L;

    public CacheXml70Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "7_0";
    }

    public void testConcurrencyChecksEnabled() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.REPLICATE);
        attrs.setConcurrencyChecksEnabled(true);
        cache.createRegion("replicated", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.PARTITION);
        attrs.setConcurrencyChecksEnabled(true);
        cache.createRegion("partitioned", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.EMPTY);
        attrs.setConcurrencyChecksEnabled(true);
        cache.createRegion("empty", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setConcurrencyChecksEnabled(true);
        cache.createRegion("normal", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Region region = c.getRegion("replicated");
        CacheXml70Test.assertNotNull((Object)region);
        CacheXml70Test.assertTrue((String)"expected concurrency checks to be enabled", (boolean)region.getAttributes().getConcurrencyChecksEnabled());
        region.localDestroyRegion();
        region = c.getRegion("partitioned");
        CacheXml70Test.assertNotNull((Object)region);
        CacheXml70Test.assertTrue((String)"expected concurrency checks to be enabled", (boolean)region.getAttributes().getConcurrencyChecksEnabled());
        region.localDestroyRegion();
        region = c.getRegion("empty");
        CacheXml70Test.assertNotNull((Object)region);
        CacheXml70Test.assertTrue((String)"expected concurrency checks to be enabled", (boolean)region.getAttributes().getConcurrencyChecksEnabled());
        region.localDestroyRegion();
        region = c.getRegion("normal");
        CacheXml70Test.assertNotNull((Object)region);
        CacheXml70Test.assertTrue((String)"expected concurrency checks to be enabled", (boolean)region.getAttributes().getConcurrencyChecksEnabled());
        region.localDestroyRegion();
    }

    public void testSerialGatewaySender() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        GatewaySenderFactory gatewaySenderFactory = cache.createGatewaySenderFactory();
        gatewaySenderFactory.setParallel(false);
        gatewaySenderFactory.setManualStart(true);
        gatewaySenderFactory.setSocketBufferSize(124);
        gatewaySenderFactory.setSocketReadTimeout(1000);
        gatewaySenderFactory.setBatchConflationEnabled(false);
        gatewaySenderFactory.setBatchSize(100);
        gatewaySenderFactory.setBatchTimeInterval(10);
        gatewaySenderFactory.setPersistenceEnabled(true);
        gatewaySenderFactory.setDiskStoreName("LNSender");
        gatewaySenderFactory.setDiskSynchronous(true);
        gatewaySenderFactory.setMaximumQueueMemory(200);
        gatewaySenderFactory.setAlertThreshold(30);
        MyGatewayEventFilter1 myeventfilter1 = new MyGatewayEventFilter1();
        gatewaySenderFactory.addGatewayEventFilter((GatewayEventFilter)myeventfilter1);
        MyGatewayTransportFilter1 myStreamfilter1 = new MyGatewayTransportFilter1();
        gatewaySenderFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter1);
        MyGatewayTransportFilter2 myStreamfilter2 = new MyGatewayTransportFilter2();
        gatewaySenderFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter2);
        GatewaySender serialGatewaySender = gatewaySenderFactory.create("LN", 2);
        RegionAttributesCreation attrs = new RegionAttributesCreation();
        attrs.addGatewaySenderId(serialGatewaySender.getId());
        cache.createRegion("UserRegion", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Set sendersOnCache = c.getGatewaySenders();
        for (GatewaySender sender : sendersOnCache) {
            CacheXml70Test.assertEquals((boolean)false, (boolean)sender.isParallel());
            this.validateGatewaySender(serialGatewaySender, sender);
        }
    }

    public void testAsyncEventQueue() {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        String id = "WBCLChannel";
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(100);
        factory.setBatchTimeInterval(500);
        factory.setBatchConflationEnabled(true);
        factory.setMaximumQueueMemory(200);
        factory.setPersistent(true);
        factory.setDiskStoreName("WBCLStore");
        factory.setDiskSynchronous(true);
        factory.setParallel(true);
        MyAsyncEventListener eventListener = new MyAsyncEventListener();
        AsyncEventQueue asyncEventQueue = factory.create(id, (AsyncEventListener)eventListener);
        RegionAttributesCreation attrs = new RegionAttributesCreation();
        attrs.addAsyncEventQueueId(asyncEventQueue.getId());
        cache.createRegion("UserRegion", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Set asyncEventQueuesOnCache = c.getAsyncEventQueues();
        CacheXml70Test.assertTrue((String)"Size of asyncEventQueues should be greater than 0", (asyncEventQueuesOnCache.size() > 0 ? 1 : 0) != 0);
        for (AsyncEventQueue asyncEventQueueOnCache : asyncEventQueuesOnCache) {
            this.validateAsyncEventQueue(asyncEventQueue, asyncEventQueueOnCache);
        }
    }

    public void testConcurrentAsyncEventQueue() {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        String id = "WBCLChannel";
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(100);
        factory.setBatchTimeInterval(500);
        factory.setBatchConflationEnabled(true);
        factory.setMaximumQueueMemory(200);
        factory.setPersistent(true);
        factory.setDiskStoreName("WBCLStore");
        factory.setDiskSynchronous(true);
        factory.setDispatcherThreads(5);
        factory.setOrderPolicy(Gateway.OrderPolicy.THREAD);
        MyAsyncEventListener eventListener = new MyAsyncEventListener();
        AsyncEventQueue asyncEventQueue = factory.create(id, (AsyncEventListener)eventListener);
        RegionAttributesCreation attrs = new RegionAttributesCreation();
        attrs.addAsyncEventQueueId(asyncEventQueue.getId());
        cache.createRegion("UserRegion", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Set asyncEventQueuesOnCache = c.getAsyncEventQueues();
        CacheXml70Test.assertTrue((String)"Size of asyncEventQueues should be greater than 0", (asyncEventQueuesOnCache.size() > 0 ? 1 : 0) != 0);
        for (AsyncEventQueue asyncEventQueueOnCache : asyncEventQueuesOnCache) {
            this.validateConcurrentAsyncEventQueue(asyncEventQueue, asyncEventQueueOnCache);
        }
    }

    public void testParallelGatewaySender() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        GatewaySenderFactory gatewaySenderFactory = cache.createGatewaySenderFactory();
        gatewaySenderFactory.setParallel(true);
        gatewaySenderFactory.setManualStart(true);
        gatewaySenderFactory.setSocketBufferSize(1234);
        gatewaySenderFactory.setSocketReadTimeout(1050);
        gatewaySenderFactory.setBatchConflationEnabled(false);
        gatewaySenderFactory.setBatchSize(88);
        gatewaySenderFactory.setBatchTimeInterval(9);
        gatewaySenderFactory.setPersistenceEnabled(true);
        gatewaySenderFactory.setDiskStoreName("LNSender");
        gatewaySenderFactory.setDiskSynchronous(true);
        gatewaySenderFactory.setMaximumQueueMemory(211);
        gatewaySenderFactory.setAlertThreshold(35);
        MyGatewayEventFilter1 myeventfilter1 = new MyGatewayEventFilter1();
        gatewaySenderFactory.addGatewayEventFilter((GatewayEventFilter)myeventfilter1);
        MyGatewayTransportFilter1 myStreamfilter1 = new MyGatewayTransportFilter1();
        gatewaySenderFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter1);
        MyGatewayTransportFilter2 myStreamfilter2 = new MyGatewayTransportFilter2();
        gatewaySenderFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter2);
        GatewaySender parallelGatewaySender = gatewaySenderFactory.create("LN", 2);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Set sendersOnCache = c.getGatewaySenders();
        for (GatewaySender sender : sendersOnCache) {
            CacheXml70Test.assertEquals((boolean)true, (boolean)sender.isParallel());
            this.validateGatewaySender(parallelGatewaySender, sender);
        }
    }

    public void testGatewayReceiver() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        GatewayReceiverFactory gatewayReceiverFactory = cache.createGatewayReceiverFactory();
        gatewayReceiverFactory.setBindAddress("");
        gatewayReceiverFactory.setStartPort(54321);
        gatewayReceiverFactory.setEndPort(54331);
        gatewayReceiverFactory.setMaximumTimeBetweenPings(2000);
        gatewayReceiverFactory.setSocketBufferSize(1500);
        MyGatewayTransportFilter1 myStreamfilter1 = new MyGatewayTransportFilter1();
        gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter1);
        MyGatewayTransportFilter2 myStreamfilter2 = new MyGatewayTransportFilter2();
        gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)myStreamfilter2);
        GatewayReceiver receiver1 = gatewayReceiverFactory.create();
        try {
            receiver1.start();
        }
        catch (IOException e) {
            CacheXml70Test.fail((String)"Could not start GatewayReceiver");
        }
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Set receivers = c.getGatewayReceivers();
        for (GatewayReceiver receiver : receivers) {
            this.validateGatewayReceiver(receiver1, receiver);
        }
    }

    public void testGatewayConflictResolver() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setGatewayConflictResolver((GatewayConflictResolver)new ConflictResolver());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        GatewayConflictResolver resolver = c.getGatewayConflictResolver();
        CacheXml70Test.assertNotNull((Object)resolver);
        CacheXml70Test.assertTrue((boolean)(resolver instanceof ConflictResolver));
        CacheXml70Test.assertTrue((boolean)((ConflictResolver)resolver).initialized);
        c.close();
    }

    private void validateGatewaySender(GatewaySender sender1, GatewaySender gatewaySender) {
        CacheXml70Test.assertEquals((String)sender1.getId(), (String)gatewaySender.getId());
        CacheXml70Test.assertEquals((int)sender1.getRemoteDSId(), (int)gatewaySender.getRemoteDSId());
        CacheXml70Test.assertEquals((boolean)sender1.isParallel(), (boolean)gatewaySender.isParallel());
        CacheXml70Test.assertEquals((boolean)sender1.isBatchConflationEnabled(), (boolean)gatewaySender.isBatchConflationEnabled());
        CacheXml70Test.assertEquals((int)sender1.getBatchSize(), (int)gatewaySender.getBatchSize());
        CacheXml70Test.assertEquals((int)sender1.getBatchTimeInterval(), (int)gatewaySender.getBatchTimeInterval());
        CacheXml70Test.assertEquals((boolean)sender1.isPersistenceEnabled(), (boolean)gatewaySender.isPersistenceEnabled());
        CacheXml70Test.assertEquals((String)sender1.getDiskStoreName(), (String)gatewaySender.getDiskStoreName());
        CacheXml70Test.assertEquals((boolean)sender1.isDiskSynchronous(), (boolean)gatewaySender.isDiskSynchronous());
        CacheXml70Test.assertEquals((int)sender1.getMaximumQueueMemory(), (int)gatewaySender.getMaximumQueueMemory());
        CacheXml70Test.assertEquals((int)sender1.getAlertThreshold(), (int)gatewaySender.getAlertThreshold());
        CacheXml70Test.assertEquals((int)sender1.getGatewayEventFilters().size(), (int)gatewaySender.getGatewayEventFilters().size());
        CacheXml70Test.assertEquals((int)sender1.getGatewayTransportFilters().size(), (int)gatewaySender.getGatewayTransportFilters().size());
        boolean isParallel = sender1.isParallel();
        if (isParallel) {
            CacheXml70Test.assertTrue((String)"sender should be instanceof Creation", (boolean)(sender1 instanceof ParallelGatewaySenderCreation));
            CacheXml70Test.assertTrue((String)"sender should be instanceof Impl", (boolean)(gatewaySender instanceof ParallelGatewaySenderImpl));
        } else {
            CacheXml70Test.assertTrue((String)"sender should be instanceof Creation", (boolean)(sender1 instanceof SerialGatewaySenderCreation));
            CacheXml70Test.assertTrue((String)"sender should be instanceof Impl", (boolean)(gatewaySender instanceof SerialGatewaySenderImpl));
        }
    }

    private void validateGatewayReceiver(GatewayReceiver receiver1, GatewayReceiver gatewayReceiver) {
        CacheXml70Test.assertEquals((String)receiver1.getHost(), (String)gatewayReceiver.getHost());
        CacheXml70Test.assertEquals((int)receiver1.getStartPort(), (int)gatewayReceiver.getStartPort());
        CacheXml70Test.assertEquals((int)receiver1.getEndPort(), (int)gatewayReceiver.getEndPort());
        CacheXml70Test.assertEquals((int)receiver1.getMaximumTimeBetweenPings(), (int)gatewayReceiver.getMaximumTimeBetweenPings());
        CacheXml70Test.assertEquals((int)receiver1.getSocketBufferSize(), (int)gatewayReceiver.getSocketBufferSize());
        CacheXml70Test.assertEquals((int)receiver1.getGatewayTransportFilters().size(), (int)gatewayReceiver.getGatewayTransportFilters().size());
    }

    private void validateAsyncEventQueue(AsyncEventQueue eventChannelFromXml, AsyncEventQueue channel) {
        CacheXml70Test.assertEquals((String)"AsyncEventQueue id doesn't match", (String)eventChannelFromXml.getId(), (String)channel.getId());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchSize doesn't match", (int)eventChannelFromXml.getBatchSize(), (int)channel.getBatchSize());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchTimeInterval doesn't match", (int)eventChannelFromXml.getBatchTimeInterval(), (int)channel.getBatchTimeInterval());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchConflationEnabled doesn't match", (boolean)eventChannelFromXml.isBatchConflationEnabled(), (boolean)channel.isBatchConflationEnabled());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue persistent doesn't match", (boolean)eventChannelFromXml.isPersistent(), (boolean)channel.isPersistent());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue diskStoreName doesn't match", (String)eventChannelFromXml.getDiskStoreName(), (String)channel.getDiskStoreName());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue isDiskSynchronous doesn't match", (boolean)eventChannelFromXml.isDiskSynchronous(), (boolean)channel.isDiskSynchronous());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue maximumQueueMemory doesn't match", (int)eventChannelFromXml.getMaximumQueueMemory(), (int)channel.getMaximumQueueMemory());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue Parallel doesn't match", (boolean)eventChannelFromXml.isParallel(), (boolean)channel.isParallel());
        CacheXml70Test.assertTrue((String)"AsyncEventQueue should be instanceof Creation", (boolean)(eventChannelFromXml instanceof AsyncEventQueueCreation));
        CacheXml70Test.assertTrue((String)"AsyncEventQueue should be instanceof Impl", (boolean)(channel instanceof AsyncEventQueueImpl));
    }

    private void validateConcurrentAsyncEventQueue(AsyncEventQueue eventChannelFromXml, AsyncEventQueue channel) {
        CacheXml70Test.assertEquals((String)"AsyncEventQueue id doesn't match", (String)eventChannelFromXml.getId(), (String)channel.getId());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchSize doesn't match", (int)eventChannelFromXml.getBatchSize(), (int)channel.getBatchSize());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchTimeInterval doesn't match", (int)eventChannelFromXml.getBatchTimeInterval(), (int)channel.getBatchTimeInterval());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue batchConflationEnabled doesn't match", (boolean)eventChannelFromXml.isBatchConflationEnabled(), (boolean)channel.isBatchConflationEnabled());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue persistent doesn't match", (boolean)eventChannelFromXml.isPersistent(), (boolean)channel.isPersistent());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue diskStoreName doesn't match", (String)eventChannelFromXml.getDiskStoreName(), (String)channel.getDiskStoreName());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue isDiskSynchronous doesn't match", (boolean)eventChannelFromXml.isDiskSynchronous(), (boolean)channel.isDiskSynchronous());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue maximumQueueMemory doesn't match", (int)eventChannelFromXml.getMaximumQueueMemory(), (int)channel.getMaximumQueueMemory());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue Parallel doesn't match", (boolean)eventChannelFromXml.isParallel(), (boolean)channel.isParallel());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue dispatcherThreads doesn't match", (int)eventChannelFromXml.getDispatcherThreads(), (int)channel.getDispatcherThreads());
        CacheXml70Test.assertEquals((String)"AsyncEventQueue orderPolicy doesn't match", (Object)eventChannelFromXml.getOrderPolicy(), (Object)channel.getOrderPolicy());
        CacheXml70Test.assertTrue((String)"AsyncEventQueue should be instanceof Creation", (boolean)(eventChannelFromXml instanceof AsyncEventQueueCreation));
        CacheXml70Test.assertTrue((String)"AsyncEventQueue should be instanceof Impl", (boolean)(channel instanceof AsyncEventQueueImpl));
    }

    public void testPartitionedRegionAttributesForCoLocation3() {
        CacheXml70Test.closeCache();
        this.setXmlFile(this.findFile("coLocation3.xml"));
        Cache c = this.getCache();
        CacheXml70Test.assertNotNull((Object)c);
        Region cust = c.getRegion("/Customer");
        CacheXml70Test.assertNotNull((Object)cust);
        Region order = c.getRegion("/Order");
        CacheXml70Test.assertNotNull((Object)order);
        CacheXml70Test.assertTrue((cust.getAttributes().getPartitionAttributes().getColocatedWith() == null ? 1 : 0) != 0);
        CacheXml70Test.assertTrue((boolean)order.getAttributes().getPartitionAttributes().getColocatedWith().equals("Customer"));
    }

    public static class ConflictResolver
    implements GatewayConflictResolver,
    Declarable {
        public boolean initialized;

        public void init(Properties props) {
            this.initialized = true;
        }

        public void onEvent(TimestampedEntryEvent event, GatewayConflictHelper helper) {
        }
    }

    public static class MyAsyncEventListener
    implements AsyncEventListener<Object, Object>,
    Declarable {
        public boolean processEvents(List<AsyncEvent<Object, Object>> events) {
            return true;
        }

        public void close() {
        }

        public void init(Properties properties) {
        }
    }
}

