/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class CacheRegionsReliablityStatsCheckTest
extends CacheTestCase {
    public CacheRegionsReliablityStatsCheckTest(String name) {
        super(name);
    }

    public void testRegionsReliablityStats() throws Exception, RegionExistsException {
        String rr1 = "roleA";
        String regionNoAccess = "regionNoAccess";
        String regionLimitedAccess = "regionLimitedAccess";
        String regionFullAccess = "regionFullAccess";
        String[] requiredRoles = new String[]{"roleA"};
        Cache myCache = this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.create();
        myCache.createRegion("regionNoAccess", attr);
        ra = new MembershipAttributes(requiredRoles, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.create();
        myCache.createRegion("regionLimitedAccess", attr);
        ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.create();
        myCache.createRegion("regionFullAccess", attr);
        CachePerfStats stats = ((GemFireCacheImpl)myCache).getCachePerfStats();
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingNoAccess(), (int)1);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingLimitedAccess(), (int)1);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingFullAccess(), (int)1);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissing(), (int)(stats.getReliableRegionsMissingNoAccess() + stats.getReliableRegionsMissingLimitedAccess() + stats.getReliableRegionsMissingFullAccess()));
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable roleAPlayer = new CacheSerializableRunnable("ROLEAPLAYER"){

            @Override
            public void run2() throws CacheException {
                Properties props = new Properties();
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                props.setProperty("roles", "roleA");
                CacheRegionsReliablityStatsCheckTest.this.getSystem(props);
                Cache cache = CacheRegionsReliablityStatsCheckTest.this.getCache();
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                cache.createRegion("regionNoAccess", attr);
                cache.createRegion("regionLimitedAccess", attr);
                cache.createRegion("regionFullAccess", attr);
            }
        };
        vm1.invoke(roleAPlayer);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingNoAccess(), (int)0);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingLimitedAccess(), (int)0);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissingFullAccess(), (int)0);
        CacheRegionsReliablityStatsCheckTest.assertEquals((int)stats.getReliableRegionsMissing(), (int)(stats.getReliableRegionsMissingNoAccess() + stats.getReliableRegionsMissingLimitedAccess() + stats.getReliableRegionsMissingFullAccess()));
    }
}

