/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.concurrent.AI;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class Bug38741DUnitTest
extends BridgeTestCase {
    private static final long serialVersionUID = 1L;

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        return factory.create();
    }

    public Bug38741DUnitTest(String name) {
        super(name);
    }

    public void testCopyOnReadWithBridgeServer() throws Exception {
        Host h = Host.getHost(0);
        VM client = h.getVM(2);
        VM server = h.getVM(3);
        final String rName = this.getUniqueName();
        final int[] ports = Bug38741DUnitTest.createUniquePorts(1);
        String k1 = "k1";
        String k2 = "k2";
        String k3 = "k3";
        this.createBridgeServer(server, rName, ports[0]);
        server.invoke(new CacheSerializableRunnable("Enable copy on read and assert server copy behavior"){

            @Override
            public void run2() throws CacheException {
                LocalRegion r = (LocalRegion)Bug38741DUnitTest.this.getRootRegion(rName);
                SerializationCountingKey key = new SerializationCountingKey("k1");
                byte[] val = new byte[1];
                byte valIsObj = 1;
                Integer cb = new Integer(0);
                ClientProxyMembershipID cpmi = null;
                EventID eid = null;
                ClientUpdateMessageImpl cui = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_CREATE, r, (Object)key, (Object)val, valIsObj, (Object)cb, cpmi, eid, DistributedTestCase.getLogWriter().convertToLogWriterI18n());
                ClientUpdateMessageImpl cuiCopy = (ClientUpdateMessageImpl)CopyHelper.copy((Object)cui);
                TestCase.assertSame((Object)key, (Object)cui.getKeyOfInterest());
                TestCase.assertEquals((int)1, (int)key.count.get());
                key = (SerializationCountingKey)cuiCopy.getKeyOfInterest();
                TestCase.assertEquals((Object)cui.getKeyOfInterest(), (Object)cuiCopy.getKeyOfInterest());
                TestCase.assertEquals((int)1, (int)key.count.get());
                SerializationCountingKey ks1 = new SerializationCountingKey("k1");
                SerializationCountingValue sc = new SerializationCountingValue();
                r.put((Object)ks1, (Object)sc);
                TestCase.assertEquals((int)0, (int)sc.count.get());
                TestCase.assertEquals((int)0, (int)ks1.count.get());
                sc = (SerializationCountingValue)r.get((Object)ks1);
                TestCase.assertEquals((int)0, (int)sc.count.get());
                TestCase.assertEquals((int)0, (int)ks1.count.get());
                Bug38741DUnitTest.this.getCache().setCopyOnRead(true);
                sc = (SerializationCountingValue)r.get((Object)ks1);
                TestCase.assertEquals((int)1, (int)sc.count.get());
                TestCase.assertEquals((int)0, (int)ks1.count.get());
                sc = new SerializationCountingValue();
                SerializationCountingKey ks3 = new SerializationCountingKey("k3");
                r.put((Object)ks3, (Object)sc);
                TestCase.assertEquals((int)0, (int)sc.count.get());
                TestCase.assertEquals((int)0, (int)ks3.count.get());
            }
        });
        final String serverHostName = Bug38741DUnitTest.getServerHostName(server.getHost());
        client.invoke(new CacheSerializableRunnable("Assert server copy behavior from client"){

            @Override
            public void run2() throws CacheException {
                Bug38741DUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                BridgeTestCase.configureConnectionPool(factory, serverHostName, ports, true, -1, 1, null);
                factory.setScope(Scope.LOCAL);
                Region r = Bug38741DUnitTest.this.createRootRegion(rName, factory.create());
                SerializationCountingKey ks1 = new SerializationCountingKey("k1");
                SerializationCountingKey ks3 = new SerializationCountingKey("k3");
                r.registerInterest((Object)ks1, InterestResultPolicy.KEYS_VALUES);
                r.registerInterest((Object)new SerializationCountingKey("k2"), InterestResultPolicy.KEYS_VALUES);
                r.registerInterest((Object)ks3, InterestResultPolicy.KEYS_VALUES);
                SerializationCountingValue sc = (SerializationCountingValue)r.get((Object)ks1);
                TestCase.assertEquals((int)2, (int)sc.count.get());
                sc = (SerializationCountingValue)r.get((Object)ks3);
                TestCase.assertEquals((int)1, (int)sc.count.get());
            }
        });
        server.invoke(new CacheSerializableRunnable("Assert copy behavior after client is setup"){

            @Override
            public void run2() throws CacheException {
                Region r = Bug38741DUnitTest.this.getRootRegion(rName);
                BridgeServerImpl bsi = (BridgeServerImpl)Bug38741DUnitTest.this.getCache().getBridgeServers().iterator().next();
                Collection cp = bsi.getAcceptor().getCacheClientNotifier().getClientProxies();
                TestCase.assertEquals((int)1, (int)cp.size());
                final CacheClientProxy ccp = (CacheClientProxy)cp.iterator().next();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ccp.getHARegionQueue().size() == 0;
                    }

                    @Override
                    public String description() {
                        return "region queue never became empty";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                final int currMesgCount = ccp.getStatistics().getMessagesProcessed();
                SerializationCountingKey ks2 = new SerializationCountingKey("k2");
                SerializationCountingValue sc = new SerializationCountingValue();
                r.put((Object)ks2, (Object)sc);
                ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ccp.getStatistics().getMessagesProcessed() != currMesgCount;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                TestCase.assertEquals((int)1, (int)sc.count.get());
                TestCase.assertEquals((int)1, (int)ks2.count.get());
            }
        });
        client.invoke(new CacheSerializableRunnable("Assert copy behavior from client after update"){

            @Override
            public void run2() throws CacheException {
                Region r = Bug38741DUnitTest.this.getRootRegion(rName);
                SerializationCountingKey ks2 = new SerializationCountingKey("k2");
                long start = NanoTimer.getTime();
                int maxSecs = 30;
                while (!r.containsKey((Object)ks2)) {
                    DistributedTestCase.pause(100);
                    if (NanoTimer.getTime() - start <= TimeUnit.SECONDS.toNanos(30L)) continue;
                    TestCase.fail((String)"Waited over 30s");
                }
                SerializationCountingValue sc = (SerializationCountingValue)r.getEntry((Object)ks2).getValue();
                TestCase.assertEquals((int)1, (int)sc.count.get());
            }
        });
    }

    public void testPartitionedRegionAndCopyOnRead() throws Exception {
        Host h = Host.getHost(0);
        VM accessor = h.getVM(2);
        VM datastore = h.getVM(3);
        final String rName = this.getUniqueName();
        String k1 = "k1";
        datastore.invoke(new CacheSerializableRunnable("Create PR DataStore"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).create());
                Bug38741DUnitTest.this.createRootRegion(rName, factory.create());
            }
        });
        accessor.invoke(new CacheSerializableRunnable("Create PR Accessor and put new value"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).setRedundantCopies(0).create());
                Region r = Bug38741DUnitTest.this.createRootRegion(rName, factory.create());
                SerializationCountingValue val = new SerializationCountingValue();
                r.put((Object)"k1", (Object)val);
                TestCase.assertEquals((int)2, (int)val.count.get());
                val = new SerializationCountingValue();
                r.put((Object)"k1", (Object)val);
                TestCase.assertEquals((int)1, (int)val.count.get());
            }
        });
        datastore.invoke(new CacheSerializableRunnable("assert datastore entry serialization count"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)Bug38741DUnitTest.this.getRootRegion(rName);
                pr.getDataStore().visitBuckets(new PartitionedRegionDataStore.BucketVisitor(){

                    public void visit(Integer bucketId, Region r) {
                        BucketRegion br = (BucketRegion)r;
                        try {
                            BucketRegion.RawValue rv = br.getSerialized((Object)"k1", null, null, false, false, null, null, false, false);
                            Object val = rv.getRawValue();
                            if (CachedDeserializableFactory.preferObject()) {
                                SerializationCountingValue scv = (SerializationCountingValue)val;
                                TestCase.assertEquals((int)2, (int)scv.count.get());
                            } else {
                                TestCase.assertTrue((boolean)(val instanceof CachedDeserializable));
                                CachedDeserializable cd = (CachedDeserializable)val;
                                SerializationCountingValue scv = (SerializationCountingValue)cd.getDeserializedForReading();
                                TestCase.assertEquals((int)1, (int)scv.count.get());
                            }
                        }
                        catch (IOException fail) {
                            DistributedTestCase.fail("Unexpected IOException", fail);
                        }
                    }
                });
            }
        });
        accessor.invoke(new CacheSerializableRunnable("assert accessor entry serialization count"){

            @Override
            public void run2() throws CacheException {
                Region r = Bug38741DUnitTest.this.getRootRegion(rName);
                SerializationCountingValue v1 = (SerializationCountingValue)r.get((Object)"k1");
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)3, (int)v1.count.get());
                    Bug38741DUnitTest.this.getCache().setCopyOnRead(true);
                    v1 = (SerializationCountingValue)r.get((Object)"k1");
                    TestCase.assertEquals((int)4, (int)v1.count.get());
                } else {
                    TestCase.assertEquals((int)1, (int)v1.count.get());
                    Bug38741DUnitTest.this.getCache().setCopyOnRead(true);
                    SerializationCountingValue v2 = (SerializationCountingValue)r.get((Object)"k1");
                    TestCase.assertEquals((int)1, (int)v2.count.get());
                    TestCase.assertTrue((v1 != v2 ? 1 : 0) != 0);
                }
            }
        });
        datastore.invoke(new CacheSerializableRunnable("assert value serialization"){

            @Override
            public void run2() throws CacheException {
                Region r = Bug38741DUnitTest.this.getRootRegion(rName);
                SerializationCountingValue v1 = (SerializationCountingValue)r.get((Object)"k1");
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)4, (int)v1.count.get());
                    Bug38741DUnitTest.this.getCache().setCopyOnRead(true);
                    v1 = (SerializationCountingValue)r.get((Object)"k1");
                    TestCase.assertEquals((int)5, (int)v1.count.get());
                } else {
                    TestCase.assertEquals((int)1, (int)v1.count.get());
                    Bug38741DUnitTest.this.getCache().setCopyOnRead(true);
                    SerializationCountingValue v2 = (SerializationCountingValue)r.get((Object)"k1");
                    TestCase.assertEquals((int)2, (int)v2.count.get());
                    TestCase.assertTrue((v1 != v2 ? 1 : 0) != 0);
                }
            }
        });
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = new Properties();
        props.setProperty("delta-propagation", "false");
        return props;
    }

    public static class SerializationCountingKey
    extends SerializationCountingValue {
        private static final long serialVersionUID = 1L;
        private String k;

        public SerializationCountingKey(String k) {
            this.k = k;
        }

        public SerializationCountingKey() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.k = DataSerializer.readString((DataInput)in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.k, (DataOutput)out);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SerializationCountingKey) {
                SerializationCountingKey other = (SerializationCountingKey)obj;
                return this.k.equals(other.k);
            }
            return false;
        }

        public int hashCode() {
            return this.k.hashCode();
        }

        @Override
        public String toString() {
            return super.toString() + "; k=" + this.k;
        }
    }

    public static class SerializationCountingValue
    implements DataSerializable {
        private static final long serialVersionUID = 1L;
        public final AI count = CFactory.createAI();

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.count.set(in.readInt());
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.count.addAndGet(1));
        }

        public String toString() {
            return this.getClass().getName() + "@" + System.identityHashCode(this) + "; count=" + this.count;
        }
    }
}

