/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import dunit.Host;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Bug34948DUnitTest
extends CacheTestCase {
    protected static Object lastCallback = null;

    public Bug34948DUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void doCreateOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                Bug34948DUnitTest.this.getSystem();
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PRELOADED);
                CacheListenerAdapter cl = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterInvalidate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterDestroy(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }
                };
                af.setCacheListener((CacheListener)cl);
                Bug34948DUnitTest.this.createRootRegion("bug34948", af.create());
            }
        });
    }

    public void testBug34948() throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PRELOADED);
        Region r = this.createRootRegion("bug34948", factory.create());
        r.put((Object)"key1", (Object)new HomeBoy());
        this.doCreateOtherVm();
        r.put((Object)"key2", (Object)new HomeBoy());
        r.localDestroy((Object)"key1");
        r.localDestroy((Object)"key2");
        Object o = r.get((Object)"key1");
        Bug34948DUnitTest.assertTrue((boolean)(r.get((Object)"key1") instanceof HomeBoy));
        Bug34948DUnitTest.assertTrue((r.get((Object)"key2") == null ? 1 : 0) != 0);
    }

    public static class HomeBoy
    implements DataSerializable {
        public void toData(DataOutput out) throws IOException {
            InternalDistributedMember me = InternalDistributedSystem.getAnyInstance().getDistributedMember();
            DataSerializer.writeObject((Object)me, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            DistributedMember hb;
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            DistributedMember me = ds.getDistributedMember();
            if (me.equals(hb = (DistributedMember)DataSerializer.readObject((DataInput)in))) {
                ds.getLogWriter().info("HomeBoy was deserialized on his home");
            } else {
                String msg = "HomeBoy was deserialized on " + me + " instead of his home " + hb;
                if (CachedDeserializableFactory.preferObject()) {
                    ds.getLogWriter().info(msg);
                } else {
                    ds.getLogWriter().error(msg);
                    throw new IllegalStateException(msg);
                }
            }
        }
    }
}

