/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.SubscriptionNotEnabledException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class BridgeWriterDUnitTest
extends BridgeTestCase {
    protected static int bridgeServerPort;

    public BridgeWriterDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        BridgeWriterDUnitTest.disconnectAllFromDS();
    }

    public void testBug35381() throws Exception {
        Host host = Host.getHost(0);
        final String name = this.getUniqueName();
        int[] ports = new int[1];
        boolean whichVM = false;
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(new CacheSerializableRunnable("Create bridge server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testBug35381] Create BridgeServer");
                BridgeWriterDUnitTest.this.getSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region = BridgeWriterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)region);
                TestCase.assertNotNull((Object)BridgeWriterDUnitTest.this.getRootRegion().getSubregion(name));
                region.put((Object)"KEY-1", (Object)"VAL-1");
                try {
                    bridgeServerPort = BridgeWriterDUnitTest.this.startBridgeServer(0);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                    TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                }
                TestCase.assertTrue((bridgeServerPort != 0 ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("[testBug35381] port=" + bridgeServerPort);
                DistributedTestCase.getLogWriter().info("[testBug35381] serverMemberId=" + BridgeTestCase.getMemberId());
            }
        });
        ports[0] = vm.invokeInt(BridgeWriterDUnitTest.class, "getBridgeServerPort");
        BridgeWriterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        BridgeWriterDUnitTest.getLogWriter().info("[testBug35381] create bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        BridgeWriterDUnitTest.getLogWriter().info("[testBug35381] creating connection pool");
        boolean establishCallbackConnection = false;
        BridgeTestCase.configureConnectionPool(factory, BridgeWriterDUnitTest.getServerHostName(host), ports, establishCallbackConnection, -1, -1, null);
        Region region = this.createRegion(name, factory.create());
        BridgeWriterDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        try {
            region.registerInterest((Object)"KEY-1");
            BridgeWriterDUnitTest.fail((String)"registerInterest failed to throw BridgeWriterException with establishCallbackConnection set to false");
        }
        catch (SubscriptionNotEnabledException subscriptionNotEnabledException) {
            // empty catch block
        }
    }

    private static int getBridgeServerPort() {
        return bridgeServerPort;
    }

    public void _testRegisterInterestFailover() throws Exception {
        Host host = Host.getHost(0);
        String name = this.getUniqueName();
        final String regionName1 = name + "-1";
        final String regionName2 = name + "-2";
        final String regionName3 = name + "-3";
        final String key1 = "KEY-" + regionName1 + "-1";
        final String key2 = "KEY-" + regionName1 + "-2";
        final String key3 = "KEY-" + regionName1 + "-3";
        final int[] ports = new int[3];
        boolean firstServerIdx = false;
        VM firstServerVM = Host.getHost(0).getVM(0);
        firstServerVM.invoke(new CacheSerializableRunnable("Create first bridge server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] Create first bridge server");
                BridgeWriterDUnitTest.this.getSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region1 = BridgeWriterDUnitTest.this.createRootRegion(regionName1, factory.create());
                Region region2 = BridgeWriterDUnitTest.this.createRootRegion(regionName2, factory.create());
                Region region3 = BridgeWriterDUnitTest.this.createRootRegion(regionName3, factory.create());
                region1.put((Object)key1, (Object)"VAL-1");
                region2.put((Object)key2, (Object)"VAL-1");
                region3.put((Object)key3, (Object)"VAL-1");
                try {
                    bridgeServerPort = BridgeWriterDUnitTest.this.startBridgeServer(0);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                    TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                }
                TestCase.assertTrue((bridgeServerPort != 0 ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] firstServer port=" + bridgeServerPort);
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] firstServer memberId=" + BridgeTestCase.getMemberId());
            }
        });
        boolean secondServerIdx = true;
        VM secondServerVM = Host.getHost(0).getVM(1);
        secondServerVM.invoke(new CacheSerializableRunnable("Create second bridge server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] Create second bridge server");
                BridgeWriterDUnitTest.this.getSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region1 = BridgeWriterDUnitTest.this.createRootRegion(regionName1, factory.create());
                Region region3 = BridgeWriterDUnitTest.this.createRootRegion(regionName3, factory.create());
                region1.put((Object)key1, (Object)"VAL-2");
                region3.put((Object)key3, (Object)"VAL-2");
                try {
                    bridgeServerPort = BridgeWriterDUnitTest.this.startBridgeServer(0);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                    TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                }
                TestCase.assertTrue((bridgeServerPort != 0 ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] secondServer port=" + bridgeServerPort);
                DistributedTestCase.getLogWriter().info("[testRegisterInterestFailover] secondServer memberId=" + BridgeTestCase.getMemberId());
            }
        });
        ports[0] = firstServerVM.invokeInt(BridgeWriterDUnitTest.class, "getBridgeServerPort");
        BridgeWriterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        ports[1] = secondServerVM.invokeInt(BridgeWriterDUnitTest.class, "getBridgeServerPort");
        BridgeWriterDUnitTest.assertTrue((ports[1] != 0 ? 1 : 0) != 0);
        BridgeWriterDUnitTest.assertTrue((ports[0] != ports[1] ? 1 : 0) != 0);
        secondServerVM.invoke(new CacheSerializableRunnable("Stop second bridge server"){

            @Override
            public void run2() throws CacheException {
                BridgeWriterDUnitTest.this.stopBridgeServers(BridgeWriterDUnitTest.this.getCache());
            }
        });
        BridgeWriterDUnitTest.getLogWriter().info("[testBug35654] create bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        BridgeWriterDUnitTest.getLogWriter().info("[testRegisterInterestFailover] creating connection pool");
        boolean establishCallbackConnection = true;
        final PoolImpl p = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, BridgeWriterDUnitTest.getServerHostName(host), ports, establishCallbackConnection, -1, -1, null);
        final Region region1 = this.createRootRegion(regionName1, factory.create());
        final Region region2 = this.createRootRegion(regionName2, factory.create());
        final Region region3 = this.createRootRegion(regionName3, factory.create());
        BridgeWriterDUnitTest.assertTrue((boolean)region1.getInterestList().isEmpty());
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestList().isEmpty());
        BridgeWriterDUnitTest.assertTrue((boolean)region3.getInterestList().isEmpty());
        region1.registerInterest((Object)key1);
        region2.registerInterest((Object)key2);
        region3.registerInterest((Object)key3);
        BridgeWriterDUnitTest.assertTrue((boolean)region1.getInterestList().contains(key1));
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestList().contains(key2));
        BridgeWriterDUnitTest.assertTrue((boolean)region3.getInterestList().contains(key3));
        BridgeWriterDUnitTest.assertTrue((boolean)region1.getInterestListRegex().isEmpty());
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestListRegex().isEmpty());
        BridgeWriterDUnitTest.assertTrue((boolean)region3.getInterestListRegex().isEmpty());
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return p.getPrimaryPort() != -1;
            }

            @Override
            public String description() {
                return "primary port remained invalid";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        BridgeWriterDUnitTest.assertEquals((int)ports[0], (int)p.getPrimaryPort());
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1", (Object)region1.get((Object)key1));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1", (Object)region2.get((Object)key2));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1", (Object)region3.get((Object)key3));
        firstServerVM.invoke(new CacheSerializableRunnable("Puts from first bridge server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName1);
                region1.put((Object)key1, (Object)"VAL-1-1");
                Region region2 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName2);
                region2.put((Object)key2, (Object)"VAL-1-1");
                Region region3 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName3);
                region3.put((Object)key3, (Object)"VAL-1-1");
            }
        });
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return "VAL-1-1".equals(region1.get((Object)key1)) && "VAL-1-1".equals(region2.get((Object)key2)) && "VAL-1-1".equals(region3.get((Object)key3));
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1-1", (Object)region1.get((Object)key1));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1-1", (Object)region2.get((Object)key2));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-1-1", (Object)region3.get((Object)key3));
        secondServerVM.invoke(new CacheSerializableRunnable("Start second bridge server"){

            @Override
            public void run2() throws CacheException {
                try {
                    BridgeWriterDUnitTest.this.startBridgeServer(ports[1]);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                    TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                }
            }
        });
        firstServerVM.invoke(new CacheSerializableRunnable("Stop first bridge server"){

            @Override
            public void run2() throws CacheException {
                BridgeWriterDUnitTest.this.stopBridgeServers(BridgeWriterDUnitTest.this.getCache());
            }
        });
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ports[1] == p.getPrimaryPort();
            }

            @Override
            public String description() {
                return "primary port never became " + ports[1];
            }
        };
        DistributedTestCase.waitForCriterion(ev, 100000L, 200L, true);
        try {
            BridgeWriterDUnitTest.assertEquals(null, (Object)region2.get((Object)key2));
            BridgeWriterDUnitTest.fail((String)"CacheLoaderException expected");
        }
        catch (CacheLoaderException cacheLoaderException) {
            // empty catch block
        }
        secondServerVM.invoke(new CacheSerializableRunnable("Puts from second bridge server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeWriterDUnitTest.this.createRootRegion(regionName2, factory.create());
            }
        });
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestList().isEmpty());
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestListRegex().isEmpty());
        region2.put((Object)key2, (Object)"VAL-0");
        secondServerVM.invoke(new CacheSerializableRunnable("Put from second bridge server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName1);
                region1.put((Object)key1, (Object)"VAL-2-2");
                Region region2 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName2);
                region2.put((Object)key2, (Object)"VAL-2-1");
                Region region3 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName3);
                region3.put((Object)key3, (Object)"VAL-2-2");
            }
        });
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return "VAL-2-2".equals(region1.get((Object)key1)) && "VAL-2-2".equals(region3.get((Object)key3));
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 100000L, 200L, true);
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-2", (Object)region1.get((Object)key1));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-0", (Object)region2.get((Object)key2));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-2", (Object)region3.get((Object)key3));
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestList().isEmpty());
        region2.registerInterest((Object)key2);
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-1", (Object)region2.get((Object)key2));
        secondServerVM.invoke(new CacheSerializableRunnable("Put from second bridge server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName1);
                region1.put((Object)key1, (Object)"VAL-2-3");
                Region region2 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName2);
                region2.put((Object)key2, (Object)"VAL-2-2");
                Region region3 = BridgeWriterDUnitTest.this.getCache().getRegion(regionName3);
                region3.put((Object)key3, (Object)"VAL-2-3");
            }
        });
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return "VAL-2-3".equals(region1.get((Object)key1)) && "VAL-2-2".equals(region2.get((Object)key2)) && "VAL-2-3".equals(region3.get((Object)key3));
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 100000L, 200L, true);
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-3", (Object)region1.get((Object)key1));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-2", (Object)region2.get((Object)key2));
        BridgeWriterDUnitTest.assertEquals((Object)"VAL-2-3", (Object)region3.get((Object)key3));
        BridgeWriterDUnitTest.assertTrue((boolean)region2.getInterestList().contains(key2));
    }
}

