/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;

public class PRQueryPerfDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final int SLEEP = 0;
    int totalNumBuckets = 100;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 5000;

    public PRQueryPerfDUnitTest(String name) {
        super(name);
    }

    public void testNuthin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void norun_testBenchmarkingQueryingOneAccessorOneDS_Redundancy0() throws Exception {
        LogWriter log = PRQueryPerfDUnitTest.getLogWriter();
        log.info("BenchMarking PR Querying Test Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int redundancy = 0;
        try {
            this.setVMInfoLogLevel();
            log.info("Creating Accessor node on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", redundancy));
            log.info("Successfully Created Accessor node on VM0");
            log.info("Creating Datastores across  VM1");
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            log.info("Successfully Created Datastores on VM1");
            log.info("Creating Local Region on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
            log.info("Successfully Created Local Region on VM0");
            Object[] portfolio = this.PRQHelp.createPortfolioData(0, 5000);
            log.info("Inserting Portfolio data through the accessor node");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data through the accessor node");
            log.info("Inserting Portfolio data on local node  VM0 for result set comparison");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data on local node  VM0 for result set comparison");
            ResultsObject perfR = new ResultsObject();
            perfR.OperationDescription = "PR with 1 Accessor, 1 D.S., Redundancy =0,";
            perfR.NumberOfAccessors = 1;
            perfR.NumberOfDataStores = 1;
            perfR.redundancy = 0;
            log.info("Querying on VM0 both on PR Region & local, also comparing the Results sets from both");
            vm0.invoke(this.PRQHelp.PRQueryingVsLocalQuerying("Portfolios", "LocalPortfolios", perfR));
            log.info("Benchmarking Querying between PR & local  ENDED*****");
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void norun_testBenchmarkingQueryingOneAccessorTwoDS_Redundancy0() throws Exception {
        LogWriter log = PRQueryPerfDUnitTest.getLogWriter();
        log.info("BenchMarking PR Querying Test Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int redundancy = 0;
        try {
            this.setVMInfoLogLevel();
            log.info("Creating Accessor node on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", redundancy));
            log.info("Successfully Created Accessor node on VM0");
            log.info("Creating Datastores across  VM1 , VM2");
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            log.info("Successfully Created Datastores on VM1 , VM2");
            log.info("Creating Local Region on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
            log.info("Successfully Created Local Region on VM0");
            Object[] portfolio = this.PRQHelp.createPortfolioData(0, 5000);
            log.info("Inserting Portfolio data through the accessor node");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data through the accessor node");
            log.info("Inserting Portfolio data on local node  VM0 for result set comparison");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data on local node  VM0 for result set comparison");
            ResultsObject perfR = new ResultsObject();
            perfR.OperationDescription = "PR with 1 Accessor, 2 D.S., Redundancy=0";
            perfR.NumberOfAccessors = 1;
            perfR.NumberOfDataStores = 2;
            perfR.redundancy = 0;
            log.info("Querying on VM0 both on PR Region & local, also comparing the results sets from both");
            vm0.invoke(this.PRQHelp.PRQueryingVsLocalQuerying("Portfolios", "LocalPortfolios", perfR));
            log.info("Benchmarking Querying between PR & local  ENDED*****");
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void norun_testBenchmarkingQueryingOneAccessorTwoDS_D_ACK_Redundancy1() throws Exception {
        LogWriter log = PRQueryPerfDUnitTest.getLogWriter();
        log.info("BenchMarking PR Querying Test Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int redundancy = 1;
        try {
            this.setVMInfoLogLevel();
            log.info("Creating Accessor node on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", redundancy));
            log.info("Successfully Created Accessor node on VM0");
            log.info("Creating Datastores across  VM1 , VM2");
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            log.info("Successfully Created Datastores on VM1 , VM2");
            log.info("Creating Local Region on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
            log.info("Successfully Created Local Region on VM0");
            Object[] portfolio = this.PRQHelp.createPortfolioData(0, 5000);
            log.info("Inserting Portfolio data through the accessor node");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data through the accessor node");
            log.info("Inserting Portfolio data on local node VM0 for result set comparison");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data on local node VM0 for result set comparison");
            ResultsObject perfR = new ResultsObject();
            perfR.OperationDescription = "PR with 1 Accessor, 2 D.S., Redundancy=1";
            perfR.NumberOfAccessors = 1;
            perfR.NumberOfDataStores = 2;
            perfR.redundancy = 1;
            log.info("Querying on VM0 both on PR Region & local, also comparing the results sets from both");
            vm0.invoke(this.PRQHelp.PRQueryingVsLocalQuerying("Portfolios", "LocalPortfolios", perfR));
            log.info("Benchmarking Querying between PR & local  ENDED*****");
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void norun_testBenchmarkingQueryingOneAccessorThreeDS_Redundancy1() throws Exception {
        LogWriter log = PRQueryPerfDUnitTest.getLogWriter();
        log.info("BenchMarking PR Querying Test Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int redundancy = 1;
        try {
            this.setVMInfoLogLevel();
            log.info("Creating Accessor node on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", redundancy));
            log.info("Successfully Created Accessor node on VM0");
            log.info("Creating Datastores across  VM1 , VM2 , VM3");
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            log.info("Successfully Created Datastores on VM1 , VM2 ,VM3");
            log.info("Creating Local Region on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
            log.info("Successfully Created Local Region on VM0");
            Object[] portfolio = this.PRQHelp.createPortfolioData(0, 5000);
            log.info("Inserting Portfolio data through the accessor node");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data through the accessor node");
            log.info("Inserting Portfolio data on local node  VM0 for result set comparison");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data on local node VM0 for result set comparison");
            ResultsObject perfR = new ResultsObject();
            perfR.OperationDescription = "PR with 1 Accessor, 3 D.S., Redundancy=1";
            perfR.NumberOfAccessors = 1;
            perfR.NumberOfDataStores = 3;
            perfR.redundancy = 1;
            log.info("Querying on VM0 both on PR Region & local, also comparing the results sets from both");
            vm0.invoke(this.PRQHelp.PRQueryingVsLocalQuerying("Portfolios", "LocalPortfolios", perfR));
            log.info("Benchmarking Querying between PR & local  ENDED*****");
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void norun_testBenchmarkingQueryingOneAccessorThreeDS_Redundancy2() throws Exception {
        LogWriter log = PRQueryPerfDUnitTest.getLogWriter();
        log.info("BenchMarking PR Querying Test Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int redundancy = 2;
        try {
            this.setVMInfoLogLevel();
            log.info("Creating Accessor node on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", redundancy));
            log.info("Successfully Created Accessor node on VM0");
            log.info("Creating Datastores across  VM1 , VM2 , VM3");
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", redundancy));
            log.info("Successfully Created Datastores on VM1 , VM2 , VM3");
            log.info("Creating Local Region on VM0");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
            log.info("Successfully Created Local Region on VM0");
            Object[] portfolio = this.PRQHelp.createPortfolioData(0, 5000);
            log.info("Inserting Portfolio data through the accessor node");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data through the accessor node");
            log.info("Inserting Portfolio data on local node  VM0 for result set comparison");
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 5000));
            log.info("Successfully Inserted Portfolio data on local node VM0 for result set comparison");
            ResultsObject perfR = new ResultsObject();
            perfR.OperationDescription = "PR with 1 Accessor, 3 D.S., Redundancy=2";
            perfR.NumberOfAccessors = 1;
            perfR.NumberOfDataStores = 3;
            perfR.redundancy = 2;
            log.info("Querying on VM0 both on PR Region & local, also comparing the results sets from both");
            vm0.invoke(this.PRQHelp.PRQueryingVsLocalQuerying("Portfolios", "LocalPortfolios", perfR));
            log.info("Benchmarking Querying between PR & local  ENDED*****");
        }
        finally {
            this.resetVMLogLevel();
        }
    }

    class ResultsObject
    implements Serializable {
        String OperationDescription;
        long QueryingTimeLocal;
        long QueryingTimePR;
        int NumberOfDataStores = 0;
        int NumberOfAccessors = 0;
        int redundancy = 0;

        ResultsObject() {
        }
    }
}

