/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Collection;
import junit.framework.TestCase;

public class PRBasicIndexCreationDUnitTest
extends PartitionedRegionDUnitTestCase {
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "PartionedPortfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 1003;
    final int redundancy = 0;

    public PRBasicIndexCreationDUnitTest(String name) {
        super(name);
    }

    public void testPRBasicIndexCreate() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPRBasicIndexCreate started ....");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("PartionedPortfolios", 0));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest : creating all the prs ");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForDuplicatePRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForDuplicatePRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForDuplicatePRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPRBasicIndexCreate is done ");
    }

    public void testPRMultiIndexCreation() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testPRMultiIndexCreation Test Started");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnID", "p.ID", null, "p"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQBasicIndexCreationTest.testPRMultiIndexCreation ENDED");
    }

    public void testPRMultiIndexCreationAndGetIndex() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testPRMultiIndexCreation Test Started");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnID", "p.ID", null, "p"));
        CacheSerializableRunnable getIndexCheck = new CacheSerializableRunnable("Get Index Check"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRBasicIndexCreationDUnitTest.this.getCache();
                Index idIndex = cache.getQueryService().getIndex(cache.getRegion("PartionedPortfolios"), "PrIndexOnID");
                TestCase.assertNotNull((Object)idIndex);
                TestCase.assertEquals((String)"PrIndexOnID", (String)idIndex.getName());
                TestCase.assertEquals((String)"p.ID", (String)idIndex.getIndexedExpression());
                TestCase.assertEquals((String)"/PartionedPortfolios p", (String)idIndex.getFromClause());
                TestCase.assertNotNull((Object)idIndex.getStatistics());
                Index statusIndex = cache.getQueryService().getIndex(cache.getRegion("PartionedPortfolios"), "PrIndexOnStatus");
                TestCase.assertNotNull((Object)statusIndex);
                TestCase.assertEquals((String)"PrIndexOnStatus", (String)statusIndex.getName());
                TestCase.assertEquals((String)"p.status", (String)statusIndex.getIndexedExpression());
                TestCase.assertEquals((String)"/PartionedPortfolios p", (String)statusIndex.getFromClause());
                TestCase.assertNotNull((Object)statusIndex.getStatistics());
                Collection indexes = cache.getQueryService().getIndexes(cache.getRegion("PartionedPortfolios"));
                for (Index ind : indexes) {
                    TestCase.assertNotNull((Object)ind);
                    TestCase.assertNotNull((Object)ind.getName());
                    TestCase.assertNotNull((Object)ind.getIndexedExpression());
                    TestCase.assertNotNull((Object)ind.getFromClause());
                    TestCase.assertNotNull((Object)ind.getStatistics());
                }
            }
        };
        vm0.invoke(getIndexCheck);
        vm1.invoke(getIndexCheck);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQBasicIndexCreationTest.testPRMultiIndexCreation ENDED");
    }

    public void testCreatePartitionedIndexThroughXML() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "PRIndexCreation.xml";
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testCreatePartitionedIndexThroughXML started");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("Starting and initializing partitioned regions and indexes using xml");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("Starting a pr asynchronously using an xml file name : PRIndexCreation.xml");
        AsyncInvocation asyInvk0 = vm0.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRCreateThrougXML("PartionedPortfolios", "PRIndexCreation.xml"));
        AsyncInvocation asyInvk1 = vm1.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRCreateThrougXML("PartionedPortfolios", "PRIndexCreation.xml"));
        DistributedTestCase.join(asyInvk1, 30000L, PRBasicIndexCreationDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            PRBasicIndexCreationDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
        DistributedTestCase.join(asyInvk0, 30000L, PRBasicIndexCreationDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            PRBasicIndexCreationDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testCreatePartitionedIndexThroughXML is done  ");
    }

    public void testCreatePartitionedRegionThroughXMLAndAPI() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testCreatePartitionedRegionThroughXMLAndAPI started ");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnId", "p.ID", null, "p"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnPKID", "p.pkid", null, "p"));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
    }

    public void testCreatePartitionedIndexWithNoAliasBeforePuts() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testCreatePartitionedIndexWithNoAliasAfterPuts started ");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "status", null, ""));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
    }

    public void testCreatePartitionedIndexWithNoAliasAfterPuts() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testCreatePartitionedIndexWithNoAliasBeforePuts started ");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "status", null, ""));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexCreationCheck("PartionedPortfolios"));
    }

    public void testPartitionedIndexUsageWithPRQuery() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedIndexUsageWithPRQuery started ");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnId", "p.ID", null, "p"));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("PartionedPortfolios", "LocalPortfolios"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexUsageCheck("PartionedPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexUsageCheck("PartionedPortfolios"));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexUsageCheck("PartionedPortfolios"));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForIndexUsageCheck("PartionedPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedIndexUsageWithPRQuery done ");
    }

    public void testPartitionedIndexCreationDuringPersistentRecovery() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int redundancy = 1;
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedIndexCreationDuringPersistentRecovery started ");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPersistentPRCreate("PartionedPortfolios", redundancy, this.PRQHelp.valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPersistentPRCreate("PartionedPortfolios", redundancy, this.PRQHelp.valueConstraint));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForCloseCache());
        AsyncInvocation regionCreateFuture = vm0.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPersistentPRCreate("PartionedPortfolios", redundancy, this.PRQHelp.valueConstraint));
        AsyncInvocation indexCreateFuture = vm1.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnId", "p.ID", null, "p"));
        regionCreateFuture.getResult(20000L);
        indexCreateFuture.getResult(20000L);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("PartionedPortfolios", "LocalPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedIndexCreationDuringPersistentRecovery done ");
    }

    public void testPartitionedQueryWithIndexOnIdBug37089() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedQueryWithIndexOnIdBug37089 started ");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnId", "p.ID", null, "p"));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("PartionedPortfolios", "LocalPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreationDUnitTest.testPartitionedQueryWithIndexOnIdBug37089 done ");
    }

    public void testCreatePartitionedIndexWithKeysValuesAndFunction() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "PRIndexCreation.xml";
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testCreatePartitionedIndexThroughXML started");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("Starting and initializing partitioned regions and indexes using xml");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("Starting a pr asynchronously using an xml file name : PRIndexCreation.xml");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "index8", "k", "/PartionedPortfolios.keys k", ""));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "index7", "nvl(k.status.toString(),'nopes')", "/PartionedPortfolios.values k", ""));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRBasicIndexCreation.testCreatePartitionedIndexThroughXML is done  ");
    }

    public void testCreateIndexFromAccessor() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("PartionedPortfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
    }

    public void testCreateIndexAndAddAnAccessor() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0));
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 1003);
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("PartionedPortfolios", portfolio, 0, 1003));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("PartionedPortfolios", 0));
    }

    public void testIndexQueryingWithOrderBy() throws Exception {
        int dataSize = 10;
        int step = 2;
        int totalDataSize = 90;
        boolean i = false;
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnID", "p.ID", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnKeyID", "key.ID", "/PartionedPortfolios.keys key", null));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryAndCompareResults("PartionedPortfolios", "LocalPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testIndexQueryingWithOrderAndVerify() throws Exception {
        int dataSize = 10;
        int step = 2;
        int totalDataSize = 90;
        boolean i = false;
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnID", "p.ID", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnKeyID", "key.ID", "/PartionedPortfolios.keys key", null));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryAndVerifyOrder("PartionedPortfolios", "LocalPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testIndexQueryingWithOrderByLimit() throws Exception {
        int dataSize = 10;
        int step = 2;
        int totalDataSize = 90;
        boolean i = false;
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("PartionedPortfolios", 0, valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnStatus", "p.status", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnID", "p.ID", null, "p"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnKeyID", "key.ID", "/PartionedPortfolios.keys key", null));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnKeyStatus", "key.status", "/PartionedPortfolios.keys key", null));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("PartionedPortfolios", "PrIndexOnsecID", "p.position1.secId", "/PartionedPortfolios p", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRIndexCreate("LocalPortfolios", "rrIndexOnStatus", "p.status", null, "p"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRIndexCreate("LocalPortfolios", "rrIndexOnID", "p.ID", null, "p"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRIndexCreate("LocalPortfolios", "rrIndexOnKeyID", "key.ID", "/LocalPortfolios.keys key", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRIndexCreate("LocalPortfolios", "rrIndexOnsecID", "p.position1.secId", "/LocalPortfolios p", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRIndexCreate("LocalPortfolios", "rrIndexOnKeyStatus", "key.status", "/LocalPortfolios.keys key", null));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryWithLimit("PartionedPortfolios", "LocalPortfolios"));
        PRBasicIndexCreationDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }
}

