/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.index.IndexProtocol;
import com.gemstone.gemfire.cache.query.internal.index.IndexTrackingQueryObserverJUnitTest;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionQueryEvaluator;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Collection;
import junit.framework.TestCase;

public class IndexTrackingQueryObserverDUnitTest
extends CacheTestCase {
    private final int NUM_BKTS = 10;
    private static final String queryStr = "select * from /portfolio where ID >= 0";
    protected static final int TOTAL_OBJECTS = 1000;

    public IndexTrackingQueryObserverDUnitTest(String name) {
        super(name);
    }

    public void testIndexInfoOnRemotePartitionedRegion() throws Exception {
    }

    private void createPR(VM vm) {
        SerializableRunnable createDS = new SerializableRunnable("Creating PR Datastore"){

            @Override
            public void run() {
                System.setProperty("gemfire.Query.VERBOSE", "true");
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new IndexTrackingQueryObserver());
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(10);
                AttributesFactory af = new AttributesFactory();
                af.setPartitionAttributes(paf.create());
                Region region = IndexTrackingQueryObserverDUnitTest.this.getCache().createRegion("portfolio", af.create());
            }
        };
        vm.invoke(createDS);
    }

    private void initializeRegion(VM vm) {
        SerializableRunnable initRegion = new SerializableRunnable("Initialize the PR"){

            @Override
            public void run() {
                Region region = IndexTrackingQueryObserverDUnitTest.this.getCache().getRegion("portfolio");
                if (region.size() == 0) {
                    for (int i = 0; i < 1000; ++i) {
                        region.put((Object)Integer.toString(i), (Object)new Portfolio(i, i));
                    }
                }
                TestCase.assertEquals((int)1000, (int)region.size());
            }
        };
        vm.invoke(initRegion);
    }

    private void createQueryIndex(VM vm, final boolean create) {
        SerializableRunnable createIndex = new SerializableRunnable("Create index on PR"){

            @Override
            public void run() {
                TestCase.assertEquals((String)"true", (String)System.getProperty("gemfire.Query.VERBOSE"));
                QueryService qs = IndexTrackingQueryObserverDUnitTest.this.getCache().getQueryService();
                IndexProtocol keyIndex1 = null;
                try {
                    if (create) {
                        keyIndex1 = (IndexProtocol)qs.createIndex("keyIndex1", IndexType.FUNCTIONAL, "ID", "/portfolio ");
                        TestCase.assertNotNull((Object)keyIndex1);
                        TestCase.assertTrue((boolean)(keyIndex1 instanceof PartitionedIndex));
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While creating Index on PR", e);
                }
                Region region = IndexTrackingQueryObserverDUnitTest.this.getCache().getRegion("portfolio");
                IndexTrackingQueryObserverJUnitTest.IndexTrackingTestHook th = new IndexTrackingQueryObserverJUnitTest.IndexTrackingTestHook(region, 5);
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                ((IndexTrackingQueryObserver)observer).setTestHook((PartitionedRegionQueryEvaluator.TestHook)th);
            }
        };
        vm.invoke(createIndex);
    }

    private void runQuery(VM vm) {
        SerializableRunnable runQuery = new SerializableRunnable("Run Query on PR"){

            @Override
            public void run() {
                QueryService qs = IndexTrackingQueryObserverDUnitTest.this.getCache().getQueryService();
                Query query = qs.newQuery(IndexTrackingQueryObserverDUnitTest.queryStr);
                Region region = IndexTrackingQueryObserverDUnitTest.this.getCache().getRegion("portfolio");
                SelectResults results = null;
                try {
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While running query on PR", e);
                }
                TestCase.assertEquals((int)region.size(), (int)results.size());
            }
        };
        vm.invoke(runQuery);
    }

    private AsyncInvocation verifyQueryVerboseData(VM vm, final int results) {
        SerializableRunnable testQueryVerbose = new SerializableRunnable("Test Query Verbose Data"){

            @Override
            public void run() {
                TestCase.assertEquals((String)"true", (String)System.getProperty("gemfire.Query.VERBOSE"));
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                final IndexTrackingQueryObserverJUnitTest.IndexTrackingTestHook th = (IndexTrackingQueryObserverJUnitTest.IndexTrackingTestHook)((IndexTrackingQueryObserver)observer).getTestHook();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return th.getRegionMap() != null;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                }, 5000L, 200L, false);
                IndexTrackingQueryObserver.IndexInfo regionMap = th.getRegionMap();
                Collection rslts = regionMap.getResults().values();
                int totalResults = 0;
                for (Integer i : rslts) {
                    totalResults += i.intValue();
                }
                DistributedTestCase.getLogWriter().fine("Index Info result size is " + totalResults);
                TestCase.assertEquals((int)results, (int)totalResults);
            }
        };
        AsyncInvocation asyncInv = vm.invokeAsync(testQueryVerbose);
        return asyncInv;
    }
}

