/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.CacheUtils;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.PortfolioPdx;
import com.gemstone.gemfire.cache.query.data.Position;
import com.gemstone.gemfire.cache.query.data.PositionPdx;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.VMCachedDeserializable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.Serializable;
import junit.framework.TestCase;

public class SelectStarQueryDUnitTest
extends CacheTestCase {
    private final String regName = "exampleRegion";
    private final String regName2 = "exampleRegion2";
    private final String[] queries = new String[]{"SELECT * FROM /exampleRegion", "SELECT * FROM /exampleRegion limit 5", "SELECT p from  /exampleRegion p", "SELECT count(*) FROM /exampleRegion", "SELECT ALL * from /exampleRegion", "SELECT * from /exampleRegion.values", "SELECT distinct * FROM /exampleRegion", "SELECT distinct * FROM /exampleRegion p order by p.ID", "SELECT * from /exampleRegion r, positions.values pos"};
    private final int[] resultSize = new int[]{20, 5, 20, 1, 20, 20, 20, 20, 40};
    private final String[] multipleRegionQueries = new String[]{" SELECT * FROM /exampleRegion, /exampleRegion2", "SELECT * FROM /exampleRegion, /exampleRegion2 limit 5", "SELECT distinct * FROM /exampleRegion, /exampleRegion2", "SELECT distinct * FROM /exampleRegion p1, /exampleRegion2 p2 order by p1.ID", "SELECT count(*) FROM /exampleRegion, /exampleRegion2", "SELECT p, q from  /exampleRegion p, /exampleRegion2 q", "SELECT ALL * from /exampleRegion p, /exampleRegion2 q", "SELECT * from /exampleRegion.values, /exampleRegion2.values", "SELECT * from /exampleRegion p, p.positions.values pos, /exampleRegion2 q, q.positions.values pos"};
    private final int[] resultSize2 = new int[]{400, 5, 400, 400, 1, 400, 400, 400, 1600};

    public SelectStarQueryDUnitTest(String name) {
        super(name);
    }

    public void testSelectStarQueryForPartitionedRegion() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        final VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        Object[] portfolios = new Portfolio[10];
        for (int i = 0; i < portfolios.length; ++i) {
            portfolios[i] = new Portfolio(i);
        }
        final int port1 = this.startPartitionedCacheServer(server1, portfolios);
        final int port2 = this.startPartitionedCacheServer(server2, portfolios);
        final int port3 = this.startPartitionedCacheServer(server3, portfolios);
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                cf.addPoolServer(DistributedTestCase.getServerHostName(server2.getHost()), port2);
                cf.addPoolServer(DistributedTestCase.getServerHostName(server3.getHost()), port3);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults[][] sr = new SelectResults[1][2];
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertTrue((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
        this.closeCache(server2);
        this.closeCache(server3);
    }

    public void testSelectStarQueryForReplicatedRegion() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final int port1 = this.startReplicatedCacheServer(server1);
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion2");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                Region r2 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion2");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new Portfolio(i));
                    r2.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.multipleRegionQueries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize2[i], (int)res.size());
                    if (i == 4) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)400, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertTrue((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.multipleRegionQueries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize2[i], (int)res.size());
                    if (i == 4) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)400, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testByteArrayReplicatedRegion() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final byte[] ba = new byte[]{1, 2, 3, 4, 5};
        final int port = (Integer)server1.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("exampleRegion");
                for (int i = 0; i < 10; ++i) {
                    r1.put((Object)("key-" + i), (Object)ba);
                }
                CacheServer server = SelectStarQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)ba);
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < 6; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object o : res) {
                        if (o instanceof byte[]) {
                            int j = 0;
                            for (byte b : (byte[])o) {
                                if (b == ba[j++]) continue;
                                TestCase.fail((String)"Bytes in byte array are different when queried from client");
                            }
                            continue;
                        }
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + o.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < 6; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object o : res) {
                        if (o instanceof byte[]) {
                            int j = 0;
                            for (byte b : (byte[])o) {
                                if (b == ba[j++]) continue;
                                TestCase.fail((String)"Bytes in byte array are different when queried locally on server");
                            }
                            continue;
                        }
                        TestCase.fail((String)("Result objects for server local query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of byte array and not " + o.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testByteArrayPartitionedRegion() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final VM server2 = host.getVM(1);
        final VM server3 = host.getVM(2);
        final byte[][] objs = new byte[10][5];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = new byte[]{1, 2, 3, 4, 5};
        }
        final int port1 = this.startPartitionedCacheServer(server1, (Object[])objs);
        final int port2 = this.startPartitionedCacheServer(server2, (Object[])objs);
        final int port3 = this.startPartitionedCacheServer(server3, (Object[])objs);
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                cf.addPoolServer(DistributedTestCase.getServerHostName(server2.getHost()), port2);
                cf.addPoolServer(DistributedTestCase.getServerHostName(server3.getHost()), port3);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new byte[]{1, 2, 3, 4, 5});
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < 6; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object o : res) {
                        if (o instanceof byte[]) {
                            int j = 0;
                            for (byte b : (byte[])o) {
                                if (b == objs[0][j++]) continue;
                                TestCase.fail((String)"Bytes in byte array are different when queried from client");
                            }
                            continue;
                        }
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + o.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < 6; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object o : res) {
                        if (o instanceof byte[]) {
                            int j = 0;
                            for (byte b : (byte[])o) {
                                if (b == objs[0][j++]) continue;
                                TestCase.fail((String)"Bytes in byte array are different when queried locally on server");
                            }
                            continue;
                        }
                        TestCase.fail((String)("Result objects for server local query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of byte array and not " + o.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testSelectStarQueryForIndexes() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final int port1 = this.startReplicatedCacheServer(server1);
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion2");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                Region r2 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion2");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new Portfolio(i));
                    r2.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                    qs.createIndex("status", "status", "/exampleRegion");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.multipleRegionQueries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize2[i], (int)res.size());
                    if (i == 4) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)400, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                    qs.createIndex("status", "status", "/exampleRegion2");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.multipleRegionQueries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.multipleRegionQueries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize2[i], (int)res.size());
                    if (i == 4) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)400, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.multipleRegionQueries[i] + " should be instance of Portfolio and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testSelectStarQueryForPdxObjects() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final int port1 = this.startReplicatedCacheServer(server1);
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 0; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new PortfolioPdx(i));
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertTrue((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)SelectStarQueryDUnitTest.this.getCache();
                cache.setReadSerialized(true);
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testSelectStarQueryForPdxAndNonPdxObjects() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final int port1 = this.startReplicatedCacheServer(server1);
        final QueryObserver oldObserver = (QueryObserver)server1.invoke(new SerializableCallable("Set observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                return observer;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port1);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                return null;
            }
        });
        client.invoke(new SerializableCallable("Put objects"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 10; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new PortfolioPdx(i));
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx || obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx or Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx || rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Get observer"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertTrue((boolean)resultObserver.isObjectSerialized());
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                QueryObserver observer = QueryObserverHolder.setInstance((QueryObserver)new QueryResultTrackingObserver());
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx || obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx or Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx || rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                observer = QueryObserverHolder.getInstance();
                TestCase.assertTrue((boolean)QueryObserverHolder.hasObserver());
                TestCase.assertTrue((boolean)(observer instanceof QueryResultTrackingObserver));
                QueryResultTrackingObserver resultObserver = (QueryResultTrackingObserver)observer;
                TestCase.assertFalse((boolean)resultObserver.isObjectSerialized());
                QueryObserverHolder.setInstance((QueryObserver)oldObserver);
                return null;
            }
        });
        server1.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)SelectStarQueryDUnitTest.this.getCache();
                cache.setReadSerialized(true);
                QueryService qs = null;
                try {
                    qs = SelectStarQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        res = (SelectResults)qs.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx || obj instanceof Portfolio || obj instanceof Position) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx or Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx || rs instanceof Portfolio) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx or Portfolio and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    public void testSelectStarQueryForPdxObjectsReadSerializedTrue() throws Exception {
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        VM client = host.getVM(3);
        final int port = (Integer)server1.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                ((GemFireCacheImpl)SelectStarQueryDUnitTest.this.getCache()).setReadSerialized(true);
                Region r1 = SelectStarQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("exampleRegion");
                CacheServer server = SelectStarQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        client.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(server1.getHost()), port);
                ClientCache cache = SelectStarQueryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("exampleRegion");
                Region r1 = SelectStarQueryDUnitTest.this.getRootRegion("exampleRegion");
                for (int i = 0; i < 20; ++i) {
                    r1.put((Object)("key-" + i), (Object)new PortfolioPdx(i));
                }
                return null;
            }
        });
        client.invoke(new SerializableCallable("Query"){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().info("Querying remotely from client");
                QueryService localQS = null;
                QueryService remoteQS = null;
                try {
                    localQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getLocalQueryService();
                    remoteQS = ((ClientCache)SelectStarQueryDUnitTest.this.getCache()).getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception getting query service ", e);
                }
                SelectResults res = null;
                SelectResults[][] sr = new SelectResults[1][2];
                for (int i = 0; i < SelectStarQueryDUnitTest.this.queries.length; ++i) {
                    try {
                        sr[0][0] = res = (SelectResults)localQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        sr[0][1] = res = (SelectResults)remoteQS.newQuery(SelectStarQueryDUnitTest.this.queries[i]).execute();
                        CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Error executing query: " + SelectStarQueryDUnitTest.this.queries[i], e);
                    }
                    TestCase.assertEquals((int)SelectStarQueryDUnitTest.this.resultSize[i], (int)res.size());
                    if (i == 3) {
                        int cnt = (Integer)res.iterator().next();
                        TestCase.assertEquals((int)20, (int)cnt);
                        continue;
                    }
                    for (Object rs : res) {
                        if (rs instanceof StructImpl) {
                            for (Object obj : ((StructImpl)rs).getFieldValues()) {
                                if (obj instanceof PortfolioPdx || obj instanceof PositionPdx) continue;
                                TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of Portfolio and not " + obj.getClass()));
                            }
                            continue;
                        }
                        if (rs instanceof PortfolioPdx) continue;
                        TestCase.fail((String)("Result objects for remote client query: " + SelectStarQueryDUnitTest.this.queries[i] + " should be instance of PortfolioPdx and not " + rs.getClass()));
                    }
                }
                return null;
            }
        });
        this.closeCache(client);
        this.closeCache(server1);
    }

    private int startPartitionedCacheServer(VM vm, final Object[] objs) {
        int port = (Integer)vm.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).create("exampleRegion");
                for (int i = 0; i < objs.length; ++i) {
                    r1.put((Object)("key-" + i), objs[i]);
                }
                CacheServer server = SelectStarQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        return port;
    }

    private int startReplicatedCacheServer(VM vm) {
        int port = (Integer)vm.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = SelectStarQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("exampleRegion");
                Region r2 = SelectStarQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("exampleRegion2");
                for (int i = 0; i < 10; ++i) {
                    r1.put((Object)("key-" + i), (Object)new Portfolio(i));
                    r2.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                CacheServer server = SelectStarQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        return port;
    }

    private void closeCache(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        });
    }

    public class QueryResultTrackingObserver
    extends QueryObserverAdapter
    implements Serializable {
        private boolean isObjectSerialized = false;

        public void beforeIterationEvaluation(CompiledValue executer, Object currentObject) {
            if (currentObject instanceof VMCachedDeserializable) {
                DistributedTestCase.getLogWriter().fine("currentObject is serialized object");
                this.isObjectSerialized = true;
            } else {
                DistributedTestCase.getLogWriter().fine("currentObject is deserialized object");
            }
        }

        public boolean isObjectSerialized() {
            return this.isObjectSerialized;
        }

        public void setObjectSerialized(boolean isObjectSerialized) {
            this.isObjectSerialized = isObjectSerialized;
        }
    }
}

