/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.Position;
import com.gemstone.gemfire.cache.query.dunit.QueryAPITestPartitionResolver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QueryDataInconsistencyDUnitTest
extends CacheTestCase {
    private static final int cnt = 0;
    private static final int cntDest = 10;
    static VM server = null;
    static VM client = null;
    static Cache cache = null;
    static String PartitionedRegionName1 = "TestPartitionedRegion1";
    static String repRegionName = "TestRepRegion";
    static Integer serverPort1 = null;
    public static int numOfBuckets = 20;
    public static String[] queries = new String[]{"select * from /" + PartitionedRegionName1 + " where ID=1"};
    public static String[] queriesForRR = new String[]{"<trace> select * from /" + repRegionName + " where ID=1"};
    private static PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    public static volatile boolean hooked = false;

    public QueryDataInconsistencyDUnitTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)QueryDataInconsistencyDUnitTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QueryDataInconsistencyDUnitTest.class);
        return suite;
    }

    @Override
    public void tearDown2() throws Exception {
        QueryDataInconsistencyDUnitTest.invokeInEveryVM(CacheTestCase.class, "disconnectFromDS");
        super.tearDown2();
        QueryDataInconsistencyDUnitTest.invokeInEveryVM(QueryObserverHolder.class, "reset");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server = host.getVM(0);
    }

    public void testCompactRangeIndex() {
        Properties props = new Properties();
        server.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server.invoke(new CacheSerializableRunnable("create indexes"){

            @Override
            public void run2() throws CacheException {
                cache = CacheFactory.getAnyInstance();
                Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).create(repRegionName);
                for (int j = 0; j < 10; ++j) {
                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                }
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                try {
                    Index index = qs.createIndex("idIndex", "ID", "/" + repRegionName);
                    TestCase.assertEquals((long)10L, (long)index.getStatistics().getNumberOfKeys());
                }
                catch (Exception e) {
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation putThread = server.invokeAsync(new CacheSerializableRunnable("update a Region Entry"){

            @Override
            public void run2() throws CacheException {
                Region repRegion = CacheFactory.getAnyInstance().getRegion(repRegionName);
                IndexManager.testHook = new IndexManagerTestHook();
                repRegion.put((Object)new Integer("1"), (Object)new Portfolio(11));
            }
        });
        server.invoke(new CacheSerializableRunnable("query on server"){

            @Override
            public void run2() throws CacheException {
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                Object rs = null;
                try {
                    rs = qs.newQuery("<trace> select * from /" + repRegionName + " where ID = 1").execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)"Query execution failed on server.");
                    IndexManager.testHook = null;
                }
                TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                TestCase.assertEquals((int)1, (int)((SelectResults)rs).size());
                Portfolio p1 = (Portfolio)((SelectResults)rs).asList().get(0);
                if (p1.getID() != 1) {
                    TestCase.fail((String)"Query thread did not verify index results even when RE is under update");
                    IndexManager.testHook = null;
                }
                hooked = false;
            }
        });
        server.invoke(new CacheSerializableRunnable("query on server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Portfolio p1;
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                Object rs = null;
                try {
                    rs = qs.newQuery("<trace> select * from /" + repRegionName + " where ID = 1").execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Query execution failed on server." + e.getMessage()));
                }
                finally {
                    IndexManager.testHook = null;
                }
                TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                if (((SelectResults)rs).size() > 0 && (p1 = (Portfolio)((SelectResults)rs).iterator().next()).getID() != 1) {
                    TestCase.fail((String)"Query thread did not verify index results even when RE is under update and RegionEntry value has been modified before releasing the lock");
                    IndexManager.testHook = null;
                }
                hooked = false;
            }
        });
        DistributedTestCase.join(putThread, 200L, this.getLogWriter());
    }

    public void testRangeIndex() {
        Properties props = new Properties();
        server.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server.invoke(new CacheSerializableRunnable("create indexes"){

            @Override
            public void run2() throws CacheException {
                cache = CacheFactory.getAnyInstance();
                Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).create(repRegionName);
                IndexManager.testHook = null;
                Position.cnt = 0;
                for (int j = 0; j < 10; ++j) {
                    Portfolio p = new Portfolio(j);
                    CacheFactory.getAnyInstance().getLogger().fine("Shobhit: portfolio " + j + " : " + p);
                    region.put((Object)new Integer(j), (Object)p);
                }
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                try {
                    Index index = qs.createIndex("posIndex", "pos.secId", "/" + repRegionName + " p, p.positions.values pos");
                    TestCase.assertEquals((long)12L, (long)index.getStatistics().getNumberOfKeys());
                }
                catch (Exception e) {
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation putThread = server.invokeAsync(new CacheSerializableRunnable("update a Region Entry"){

            @Override
            public void run2() throws CacheException {
                Region repRegion = CacheFactory.getAnyInstance().getRegion(repRegionName);
                IndexManager.testHook = new IndexManagerTestHook();
                Portfolio newPort = new Portfolio(11);
                CacheFactory.getAnyInstance().getLogger().fine("Shobhit: New Portfolio" + newPort);
                repRegion.put((Object)new Integer("1"), (Object)newPort);
            }
        });
        server.invoke(new CacheSerializableRunnable("query on server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Object rs;
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                Position pos1 = null;
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    rs = qs.newQuery("<trace> select pos from /" + repRegionName + " p, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    CacheFactory.getAnyInstance().getLogger().fine("Shobhit: " + rs);
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    pos1 = (Position)((SelectResults)rs).iterator().next();
                    if (!pos1.secId.equals("APPL")) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update");
                        IndexManager.testHook = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Query execution failed on server.", e);
                    IndexManager.testHook = null;
                }
                finally {
                    hooked = false;
                }
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    Position pos2;
                    rs = qs.newQuery("<trace> select pos from /" + repRegionName + " p, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    CacheFactory.getAnyInstance().getLogger().fine("Shobhit: " + rs);
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    if (((SelectResults)rs).size() > 0 && (pos2 = (Position)((SelectResults)rs).iterator().next()).equals((Object)pos1)) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update and RegionEntry value has been modified before releasing the lock");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)"Query execution failed on server.");
                }
                finally {
                    hooked = false;
                    IndexManager.testHook = null;
                }
            }
        });
        DistributedTestCase.join(putThread, 200L, this.getLogWriter());
    }

    public void testRangeIndexWithIndexAndQueryFromCluaseMisMatch() {
        Properties props = new Properties();
        server.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server.invoke(new CacheSerializableRunnable("create indexes"){

            @Override
            public void run2() throws CacheException {
                cache = CacheFactory.getAnyInstance();
                Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).create(repRegionName);
                IndexManager.testHook = null;
                Position.cnt = 0;
                for (int j = 0; j < 10; ++j) {
                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                }
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                try {
                    Index index = qs.createIndex("posIndex", "pos.secId", "/" + repRegionName + " p, p.collectionHolderMap.values coll, p.positions.values pos");
                    TestCase.assertEquals((long)12L, (long)index.getStatistics().getNumberOfKeys());
                }
                catch (Exception e) {
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation putThread = server.invokeAsync(new CacheSerializableRunnable("update a Region Entry"){

            @Override
            public void run2() throws CacheException {
                Region repRegion = CacheFactory.getAnyInstance().getRegion(repRegionName);
                IndexManager.testHook = new IndexManagerTestHook();
                repRegion.put((Object)new Integer("1"), (Object)new Portfolio(1));
            }
        });
        server.invoke(new CacheSerializableRunnable("query on server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Object rs;
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                Position pos1 = null;
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    rs = qs.newQuery("<trace> select pos from /" + repRegionName + " p, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    CacheFactory.getAnyInstance().getLogger().fine("Shobhit: " + rs);
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    pos1 = (Position)((SelectResults)rs).iterator().next();
                    if (!pos1.secId.equals("APPL")) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update");
                        IndexManager.testHook = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Query execution failed on server.", e);
                    IndexManager.testHook = null;
                }
                finally {
                    hooked = false;
                }
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    Position pos2;
                    rs = qs.newQuery("select pos from /" + repRegionName + " p, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    if (((SelectResults)rs).size() > 0 && (pos2 = (Position)((SelectResults)rs).iterator().next()).equals((Object)pos1)) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update and RegionEntry value has been modified before releasing the lock");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)"Query execution failed on server.");
                }
                finally {
                    hooked = false;
                    IndexManager.testHook = null;
                }
            }
        });
        DistributedTestCase.join(putThread, 200L, this.getLogWriter());
    }

    public void testRangeIndexWithIndexAndQueryFromCluaseMisMatch2() {
        Properties props = new Properties();
        server.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server.invoke(new CacheSerializableRunnable("create indexes"){

            @Override
            public void run2() throws CacheException {
                cache = CacheFactory.getAnyInstance();
                Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).create(repRegionName);
                IndexManager.testHook = null;
                Position.cnt = 0;
                for (int j = 0; j < 10; ++j) {
                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                }
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                try {
                    Index index = qs.createIndex("posIndex", "pos.secId", "/" + repRegionName + " p, p.positions.values pos");
                    TestCase.assertEquals((long)12L, (long)index.getStatistics().getNumberOfKeys());
                }
                catch (Exception e) {
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation putThread = server.invokeAsync(new CacheSerializableRunnable("update a Region Entry"){

            @Override
            public void run2() throws CacheException {
                Region repRegion = CacheFactory.getAnyInstance().getRegion(repRegionName);
                IndexManager.testHook = new IndexManagerTestHook();
                repRegion.put((Object)new Integer("1"), (Object)new Portfolio(1));
            }
        });
        server.invoke(new CacheSerializableRunnable("query on server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Object rs;
                QueryService qs = CacheFactory.getAnyInstance().getQueryService();
                Position pos1 = null;
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    rs = qs.newQuery("<trace> select pos from /" + repRegionName + " p, p.collectionHolderMap.values coll, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    CacheFactory.getAnyInstance().getLogger().fine("Shobhit: " + rs);
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    pos1 = (Position)((SelectResults)rs).iterator().next();
                    if (!pos1.secId.equals("APPL")) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update");
                        IndexManager.testHook = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Query execution failed on server.", e);
                    IndexManager.testHook = null;
                }
                finally {
                    hooked = false;
                }
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    Position pos2;
                    rs = qs.newQuery("select pos from /" + repRegionName + " p, p.collectionHolderMap.values coll, p.positions.values pos where pos.secId = 'APPL' AND p.ID = 1").execute();
                    TestCase.assertTrue((boolean)(rs instanceof SelectResults));
                    if (((SelectResults)rs).size() > 0 && (pos2 = (Position)((SelectResults)rs).iterator().next()).equals((Object)pos1)) {
                        TestCase.fail((String)"Query thread did not verify index results even when RE is under update and RegionEntry value has been modified before releasing the lock");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)"Query execution failed on server.");
                }
                finally {
                    IndexManager.testHook = null;
                    hooked = false;
                }
            }
        });
        DistributedTestCase.join(putThread, 200L, this.getLogWriter());
    }

    public static void createProxyRegions() {
        new QueryDataInconsistencyDUnitTest("temp").createProxyRegs();
    }

    private void createProxyRegs() {
        ClientCache cache = (ClientCache)CacheFactory.getAnyInstance();
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(repRegionName);
    }

    public static void createNewPR() {
        new QueryDataInconsistencyDUnitTest("temp").createPR();
    }

    public void createPR() {
        QueryAPITestPartitionResolver testKeyBasedResolver = new QueryAPITestPartitionResolver();
        cache = CacheFactory.getAnyInstance();
        cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).create()).create(PartitionedRegionName1);
    }

    public static void createCacheClientWithoutRegion(String host, Integer port1) {
        new QueryDataInconsistencyDUnitTest("temp").createCacheClientWithoutReg(host, port1);
    }

    private void createCacheClientWithoutReg(String host, Integer port1) {
        this.disconnectFromDS();
        ClientCache cache = new ClientCacheFactory().addPoolServer(host, port1.intValue()).create();
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPuts(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("Region Puts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(repRegionName);
                for (int j = from; j < to; ++j) {
                    region.put((Object)new Integer(j), portfolio[j]);
                }
                DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRPuts: Inserted Portfolio data on Region " + regionName);
            }
        };
        return puts;
    }

    public class IndexManagerTestHook
    implements IndexManager.TestHook {
        public void hook(int spot) throws RuntimeException {
            switch (spot) {
                case 9: {
                    hooked = true;
                    DistributedTestCase.getLogWriter().info("QueryDataInconsistency.IndexManagerTestHook is hooked in Update Index Entry.");
                    while (hooked) {
                        DistributedTestCase.pause(100);
                    }
                    TestCase.assertEquals((boolean)hooked, (boolean)false);
                    break;
                }
                case 10: {
                    hooked = true;
                    DistributedTestCase.getLogWriter().info("QueryDataInconsistency.IndexManagerTestHook is hooked in Remove Index Entry.");
                    while (hooked) {
                        DistributedTestCase.pause(100);
                    }
                    TestCase.assertEquals((boolean)hooked, (boolean)false);
                    break;
                }
            }
        }
    }
}

