/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.CacheUtils;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.PortfolioPdx;
import com.gemstone.gemfire.cache.query.data.PositionPdx;
import com.gemstone.gemfire.cache.query.internal.Undefined;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxWriter;
import com.gemstone.gemfire.pdx.VersionClassLoader;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class PdxQueryDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    protected static final Compressor compressor;
    final String rootRegionName = "root";
    private final String regionName = "PdxTest";
    private final String regionName2 = "PdxTest2";
    private final String regName = "/root/PdxTest";
    private final String regName2 = "/root/PdxTest2";
    private final String[] queryString = new String[]{"SELECT DISTINCT id FROM /root/PdxTest", "SELECT * FROM /root/PdxTest", "SELECT ticker FROM /root/PdxTest", "SELECT * FROM /root/PdxTest WHERE id > 5", "SELECT p FROM /root/PdxTest p, p.idTickers idTickers WHERE p.ticker = 'vmware'"};
    private static int mcastPort;

    public PdxQueryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestObject.numInstance = 0;
        PortfolioPdx.numInstance = 0;
        PositionPdx.numInstance = 0;
        TestObject2.numInstance = 0;
        this.resetTestObjectInstanceCount();
    }

    @Override
    public void tearDown2() throws Exception {
        PdxQueryDUnitTest.disconnectAllFromDS();
        TestObject.numInstance = 0;
        PortfolioPdx.numInstance = 0;
        PositionPdx.numInstance = 0;
        TestObject2.numInstance = 0;
        this.resetTestObjectInstanceCount();
    }

    private void resetTestObjectInstanceCount() {
        PdxQueryDUnitTest.invokeInEveryVM(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestObject.numInstance = 0;
                PortfolioPdx.numInstance = 0;
                PositionPdx.numInstance = 0;
                TestObject2.numInstance = 0;
            }
        });
    }

    public void createPool(VM vm, String poolName, String server, int port, boolean subscriptionEnabled) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, subscriptionEnabled);
    }

    public void createPool(VM vm, String poolName, String server, int port) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, false);
    }

    public void createPool(VM vm, String poolName, String[] servers, int[] ports, boolean subscriptionEnabled) {
        this.createPool(vm, poolName, servers, ports, subscriptionEnabled, 0);
    }

    public void createPool(VM vm, final String poolName, final String[] servers, final int[] ports, final boolean subscriptionEnabled, final int redundancy) {
        vm.invoke(new CacheSerializableRunnable("createPool :" + poolName){

            @Override
            public void run2() throws CacheException {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxQueryDUnitTest.this.getSystem(props);
                PdxQueryDUnitTest.this.getCache();
                PoolFactory cpf = PoolManager.createFactory();
                cpf.setSubscriptionEnabled(subscriptionEnabled);
                cpf.setSubscriptionRedundancy(redundancy);
                for (int i = 0; i < servers.length; ++i) {
                    DistributedTestCase.getLogWriter().info("### Adding to Pool. ### Server : " + servers[i] + " Port : " + ports[i]);
                    cpf.addServer(servers[i], ports[i]);
                }
                cpf.create(poolName);
            }
        });
    }

    public void testServerQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 5;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)5, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
                QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                Query query = null;
                SelectResults sr = null;
                for (int i = 0; i < PdxQueryDUnitTest.this.queryString.length; ++i) {
                    try {
                        query = qs.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        sr = (SelectResults)query.execute();
                    }
                    catch (Exception ex) {
                        TestCase.fail((String)("Failed to execute query, " + ex.getMessage()));
                    }
                    for (Object o : sr.asSet()) {
                        if (i == 0 && !(o instanceof Integer)) {
                            TestCase.fail((String)("Expected type Integer, not found in result set. Found type :" + o.getClass()));
                            continue;
                        }
                        if (i == 1 && !(o instanceof TestObject)) {
                            TestCase.fail((String)("Expected type TestObject, not found in result set. Found type :" + o.getClass()));
                            continue;
                        }
                        if (i != 2 || o instanceof String) continue;
                        TestCase.fail((String)("Expected type String, not found in result set. Found type :" + o.getClass()));
                    }
                }
                TestCase.assertEquals((int)5, (int)TestObject.numInstance);
            }
        });
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testClientServerQueryWithProjections() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    if (CachedDeserializableFactory.preferObject()) {
                        region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                        continue;
                    }
                    class PdxObject
                    extends TestObject {
                        PdxObject() {
                        }

                        PdxObject(int id, String ticker) {
                            super(id, ticker);
                        }
                    }
                    region.put((Object)("key-" + i), (Object)new PdxObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                System.out.println("##### Region size is: " + region.size());
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueriesWithParamsPool";
        this.createPool(vm2, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port1}, true);
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParamsPool").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    DistributedTestCase.getLogWriter().info("### Executing Query :" + PdxQueryDUnitTest.this.queryString[0]);
                    Query query = qService.newQuery(PdxQueryDUnitTest.this.queryString[0]);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[0], e);
                }
                TestCase.assertEquals((int)10, (int)results.size());
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testClientServerQueryWithCompression() throws CacheException {
        String randomString = "asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(false, false, false, compressor);
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                assert (region.getAttributes().getCompressor() != null);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                System.out.println("##### Region size is: " + region.size());
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueriesWithParamsPool";
        this.createPool(vm2, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port1}, true);
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParamsPool").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    DistributedTestCase.getLogWriter().info("### Executing Query :" + PdxQueryDUnitTest.this.queryString[2]);
                    Query query = qService.newQuery(PdxQueryDUnitTest.this.queryString[2]);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[2], e);
                }
                TestCase.assertEquals((int)10, (int)results.size());
                for (String result : results) {
                    TestCase.assertEquals((String)"asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4asddfjkhaskkfdjhzjc0943509328kvnhfjkldsg09q3485ibjafdp9q8y43p9u7hgavpiuaha48uy9afliasdnuaiuqa498qa4", (String)result);
                }
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testVersionedClass() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                try {
                    VersionClassLoader.initClassLoader(1L);
                    String className = "com.gemstone.gemfire.cache.query.data.PdxTestObject";
                    for (int i = 0; i < 10; ++i) {
                        Object obj = VersionClassLoader.getVersionedInstance(className, new Object[]{new Integer(i), "vmware"});
                        region.put((Object)("key-" + i), obj);
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to load the class.", ex);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                System.out.println("##### Region size is: " + region.size());
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueriesWithParamsPool";
        this.createPool(vm2, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParamsPool", new String[]{host0}, new int[]{port1}, true);
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParamsPool").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    DistributedTestCase.getLogWriter().info("### Executing Query :" + PdxQueryDUnitTest.this.queryString[0]);
                    Query query = qService.newQuery(PdxQueryDUnitTest.this.queryString[0]);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[0], e);
                }
                TestCase.assertEquals((int)10, (int)results.size());
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testClientServerQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                QueryService localQueryService = null;
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
                try {
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 0; i < 3; ++i) {
                    try {
                        Query query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)10, (int)results.size());
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
            }
        });
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 1; i < 3; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        Query query = remoteQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][0] = (SelectResults)query.execute();
                        TestCase.assertEquals((int)10, (int)rs[0][0].size());
                        DistributedTestCase.getLogWriter().info("### Executing Query locally:" + PdxQueryDUnitTest.this.queryString[i]);
                        query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][1] = (SelectResults)query.execute();
                        TestCase.assertEquals((int)10, (int)rs[0][1].size());
                        if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) continue;
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + PdxQueryDUnitTest.this.queryString[i]));
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
                TestCase.assertEquals((int)20, (int)TestObject.numInstance);
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)20, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testClientServerQueryWithRangeIndex() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        PdxQueryDUnitTest test = this;
        final String[] qs = new String[]{"SELECT * FROM /root/PdxTest p WHERE p.ID > 0", "SELECT p FROM /root/PdxTest p WHERE p.ID > 0", "SELECT * FROM /root/PdxTest p WHERE p.ID = 1", "SELECT * FROM /root/PdxTest p WHERE p.ID < 10", "SELECT * FROM /root/PdxTest p WHERE p.ID != 10", "SELECT * FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 0", "SELECT * FROM /root/PdxTest p, p.positions.values pos WHERE p.ID = 10", "SELECT p, pos FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 0", "SELECT p, pos FROM /root/PdxTest p, p.positions.values pos WHERE p.ID = 10", "SELECT pos FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 0", "SELECT p, pos FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId != 'XXX'", "SELECT pos FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId != 'XXX'", "SELECT pos FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId = 'SUN'", "SELECT p, pos FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId = 'SUN'", "SELECT p, pos FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId = 'DELL'", "SELECT * FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId = 'SUN'", "SELECT * FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId = 'DELL'", "SELECT p, p.position1 FROM /root/PdxTest p where p.position1.secId != 'XXX'", "SELECT p, p.position1 FROM /root/PdxTest p where p.position1.secId = 'SUN'", "SELECT p.position1 FROM /root/PdxTest p WHERE p.ID > 0", "SELECT * FROM /root/PdxTest p WHERE p.status = 'active'", "SELECT p FROM /root/PdxTest p WHERE p.status != 'active'"};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(false, false, true, null);
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                try {
                    qs.createIndex("idIndex", "p.ID", "/root/PdxTest p");
                    qs.createIndex("statusIndex", "p.status", "/root/PdxTest p");
                    qs.createIndex("secIdIndex", "pos.secId", "/root/PdxTest p, p.positions.values pos");
                    qs.createIndex("pSecIdIdIndex", "p.position1.secId", "/root/PdxTest p");
                }
                catch (Exception ex) {
                    TestCase.fail((String)("Failed to create index." + ex.getMessage()));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(false, false, true, null);
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Object localQueryService = null;
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                int j = 0;
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new PortfolioPdx(j, j++));
                    if (i % 24 != 0) continue;
                    j = 0;
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                for (int i = 0; i < qs.length; ++i) {
                    try {
                        Query query = queryService.newQuery(qs[i]);
                        SelectResults results = (SelectResults)query.execute();
                        for (Object o : results.asList()) {
                            if (o instanceof Struct) {
                                Object[] values = ((Struct)o).getFieldValues();
                                for (int c = 0; c < values.length; ++c) {
                                    if (!(values[c] instanceof PdxInstance)) continue;
                                    TestCase.fail((String)("Found unexpected PdxInstance in the query results. At struct field [" + c + "] query :" + qs[i] + " Object is: " + values[c]));
                                }
                                continue;
                            }
                            if (!(o instanceof PdxInstance)) continue;
                            TestCase.fail((String)("Found unexpected PdxInstance in the query results. " + qs[i]));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + qs[i], e);
                    }
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl cache = (GemFireCacheImpl)PdxQueryDUnitTest.this.getCache();
                cache.setReadSerialized(true);
                try {
                    QueryService queryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                    for (int i = 0; i < qs.length; ++i) {
                        try {
                            Query query = queryService.newQuery(qs[i]);
                            SelectResults results = (SelectResults)query.execute();
                            for (Object o : results.asList()) {
                                if (o instanceof Struct) {
                                    Object[] values = ((Struct)o).getFieldValues();
                                    for (int c = 0; c < values.length; ++c) {
                                        if (values[c] instanceof PdxInstance) continue;
                                        TestCase.fail((String)("Didn't found expected PdxInstance in the query results. At struct field [" + c + "] query :" + qs[i] + " Object is: " + values[c]));
                                    }
                                    continue;
                                }
                                if (o instanceof PdxInstance) continue;
                                TestCase.fail((String)("Didn't found expected PdxInstance in the query results. " + qs[i] + " Object is: " + o));
                            }
                            continue;
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + qs[i], e);
                        }
                    }
                }
                finally {
                    cache.setReadSerialized(false);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testClientServerCountQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        String queryStr = "SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0";
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                QueryService localQueryService = null;
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
                try {
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    Query query = localQueryService.newQuery("SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    SelectResults results = (SelectResults)query.execute();
                    TestCase.assertEquals((int)10, (int)((Integer)results.asList().get(0)));
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0", e);
                }
            }
        });
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    DistributedTestCase.getLogWriter().info("### Executing Query on server:SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    Query query = remoteQueryService.newQuery("SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    rs[0][0] = (SelectResults)query.execute();
                    TestCase.assertEquals((int)10, (int)((Integer)rs[0][0].asList().get(0)));
                    DistributedTestCase.getLogWriter().info("### Executing Query locally:SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    query = localQueryService.newQuery("SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    rs[0][1] = (SelectResults)query.execute();
                    TestCase.assertEquals((int)10, (int)((Integer)rs[0][1].asList().get(0)));
                    if (!CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) {
                        TestCase.fail((String)"Local and Remote Query Results are not matching for query :SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0");
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing SELECT COUNT(*) FROM /root/PdxTest WHERE id >= 0", e);
                }
                TestCase.assertEquals((int)10, (int)TestObject.numInstance);
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testVersionedClientServerQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        final String[] queryStr = new String[]{"SELECT DISTINCT ID FROM /root/PdxTest", "SELECT * FROM /root/PdxTest", "SELECT pkid FROM /root/PdxTest", "SELECT * FROM /root/PdxTest WHERE ID > 5", "SELECT p FROM /root/PdxTest p, p.positions pos WHERE p.pkid != 'vmware'", "SELECT entry.value FROM " + this.regName + ".entries entry WHERE entry.value.ID > 0", "SELECT entry.value FROM  " + this.regName + ".entries entry WHERE entry.key = 'key-1'", "SELECT e.value FROM " + this.regName + ".entrySet e where  e.value.pkid >= '0'", "SELECT * FROM " + this.regName + ".values p WHERE p.pkid in SET('1', '2','3')", "SELECT * FROM " + this.regName + " pf where pf.position1.secId > '2'", "SELECT * FROM " + this.regName + " p where p.position3[1].portfolioId = 2", "SELECT * FROM " + this.regName + " p, p.positions.values AS pos WHERE pos.secId != '1'", "SELECT key, positions FROM " + this.regName + ".entrySet, value.positions.values positions WHERE positions.mktValue >= 25.00", "SELECT * FROM " + this.regName + " portfolio1, " + this.regName + " portfolio2 WHERE portfolio1.status = portfolio2.status", "SELECT portfolio1.ID, portfolio2.status FROM " + this.regName + " portfolio1, " + this.regName + " portfolio2  WHERE portfolio1.status = portfolio2.status", "SELECT * FROM " + this.regName + " portfolio1, portfolio1.positions.values positions1, " + this.regName + " portfolio2,  portfolio2.positions.values positions2 WHERE positions1.secId = positions1.secId ", "SELECT * FROM " + this.regName + " portfolio, portfolio.positions.values positions WHERE portfolio.Pk IN SET ('1', '2') AND positions.secId = '1'", "SELECT DISTINCT pf1, pf2 FROM " + this.regName + "  pf1, pf1.collectionHolderMap.values coll1, pf1.positions.values posit1, " + this.regName + "  pf2, pf2.collectionHolderMap.values  coll2, pf2.positions.values posit2 WHERE pf1.ID = pf2.ID"};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                try {
                    VersionClassLoader.initClassLoader(1L);
                    String pPdxVersion1ClassName = "com.gemstone.gemfire.cache.query.data.PortfolioPdxVersion1";
                    for (int i = 0; i < 10; ++i) {
                        Object obj = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{new Integer(i), new Integer(i)});
                        region.put((Object)("key-" + i), obj);
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to load the class.");
                }
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 0; i < queryStr.length; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + queryStr[i]);
                        Query query = remoteQueryService.newQuery(queryStr[i]);
                        rs[0][0] = (SelectResults)query.execute();
                        DistributedTestCase.getLogWriter().info("### Executing Query locally:" + queryStr[i]);
                        query = localQueryService.newQuery(queryStr[i]);
                        rs[0][1] = (SelectResults)query.execute();
                        DistributedTestCase.getLogWriter().info("### Remote Query rs size: " + rs[0][0].size() + "Local Query rs size: " + rs[0][1].size());
                        if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) continue;
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + queryStr[i]));
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + queryStr[i], e);
                    }
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                String pPdxVersion1ClassName = "com.gemstone.gemfire.cache.query.data.PortfolioPdxVersion1";
                try {
                    Object obj = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{new Integer(0), new Integer(0)});
                    TestCase.fail((String)"Should have thrown class not found exception.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testQueryOnPR() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, true);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                Object localQueryService = null;
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 1; i < 3; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        Query query = remoteQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        SelectResults rs = (SelectResults)query.execute();
                        TestCase.assertEquals((int)100, (int)rs.size());
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
                TestCase.assertEquals((int)100, (int)TestObject.numInstance);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)100, (int)TestObject.numInstance);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                Query query = null;
                SelectResults sr = null;
                for (int i = 0; i < PdxQueryDUnitTest.this.queryString.length; ++i) {
                    try {
                        query = qs.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        sr = (SelectResults)query.execute();
                    }
                    catch (Exception ex) {
                        TestCase.fail((String)("Failed to execute query, " + ex.getMessage()));
                    }
                    for (Object o : sr.asSet()) {
                        if (i == 0 && !(o instanceof Integer)) {
                            TestCase.fail((String)("Expected type Integer, not found in result set. Found type :" + o.getClass()));
                            continue;
                        }
                        if (i == 1 && !(o instanceof TestObject)) {
                            TestCase.fail((String)("Expected type TestObject, not found in result set. Found type :" + o.getClass()));
                            continue;
                        }
                        if (i != 2 || o instanceof String) continue;
                        TestCase.fail((String)("Expected type String, not found in result set. Found type :" + o.getClass()));
                    }
                }
                if (TestObject.numInstance <= 0) {
                    TestCase.fail((String)"Expected TestObject instance to be >= 0.");
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)TestObject.numInstance);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testLocalPRQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, true);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm3.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    PdxQueryDUnitTest.this.getCache(new CacheFactory().setPdxReadSerialized(true));
                }
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                try {
                    VersionClassLoader.initClassLoader(1L);
                    String pPdxVersion1ClassName = "com.gemstone.gemfire.cache.query.data.PortfolioPdxVersion1";
                    for (int i = 0; i < 100; ++i) {
                        Object obj = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{new Integer(i), new Integer(i)});
                        region.put((Object)("key-" + i), obj);
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to load the class.");
                }
                Object results = null;
                QueryService localQueryService = null;
                try {
                    localQueryService = region.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 1; i < 3; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        Query query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        SelectResults rs = (SelectResults)query.execute();
                        TestCase.assertEquals((int)100, (int)rs.size());
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testPdxReadSerializedForPRQuery() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, true);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm3.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer(true, false);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                try {
                    VersionClassLoader.initClassLoader(1L);
                    String pPdxVersion1ClassName = "com.gemstone.gemfire.cache.query.data.PortfolioPdxVersion1";
                    for (int i = 0; i < 100; ++i) {
                        Object obj = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{new Integer(i), new Integer(i)});
                        region.put((Object)("key-" + i), obj);
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to load the class.");
                }
                Object results = null;
                QueryService localQueryService = null;
                try {
                    localQueryService = region.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 1; i < 3; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        Query query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        SelectResults rs = (SelectResults)query.execute();
                        TestCase.assertEquals((int)100, (int)rs.size());
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
            }
        });
        final String[] qs = new String[]{"SELECT * FROM /root/PdxTest", "SELECT * FROM /root/PdxTest WHERE ID > 5", "SELECT p FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 2 or pos.secId = 'vmware'"};
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                GemFireCacheImpl c = (GemFireCacheImpl)region.getCache();
                try {
                    c.setReadSerialized(true);
                    Object results = null;
                    QueryService localQueryService = null;
                    try {
                        localQueryService = region.getCache().getQueryService();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed to get QueryService.", e);
                    }
                    for (int i = 1; i < qs.length; ++i) {
                        try {
                            DistributedTestCase.getLogWriter().info("### Executing Query on server:" + qs[i]);
                            Query query = localQueryService.newQuery(qs[i]);
                            SelectResults rs = (SelectResults)query.execute();
                            for (Object o : rs.asSet()) {
                                if (o instanceof PdxInstance) continue;
                                TestCase.fail((String)("Expected type PdxInstance, not found in result set. Found type :" + o.getClass()));
                            }
                            continue;
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + qs[i], e);
                        }
                    }
                }
                finally {
                    c.setReadSerialized(false);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testCq() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        int queryLimit = 6;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testCqPool";
        this.createPool(vm2, "testCqPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testCqPool", new String[]{host0}, new int[]{port1}, true);
        String cqName = "testCq";
        CacheSerializableRunnable executeCq = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###testCq");
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testCqPool").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                ((CqQueryTestListener)cqListeners[0]).cqName = "testCq";
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq = qService.newCq("testCq", PdxQueryDUnitTest.this.queryString[3], cqa);
                    CqResults sr = cq.executeWithInitialResults();
                    for (Object o : sr.asSet()) {
                        Struct s = (Struct)o;
                        Object value = s.get("value");
                        if (value instanceof TestObject) continue;
                        TestCase.fail((String)("Expected type TestObject, not found in result set. Found type :" + o.getClass()));
                    }
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to create CQ testCq . ");
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("QueryService is :" + qService, (Throwable)((Object)err));
                    throw err;
                }
            }
        };
        vm2.invoke(executeCq);
        vm3.invoke(executeCq);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 20; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
                TestCase.assertEquals((int)30, (int)TestObject.numInstance);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)30, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        CacheSerializableRunnable validateCq = new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                Object[] cqEvents;
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### testCq");
                QueryService cqService = null;
                try {
                    cqService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq("testCq");
                if (cQuery == null) {
                    TestCase.fail((String)"Failed to get CqQuery for CQ : testCq");
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListeners = cqAttr.getCqListeners();
                final CqQueryTestListener listener = (CqQueryTestListener)cqListeners[0];
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return listener.getTotalEventCount() >= 14;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                }, 30000L, 100L, false);
                listener.printInfo(false);
                for (Object o : cqEvents = listener.getEvents()) {
                    CqEvent cqEvent = (CqEvent)o;
                    Object value = cqEvent.getNewValue();
                    if (value instanceof TestObject) continue;
                    TestCase.fail((String)("Expected type TestObject, not found in result set. Found type :" + o.getClass()));
                }
                TestCase.assertEquals((String)"Total Event Count mismatch", (int)14, (int)listener.getTotalEventCount());
                TestCase.assertEquals((String)"Create Event mismatch", (int)10, (int)listener.getCreateEventCount());
                TestCase.assertEquals((String)"Update Event mismatch", (int)4, (int)listener.getUpdateEventCount());
            }
        };
        vm2.invoke(validateCq);
        vm3.invoke(validateCq);
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testIndex() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    if (i % 2 == 0) {
                        region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                        continue;
                    }
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware" + i));
                }
                try {
                    QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                    qs.createIndex("idIndex", IndexType.FUNCTIONAL, "id", "/root/PdxTest");
                    qs.createIndex("tickerIndex", IndexType.FUNCTIONAL, "p.ticker", "/root/PdxTest p");
                    qs.createIndex("tickerIdTickerMapIndex", IndexType.FUNCTIONAL, "p.ticker", "/root/PdxTest p, p.idTickers idTickers");
                }
                catch (Exception ex) {
                    TestCase.fail((String)("Unable to create index. " + ex.getMessage()));
                }
                TestCase.assertEquals((int)10, (int)TestObject.numInstance);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                try {
                    QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                    qs.createIndex("idIndex", IndexType.FUNCTIONAL, "id", "/root/PdxTest");
                    qs.createIndex("tickerIndex", IndexType.FUNCTIONAL, "p.ticker", "/root/PdxTest p");
                    qs.createIndex("tickerIdTickerMapIndex", IndexType.FUNCTIONAL, "p.ticker", "/root/PdxTest p, p.idTickers idTickers");
                }
                catch (Exception ex) {
                    TestCase.fail((String)("Unable to create index. " + ex.getMessage()));
                }
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        CacheSerializableRunnable createClientRegions = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Object localQueryService = null;
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                for (int i = 0; i < 20; ++i) {
                    if (i % 2 == 0) {
                        region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                        continue;
                    }
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware" + i));
                }
            }
        };
        vm2.invoke(createClientRegions);
        vm3.invoke(createClientRegions);
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)50, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)50, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                int i;
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (i = 0; i < 3; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        query = remoteQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][0] = (SelectResults)query.execute();
                        TestCase.assertEquals((int)20, (int)rs[0][0].size());
                        DistributedTestCase.getLogWriter().info("### Executing Query locally:" + PdxQueryDUnitTest.this.queryString[i]);
                        query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][1] = (SelectResults)query.execute();
                        TestCase.assertEquals((int)20, (int)rs[0][1].size());
                        if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) continue;
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + PdxQueryDUnitTest.this.queryString[i]));
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
                TestCase.assertEquals((int)40, (int)TestObject.numInstance);
                for (i = 3; i < PdxQueryDUnitTest.this.queryString.length; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + PdxQueryDUnitTest.this.queryString[i]);
                        query = remoteQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][0] = (SelectResults)query.execute();
                        DistributedTestCase.getLogWriter().info("### Executing Query locally:" + PdxQueryDUnitTest.this.queryString[i]);
                        query = localQueryService.newQuery(PdxQueryDUnitTest.this.queryString[i]);
                        rs[0][1] = (SelectResults)query.execute();
                        if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) continue;
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + PdxQueryDUnitTest.this.queryString[i]));
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + PdxQueryDUnitTest.this.queryString[i], e);
                    }
                }
            }
        };
        vm2.invoke(executeQueries);
        vm3.invoke(executeQueries);
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)50, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)10, (int)TestObject.numInstance);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)50, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void testRegionIterators() throws CacheException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        final String[] queries = new String[]{"SELECT entry.value FROM " + this.regName + ".entries entry WHERE entry.value.id > 0", "SELECT entry.value FROM  " + this.regName + ".entries entry WHERE entry.key = 'key-1'", "SELECT e.value FROM " + this.regName + ".entrySet e where  e.value.id >= 0", "SELECT * FROM " + this.regName + ".values p WHERE p.ticker = 'vmware'"};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                PdxQueryDUnitTest.this.configAndStartBridgeServer();
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
            }
        });
        int port0 = vm0.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final int port1 = vm1.invokeInt(PdxQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = PdxQueryDUnitTest.getServerHostName(vm0.getHost());
        String poolName = "testClientServerQueryPool";
        this.createPool(vm2, "testClientServerQueryPool", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueryPool", new String[]{host0}, new int[]{port1}, true);
        vm3.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Object localQueryService = null;
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port1, -1, true, -1, -1, null);
                Region region = PdxQueryDUnitTest.this.createRegion("PdxTest", "root", factory.create());
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "vmware"));
                }
            }
        });
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)"testClientServerQueryPool").getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 0; i < queries.length; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query on server:" + queries[i]);
                        Query query = remoteQueryService.newQuery(queries[i]);
                        rs[0][0] = (SelectResults)query.execute();
                        DistributedTestCase.getLogWriter().info("### Executing Query locally:" + queries[i]);
                        query = localQueryService.newQuery(queries[i]);
                        rs[0][1] = (SelectResults)query.execute();
                        if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) continue;
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + queries[i]));
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + queries[i], e);
                    }
                }
            }
        };
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)20, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PdxQueryDUnitTest.this.getRootRegion().getSubregion("PdxTest");
                QueryService qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                try {
                    qs.createIndex("idIndex", IndexType.FUNCTIONAL, "entry.value.id", "/root/PdxTest.entries entry");
                    qs.createIndex("tickerIndex", IndexType.FUNCTIONAL, "p.ticker", "/root/PdxTest.values p");
                }
                catch (Exception ex) {
                    TestCase.fail((String)("Unable to create index. " + ex.getMessage()));
                }
            }
        });
        vm3.invoke(executeQueries);
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                if (CachedDeserializableFactory.preferObject()) {
                    TestCase.assertEquals((int)20, (int)TestObject.numInstance);
                } else {
                    TestCase.assertEquals((int)0, (int)TestObject.numInstance);
                }
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        this.closeClient(vm1);
        this.closeClient(vm0);
    }

    public void validateCq(VM vm, final String cqName, final int expectedEvents, final int createEvents, final int updateEvents) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                Object[] cqEvents;
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListeners = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListeners[0];
                listener.printInfo(false);
                for (Object o : cqEvents = listener.getEvents()) {
                    CqEvent cqEvent = (CqEvent)o;
                    Object value = cqEvent.getNewValue();
                    if (value instanceof TestObject) continue;
                    TestCase.fail((String)("Expected type TestObject, not found in result set. Found type :" + o.getClass()));
                }
                if (listener.getTotalEventCount() != expectedEvents) {
                    listener.waitForTotalEvents(expectedEvents);
                }
                TestCase.assertEquals((String)"Total Event Count mismatch", (int)expectedEvents, (int)listener.getTotalEventCount());
                TestCase.assertEquals((String)"Create Event mismatch", (int)createEvents, (int)listener.getCreateEventCount());
                TestCase.assertEquals((String)"Update Event mismatch", (int)updateEvents, (int)listener.getUpdateEventCount());
            }
        });
    }

    public void executeClientQueries(VM vm, final String poolName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] rs = new SelectResults[1][2];
                try {
                    remoteQueryService = PoolManager.find((String)poolName).getQueryService();
                    localQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    DistributedTestCase.getLogWriter().info("### Executing Query on server:" + queryStr);
                    Query query = remoteQueryService.newQuery(queryStr);
                    rs[0][0] = (SelectResults)query.execute();
                    DistributedTestCase.getLogWriter().info("### Executing Query locally:" + queryStr);
                    query = localQueryService.newQuery(queryStr);
                    rs[0][1] = (SelectResults)query.execute();
                    DistributedTestCase.getLogWriter().info("### Remote Query rs size: " + rs[0][0].size() + "Local Query rs size: " + rs[0][1].size());
                    if (!CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])rs)) {
                        TestCase.fail((String)("Local and Remote Query Results are not matching for query :" + queryStr));
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryStr, e);
                }
            }
        });
    }

    public void printResults(SelectResults results, String message) {
        LogWriterI18n logger = GemFireCacheImpl.getInstance().getLoggerI18n();
        logger.fine(message);
        int row = 0;
        for (Object r : results) {
            ++row;
            if (r instanceof Struct) {
                Struct s = (Struct)r;
                String[] fieldNames = ((Struct)r).getStructType().getFieldNames();
                for (int i = 0; i < fieldNames.length; ++i) {
                    logger.fine("### Row " + row + "\nField: " + fieldNames[i] + " > " + s.get(fieldNames[i]).toString());
                }
                continue;
            }
            logger.fine("#### Row " + row + "\n" + r);
        }
    }

    protected void configAndStartBridgeServer() {
        this.configAndStartBridgeServer(false, false, false, null);
    }

    protected void configAndStartBridgeServer(boolean isPr, boolean isAccessor) {
        this.configAndStartBridgeServer(false, false, false, null);
    }

    protected void configAndStartBridgeServer(boolean isPr, boolean isAccessor, boolean asyncIndex, Compressor compressor) {
        AttributesFactory factory = new AttributesFactory();
        if (isPr) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            if (isAccessor) {
                paf.setLocalMaxMemory(0);
            }
            PartitionAttributes prAttr = paf.setTotalNumBuckets(20).setRedundantCopies(0).create();
            factory.setPartitionAttributes(prAttr);
        } else {
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        if (asyncIndex) {
            factory.setIndexMaintenanceSynchronous(!asyncIndex);
        }
        if (compressor != null) {
            factory.setCompressor(compressor);
        }
        this.createRegion(this.regionName, this.rootRegionName, factory.create());
        this.createRegion(this.regionName2, this.rootRegionName, factory.create());
        try {
            this.startBridgeServer(0, false);
        }
        catch (Exception ex) {
            PdxQueryDUnitTest.fail("While starting CacheServer", ex);
        }
    }

    protected void executeCompiledQueries(String poolName, Object[][] params) {
        SelectResults results = null;
        Object comparator = null;
        Object resultsArray = null;
        QueryService qService = null;
        try {
            qService = PoolManager.find((String)poolName).getQueryService();
        }
        catch (Exception e) {
            PdxQueryDUnitTest.fail("Failed to get QueryService.", e);
        }
        for (int i = 0; i < this.queryString.length; ++i) {
            try {
                PdxQueryDUnitTest.getLogWriter().info("### Executing Query :" + this.queryString[i]);
                Query query = qService.newQuery(this.queryString[i]);
                results = (SelectResults)query.execute(params[i]);
                continue;
            }
            catch (Exception e) {
                PdxQueryDUnitTest.fail("Failed executing " + this.queryString[i], e);
            }
        }
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        PdxQueryDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    public void closeClient(VM client) {
        CacheSerializableRunnable closeCache = new CacheSerializableRunnable("Close Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close Client. ###");
                try {
                    CacheTestCase.closeCache();
                    CacheTestCase.disconnectFromDS();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get close client. ###");
                }
            }
        };
        client.invoke(closeCache);
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public void testPdxInstanceNoFieldNoMethod() throws CacheException {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        String name = "/PdxTest";
        final String[] qs = new String[]{"select * from /PdxTest where pdxStatus = 'active'", "select pdxStatus from /PdxTest where id > 4"};
        final int port1 = (Integer)vm0.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = PdxQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("PdxTest");
                CacheServer server = PdxQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        vm3.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm0.getHost()), port1);
                ClientCache cache = PdxQueryDUnitTest.this.getClientCache(cf);
                Region region = cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create("PdxTest");
                VersionClassLoader.initClassLoader(1L);
                String pPdxVersion1ClassName = "parReg.query.PdxVersionedNewPortfolio";
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{"version1_obj-" + i, i}));
                }
                return null;
            }
        });
        vm3.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                VersionClassLoader.initClassLoader(1L);
                QueryService remoteQueryService = null;
                try {
                    remoteQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 0; i < qs.length; ++i) {
                    try {
                        SelectResults sr = (SelectResults)remoteQueryService.newQuery(qs[i]).execute();
                        if (i == 1) {
                            TestCase.assertEquals((int)5, (int)sr.size());
                            for (Object o : sr) {
                                if (o instanceof Undefined) continue;
                                TestCase.fail((String)("Result should be Undefined and not " + o.getClass()));
                            }
                            continue;
                        }
                        TestCase.assertEquals((int)0, (int)sr.size());
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + qs[i], e);
                    }
                }
                return null;
            }
        });
        PdxQueryDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
    }

    public void testDefaultValuesInPdxFieldTypes() throws Exception {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 10;
        String name = "/PdxTest";
        String query = "select stringField, booleanField, charField, shortField, intField, longField, floatField, doubleField from /PdxTest";
        final int port1 = (Integer)vm0.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = PdxQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("PdxTest");
                CacheServer server = PdxQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        vm1.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                int i;
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm0.getHost()), port1);
                ClientCache cache = PdxQueryDUnitTest.this.getClientCache(cf);
                Region region = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("PdxTest");
                String pPdxVersion1ClassName = "objects.PdxVersionedFieldType";
                VersionClassLoader.initClassLoader(1L);
                for (i = 0; i < 10; ++i) {
                    Object v1 = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{i});
                    DistributedTestCase.getLogWriter().info("Putting object: " + v1);
                    region.put((Object)("key-" + i), v1);
                }
                VersionClassLoader.initClassLoader(2L);
                for (i = 10; i < 20; ++i) {
                    Object v2 = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{i});
                    DistributedTestCase.getLogWriter().info("Putting object: " + v2);
                    region.put((Object)("key-" + i), v2);
                }
                return null;
            }
        });
        vm0.invoke(new SerializableCallable("Create index"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)PdxQueryDUnitTest.this.getCache();
                cache.setReadSerialized(true);
                QueryService qs = null;
                SelectResults[][] sr = new SelectResults[1][2];
                try {
                    qs = PdxQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    sr[0][0] = (SelectResults)qs.newQuery("select stringField, booleanField, charField, shortField, intField, longField, floatField, doubleField from /PdxTest").execute();
                    TestCase.assertEquals((int)20, (int)sr[0][0].size());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + qs, e);
                }
                try {
                    qs.createIndex("stringIndex", "stringField", "/PdxTest");
                    qs.createIndex("boolanIndex", "booleanField", "/PdxTest");
                    qs.createIndex("shortIndex", "shortField", "/PdxTest");
                    qs.createIndex("charIndex", "charField", "/PdxTest");
                    qs.createIndex("intIndex", "intField", "/PdxTest");
                    qs.createIndex("longIndex", "longField", "/PdxTest");
                    qs.createIndex("floatIndex", "floatField", "/PdxTest");
                    qs.createIndex("doubleIndex", "doubleField", "/PdxTest");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Exception creating index ", e);
                }
                try {
                    sr[0][1] = (SelectResults)qs.newQuery("select stringField, booleanField, charField, shortField, intField, longField, floatField, doubleField from /PdxTest").execute();
                    TestCase.assertEquals((int)20, (int)sr[0][1].size());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + qs, e);
                }
                CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable("update index"){

            public Object call() throws Exception {
                int i;
                Region region = PdxQueryDUnitTest.this.getCache().getRegion("PdxTest");
                String pPdxVersion1ClassName = "objects.PdxVersionedFieldType";
                VersionClassLoader.initClassLoader(1L);
                for (i = 10; i < 20; ++i) {
                    Object v1 = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{i});
                    DistributedTestCase.getLogWriter().info("Putting object: " + v1);
                    region.put((Object)("key-" + i), v1);
                }
                VersionClassLoader.initClassLoader(2L);
                for (i = 0; i < 10; ++i) {
                    Object v2 = VersionClassLoader.getVersionedInstance(pPdxVersion1ClassName, new Object[]{i});
                    DistributedTestCase.getLogWriter().info("Putting object: " + v2);
                    region.put((Object)("key-" + i), v2);
                }
                return null;
            }
        });
        vm1.invoke(new SerializableCallable("query"){

            public Object call() throws Exception {
                QueryService remoteQueryService = null;
                QueryService localQueryService = null;
                SelectResults[][] sr = new SelectResults[1][2];
                try {
                    remoteQueryService = PdxQueryDUnitTest.this.getCache().getQueryService();
                    localQueryService = ((ClientCache)PdxQueryDUnitTest.this.getCache()).getLocalQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    sr[0][0] = (SelectResults)remoteQueryService.newQuery("select stringField, booleanField, charField, shortField, intField, longField, floatField, doubleField from /PdxTest").execute();
                    TestCase.assertEquals((int)20, (int)sr[0][0].size());
                    sr[0][1] = (SelectResults)localQueryService.newQuery("select stringField, booleanField, charField, shortField, intField, longField, floatField, doubleField from /PdxTest").execute();
                    TestCase.assertEquals((int)20, (int)sr[0][1].size());
                }
                catch (Exception e) {
                    TestCase.fail((String)("Failed executing query " + e));
                }
                CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])sr);
                return null;
            }
        });
        PdxQueryDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
    }

    protected void startCacheServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = CacheFactory.getAnyInstance();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    private static int getMcastPort() {
        return mcastPort;
    }

    static {
        compressor = SnappyCompressor.getDefaultInstance();
    }

    public static class TestObject
    implements PdxSerializable {
        public static LogWriter log;
        protected String _ticker;
        protected int _price;
        public int id;
        public int important;
        public int selection;
        public int select;
        public static int numInstance;
        public Map idTickers = new HashMap();
        public HashMap positions = new HashMap();
        public TestObject2 test;

        public TestObject() {
            if (log != null) {
                log.info("TestObject ctor stack trace", (Throwable)new Exception());
            }
            ++numInstance;
        }

        public TestObject(int id, String ticker) {
            if (log != null) {
                log.info("TestObject ctor stack trace", (Throwable)new Exception());
            }
            this.id = id;
            this._ticker = ticker;
            this._price = id;
            this.important = id;
            this.selection = id;
            this.select = id;
            ++numInstance;
            this.idTickers.put(id + "", ticker);
            this.test = new TestObject2(id);
        }

        public TestObject(int id, String ticker, int numPositions) {
            this(id, ticker);
            for (int i = 0; i < numPositions; ++i) {
                this.positions.put(id + i, new PositionPdx(ticker + ":" + id + ":" + i, id + 100));
            }
        }

        public int getIdValue() {
            return this.id;
        }

        public String getTicker() {
            return this._ticker;
        }

        public int getPriceValue() {
            return this._price;
        }

        public HashMap getPositions(String id) {
            return this.positions;
        }

        public String getStatus() {
            return this.id % 2 == 0 ? "active" : "inactive";
        }

        public void toData(PdxWriter out) {
            out.writeInt("id", this.id);
            out.writeString("ticker", this._ticker);
            out.writeInt("price", this._price);
            out.writeObject("idTickers", (Object)this.idTickers);
            out.writeObject("positions", (Object)this.positions);
            out.writeObject("test", (Object)this.test);
        }

        public void fromData(PdxReader in) {
            this.id = in.readInt("id");
            this._ticker = in.readString("ticker");
            this._price = in.readInt("price");
            this.idTickers = (Map)in.readObject("idTickers");
            this.positions = (HashMap)in.readObject("positions");
            this.test = (TestObject2)in.readObject("test");
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TestObject [").append("id=").append(this.id).append("; ticker=").append(this._ticker).append("; price=").append(this._price).append("]");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            TestObject other = (TestObject)o;
            return this.id == other.id && this._ticker.equals(other._ticker);
        }

        public int hashCode() {
            GemFireCacheImpl.getInstance().getLoggerI18n().fine("In TestObject.hashCode() : " + this.id);
            return this.id;
        }

        static {
            numInstance = 0;
        }
    }

    public static class TestObject2
    implements PdxSerializable {
        public int _id;
        public static int numInstance = 0;

        public TestObject2() {
            ++numInstance;
        }

        public TestObject2(int id) {
            this._id = id;
            ++numInstance;
        }

        public int getId() {
            return this._id;
        }

        public void toData(PdxWriter out) {
            out.writeInt("id", this._id);
        }

        public void fromData(PdxReader in) {
            this._id = in.readInt("id");
        }

        public boolean equals(Object o) {
            DistributedTestCase.getLogWriter().info("In TestObject2.equals() this: " + this + " other :" + o);
            GemFireCacheImpl.getInstance().getLoggerI18n().fine("In TestObject2.equals() this: " + this + " other :" + o);
            TestObject2 other = (TestObject2)o;
            if (this._id == other._id) {
                return true;
            }
            DistributedTestCase.getLogWriter().info("NOT EQUALS");
            return false;
        }

        public int hashCode() {
            GemFireCacheImpl.getInstance().getLoggerI18n().fine("In TestObject2.hashCode() : " + this._id);
            return this._id;
        }
    }
}

