/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.CqStatistics;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryUsingPoolDUnitTest;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqQueryVsdStats;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.CqServiceVsdStats;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class CqStatsUsingPoolDUnitTest
extends CacheTestCase {
    private CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqStatsUsingPoolDUnitTest");
    private static final int PAUSE = 8000;

    public CqStatsUsingPoolDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqStatsUsingPoolDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqStatsUsingPoolDUnitTest.this.getSystem();
            }
        });
    }

    private void validateCQStats(VM vm, final String cqName, final int creates, final int updates, final int deletes, final int totalEvents, final int cqListenerInvocations) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ Stats. ### " + cqName);
                QueryService qService = null;
                try {
                    qService = CqStatsUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to get query service.");
                }
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)qService).getCqService();
                }
                catch (CqException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Failed to get CqService, CQ : " + cqName));
                }
                CqQuery[] cQuery = cqService.getAllCqs();
                if (cQuery.length == 0) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqStatistics cqStats = cQuery[0].getStatistics();
                CqQueryVsdStats cqVsdStats = ((CqQueryImpl)cQuery[0]).getVsdStats();
                if (cqStats == null || cqVsdStats == null) {
                    TestCase.fail((String)("Failed to get CqQuery Stats for CQ : " + cqName));
                }
                CqStatsUsingPoolDUnitTest.this.getCache().getLogger().info("#### CQ stats for " + cQuery[0].getName() + ":  Events Total: " + cqStats.numEvents() + " Events Created: " + cqStats.numInserts() + " Events Updated: " + cqStats.numUpdates() + " Events Deleted: " + cqStats.numDeletes() + " CQ Listener invocations: " + cqVsdStats.getNumCqListenerInvocations() + " Initial results time (nano sec): " + cqVsdStats.getCqInitialResultsTime());
                if (totalEvents != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Total Event Count mismatch", (long)totalEvents, (long)cqStats.numEvents());
                }
                if (creates != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Create Event mismatch", (long)creates, (long)cqStats.numInserts());
                }
                if (updates != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Update Event mismatch", (long)updates, (long)cqStats.numUpdates());
                }
                if (deletes != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Delete Event mismatch", (long)deletes, (long)cqStats.numDeletes());
                }
                if (cqListenerInvocations != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"CQ Listener invocations mismatch", (long)cqListenerInvocations, (long)cqVsdStats.getNumCqListenerInvocations());
                }
            }
        });
    }

    private void validateCQServiceStats(VM vm, final int created, final int activated, final int stopped, final int closed, final int cqsOnClient, final int cqsOnRegion, final int clientsWithCqs) {
        vm.invoke(new CacheSerializableRunnable("Validate CQ Service Stats"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ Service Stats. ### ");
                QueryService qService = null;
                try {
                    qService = CqStatsUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqServiceStatistics cqServiceStats = null;
                cqServiceStats = qService.getCqStatistics();
                CqServiceVsdStats cqServiceVsdStats = null;
                try {
                    cqServiceVsdStats = ((DefaultQueryService)qService).getCqService().stats;
                }
                catch (CqException e) {
                    e.printStackTrace();
                }
                if (cqServiceStats == null) {
                    TestCase.fail((String)"Failed to get CQ Service Stats");
                }
                CqStatsUsingPoolDUnitTest.this.getCache().getLogger().info("#### CQ Service stats:  CQs created: " + cqServiceStats.numCqsCreated() + " CQs active: " + cqServiceStats.numCqsActive() + " CQs stopped: " + cqServiceStats.numCqsStopped() + " CQs closed: " + cqServiceStats.numCqsClosed() + " CQs on Client: " + cqServiceStats.numCqsOnClient() + " CQs on region /root/regionA : " + cqServiceVsdStats.numCqsOnRegion("/root/regionA") + " Clients with CQs: " + cqServiceVsdStats.getNumClientsWithCqs());
                if (created != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs created mismatch", (long)created, (long)cqServiceStats.numCqsCreated());
                }
                if (activated != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs activated mismatch", (long)activated, (long)cqServiceStats.numCqsActive());
                }
                if (stopped != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs stopped mismatch", (long)stopped, (long)cqServiceStats.numCqsStopped());
                }
                if (closed != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs closed mismatch", (long)closed, (long)cqServiceStats.numCqsClosed());
                }
                if (cqsOnClient != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs on client mismatch", (long)cqsOnClient, (long)cqServiceStats.numCqsOnClient());
                }
                if (cqsOnRegion != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Number of CQs on region /root/regionA mismatch", (long)cqsOnRegion, (long)cqServiceVsdStats.numCqsOnRegion("/root/regionA"));
                }
                if (clientsWithCqs != CqQueryUsingPoolDUnitTest.noTest) {
                    TestCase.assertEquals((String)"Clints with CQs mismatch", (long)clientsWithCqs, (long)cqServiceVsdStats.getNumClientsWithCqs());
                }
            }
        });
    }

    public void testCQStatistics() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqStatsUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQStatistics";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createCQ(client, poolName, "testCQStatistics_0", this.cqDUnitTest.cqs[0]);
        int size = 100;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.executeCQ(client, "testCQStatistics_0", true, null);
        this.cqDUnitTest.waitForCqState(client, "testCQStatistics_0", 1);
        this.validateCQStats(client, "testCQStatistics_0", 0, 0, 0, 0, 0);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 200);
        this.cqDUnitTest.waitForCreated(client, "testCQStatistics_0", "key-200");
        CqStatsUsingPoolDUnitTest.pause(8000);
        size = 200;
        this.cqDUnitTest.validateCQ(client, "testCQStatistics_0", CqQueryUsingPoolDUnitTest.noTest, 100, 100, 0, 100, 100, 0, 200);
        this.validateCQStats(client, "testCQStatistics_0", 100, 100, 0, 200, 200);
        this.validateCQStats(server, "testCQStatistics_0", 100, 100, 0, 200, CqQueryUsingPoolDUnitTest.noTest);
        this.cqDUnitTest.deleteValues(server, this.cqDUnitTest.regions[0], 100);
        this.cqDUnitTest.waitForDestroyed(client, "testCQStatistics_0", "key-100");
        size = 10;
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.cqDUnitTest.validateCQ(client, "testCQStatistics_0", CqQueryUsingPoolDUnitTest.noTest, 100, 100, 100, 100, 100, 100, 300);
        this.validateCQStats(client, "testCQStatistics_0", 100, 100, 100, 300, 300);
        this.validateCQStats(server, "testCQStatistics_0", 100, 100, 100, 300, CqQueryUsingPoolDUnitTest.noTest);
        this.cqDUnitTest.closeCQ(client, "testCQStatistics_0");
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQServiceStatistics() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqStatsUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName1 = "testCQServiceStatistics1";
        String poolName2 = "testCQServiceStatistics2";
        this.cqDUnitTest.createPool(client1, poolName1, host0, port);
        this.cqDUnitTest.createPool(client2, poolName2, host0, port);
        String cqName = new String("testCQServiceStatistics_0");
        String cqName10 = new String("testCQServiceStatistics_10");
        this.cqDUnitTest.createCQ(client1, poolName1, cqName, this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.createCQ(client2, poolName2, cqName10, this.cqDUnitTest.cqs[2]);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on clients: #1");
        this.validateCQServiceStats(client1, 1, 0, 1, 0, 1, 1, CqQueryUsingPoolDUnitTest.noTest);
        this.validateCQServiceStats(server, 0, 0, 0, 0, CqQueryUsingPoolDUnitTest.noTest, 0, 0);
        this.cqDUnitTest.executeCQ(client1, cqName, false, null);
        this.cqDUnitTest.executeCQ(client2, cqName10, false, null);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on clients: #2");
        this.validateCQServiceStats(client1, 1, 1, 0, 0, 1, 1, CqQueryUsingPoolDUnitTest.noTest);
        this.validateCQServiceStats(client2, 1, 1, 0, 0, 1, CqQueryUsingPoolDUnitTest.noTest, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #1");
        this.validateCQServiceStats(server, 2, 2, 0, 0, CqQueryUsingPoolDUnitTest.noTest, 1, 2);
        int size = 10;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForCreated(client1, "testCQServiceStatistics_0", "key-" + size);
        this.cqDUnitTest.validateCQ(client1, cqName, CqQueryUsingPoolDUnitTest.noTest, size, 0, 0, size, 0, 0, size);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on clients: #3");
        this.validateCQServiceStats(client1, 1, 1, 0, 0, 1, 1, CqQueryUsingPoolDUnitTest.noTest);
        this.validateCQServiceStats(client2, 1, 1, 0, 0, 1, CqQueryUsingPoolDUnitTest.noTest, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #1");
        this.validateCQServiceStats(server, 2, 2, 0, 0, CqQueryUsingPoolDUnitTest.noTest, 1, 2);
        this.cqDUnitTest.createAndExecCQNoName(client1, poolName1, this.cqDUnitTest.cqs[0]);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on client: #4");
        this.validateCQServiceStats(client1, 21, 1, 0, 20, 1, 1, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #2");
        this.validateCQServiceStats(server, 22, 2, 0, 20, CqQueryUsingPoolDUnitTest.noTest, 1, 2);
        this.cqDUnitTest.closeCQ(client1, cqName);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on client: #5");
        this.validateCQServiceStats(client1, 21, 0, 0, 21, 0, 0, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #3");
        this.validateCQServiceStats(server, 22, 1, 0, 21, CqQueryUsingPoolDUnitTest.noTest, 0, 1);
        this.cqDUnitTest.stopCQ(client2, cqName10);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on client: #6");
        this.validateCQServiceStats(client2, 1, 0, 1, 0, 1, CqQueryUsingPoolDUnitTest.noTest, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #4");
        this.validateCQServiceStats(server, 22, 0, 1, 21, CqQueryUsingPoolDUnitTest.noTest, CqQueryUsingPoolDUnitTest.noTest, 1);
        this.cqDUnitTest.closeCQ(client2, cqName10);
        CqStatsUsingPoolDUnitTest.pause(8000);
        this.getCache().getLogger().info("Validating CQ Service stats on client: #7");
        this.validateCQServiceStats(client1, 21, 0, 0, 21, 0, 0, CqQueryUsingPoolDUnitTest.noTest);
        this.validateCQServiceStats(client2, 1, 0, 0, 1, 0, 0, CqQueryUsingPoolDUnitTest.noTest);
        this.getCache().getLogger().info("Validating CQ Service stats on server: #5");
        this.validateCQServiceStats(server, 22, 0, 0, 22, CqQueryUsingPoolDUnitTest.noTest, 0, 0);
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeServer(server);
    }
}

