/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.management;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MXMemoryPoolListenerExample
implements NotificationListener {
    private AtomicBoolean critical = new AtomicBoolean();
    private final LogWriter logger;

    public MXMemoryPoolListenerExample(DistributedSystem ds) {
        this.logger = ds.getLogWriter();
    }

    @Override
    public void handleNotification(Notification arg0, Object arg1) {
        this.logger.info("Notification: " + arg0 + "; o: " + arg1 + "; m: " + arg0.getMessage());
        this.critical.set(true);
    }

    public static void main(String[] args) {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        double t = 0.8;
        if (args.length > 0) {
            try {
                t = Integer.parseInt(args[0]) / 100;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("Theshold must be >= 0 and <= 100");
        }
        double threshold = t;
        int p = 100;
        if (args.length > 1) {
            try {
                p = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (p > 100 || p < 0) {
            throw new IllegalArgumentException("Percent Tenured must be >= 0 and <= 100");
        }
        int percentTenured = p;
        Properties dsProps = new Properties();
        dsProps.setProperty("mcast-port", "0");
        dsProps.setProperty("log-level", "info");
        dsProps.setProperty("statistic-sample-rate", "200");
        dsProps.setProperty("enable-time-statistics", "true");
        dsProps.setProperty("statistic-sampling-enabled", "true");
        DistributedSystem ds = DistributedSystem.connect((Properties)dsProps);
        LogWriter logger = ds.getLogWriter();
        logger.info("Usage threshold: " + threshold + "; percent tenured: " + percentTenured + "; Runtime Maximum memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "Mb; Heap Maximum memory: " + mbean.getHeapMemoryUsage().getMax() / 0x100000L + "Mb");
        MXMemoryPoolListenerExample me = new MXMemoryPoolListenerExample(ds);
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(me, null, null);
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean p2 : pools) {
            if (p2.isCollectionUsageThresholdSupported()) {
                logger.info("Pool which supports collection usage threshold: " + p2.getName() + "; " + p2.getCollectionUsage());
            }
            if (!p2.getType().equals((Object)MemoryType.HEAP) || !p2.isUsageThresholdSupported() || p2.getName().startsWith("Nursery")) continue;
            int byteThreshold = (int)Math.ceil(threshold * (double)p2.getUsage().getMax());
            logger.info("Setting threshold " + byteThreshold / 0x100000 + "Mb on: " + p2.getName() + "; " + p2.getCollectionUsage());
            p2.setUsageThreshold(byteThreshold);
        }
        Cache c = CacheFactory.create((DistributedSystem)ds);
        new MemoryHog("hog_1", c, me.critical).consumeMemory(percentTenured).printTenuredSize();
        ds.disconnect();
    }

    public static class MemoryHog {
        private final String name;
        private final Region tenuredData;
        private final Cache cache;
        private final AtomicBoolean criticalState;

        public MemoryHog(String n, Cache c, AtomicBoolean critical) {
            this.name = n;
            this.cache = c;
            this.tenuredData = new RegionFactory().setScope(Scope.LOCAL).create(this.name);
            this.criticalState = critical;
        }

        public MemoryHog consumeMemory(int percentTenured) {
            long runTime;
            long maxSecondsToRun = 180L;
            LogWriter logger = this.cache.getLogger();
            long start = System.nanoTime();
            int i = 100;
            while (true) {
                byte[] val = new byte[1012];
                val[percentTenured] = (byte)i;
                if (percentTenured > 0 && i % 100 <= percentTenured) {
                    this.tenuredData.put((Object)new Integer(i), (Object)val);
                }
                if (i % 1000 == 0 && (runTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start)) > 180L) break;
                if (this.criticalState.get()) {
                    logger.info(this.name + ": Clearing tenured data: size=" + this.tenuredData.size() / 1024 + "Mb");
                    this.tenuredData.clear();
                    this.criticalState.set(false);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            logger.info(this.name + ": Ending consume loop after " + runTime + "s");
            return this;
        }

        public MemoryHog printTenuredSize() {
            this.cache.getLogger().info("Tenured data size: " + this.tenuredData.getName() + ": " + this.tenuredData.size());
            return this;
        }
    }
}

