/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.RegionWithHDFSBasicDUnitTest;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.SerializableCallable;

public class RegionWithHDFSPersistenceBasicDUnitTest
extends RegionWithHDFSBasicDUnitTest {
    public RegionWithHDFSPersistenceBasicDUnitTest(String name) {
        super(name);
    }

    @Override
    protected SerializableCallable getCreateRegionCallable(final int totalnumOfBuckets, final int batchSizeMB, final int maximumEntries, final String folderPath, final String uniqueName, final int batchInterval, final boolean queuePersistent, final boolean writeonly, final long timeForRollover, final long maxFileSize) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PERSISTENT_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
                hqf.setBatchSizeMB(batchSizeMB);
                hqf.setPersistent(queuePersistent);
                hqf.setMaximumQueueMemory(3);
                hqf.setBatchTimeInterval(batchInterval);
                af.setHDFSStoreName(uniqueName);
                af.setPartitionAttributes(paf.create());
                HDFSStoreFactory hsf = RegionWithHDFSPersistenceBasicDUnitTest.this.getCache().createHDFSStoreFactory();
                String homeDir = RegionWithHDFSPersistenceBasicDUnitTest.this.tmpDir + "/" + folderPath;
                hsf.setHomeDir(homeDir);
                hsf.setHDFSEventQueueAttributes(hqf.create());
                if (timeForRollover != -1L) {
                    hsf.setFileRolloverInterval((int)timeForRollover);
                    System.setProperty("gemfire.HDFSRegionDirector.FILE_ROLLOVER_TASK_INTERVAL_SECONDS", "1");
                }
                if (maxFileSize != -1L) {
                    hsf.setMaxFileSize((int)maxFileSize);
                }
                hsf.create(uniqueName);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setHDFSWriteOnly(writeonly);
                Region r = RegionWithHDFSPersistenceBasicDUnitTest.this.createRootRegion(uniqueName, af.create());
                ((LocalRegion)r).setIsTest();
                return 0;
            }
        };
        return createRegion;
    }
}

