/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SerializedCacheValue;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PoolStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifierStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.concurrent.AB;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitExt.MultiThreadedTestRunner;
import junitExt.TestRunnable;
import objects.Order;

public class ConnectionPoolDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    protected static int port;
    protected static int port2;
    protected static int numberOfAfterInvalidates;
    protected static int numberOfAfterCreates;
    protected static int numberOfAfterUpdates;
    protected static final int TYPE_CREATE = 0;
    protected static final int TYPE_UPDATE = 1;
    protected static final int TYPE_INVALIDATE = 2;
    protected static final int TYPE_DESTROY = 3;
    private final AB timeToStop = CFactory.createAB((boolean)false);
    private Thread gettorThread;
    protected static volatile boolean stopTestLifetimeExpire;
    protected static volatile int baselineLifetimeCheck;
    protected static volatile int baselineLifetimeExtensions;
    protected static volatile int baselineLifetimeConnect;
    protected static volatile int baselineLifetimeDisconnect;

    public ConnectionPoolDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        ConnectionPoolDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.getSystem();
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        ConnectionPoolDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                Map pools = PoolManager.getAll();
                if (!pools.isEmpty()) {
                    DistributedTestCase.getLogWriter().warning("found pools remaining after teardown: " + pools);
                    TestCase.assertEquals((int)0, (int)pools.size());
                }
            }
        });
    }

    protected static PoolImpl getPool(Region r) {
        PoolImpl result = null;
        String poolName = r.getAttributes().getPoolName();
        if (poolName != null) {
            result = (PoolImpl)PoolManager.find((String)poolName);
        }
        return result;
    }

    protected static TestCacheWriter getTestWriter(Region r) {
        return (TestCacheWriter)r.getAttributes().getCacheWriter();
    }

    protected void createBridgeServer(int port) throws IOException {
        CacheServer bridge = this.getCache().addCacheServer();
        bridge.setPort(port);
        bridge.setMaxThreads(this.getMaxThreads());
        bridgeServerPort = bridge.getPort();
    }

    protected void startBridgeServer(int port) throws IOException {
        this.startBridgeServer(port, -1);
    }

    protected void startBridgeServer(int port, int socketBufferSize) throws IOException {
        this.startBridgeServer(port, socketBufferSize, 5000L);
    }

    protected void startBridgeServer(int port, int socketBufferSize, long loadPollInterval) throws IOException {
        Cache cache = this.getCache();
        CacheServer bridge = cache.addCacheServer();
        bridge.setPort(port);
        if (socketBufferSize != -1) {
            bridge.setSocketBufferSize(socketBufferSize);
        }
        bridge.setMaxThreads(this.getMaxThreads());
        bridge.setLoadPollInterval(loadPollInterval);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected int getMaxThreads() {
        return 0;
    }

    void stopBridgeServer(Cache cache) {
        CacheServer bridge = (CacheServer)cache.getCacheServers().iterator().next();
        bridge.stop();
        ConnectionPoolDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    void stopBridgeServers(Cache cache) {
        CacheServer bridge2 = null;
        for (CacheServer bridge2 : cache.getCacheServers()) {
            bridge2.stop();
            ConnectionPoolDUnitTest.assertFalse((boolean)bridge2.isRunning());
        }
    }

    private void restartBridgeServers(Cache cache) throws IOException {
        CacheServer bridge2 = null;
        for (CacheServer bridge2 : cache.getCacheServers()) {
            bridge2.start();
            ConnectionPoolDUnitTest.assertTrue((boolean)bridge2.isRunning());
        }
    }

    protected InternalDistributedSystem createLonerDS() {
        ConnectionPoolDUnitTest.disconnectFromDS();
        InternalDistributedSystem ds = this.getLonerSystem();
        ConnectionPoolDUnitTest.assertEquals((int)0, (int)ds.getDistributionManager().getOtherDistributionManagerIds().size());
        return ds;
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        return factory.create();
    }

    private static String createBridgeClientConnection(String host, int[] ports) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("name" + i + "=");
            sb.append(host + ":" + ports[i]);
        }
        return sb.toString();
    }

    protected static EntryEvent createFakeyEntryEvent(final Region r) {
        return new EntryEvent(){

            public Operation getOperation() {
                return Operation.LOCAL_LOAD_CREATE;
            }

            public Region getRegion() {
                return r;
            }

            public Object getKey() {
                return null;
            }

            public Object getOldValue() {
                return null;
            }

            public boolean isOldValueAvailable() {
                return true;
            }

            public Object getNewValue() {
                return null;
            }

            public boolean isLocalLoad() {
                return false;
            }

            public boolean isNetLoad() {
                return false;
            }

            public boolean isLoad() {
                return true;
            }

            public boolean isNetSearch() {
                return false;
            }

            public TransactionId getTransactionId() {
                return null;
            }

            public Object getCallbackArgument() {
                return null;
            }

            public boolean isCallbackArgumentAvailable() {
                return true;
            }

            public boolean isOriginRemote() {
                return false;
            }

            public DistributedMember getDistributedMember() {
                return null;
            }

            public boolean isExpiration() {
                return false;
            }

            public boolean isDistributed() {
                return false;
            }

            public boolean isBridgeEvent() {
                return this.hasClientOrigin();
            }

            public boolean hasClientOrigin() {
                return false;
            }

            public ClientProxyMembershipID getContext() {
                return null;
            }

            public SerializedCacheValue getSerializedOldValue() {
                return null;
            }

            public SerializedCacheValue getSerializedNewValue() {
                return null;
            }
        };
    }

    private void runGets(String name, String objectName) throws Throwable {
        int threadCount = 40;
        TestRunnable[] runnables = new TestRunnable[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            String objectRequested = objectName + i;
            runnables[i] = new GetKey(objectRequested, this, name, 10);
        }
        new MultiThreadedTestRunner(runnables).runTestRunnables();
    }

    private void startRunningGets(String name, String objectName) throws Throwable {
        this.timeToStop.set(false);
        int threadCount = 10;
        final TestRunnable[] runnables = new TestRunnable[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            String objectRequested = objectName + i;
            runnables[i] = new GetKey(objectRequested, this, name, this.timeToStop);
        }
        this.gettorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new MultiThreadedTestRunner(runnables).runTestRunnables();
                }
                catch (Throwable ex) {
                    DistributedTestCase.fail("unexpected exception", ex);
                }
            }
        });
        this.gettorThread.start();
    }

    private void stopRunningGets() throws InterruptedException {
        this.timeToStop.set(true);
        try {
            DistributedTestCase.join(this.gettorThread, 30000L, ConnectionPoolDUnitTest.getLogWriter());
        }
        finally {
            this.gettorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBridgeLoaderFailover() throws CacheException, InterruptedException, Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "A";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create ACK Region on Server"){

            @Override
            public void run2() {
                try {
                    CacheLoader cl = new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            return helper.getKey();
                        }

                        public void close() {
                        }
                    };
                    AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                    Region region = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name));
                    ConnectionPoolDUnitTest.this.startBridgeServer(0, -1, 100L);
                }
                catch (Exception e) {
                    ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    TestCase.fail((String)"Failed to start CacheServer");
                }
            }
        };
        vm0.invoke(create);
        port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        vm1.invoke(create);
        port2 = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        SerializableRunnable killCacheServer = new SerializableRunnable("Kill CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        };
        final int[] restartPort = new int[1];
        SerializableRunnable reStartCacheServer = new SerializableRunnable("Restart CacheServer"){

            @Override
            public void run() {
                try {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    TestCase.assertNotNull((Object)region);
                    ConnectionPoolDUnitTest.this.startBridgeServer(restartPort[0], -1, 100L);
                }
                catch (Exception e) {
                    ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    DistributedTestCase.fail("Failed to start CacheServer", e);
                }
            }
        };
        try {
            this.getLonerSystem();
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setConcurrencyChecksEnabled(false);
            BridgeTestCase.configureConnectionPool(factory, ConnectionPoolDUnitTest.getServerHostName(host), port, port2, false, -1, 0, null, 900, 500, true, 500);
            this.createRegion(name, factory.create());
            ConnectionPoolDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        }
        catch (CacheException ex) {
            ConnectionPoolDUnitTest.fail("While creating LOCAL region on Edge", ex);
        }
        PoolImpl pool = ConnectionPoolDUnitTest.getPool(this.getRootRegion().getSubregion(name));
        this.verifyServerCount(pool, 0);
        String expected = "java.net.ConnectException";
        String addExpected = "<ExpectedException action=add>java.net.ConnectException</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>java.net.ConnectException</ExpectedException>";
        String expected2 = "java.io.IOException";
        String addExpected2 = "<ExpectedException action=add>java.io.IOException</ExpectedException>";
        String removeExpected2 = "<ExpectedException action=remove>java.io.IOException</ExpectedException>";
        this.getCache().getLogger().info("<ExpectedException action=add>java.net.ConnectException</ExpectedException>");
        this.getCache().getLogger().info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
        try {
            this.runGets(name, "A");
            this.verifyServerCount(pool, 2);
            vm0.invoke(killCacheServer);
            this.verifyServerCount(pool, 0);
            this.runGets(name, "A");
            this.verifyServerCount(pool, 1);
        }
        finally {
            this.getCache().getLogger().info("<ExpectedException action=remove>java.net.ConnectException</ExpectedException>");
            this.getCache().getLogger().info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
        }
        restartPort[0] = port;
        vm0.invoke(reStartCacheServer);
        int port3 = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        ConnectionPoolDUnitTest.assertTrue((port3 == port ? 1 : 0) != 0);
        this.verifyServerCount(pool, 0);
        this.waitForBlacklistToClear(pool);
        this.startRunningGets(name, "A");
        try {
            this.verifyBalanced(pool, 2, 5);
            Thread.sleep(1000L);
            this.verifyBalanced(pool, 2, 5);
            Thread.sleep(1000L);
            this.verifyBalanced(pool, 2, 5);
        }
        finally {
            this.stopRunningGets();
        }
        this.getRootRegion().getSubregion(name).localDestroyRegion();
        vm0.invoke(killCacheServer);
        vm1.invoke(killCacheServer);
    }

    public void verifyBalanced(final PoolImpl pool, int expectedServer, final int expectedConsPerServer) {
        this.verifyServerCount(pool, expectedServer);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ConnectionPoolDUnitTest.this.balanced(pool, expectedConsPerServer);
            }

            @Override
            public String description() {
                return "expected " + expectedConsPerServer + " but endpoints=" + ConnectionPoolDUnitTest.this.outOfBalanceReport(pool);
            }
        };
        DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
        ConnectionPoolDUnitTest.assertEquals((String)("expected " + expectedConsPerServer + " but endpoints=" + this.outOfBalanceReport(pool)), (boolean)true, (boolean)this.balanced(pool, expectedConsPerServer));
    }

    protected boolean balanced(PoolImpl pool, int expectedConsPerServer) {
        for (Endpoint ep : pool.getEndpointMap().values()) {
            if (ep.getStats().getConnections() == expectedConsPerServer) continue;
            return false;
        }
        return true;
    }

    protected String outOfBalanceReport(PoolImpl pool) {
        StringBuffer result = new StringBuffer();
        Iterator it = pool.getEndpointMap().values().iterator();
        result.append("<");
        while (it.hasNext()) {
            Endpoint ep = (Endpoint)it.next();
            result.append("ep=" + ep);
            result.append(" conCount=" + ep.getStats().getConnections());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(">");
        return result.toString();
    }

    public void waitForBlacklistToClear(final PoolImpl pool) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pool.getBlacklistedServers().size() == 0;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
        ConnectionPoolDUnitTest.assertEquals((String)("unexpected blacklistedServers=" + pool.getBlacklistedServers()), (int)0, (int)pool.getBlacklistedServers().size());
    }

    public void verifyServerCount(final PoolImpl pool, final int expectedCount) {
        this.getCache().getLogger().info("verifyServerCount expects=" + expectedCount);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int actual = pool.getConnectedServerCount();
                if (actual == expectedCount) {
                    return true;
                }
                this.excuse = "Found only " + actual + " servers, expected " + expectedCount;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 300000L, 200L, true);
    }

    public void testCallbackArg() throws CacheException {
        final String name = this.getName();
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String createCallbackArg = "CREATE CALLBACK ARG";
        final String updateCallbackArg = "PUT CALLBACK ARG";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                TestCacheWriter cw = new TestCacheWriter(){

                    @Override
                    public final void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                        Object beca = event.getCallbackArgument();
                        TestCase.assertEquals((Object)updateCallbackArg, (Object)beca);
                    }

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                        Object beca = event.getCallbackArgument();
                        TestCase.assertEquals((Object)createCallbackArg, (Object)beca);
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, cw);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        final int port2 = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                System.out.println("!!!!!!!!!!!!!!!!! Host:" + host0 + " port:" + port + " port2:" + port2);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), port, port2, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Add entries"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (i = 0; i < 10; ++i) {
                    region.create((Object)new Integer(i), (Object)("old" + i), createCallbackArg);
                }
                for (i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("new" + i), updateCallbackArg);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check cache writer"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCacheWriter writer = ConnectionPoolDUnitTest.getTestWriter(region);
                TestCase.assertTrue((boolean)writer.wasInvoked());
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testCallbackArg2() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String createCallbackArg = "CREATE CALLBACK ARG";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                TestCacheWriter cw = new TestCacheWriter(){

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                        Integer key = (Integer)event.getKey();
                        if (key % 2 == 0) {
                            Object beca = event.getCallbackArgument();
                            TestCase.assertEquals((Object)createCallbackArg, (Object)beca);
                        } else {
                            Object beca = event.getCallbackArgument();
                            TestCase.assertNull((Object)beca);
                        }
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, cw);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        final int port2 = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, port2, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Add entries"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    if (i % 2 == 0) {
                        region.create((Object)new Integer(i), (Object)("old" + i), createCallbackArg);
                        continue;
                    }
                    region.create((Object)new Integer(i), (Object)("old" + i));
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm0.invoke(new CacheSerializableRunnable("Check cache writer"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCacheWriter writer = ConnectionPoolDUnitTest.getTestWriter(region);
                TestCase.assertTrue((boolean)writer.wasInvoked());
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBug36684() throws CacheException, InterruptedException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerMirroredAckRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        this.getSystem().getLogWriter().info("before create server");
        vm0.invoke(createServer);
        vm1.invoke(createServer);
        int numberOfKeys = 1000;
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(host);
        final int vm0Port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final int vm1Port = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createClient = new CacheSerializableRunnable("Create Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                numberOfAfterInvalidates = 0;
                numberOfAfterCreates = 0;
                numberOfAfterUpdates = 0;
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, vm0Port, vm1Port, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        this.getSystem().getLogWriter().info("before create client");
        vm2.invoke(createClient);
        vm3.invoke(createClient);
        CacheSerializableRunnable initializeClient = new CacheSerializableRunnable("Initialize Client"){

            @Override
            public void run2() throws CacheException {
                numberOfAfterInvalidates = 0;
                numberOfAfterCreates = 0;
                numberOfAfterUpdates = 0;
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    String expected = "key-" + i;
                    String actual = (String)region.get((Object)("key-" + i));
                    TestCase.assertEquals((String)expected, (String)actual);
                }
            }
        };
        this.getSystem().getLogWriter().info("before initialize client");
        AsyncInvocation inv2 = vm2.invokeAsync(initializeClient);
        AsyncInvocation inv3 = vm3.invokeAsync(initializeClient);
        DistributedTestCase.join(inv2, 30000L, ConnectionPoolDUnitTest.getLogWriter());
        DistributedTestCase.join(inv3, 30000L, ConnectionPoolDUnitTest.getLogWriter());
        if (inv2.exceptionOccurred()) {
            ConnectionPoolDUnitTest.fail("Error occured in vm2", inv2.getException());
        }
        if (inv3.exceptionOccurred()) {
            ConnectionPoolDUnitTest.fail("Error occured in vm3", inv3.getException());
        }
    }

    public void testForCacheLoaderException() throws CacheException, InterruptedException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        System.out.println("### CALLING CACHE LOADER....");
                        throw new CacheLoaderException("Test for CahceLoaderException causing Client connection to disconnect.");
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerMirroredAckRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        this.getSystem().getLogWriter().info("before create server");
        server.invoke(createServer);
        int numberOfKeys = 10;
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(host);
        final int[] port = new int[]{server.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort")};
        String poolName = "myPool";
        CacheSerializableRunnable createClient = new CacheSerializableRunnable("Create Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPoolWithName(factory, host0, port, true, -1, -1, null, "myPool");
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        this.getSystem().getLogWriter().info("before create client");
        client.invoke(createClient);
        CacheSerializableRunnable invokeServerCacheLaoder = new CacheSerializableRunnable("Initialize Client"){

            @Override
            public void run2() throws CacheException {
                int oldDisConnects;
                int oldConnects;
                PoolStats stats;
                block4: {
                    LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    stats = ((PoolImpl)PoolManager.find((String)"myPool")).getStats();
                    oldConnects = stats.getConnects();
                    oldDisConnects = stats.getDisConnects();
                    try {
                        for (int i = 0; i < 10; ++i) {
                            region.get((Object)("key-" + i));
                        }
                    }
                    catch (Exception ex) {
                        if (ex.getCause() instanceof CacheLoaderException) break block4;
                        TestCase.fail((String)("UnExpected Exception, expected to receive CacheLoaderException from server, instead found: " + ex.getCause().getClass()));
                    }
                }
                int newConnects = stats.getConnects();
                int newDisConnects = stats.getDisConnects();
                if (newConnects != oldConnects && newDisConnects != oldDisConnects) {
                    TestCase.fail((String)"New connection has created for Server side CacheLoaderException.");
                }
            }
        };
        this.getSystem().getLogWriter().info("before initialize client");
        AsyncInvocation inv2 = client.invokeAsync(invokeServerCacheLaoder);
        DistributedTestCase.join(inv2, 30000L, ConnectionPoolDUnitTest.getLogWriter());
        SerializableRunnable stopServer = new SerializableRunnable("stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        };
        server.invoke(stopServer);
    }

    public void testBridgeLoader() throws CacheException, InterruptedException, Throwable {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "A";
        String objectRequested = "A";
        SerializableRunnable killCacheServer = new SerializableRunnable("Kill CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        };
        server0.invoke(new SerializableRunnable("Create ACK Region on Server"){

            @Override
            public void run() {
                try {
                    CacheLoader cl = new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            return helper.getKey();
                        }

                        public void close() {
                        }
                    };
                    AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                    Region region = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name));
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("Failed creating ACK Region on Server", ex);
                }
                catch (Exception e) {
                    ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    TestCase.fail((String)"Failed to start CacheServer on VM1");
                }
            }
        });
        port = server0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        server1.invoke(new SerializableRunnable("Create ACK Region on Server"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setConcurrencyChecksEnabled(false);
                    factory.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            return helper.getKey();
                        }

                        public void close() {
                        }
                    });
                    Region region = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name));
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("Failed creating ACK Region on Server", ex);
                }
                catch (Exception e) {
                    ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    TestCase.fail((String)"Failed to start CacheServer on VM1");
                }
            }
        });
        port2 = server1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        Region region = null;
        try {
            this.getLonerSystem();
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setConcurrencyChecksEnabled(false);
            BridgeTestCase.configureConnectionPool(factory, ConnectionPoolDUnitTest.getServerHostName(host), port, port2, false, -1, -1, null);
            region = this.createRegion(name, factory.create());
            ConnectionPoolDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
            region.create((Object)"A", null);
        }
        catch (CacheException ex) {
            ConnectionPoolDUnitTest.fail("While creating ACK region on Edge", ex);
        }
        int threadCount = 40;
        TestRunnable[] runnables = new TestRunnable[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            objectRequested = "A" + i;
            runnables[i] = new GetKey(objectRequested, this, name, 10);
        }
        MultiThreadedTestRunner mttr = new MultiThreadedTestRunner(runnables);
        mttr.runTestRunnables();
        region.localDestroyRegion();
        server0.invoke(killCacheServer);
        server1.invoke(killCacheServer);
    }

    protected void validateDS() {
        List l = InternalDistributedSystem.getExistingSystems();
        if (l.size() > 1) {
            this.getSystem().getLogWriter().info("validateDS: size=" + l.size() + " isDedicatedAdminVM=" + DistributionManager.isDedicatedAdminVM + " l=" + l);
        }
        ConnectionPoolDUnitTest.assertFalse((boolean)DistributionManager.isDedicatedAdminVM);
        ConnectionPoolDUnitTest.assertEquals((int)1, (int)l.size());
    }

    public void testBridgeWriter() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setConcurrencyChecksEnabled(false);
                factory.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey().toString();
                    }

                    public void close() {
                    }
                });
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                ConnectionPoolDUnitTest.this.validateDS();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Get values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)new Integer(i));
                    TestCase.assertEquals((Object)String.valueOf(i), (Object)value);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Update values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)new Integer(i));
                }
            }
        });
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Validate values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)new Integer(i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof Integer));
                    TestCase.assertEquals((int)i, (int)((Integer)value));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                String pName = region.getAttributes().getPoolName();
                PoolImpl p = (PoolImpl)PoolManager.find((String)pName);
                TestCase.assertEquals((boolean)false, (boolean)p.isDestroyed());
                TestCase.assertEquals((int)1, (int)p.getAttachCount());
                try {
                    p.destroy();
                    TestCase.fail((String)"expected IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                region.localDestroyRegion();
                TestCase.assertEquals((boolean)false, (boolean)p.isDestroyed());
                TestCase.assertEquals((int)0, (int)p.getAttachCount());
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBridgeServerFailoverCnx1() throws CacheException {
        ConnectionPoolDUnitTest.disconnectAllFromDS();
        this.basicTestBridgeServerFailover(1);
    }

    public void testBridgeServerFailoverCnx0() throws CacheException {
        this.basicTestBridgeServerFailover(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestBridgeServerFailover(final int cnxCount) throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable createCacheServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        vm0.invoke(createCacheServer);
        vm1.invoke(createCacheServer);
        final int port0 = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        final int port1 = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port0, port1, true, -1, cnxCount, null, 100);
                Region region = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                region.put((Object)"keyInit", (Object)new Integer(0));
                region.put((Object)"keyInit2", (Object)new Integer(0));
            }
        };
        vm2.invoke(create);
        vm2.invokeAsync(new CacheSerializableRunnable("Put objects"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    for (int i = 0; i < 100000; ++i) {
                        region.put((Object)"keyAI", (Object)new Integer(i));
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
                catch (NoAvailableServersException noAvailableServersException) {
                }
                catch (RegionDestroyedException regionDestroyedException) {
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        });
        CacheSerializableRunnable verify1Server = new CacheSerializableRunnable("verify1Server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                PoolImpl pool = ConnectionPoolDUnitTest.getPool(region);
                ConnectionPoolDUnitTest.this.verifyServerCount(pool, 1);
            }
        };
        CacheSerializableRunnable verify2Servers = new CacheSerializableRunnable("verify2Servers"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                PoolImpl pool = ConnectionPoolDUnitTest.getPool(region);
                ConnectionPoolDUnitTest.this.verifyServerCount(pool, 2);
            }
        };
        vm2.invoke(verify2Servers);
        SerializableRunnable stopCacheServer = new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        };
        String expected = "java.io.IOException";
        String addExpected = "<ExpectedException action=add>java.io.IOException</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>java.io.IOException</ExpectedException>";
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
                bgexecLogger.info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
            }
        });
        try {
            vm1.invoke(stopCacheServer);
            vm2.invoke(verify1Server);
            final int restartPort = port1;
            vm1.invoke(new SerializableRunnable("Restart CacheServer"){

                @Override
                public void run() {
                    try {
                        Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                        TestCase.assertNotNull((Object)region);
                        ConnectionPoolDUnitTest.this.startBridgeServer(restartPort);
                    }
                    catch (Exception e) {
                        ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                        DistributedTestCase.fail("Failed to start CacheServer", e);
                    }
                }
            });
            vm2.invoke(verify2Servers);
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
                    bgexecLogger.info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
                }
            });
        }
        catch (Throwable throwable) {
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        vm0.invoke(stopCacheServer);
        vm2.invoke(verify1Server);
        ConnectionPoolDUnitTest.getLogWriter().info("FIXME: this thread does not terminate");
        vm2.invoke(new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm1.invoke(stopCacheServer);
    }

    public void testLifetimeExpireOnTL() throws CacheException {
        this.basicTestLifetimeExpire(true);
    }

    public void testLifetimeExpireOnPoolCnx() throws CacheException {
        this.basicTestLifetimeExpire(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestLifetimeExpire(final boolean threadLocal) throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        AsyncInvocation putAI = null;
        AsyncInvocation putAI2 = null;
        try {
            CacheSerializableRunnable createCacheServer = new CacheSerializableRunnable("Create Cache Server"){

                @Override
                public void run2() throws CacheException {
                    AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                    factory.setCacheListener((CacheListener)new DelayListener(25));
                    ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                    try {
                        ConnectionPoolDUnitTest.this.startBridgeServer(0);
                    }
                    catch (Exception ex) {
                        DistributedTestCase.fail("While starting CacheServer", ex);
                    }
                }
            };
            vm0.invoke(createCacheServer);
            final int port0 = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
            final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
            vm1.invoke(createCacheServer);
            final int port1 = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
            SerializableRunnable stopCacheServer = new SerializableRunnable("Stop CacheServer"){

                @Override
                public void run() {
                    ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
                }
            };
            vm1.invoke(stopCacheServer);
            CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

                @Override
                public void run2() throws CacheException {
                    ConnectionPoolDUnitTest.this.getLonerSystem();
                    ConnectionPoolDUnitTest.this.getCache();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.LOCAL);
                    factory.setConcurrencyChecksEnabled(false);
                    BridgeTestCase.configureConnectionPool(factory, host0, port0, port1, false, -1, 0, null, 100, 500, threadLocal, 500);
                    Region region = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                    region.put((Object)"keyInit", (Object)new Integer(0));
                    region.put((Object)"keyInit2", (Object)new Integer(0));
                }
            };
            vm2.invoke(create);
            CacheSerializableRunnable putter1 = new CacheSerializableRunnable("Put objects"){

                @Override
                public void run2() throws CacheException {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    PoolImpl pool = ConnectionPoolDUnitTest.getPool(region);
                    PoolStats stats = pool.getStats();
                    baselineLifetimeCheck = stats.getLoadConditioningCheck();
                    baselineLifetimeExtensions = stats.getLoadConditioningExtensions();
                    baselineLifetimeConnect = stats.getLoadConditioningConnect();
                    baselineLifetimeDisconnect = stats.getLoadConditioningDisconnect();
                    try {
                        int count = 0;
                        while (!stopTestLifetimeExpire) {
                            region.put((Object)"keyAI1", (Object)new Integer(++count));
                        }
                    }
                    catch (NoAvailableServersException ex) {
                        if (stopTestLifetimeExpire) {
                            return;
                        }
                        throw ex;
                    }
                }
            };
            CacheSerializableRunnable putter2 = new CacheSerializableRunnable("Put objects"){

                @Override
                public void run2() throws CacheException {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    try {
                        int count = 0;
                        while (!stopTestLifetimeExpire) {
                            region.put((Object)"keyAI2", (Object)new Integer(++count));
                        }
                    }
                    catch (NoAvailableServersException ex) {
                        if (stopTestLifetimeExpire) {
                            return;
                        }
                        throw ex;
                    }
                }
            };
            putAI = vm2.invokeAsync(putter1);
            putAI2 = vm2.invokeAsync(putter2);
            CacheSerializableRunnable verify1Server = new CacheSerializableRunnable("verify1Server"){

                @Override
                public void run2() throws CacheException {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    PoolImpl pool = ConnectionPoolDUnitTest.getPool(region);
                    final PoolStats stats = pool.getStats();
                    ConnectionPoolDUnitTest.this.verifyServerCount(pool, 1);
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return stats.getLoadConditioningCheck() >= 10 + baselineLifetimeCheck;
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                    TestCase.assertTrue((String)("baselineLifetimeCheck=" + baselineLifetimeCheck + " but stats.getLoadConditioningCheck()=" + stats.getLoadConditioningCheck()), (stats.getLoadConditioningCheck() >= 10 + baselineLifetimeCheck ? 1 : 0) != 0);
                    baselineLifetimeCheck = stats.getLoadConditioningCheck();
                    TestCase.assertTrue((stats.getLoadConditioningExtensions() > baselineLifetimeExtensions ? 1 : 0) != 0);
                    TestCase.assertTrue((stats.getLoadConditioningConnect() == baselineLifetimeConnect ? 1 : 0) != 0);
                    TestCase.assertTrue((stats.getLoadConditioningDisconnect() == baselineLifetimeDisconnect ? 1 : 0) != 0);
                }
            };
            CacheSerializableRunnable verify2Servers = new CacheSerializableRunnable("verify2Servers"){

                @Override
                public void run2() throws CacheException {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    PoolImpl pool = ConnectionPoolDUnitTest.getPool(region);
                    final PoolStats stats = pool.getStats();
                    ConnectionPoolDUnitTest.this.verifyServerCount(pool, 2);
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                        String excuse;

                        @Override
                        public boolean done() {
                            int expected;
                            int actual = stats.getLoadConditioningCheck();
                            if (actual >= (expected = 10 + baselineLifetimeCheck)) {
                                return true;
                            }
                            this.excuse = "Bug 39209 expected " + actual + " to be >= " + expected;
                            return false;
                        }

                        @Override
                        public String description() {
                            return this.excuse;
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
                    TestCase.assertTrue((stats.getLoadConditioningConnect() > baselineLifetimeConnect ? 1 : 0) != 0);
                    TestCase.assertTrue((stats.getLoadConditioningDisconnect() > baselineLifetimeDisconnect ? 1 : 0) != 0);
                }
            };
            vm2.invoke(verify1Server);
            ConnectionPoolDUnitTest.assertEquals((boolean)true, (boolean)putAI.isAlive());
            ConnectionPoolDUnitTest.assertEquals((boolean)true, (boolean)putAI2.isAlive());
            final int restartPort = port1;
            vm1.invoke(new SerializableRunnable("Restart CacheServer"){

                @Override
                public void run() {
                    try {
                        Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                        TestCase.assertNotNull((Object)region);
                        ConnectionPoolDUnitTest.this.startBridgeServer(restartPort);
                    }
                    catch (Exception e) {
                        ConnectionPoolDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                        DistributedTestCase.fail("Failed to start CacheServer", e);
                    }
                }
            });
            vm2.invoke(verify2Servers);
            ConnectionPoolDUnitTest.assertEquals((boolean)true, (boolean)putAI.isAlive());
            ConnectionPoolDUnitTest.assertEquals((boolean)true, (boolean)putAI2.isAlive());
            vm2.invoke(new SerializableRunnable("Stop Putters"){

                @Override
                public void run() {
                    stopTestLifetimeExpire = true;
                }
            });
        }
        catch (Throwable throwable) {
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            try {
                if (putAI != null) {
                    DistributedTestCase.join(putAI, 30000L, ConnectionPoolDUnitTest.getLogWriter());
                    if (putAI.exceptionOccurred()) {
                        ConnectionPoolDUnitTest.fail("While putting entries: ", putAI.getException());
                    }
                }
                if (putAI2 != null) {
                    DistributedTestCase.join(putAI, 30000L, ConnectionPoolDUnitTest.getLogWriter());
                }
                vm2.invoke(new SerializableRunnable("Stop Putters"){

                    @Override
                    public void run() {
                        stopTestLifetimeExpire = false;
                    }
                });
                vm2.invoke(new CacheSerializableRunnable("Close BridgeWriter", name){
                    final /* synthetic */ String val$name;
                    {
                        this.val$name = string;
                        super(name);
                    }

                    @Override
                    public void run2() throws CacheException {
                        Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(this.val$name);
                        String poolName = region.getAttributes().getPoolName();
                        region.localDestroyRegion();
                        PoolManager.find((String)poolName).destroy();
                    }
                });
            }
            catch (Throwable throwable2) {
                vm2.invoke(new /* invalid duplicate definition of identical inner class */);
                vm2.invoke(new /* invalid duplicate definition of identical inner class */);
                SerializableRunnable stopCacheServer = new SerializableRunnable("Stop CacheServer"){

                    @Override
                    public void run() {
                        ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
                    }
                };
                vm1.invoke(stopCacheServer);
                vm0.invoke(stopCacheServer);
                throw throwable2;
            }
            SerializableRunnable stopCacheServer = new /* invalid duplicate definition of identical inner class */;
            vm1.invoke(stopCacheServer);
            vm0.invoke(stopCacheServer);
            throw throwable;
        }
        try {
            if (putAI != null) {
                DistributedTestCase.join(putAI, 30000L, ConnectionPoolDUnitTest.getLogWriter());
                if (putAI.exceptionOccurred()) {
                    ConnectionPoolDUnitTest.fail("While putting entries: ", putAI.getException());
                }
            }
            if (putAI2 != null) {
                DistributedTestCase.join(putAI, 30000L, ConnectionPoolDUnitTest.getLogWriter());
            }
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable throwable) {
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            SerializableRunnable stopCacheServer = new /* invalid duplicate definition of identical inner class */;
            vm1.invoke(stopCacheServer);
            vm0.invoke(stopCacheServer);
            throw throwable;
        }
        SerializableRunnable stopCacheServer = new /* invalid duplicate definition of identical inner class */;
        vm1.invoke(stopCacheServer);
        vm0.invoke(stopCacheServer);
    }

    public void testBridgeWriterCreate() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, false, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.create((Object)new Integer(i), (Object)new Integer(i));
                }
            }
        });
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Validate values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)new Integer(i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof Integer));
                    TestCase.assertEquals((int)i, (int)((Integer)value));
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBridgeWriterPut() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable createBridgeWriter = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, false, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(createBridgeWriter);
        vm1.invoke(new CacheSerializableRunnable("Put values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-string-" + i), (Object)("value-" + i));
                    Order order = new Order();
                    order.init(i);
                    region.put((Object)("key-object-" + i), (Object)order);
                    region.put((Object)("key-bytes-" + i), (Object)("value-" + i).getBytes());
                }
            }
        });
        vm2.invoke(createBridgeWriter);
        vm2.invoke(new CacheSerializableRunnable("Get / validate string values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-string-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof String));
                    TestCase.assertEquals((Object)("value-" + i), (Object)value);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Get / validate object values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-object-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof Order));
                    TestCase.assertEquals((int)i, (int)((Order)value).getIndex());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Get / validate byte[] values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-bytes-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof byte[]));
                    TestCase.assertEquals((String)("value-" + i), (String)new String((byte[])value));
                }
            }
        });
        CacheSerializableRunnable closeBridgeWriter = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(closeBridgeWriter);
        vm2.invoke(closeBridgeWriter);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBridgeWriterPutNoDeserialize() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable createBridgeWriter = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, false, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(createBridgeWriter);
        vm1.invoke(new CacheSerializableRunnable("Put values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-string-" + i), (Object)("value-" + i));
                    Order order = new Order();
                    order.init(i);
                    region.put((Object)("key-object-" + i), (Object)order);
                    region.put((Object)("key-bytes-" + i), (Object)("value-" + i).getBytes());
                }
            }
        });
        vm2.invoke(createBridgeWriter);
        vm2.invoke(new CacheSerializableRunnable("Get / validate string values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-string-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof String));
                    TestCase.assertEquals((Object)("value-" + i), (Object)value);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Get / validate object values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-object-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof Order));
                    TestCase.assertEquals((int)i, (int)((Order)value).getIndex());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Get / validate byte[] values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Object value = region.get((Object)("key-bytes-" + i));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertTrue((boolean)(value instanceof byte[]));
                    TestCase.assertEquals((String)("value-" + i), (String)new String((byte[])value));
                }
            }
        });
        CacheSerializableRunnable closeBridgeWriter = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(closeBridgeWriter);
        vm2.invoke(closeBridgeWriter);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
    }

    public void testInvalidateAndDestroyPropagation() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                CertifiableTestCacheListener l = new CertifiableTestCacheListener(DistributedTestCase.getLogWriter());
                factory.setCacheListener((CacheListener)l);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("old" + i));
                }
            }
        });
        vm2.invoke(create);
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Turn on history"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                ctl.enableEventHistory();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Update region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("new" + i), (Object)("callbackArg" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    ctl.waitForInvalidated(key);
                    Region.Entry entry = region.getEntry((Object)key);
                    TestCase.assertNotNull((Object)entry);
                    TestCase.assertNull((Object)entry.getValue());
                }
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals((Object)("old" + i), (Object)ee.getOldValue());
                    TestCase.assertEquals((Object)Operation.INVALIDATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("callbackArg" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Validate original and destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    TestCase.assertEquals((Object)("new" + i), (Object)region.getEntry((Object)key).getValue());
                    region.destroy((Object)key, (Object)("destroyCB" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify destroys"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    ctl.waitForDestroyed(key);
                    Region.Entry entry = region.getEntry((Object)key);
                    TestCase.assertNull((Object)entry);
                }
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((Object)Operation.DESTROY, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("destroyCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("recreate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    region.create((Object)key, (Object)("create" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify creates"){

            @Override
            public void run2() throws CacheException {
                Integer key;
                int i;
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                List l = ctl.getEventHistory();
                DistributedTestCase.getLogWriter().info("history (should be empty): " + l);
                TestCase.assertEquals((int)0, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    TestCase.assertEquals((Object)("create" + i), (Object)region.get((Object)key, (Object)("loadCB" + i)));
                }
                l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    DistributedTestCase.getLogWriter().info("processing " + ee);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((Object)("create" + i), (Object)ee.getNewValue());
                    TestCase.assertEquals((Object)Operation.LOCAL_LOAD_CREATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("loadCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOriginRemote());
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testInvalidateAndDestroyToEmptyAllPropagation() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable createEmpty = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                CertifiableTestCacheListener l = new CertifiableTestCacheListener(DistributedTestCase.getLogWriter());
                factory.setCacheListener((CacheListener)l);
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        CacheSerializableRunnable createNormal = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                CertifiableTestCacheListener l = new CertifiableTestCacheListener(DistributedTestCase.getLogWriter());
                factory.setCacheListener((CacheListener)l);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        vm1.invoke(createEmpty);
        vm1.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("old" + i));
                }
            }
        });
        vm2.invoke(createNormal);
        vm1.invoke(new CacheSerializableRunnable("Turn on history"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                ctl.enableEventHistory();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Update region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("new" + i), (Object)("callbackArg" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    ctl.waitForInvalidated(key);
                    Region.Entry entry = region.getEntry((Object)key);
                    TestCase.assertNull((Object)entry);
                }
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOldValueAvailable());
                    TestCase.assertEquals((Object)Operation.INVALIDATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("callbackArg" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Validate original and destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    TestCase.assertEquals((Object)("new" + i), (Object)region.getEntry((Object)key).getValue());
                    region.destroy((Object)key, (Object)("destroyCB" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify destroys"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    ctl.waitForDestroyed(key);
                    Region.Entry entry = region.getEntry((Object)key);
                    TestCase.assertNull((Object)entry);
                }
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOldValueAvailable());
                    TestCase.assertEquals((Object)Operation.DESTROY, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("destroyCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("recreate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    region.create((Object)key, (Object)("create" + i), (Object)("createCB" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify creates"){

            @Override
            public void run2() throws CacheException {
                EntryEvent ee;
                Integer key;
                int i;
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i2 = 0; i2 < 10; ++i2) {
                    Integer key2 = new Integer(i2);
                    ctl.waitForInvalidated(key2);
                    Region.Entry entry = region.getEntry((Object)key2);
                    TestCase.assertNull((Object)entry);
                }
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOldValueAvailable());
                    TestCase.assertEquals((Object)Operation.INVALIDATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("createCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                }
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    TestCase.assertEquals((Object)("create" + i), (Object)region.get((Object)key, (Object)("loadCB" + i)));
                }
                l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((Object)("create" + i), (Object)ee.getNewValue());
                    TestCase.assertEquals((Object)Operation.LOCAL_LOAD_CREATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("loadCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOriginRemote());
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testInvalidateAndDestroyToEmptyCCPropagation() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable createEmpty = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                CertifiableTestCacheListener l = new CertifiableTestCacheListener(DistributedTestCase.getLogWriter());
                factory.setCacheListener((CacheListener)l);
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT));
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        CacheSerializableRunnable createNormal = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                CertifiableTestCacheListener l = new CertifiableTestCacheListener(DistributedTestCase.getLogWriter());
                factory.setCacheListener((CacheListener)l);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        vm1.invoke(createEmpty);
        vm1.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("old" + i));
                }
            }
        });
        vm2.invoke(createNormal);
        vm1.invoke(new CacheSerializableRunnable("Turn on history"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                ctl.enableEventHistory();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Update region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)("new" + i), (Object)("callbackArg" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)0, (int)l.size());
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Validate original and destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    TestCase.assertEquals((Object)("new" + i), (Object)region.getEntry((Object)key).getValue());
                    region.destroy((Object)key, (Object)("destroyCB" + i));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify destroys"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)0, (int)l.size());
            }
        });
        vm2.invoke(new CacheSerializableRunnable("recreate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Integer key = new Integer(i);
                    region.create((Object)key, (Object)("create" + i), (Object)("createCB" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Verify creates"){

            @Override
            public void run2() throws CacheException {
                Integer key;
                int i;
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                List l = ctl.getEventHistory();
                TestCase.assertEquals((int)0, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    TestCase.assertEquals((Object)("create" + i), (Object)region.get((Object)key, (Object)("loadCB" + i)));
                }
                l = ctl.getEventHistory();
                TestCase.assertEquals((int)10, (int)l.size());
                for (i = 0; i < 10; ++i) {
                    key = new Integer(i);
                    EntryEvent ee = (EntryEvent)l.get(i);
                    TestCase.assertEquals((Object)key, (Object)ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getOldValue());
                    TestCase.assertEquals((Object)("create" + i), (Object)ee.getNewValue());
                    TestCase.assertEquals((Object)Operation.LOCAL_LOAD_CREATE, (Object)ee.getOperation());
                    TestCase.assertEquals((Object)("loadCB" + i), (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)false, (boolean)ee.isOriginRemote());
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public AttributesFactory getBridgeServerRegionAttributes(CacheLoader cl, CacheWriter cw) {
        AttributesFactory ret = new AttributesFactory();
        if (cl != null) {
            ret.setCacheLoader(cl);
        }
        if (cw != null) {
            ret.setCacheWriter(cw);
        }
        ret.setScope(Scope.DISTRIBUTED_ACK);
        ret.setConcurrencyChecksEnabled(false);
        return ret;
    }

    public AttributesFactory getBridgeServerMirroredRegionAttributes(CacheLoader cl, CacheWriter cw) {
        AttributesFactory ret = new AttributesFactory();
        if (cl != null) {
            ret.setCacheLoader(cl);
        }
        if (cw != null) {
            ret.setCacheWriter(cw);
        }
        ret.setScope(Scope.DISTRIBUTED_NO_ACK);
        ret.setDataPolicy(DataPolicy.REPLICATE);
        ret.setConcurrencyChecksEnabled(false);
        return ret;
    }

    public AttributesFactory getBridgeServerMirroredAckRegionAttributes(CacheLoader cl, CacheWriter cw) {
        AttributesFactory ret = new AttributesFactory();
        if (cl != null) {
            ret.setCacheLoader(cl);
        }
        if (cw != null) {
            ret.setCacheWriter(cw);
        }
        ret.setScope(Scope.DISTRIBUTED_ACK);
        ret.setConcurrencyChecksEnabled(false);
        ret.setMirrorType(MirrorType.KEYS_VALUES);
        return ret;
    }

    public void testOnlyRequestedUpdates() throws Exception {
        final String name1 = this.getName() + "-1";
        final String name2 = this.getName() + "-2";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name1, factory.create());
                ConnectionPoolDUnitTest.this.createRegion(name2, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create regions"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name1, factory.create());
                rgn.registerInterestRegex(".*", false, false);
                rgn = ConnectionPoolDUnitTest.this.createRegion(name2, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name1, factory.create());
                rgn.registerInterestRegex(".*", false, false);
                ConnectionPoolDUnitTest.this.createRegion(name2, factory.create());
            }
        });
        CacheSerializableRunnable populate = new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name1);
                for (int i = 0; i < 10; ++i) {
                    region1.put((Object)new Integer(i), (Object)("Region1Old" + i));
                }
                Region region2 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name2);
                for (int i = 0; i < 10; ++i) {
                    region2.put((Object)new Integer(i), (Object)("Region2Old" + i));
                }
            }
        };
        vm1.invoke(populate);
        vm2.invoke(populate);
        vm1.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name1);
                for (int i = 0; i < 10; ++i) {
                    region1.put((Object)new Integer(i), (Object)("Region1New" + i));
                }
                Region region2 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name2);
                for (int i = 0; i < 10; ++i) {
                    region2.put((Object)new Integer(i), (Object)("Region2New" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm2.invoke(new CacheSerializableRunnable("Validate"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name1);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)("Region1New" + i), (Object)region1.get((Object)new Integer(i)));
                }
                Region region2 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name2);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)("Region2Old" + i), (Object)region2.get((Object)new Integer(i)));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name1);
                region1.localDestroyRegion();
                Region region2 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name2);
                region2.localDestroyRegion();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name1);
                region1.localDestroyRegion();
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testInterestKeyRegistration() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.get((Object)"key-1"), (Object)"key-1");
                TestCase.assertEquals((Object)region.get((Object)"key-2"), (Object)"key-2");
                try {
                    region.registerInterest((Object)"key-1");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.get((Object)"key-1"), (Object)"key-1");
                TestCase.assertEquals((Object)region.get((Object)"key-2"), (Object)"key-2");
                try {
                    region.registerInterest((Object)"key-2");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"vm1-key-1");
                region.put((Object)"key-2", (Object)"vm1-key-2");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm1-key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm1-key-2");
            }
        });
        ConnectionPoolDUnitTest.pause(500);
        vm2.invoke(new CacheSerializableRunnable("Validate Entries"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm1-key-2");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"vm2-key-1");
                region.put((Object)"key-2", (Object)"vm2-key-2");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm2-key-2");
            }
        });
        ConnectionPoolDUnitTest.pause(500);
        vm1.invoke(new CacheSerializableRunnable("Validate Entries"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm1-key-2");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Unregister Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.unregisterInterest((Object)"key-1");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Unregister Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.unregisterInterest((Object)"key-2");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"vm1-key-1-again");
                region.put((Object)"key-2", (Object)"vm1-key-2-again");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm1-key-1-again");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm1-key-2-again");
            }
        });
        ConnectionPoolDUnitTest.pause(500);
        vm2.invoke(new CacheSerializableRunnable("Validate Entries"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm2-key-2");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"vm2-key-1-again");
                region.put((Object)"key-2", (Object)"vm2-key-2-again");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1-again");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm2-key-2-again");
            }
        });
        ConnectionPoolDUnitTest.pause(500);
        vm1.invoke(new CacheSerializableRunnable("Validate Entries"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm1-key-1-again");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-2").getValue(), (Object)"vm1-key-2-again");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Unregister Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.unregisterInterest((Object)"key-1");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Unregister Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.unregisterInterest((Object)"key-2");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testInterestListRegistration() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.get((Object)"key-1"), (Object)"key-1");
                TestCase.assertEquals((Object)region.get((Object)"key-6"), (Object)"key-6");
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("key-1");
                    list.add("key-2");
                    list.add("key-3");
                    list.add("key-4");
                    list.add("key-5");
                    region.registerInterest(list);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.get((Object)"key-1"), (Object)"key-1");
                TestCase.assertEquals((Object)region.get((Object)"key-6"), (Object)"key-6");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"vm2-key-1");
                region.put((Object)"key-6", (Object)"vm2-key-6");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-6").getValue(), (Object)"vm2-key-6");
            }
        });
        ConnectionPoolDUnitTest.pause(5000);
        vm1.invoke(new CacheSerializableRunnable("Validate Entries"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)region.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
                TestCase.assertEquals((Object)region.getEntry((Object)"key-6").getValue(), (Object)"key-6");
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    protected static int getCacheServerPort() {
        return bridgeServerPort;
    }

    protected static long getNumberOfAfterCreates() {
        return numberOfAfterCreates;
    }

    protected static long getNumberOfAfterUpdates() {
        return numberOfAfterUpdates;
    }

    protected static long getNumberOfAfterInvalidates() {
        return numberOfAfterInvalidates;
    }

    protected Cache createDynamicRegionCache(String testName, BridgeWriter w) {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, w, false));
        ConnectionPoolDUnitTest.getLogWriter().info("CREATED IT");
        Cache z = this.getCache();
        return z;
    }

    protected Cache createDynamicRegionCache(String testName, String connectionPoolName) {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, connectionPoolName, false, true));
        ConnectionPoolDUnitTest.getLogWriter().info("CREATED IT");
        Cache z = this.getCache();
        return z;
    }

    public static void waitForEntry(final Region r, final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.containsValueForKey(key);
            }

            @Override
            public String description() {
                return "Waiting for entry " + key + " on region " + r;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
    }

    public static Region waitForSubRegion(final Region r, final String subRegName) {
        long MAXWAIT = 10000L;
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.getSubregion(subRegName) != null;
            }

            @Override
            public String description() {
                return "Waiting for subregion " + subRegName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        Region result = r.getSubregion(subRegName);
        return result;
    }

    public void createBridgeServer(VM vm, final String rName, final int port, boolean notifyBySubscription) {
        vm.invoke(new CacheSerializableRunnable("Create Region on Server"){

            @Override
            public void run2() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setConcurrencyChecksEnabled(false);
                    factory.setCacheLoader((CacheLoader)new BridgeServerCacheLoader());
                    CacheTestCase.beginCacheXml();
                    ConnectionPoolDUnitTest.this.createRegion(rName, factory.create());
                    ConnectionPoolDUnitTest.this.startBridgeServer(port);
                    ConnectionPoolDUnitTest.this.finishCacheXml(rName + "-" + port);
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(rName);
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(rName));
                    region.put((Object)"BridgeServer", (Object)new Integer(port));
                }
                catch (Exception e) {
                    ConnectionPoolDUnitTest.this.getSystem().getLogWriter().severe((Throwable)e);
                    TestCase.fail((String)("Failed to start CacheServer " + e));
                }
            }
        });
    }

    public void testClientGetOfInvalidServerEntry() throws CacheException {
        final String regionName1 = this.getName() + "-1";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(2);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(regionName1, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        server1.invoke(createServer);
        final int port = server1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(server1.getHost());
        server1.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(regionName1);
                region1.create((Object)"key-string-1", null);
            }
        });
        CacheSerializableRunnable createBridgeLoader2 = new CacheSerializableRunnable("Create region 2"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                regionFactory.setConcurrencyChecksEnabled(false);
                DistributedTestCase.getLogWriter().info("ZZZZZ host0:" + host0 + " port:" + port);
                BridgeTestCase.configureConnectionPool(regionFactory, host0, port, -1, false, -1, -1, null);
                DistributedTestCase.getLogWriter().info("ZZZZZDone host0:" + host0 + " port:" + port);
                ConnectionPoolDUnitTest.this.createRegion(regionName1, regionFactory.create());
            }
        };
        client.invoke(createBridgeLoader2);
        client.invoke(new CacheSerializableRunnable("get values on client"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(regionName1);
                TestCase.assertEquals(null, (Object)region1.getEntry((Object)"key-string-1"));
                TestCase.assertEquals(null, (Object)region1.get((Object)"key-string-1"));
            }
        });
        server1.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testClientRegisterUnregisterRequests() throws CacheException {
        final String regionName1 = this.getName() + "-1";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(2);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(regionName1, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        server1.invoke(createServer);
        final int port = server1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(server1.getHost());
        CacheSerializableRunnable createBridgeWriter = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                Region region1 = null;
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                regionFactory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(regionFactory, host0, port, -1, true, -1, -1, null);
                region1 = ConnectionPoolDUnitTest.this.createRegion(regionName1, regionFactory.create());
                region1.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
            }
        };
        client.invoke(createBridgeWriter);
        server1.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(regionName1);
                for (int i = 0; i < 20; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("value-" + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Put values client"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(regionName1);
                for (int i = 0; i < 10; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("client-value-" + i));
                }
            }
        });
        CacheSerializableRunnable closeBridgeWriter = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region1 = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(regionName1);
                String pName = region1.getAttributes().getPoolName();
                region1.localDestroyRegion();
                PoolImpl p = (PoolImpl)PoolManager.find((String)pName);
                p.destroy();
            }
        };
        client.invoke(closeBridgeWriter);
        CacheSerializableRunnable validateClientRegisterUnRegister = new CacheSerializableRunnable("validate Client Register UnRegister"){

            @Override
            public void run2() throws CacheException {
                for (BridgeServerImpl bsi : ConnectionPoolDUnitTest.this.getCache().getCacheServers()) {
                    final CacheClientNotifierStats ccnStats = bsi.getAcceptor().getCacheClientNotifier().getStats();
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return ccnStats.getClientRegisterRequests() == ccnStats.getClientUnRegisterRequests();
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 62000L, 200L, true);
                    TestCase.assertEquals((String)"HealthMonitor Client Register/UnRegister mismatch.", (int)ccnStats.getClientRegisterRequests(), (int)ccnStats.getClientUnRegisterRequests());
                }
            }
        };
        server1.invoke(validateClientRegisterUnRegister);
        server1.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testContainsKeyOnServer() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, false, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        final Integer key1 = new Integer(0);
        String key2 = "0";
        vm2.invoke(new CacheSerializableRunnable("Contains key on server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                boolean containsKey = false;
                containsKey = region.containsKeyOnServer((Object)key1);
                TestCase.assertFalse((boolean)containsKey);
                containsKey = region.containsKeyOnServer((Object)"0");
                TestCase.assertFalse((boolean)containsKey);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Put values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)new Integer(0), (Object)new Integer(0));
                region.put((Object)"0", (Object)"0");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Contains key on server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                boolean containsKey = false;
                containsKey = region.containsKeyOnServer((Object)key1);
                TestCase.assertTrue((boolean)containsKey);
                containsKey = region.containsKeyOnServer((Object)"0");
                TestCase.assertTrue((boolean)containsKey);
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testCreateNullValue() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String createCallbackArg = "CREATE CALLBACK ARG";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Create nulls"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.create((Object)new Integer(i), null, createCallbackArg);
                }
            }
        });
        ConnectionPoolDUnitTest.pause(1000);
        vm2.invoke(new CacheSerializableRunnable("Verify invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    TestCase.assertNotNull((Object)entry);
                    TestCase.assertNull((Object)entry.getValue());
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Attempt to create values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.create((Object)new Integer(i), (Object)("new" + i));
                }
            }
        });
        ConnectionPoolDUnitTest.pause(1000);
        vm2.invoke(new CacheSerializableRunnable("Verify invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    TestCase.assertNotNull((Object)entry);
                    TestCase.assertNull((Object)entry.getValue());
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testDestroy() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String callbackArg = "DESTROY CALLBACK";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                TestCacheWriter cw = new TestCacheWriter(){

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
                        Object beca = event.getCallbackArgument();
                        TestCase.assertEquals((Object)callbackArg, (Object)beca);
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, cw);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                rgn.registerInterestRegex(".*", false, false);
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)String.valueOf(i));
                }
            }
        });
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Load region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)String.valueOf(i), (Object)region.get((Object)new Integer(i)));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Local destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.localDestroy((Object)new Integer(i));
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("No destroy propagate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)String.valueOf(i), (Object)region.get((Object)new Integer(i)));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Fetch from server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)String.valueOf(i), (Object)region.get((Object)new Integer(i)));
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check no server cache writer"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCacheWriter writer = ConnectionPoolDUnitTest.getTestWriter(region);
                writer.wasInvoked();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Distributed destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.destroy((Object)new Integer(i), callbackArg);
                }
            }
        });
        ConnectionPoolDUnitTest.pause(1000);
        vm1.invoke(new CacheSerializableRunnable("Attempt get from server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertNull((Object)region.getEntry((Object)new Integer(i)));
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Validate destroy propagate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertNull((Object)region.getEntry((Object)new Integer(i)));
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void todo_testDestroyRegion() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String callbackArg = "DESTROY CALLBACK";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                TestCacheWriter cw = new TestCacheWriter(){

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeRegionDestroy2(RegionEvent event) throws CacheWriterException {
                        TestCase.assertEquals((Object)callbackArg, (Object)event.getCallbackArgument());
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, cw);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Local destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
                TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name));
            }
        });
        vm2.invoke(new CacheSerializableRunnable("No destroy propagate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check no server cache writer"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCacheWriter writer = ConnectionPoolDUnitTest.getTestWriter(region);
                writer.wasInvoked();
            }
        });
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Distributed destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region);
                region.destroyRegion(callbackArg);
                TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name));
            }
        });
        ConnectionPoolDUnitTest.pause(1000);
        vm2.invoke(new CacheSerializableRunnable("Verify destroy propagate"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                TestCase.assertNull((Object)region);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testDPEmptyInterestListRegistrationWithCallbackArg() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                factory.addCacheListener((CacheListener)new ControlListener());
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        CacheSerializableRunnable createPublisher = new CacheSerializableRunnable("Create publisher region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                factory.addCacheListener((CacheListener)new ControlListener());
                factory.setDataPolicy(DataPolicy.EMPTY);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(createPublisher);
        vm1.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.registerInterest((Object)"key-1", InterestResultPolicy.NONE);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.create((Object)"key-1", (Object)"key-1-create", (Object)"key-1-create");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"key-1-update", (Object)"key-1-update");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.destroy((Object)"key-1", (Object)"key-1-destroy");
            }
        });
        CacheSerializableRunnable assertEvents = new CacheSerializableRunnable("Verify events"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                ControlListener listener = (ControlListener)region.getAttributes().getCacheListeners()[0];
                int eventCount = 3;
                listener.waitWhileNotEnoughEvents(60000L, eventCount);
                TestCase.assertEquals((int)eventCount, (int)listener.events.size());
                EventWrapper ew = (EventWrapper)listener.events.get(0);
                TestCase.assertEquals((int)0, (int)ew.type);
                String key = "key-1";
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals(null, (Object)ew.event.getOldValue());
                TestCase.assertEquals((boolean)false, (boolean)ew.event.isOldValueAvailable());
                TestCase.assertEquals((Object)"key-1-create", (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.CREATE, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-create", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
                ew = (EventWrapper)listener.events.get(1);
                TestCase.assertEquals((int)1, (int)ew.type);
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals(null, (Object)ew.event.getOldValue());
                TestCase.assertEquals((boolean)false, (boolean)ew.event.isOldValueAvailable());
                TestCase.assertEquals((Object)"key-1-update", (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.UPDATE, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-update", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
                ew = (EventWrapper)listener.events.get(2);
                TestCase.assertEquals((int)3, (int)ew.type);
                TestCase.assertEquals((Object)"key-1-destroy", (Object)ew.arg);
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals(null, (Object)ew.event.getOldValue());
                TestCase.assertEquals((boolean)false, (boolean)ew.event.isOldValueAvailable());
                TestCase.assertEquals(null, (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.DESTROY, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-destroy", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
            }
        };
        vm1.invoke(assertEvents);
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testDPEmptyCCInterestListRegistrationWithCallbackArg() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                factory.setCacheListener((CacheListener)new ControlListener());
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT));
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        CacheSerializableRunnable createPublisher = new CacheSerializableRunnable("Create publisher region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                factory.setCacheListener((CacheListener)new ControlListener());
                factory.setDataPolicy(DataPolicy.EMPTY);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(createPublisher);
        vm1.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.registerInterest((Object)"key-1", InterestResultPolicy.NONE);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.create((Object)"key-1", (Object)"key-1-create", (Object)"key-1-create");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"key-1-update", (Object)"key-1-update");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.destroy((Object)"key-1", (Object)"key-1-destroy");
            }
        });
        CacheSerializableRunnable assertEvents = new CacheSerializableRunnable("Verify events"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                ControlListener listener = (ControlListener)region.getAttributes().getCacheListeners()[0];
                DistributedTestCase.pause(1000);
                TestCase.assertEquals((int)0, (int)listener.events.size());
            }
        };
        vm1.invoke(assertEvents);
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDynamicRegionCreation() throws Exception {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM client1 = host.getVM(0);
        VM srv1 = host.getVM(2);
        VM srv2 = host.getVM(3);
        final String k1 = name + "-key1";
        final String v1 = name + "-val1";
        final String k2 = name + "-key2";
        final String v2 = name + "-val2";
        final String k3 = name + "-key3";
        final String v3 = name + "-val3";
        client1.invoke(DistributedTestCase.class, "disconnectFromDS");
        srv1.invoke(DistributedTestCase.class, "disconnectFromDS");
        srv2.invoke(DistributedTestCase.class, "disconnectFromDS");
        try {
            CacheSerializableRunnable ccs = new CacheSerializableRunnable("Create Cache Server"){

                @Override
                public void run2() throws CacheException {
                    ConnectionPoolDUnitTest.this.createDynamicRegionCache(name, (BridgeWriter)null);
                    TestCase.assertTrue((boolean)DynamicRegionFactory.get().isOpen());
                    try {
                        ConnectionPoolDUnitTest.this.startBridgeServer(0);
                    }
                    catch (IOException ugh) {
                        TestCase.fail((String)"Bridge Server startup failed");
                    }
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setConcurrencyChecksEnabled(false);
                    Region region = ConnectionPoolDUnitTest.this.createRootRegion(name, factory.create());
                    region.put((Object)k1, (Object)v1);
                    Assert.assertTrue((boolean)region.get((Object)k1).equals(v1));
                }
            };
            srv1.invoke(ccs);
            srv2.invoke(ccs);
            final String srv1Host = ConnectionPoolDUnitTest.getServerHostName(srv1.getHost());
            final int srv1Port = srv1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
            final int srv2Port = srv2.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
            client1.invoke(new CacheSerializableRunnable("Create Cache Client"){

                @Override
                public void run2() throws CacheException {
                    ConnectionPoolDUnitTest.this.createLonerDS();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setConcurrencyChecksEnabled(false);
                    Pool cp = BridgeTestCase.configureConnectionPool(factory, srv1Host, srv1Port, srv2Port, true, -1, -1, null);
                    final PoolImpl pool = (PoolImpl)cp;
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            if (pool.getPrimary() == null) {
                                return false;
                            }
                            return pool.getRedundants().size() >= 1;
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                    TestCase.assertNotNull((Object)pool.getPrimary());
                    TestCase.assertTrue((String)("backups=" + pool.getRedundants() + " expected=" + 1), (pool.getRedundants().size() >= 1 ? 1 : 0) != 0);
                    ConnectionPoolDUnitTest.this.createDynamicRegionCache(name, "testPool");
                    TestCase.assertTrue((boolean)DynamicRegionFactory.get().isOpen());
                    factory.setScope(Scope.LOCAL);
                    factory.setConcurrencyChecksEnabled(false);
                    factory.setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                    Region region = ConnectionPoolDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.assertNull((Object)region.getEntry((Object)k1));
                    region.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES);
                    TestCase.assertEquals((Object)v1, (Object)region.getEntry((Object)k1).getValue());
                    TestCase.assertNull((Object)region.getEntry((Object)k2));
                    region.put((Object)k2, (Object)v2);
                    TestCase.assertEquals((Object)v2, (Object)region.getEntry((Object)k2).getValue());
                    region.put((Object)k3, (Object)v3);
                }
            });
            srv1.invoke(new CacheSerializableRunnable("Validate Server1 update"){

                @Override
                public void run2() throws CacheException {
                    CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                    final CacheClientNotifierStats ccnStats = ccn.getStats();
                    final int eventCount = ccnStats.getEvents();
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    TestCase.assertEquals((Object)v2, (Object)r.getEntry((Object)k2).getValue());
                    TestCase.assertEquals((Object)v3, (Object)r.getEntry((Object)k3).getValue());
                    r.put((Object)k3, (Object)v1);
                    int maxTime = 20000;
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return ccnStats.getEvents() > eventCount;
                        }

                        @Override
                        public String description() {
                            return "waiting for ccnStat";
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
                }
            });
            srv2.invoke(new CacheSerializableRunnable("Validate Server2 update"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    TestCase.assertEquals((Object)v2, (Object)r.getEntry((Object)k2).getValue());
                    TestCase.assertEquals((Object)v1, (Object)r.getEntry((Object)k3).getValue());
                }
            });
            client1.invoke(new CacheSerializableRunnable("Validate Client notification"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)r.getAttributes().getCacheListener();
                    ctl.waitForUpdated(k3);
                    TestCase.assertEquals((Object)v1, (Object)r.getEntry((Object)k3).getValue());
                }
            });
            final String v1Dynamic = v1 + "dynamic";
            final String dynFromClientName = name + "-dynamic-client";
            final String dynFromServerName = name + "-dynamic-server";
            client1.invoke(new CacheSerializableRunnable("Client dynamic region creation"){

                @Override
                public void run2() throws CacheException {
                    TestCase.assertTrue((boolean)DynamicRegionFactory.get().isOpen());
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    Region dr = DynamicRegionFactory.get().createDynamicRegion(name, dynFromClientName);
                    TestCase.assertNull((Object)dr.get((Object)k1));
                    dr.put((Object)k1, (Object)v1Dynamic);
                    TestCase.assertEquals((Object)v1Dynamic, (Object)dr.getEntry((Object)k1).getValue());
                }
            });
            CacheSerializableRunnable valDR = new CacheSerializableRunnable("Validate dynamic region creation on server"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    long end = System.currentTimeMillis() + 10000L;
                    Region dr = null;
                    while (true) {
                        try {
                            dr = r.getSubregion(dynFromClientName);
                            TestCase.assertNotNull((Object)dr);
                            TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(name + "/" + dynFromClientName));
                        }
                        catch (AssertionFailedError e) {
                            if (System.currentTimeMillis() <= end) continue;
                            throw e;
                        }
                        break;
                    }
                    TestCase.assertEquals((Object)v1Dynamic, (Object)dr.getEntry((Object)k1).getValue());
                }
            };
            srv1.invoke(valDR);
            srv2.invoke(valDR);
            client1.invoke(new CacheSerializableRunnable("Client dynamic region destruction"){

                @Override
                public void run2() throws CacheException {
                    TestCase.assertTrue((boolean)DynamicRegionFactory.get().isActive());
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    String drName = r.getFullPath() + "/" + dynFromClientName;
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                    DynamicRegionFactory.get().destroyDynamicRegion(drName);
                    TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                }
            });
            CacheSerializableRunnable valNoDR = new CacheSerializableRunnable("Validate dynamic region destruction on server"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    String drName = r.getFullPath() + "/" + dynFromClientName;
                    TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                    try {
                        DynamicRegionFactory.get().destroyDynamicRegion(drName);
                        TestCase.fail((String)"expected RegionDestroyedException");
                    }
                    catch (RegionDestroyedException regionDestroyedException) {
                        // empty catch block
                    }
                }
            };
            srv1.invoke(valNoDR);
            srv2.invoke(valNoDR);
            srv2.invoke(new CacheSerializableRunnable("Server dynamic region creation"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    Region dr = DynamicRegionFactory.get().createDynamicRegion(name, dynFromServerName);
                    TestCase.assertNull((Object)dr.get((Object)k1));
                    dr.put((Object)k1, (Object)v1Dynamic);
                    TestCase.assertEquals((Object)v1Dynamic, (Object)dr.getEntry((Object)k1).getValue());
                }
            });
            srv1.invoke(new CacheSerializableRunnable("Validate dynamic region creation propagation to other server"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    Region dr = ConnectionPoolDUnitTest.waitForSubRegion(r, dynFromServerName);
                    TestCase.assertNotNull((Object)dr);
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(name + "/" + dynFromServerName));
                    ConnectionPoolDUnitTest.waitForEntry(dr, k1);
                    TestCase.assertNotNull((Object)dr.getEntry((Object)k1));
                    TestCase.assertEquals((Object)v1Dynamic, (Object)dr.getEntry((Object)k1).getValue());
                }
            });
            client1.invoke(new CacheSerializableRunnable("Validate dynamic region creation on client"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    long end = System.currentTimeMillis() + 10000L;
                    Region dr = null;
                    while (true) {
                        try {
                            dr = r.getSubregion(dynFromServerName);
                            TestCase.assertNotNull((Object)dr);
                            TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(name + "/" + dynFromServerName));
                        }
                        catch (AssertionFailedError e) {
                            if (System.currentTimeMillis() > end) {
                                throw e;
                            }
                            DistributedTestCase.pause(1000);
                            continue;
                        }
                        break;
                    }
                    ConnectionPoolDUnitTest.waitForEntry(dr, k1);
                    TestCase.assertNotNull((Object)dr.getEntry((Object)k1));
                    TestCase.assertEquals((Object)v1Dynamic, (Object)dr.getEntry((Object)k1).getValue());
                }
            });
            srv2.invoke(new CacheSerializableRunnable("Server dynamic region destruction"){

                @Override
                public void run2() throws CacheException {
                    TestCase.assertTrue((boolean)DynamicRegionFactory.get().isActive());
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    String drName = r.getFullPath() + "/" + dynFromServerName;
                    TestCase.assertNotNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                    DynamicRegionFactory.get().destroyDynamicRegion(drName);
                    TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                }
            });
            srv1.invoke(new CacheSerializableRunnable("Validate dynamic region destruction on other server"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    String drName = r.getFullPath() + "/" + dynFromServerName;
                    int retry = 100;
                    while (retry-- > 0 && ConnectionPoolDUnitTest.this.getCache().getRegion(drName) != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ignore) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                }
            });
            client1.invoke(new CacheSerializableRunnable("Validate dynamic region destruction on client"){

                @Override
                public void run2() throws CacheException {
                    Region r = ConnectionPoolDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    String drName = r.getFullPath() + "/" + dynFromServerName;
                    int retry = 100;
                    while (retry-- > 0 && ConnectionPoolDUnitTest.this.getCache().getRegion(drName) != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ignore) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    TestCase.assertNull((Object)ConnectionPoolDUnitTest.this.getCache().getRegion(drName));
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        TestCase.fail((String)"interrupted");
                    }
                    try {
                        DynamicRegionFactory.get().destroyDynamicRegion(drName);
                        TestCase.fail((String)"expected RegionDestroyedException");
                    }
                    catch (RegionDestroyedException regionDestroyedException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            client1.invoke(DistributedTestCase.class, "disconnectFromDS");
            srv1.invoke(DistributedTestCase.class, "disconnectFromDS");
            srv2.invoke(DistributedTestCase.class, "disconnectFromDS");
        }
    }

    public void testEmptyByteArray() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String createCallbackArg = "CREATE CALLBACK ARG";
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create empty byte array"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1; ++i) {
                    region.create((Object)new Integer(i), (Object)new byte[0], createCallbackArg);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify values on client"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1; ++i) {
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    TestCase.assertNotNull((Object)entry);
                    byte[] value = (byte[])entry.getValue();
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((int)0, (int)value.length);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify values on server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1; ++i) {
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    TestCase.assertNotNull((Object)entry);
                    byte[] value = (byte[])entry.getValue();
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((int)0, (int)value.length);
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testInterestListRegistrationWithCallbackArg() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                factory.setCacheListener((CacheListener)new ControlListener());
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create Entries and Register Interest"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                try {
                    region.registerInterest((Object)"key-1", InterestResultPolicy.NONE);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While registering interest: ", ex);
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.create((Object)"key-1", (Object)"key-1-create", (Object)"key-1-create");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Put Value"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.put((Object)"key-1", (Object)"key-1-update", (Object)"key-1-update");
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.destroy((Object)"key-1", (Object)"key-1-destroy");
            }
        });
        CacheSerializableRunnable assertEvents = new CacheSerializableRunnable("Verify events"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                ControlListener listener = (ControlListener)region.getAttributes().getCacheListeners()[0];
                int eventCount = 3;
                listener.waitWhileNotEnoughEvents(60000L, eventCount);
                TestCase.assertEquals((int)eventCount, (int)listener.events.size());
                EventWrapper ew = (EventWrapper)listener.events.get(0);
                TestCase.assertEquals((int)ew.type, (int)0);
                String key = "key-1";
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals(null, (Object)ew.event.getOldValue());
                TestCase.assertEquals((Object)"key-1-create", (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.CREATE, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-create", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
                ew = (EventWrapper)listener.events.get(1);
                TestCase.assertEquals((int)ew.type, (int)1);
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals((Object)"key-1-create", (Object)ew.event.getOldValue());
                TestCase.assertEquals((Object)"key-1-update", (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.UPDATE, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-update", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
                ew = (EventWrapper)listener.events.get(2);
                TestCase.assertEquals((int)ew.type, (int)3);
                TestCase.assertEquals((Object)"key-1-destroy", (Object)ew.arg);
                TestCase.assertEquals((Object)key, (Object)ew.event.getKey());
                TestCase.assertEquals((Object)"key-1-update", (Object)ew.event.getOldValue());
                TestCase.assertEquals(null, (Object)ew.event.getNewValue());
                TestCase.assertEquals((Object)Operation.DESTROY, (Object)ew.event.getOperation());
                TestCase.assertEquals((Object)"key-1-destroy", (Object)ew.event.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ew.event.isOriginRemote());
            }
        };
        vm1.invoke(assertEvents);
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testKeySetOnServer() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Get keys on server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                Set keySet = region.keySetOnServer();
                TestCase.assertNotNull((Object)keySet);
                TestCase.assertEquals((int)0, (int)keySet.size());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Put values"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)new Integer(i));
                }
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Get keys on server"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                Set keySet = region.keySetOnServer();
                TestCase.assertNotNull((Object)keySet);
                TestCase.assertEquals((int)10, (int)keySet.size());
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm2.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testNotSerializableException() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerRegionAttributes(null, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        final int port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(vm0.getHost());
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                ConnectionPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Attempt to create a non-serializable value"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    try {
                        region.create((Object)new Integer(1), (Object)new BridgeLoaderTestNonSerializable());
                        TestCase.fail((String)"Should not have been able to create a BridgeLoaderTestNonSerializable");
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof NotSerializableException) break block2;
                        TestCase.fail((String)("Unexpected exception while creating a non-serializable value " + e));
                    }
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Attempt to put a non-serializable value"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    try {
                        region.put((Object)new Integer(1), (Object)new BridgeLoaderTestNonSerializable());
                        TestCase.fail((String)"Should not have been able to put a BridgeLoaderTestNonSerializable");
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof NotSerializableException) break block2;
                        TestCase.fail((String)("Unexpected exception while putting a non-serializable value " + e));
                    }
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Attempt to get a non-serializable key"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                    try {
                        region.get((Object)new BridgeLoaderTestNonSerializable());
                        TestCase.fail((String)"Should not have been able to get a BridgeLoaderTestNonSerializable");
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof NotSerializableException) break block2;
                        TestCase.fail((String)("Unexpected exception while getting a non-serializable key " + e));
                    }
                }
            }
        });
        CacheSerializableRunnable close = new CacheSerializableRunnable("Close BridgeWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        };
        vm1.invoke(close);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                ConnectionPoolDUnitTest.this.stopBridgeServer(ConnectionPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testNotifyAllUpdates() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        ConnectionPoolDUnitTest.disconnectAllFromDS();
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) {
                        return helper.getKey();
                    }

                    public void close() {
                    }
                };
                AttributesFactory factory = ConnectionPoolDUnitTest.this.getBridgeServerMirroredAckRegionAttributes(cl, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        this.getSystem().getLogWriter().info("before create server");
        vm0.invoke(createServer);
        vm1.invoke(createServer);
        int numberOfKeys = 10;
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(host);
        final int vm0Port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        final int vm1Port = vm1.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createClient = new CacheSerializableRunnable("Create Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                numberOfAfterInvalidates = 0;
                numberOfAfterCreates = 0;
                numberOfAfterUpdates = 0;
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, vm0Port, vm1Port, true, -1, -1, null);
                Region rgn = ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        this.getSystem().getLogWriter().info("before create client");
        vm2.invoke(createClient);
        vm3.invoke(createClient);
        CacheSerializableRunnable initializeClient = new CacheSerializableRunnable("Initialize Client"){

            @Override
            public void run2() throws CacheException {
                numberOfAfterInvalidates = 0;
                numberOfAfterCreates = 0;
                numberOfAfterUpdates = 0;
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertEquals((Object)("key-" + i), (Object)region.get((Object)("key-" + i)));
                }
            }
        };
        this.getSystem().getLogWriter().info("before initialize client");
        vm2.invoke(initializeClient);
        vm3.invoke(initializeClient);
        vm2.invoke(new CacheSerializableRunnable("Add CacheListener 1"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CacheListenerAdapter listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent e) {
                        DistributedTestCase.getLogWriter().info("vm2 numberOfAfterCreates: " + ++numberOfAfterCreates);
                    }

                    public void afterUpdate(EntryEvent e) {
                        DistributedTestCase.getLogWriter().info("vm2 numberOfAfterUpdates: " + ++numberOfAfterUpdates);
                    }

                    public void afterInvalidate(EntryEvent e) {
                        DistributedTestCase.getLogWriter().info("vm2 numberOfAfterInvalidates: " + ++numberOfAfterInvalidates);
                    }
                };
                region.getAttributesMutator().setCacheListener((CacheListener)listener);
                region.registerInterestRegex(".*", false, false);
            }
        });
        vm3.invoke(new CacheSerializableRunnable("Add CacheListener 2"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                CacheListenerAdapter listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent e) {
                        ++numberOfAfterCreates;
                    }

                    public void afterUpdate(EntryEvent e) {
                        ++numberOfAfterUpdates;
                    }

                    public void afterInvalidate(EntryEvent e) {
                        ++numberOfAfterInvalidates;
                    }
                };
                region.getAttributesMutator().setCacheListener((CacheListener)listener);
                region.registerInterestRegex(".*", false, false);
            }
        });
        ConnectionPoolDUnitTest.pause(3000);
        this.getSystem().getLogWriter().info("before puts");
        vm2.invoke(new CacheSerializableRunnable("Put New Values"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key-" + i), (Object)("key-" + i));
                }
            }
        });
        this.getSystem().getLogWriter().info("after puts");
        ConnectionPoolDUnitTest.pause(1000);
        int vm2AfterCreates = (int)vm2.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterCreates");
        int vm2AfterUpdates = (int)vm2.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterUpdates");
        int vm2AfterInvalidates = (int)vm2.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterInvalidates");
        int vm3AfterCreates = (int)vm3.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterCreates");
        int vm3AfterUpdates = (int)vm3.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterUpdates");
        int vm3AfterInvalidates = (int)vm3.invokeLong(ConnectionPoolDUnitTest.class, "getNumberOfAfterInvalidates");
        ConnectionPoolDUnitTest.getLogWriter().info("vm2AfterCreates: " + vm2AfterCreates);
        ConnectionPoolDUnitTest.getLogWriter().info("vm2AfterUpdates: " + vm2AfterUpdates);
        ConnectionPoolDUnitTest.getLogWriter().info("vm2AfterInvalidates: " + vm2AfterInvalidates);
        ConnectionPoolDUnitTest.getLogWriter().info("vm3AfterCreates: " + vm3AfterCreates);
        ConnectionPoolDUnitTest.getLogWriter().info("vm3AfterUpdates: " + vm3AfterUpdates);
        ConnectionPoolDUnitTest.getLogWriter().info("vm3AfterInvalidates: " + vm3AfterInvalidates);
        ConnectionPoolDUnitTest.assertTrue((String)"VM2 should not have received any afterCreate messages", (vm2AfterCreates == 0 ? 1 : 0) != 0);
        ConnectionPoolDUnitTest.assertTrue((String)"VM2 should not have received any afterInvalidate messages", (vm2AfterInvalidates == 0 ? 1 : 0) != 0);
        ConnectionPoolDUnitTest.assertTrue((String)("VM2 received " + vm2AfterUpdates + " afterUpdate messages. It should have received " + 10), (vm2AfterUpdates == 10 ? 1 : 0) != 0);
        ConnectionPoolDUnitTest.assertTrue((String)"VM3 should not have received any afterCreate messages", (vm3AfterCreates == 0 ? 1 : 0) != 0);
        ConnectionPoolDUnitTest.assertTrue((String)"VM3 should not have received any afterUpdate messages", (vm3AfterUpdates == 0 ? 1 : 0) != 0);
        ConnectionPoolDUnitTest.assertTrue((String)("VM3 received " + vm3AfterInvalidates + " afterInvalidate messages. It should have received " + 10), (vm3AfterInvalidates == 10 ? 1 : 0) != 0);
    }

    public void testBug39526part1() throws CacheException, InterruptedException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        this.getSystem().getLogWriter().info("before create server");
        vm0.invoke(createServer);
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(host);
        final int vm0Port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createClient = new CacheSerializableRunnable("Create Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, vm0Port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.registerInterestRegex(".*");
            }
        };
        this.getSystem().getLogWriter().info("before create client");
        vm1.invoke(createClient);
        CacheSerializableRunnable doServerTx = new CacheSerializableRunnable("doServerTx"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                Cache cache = ConnectionPoolDUnitTest.this.getCache();
                CacheTransactionManager txmgr = cache.getCacheTransactionManager();
                txmgr.begin();
                try {
                    region.put((Object)"k1", (Object)"v1");
                    region.put((Object)"k2", (Object)"v2");
                    region.put((Object)"k3", (Object)"v3");
                }
                finally {
                    txmgr.commit();
                }
            }
        };
        this.getSystem().getLogWriter().info("before doServerTx");
        vm0.invoke(doServerTx);
        CacheSerializableRunnable validateClient = new CacheSerializableRunnable("Validate Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                final LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.size() == 3;
                    }

                    @Override
                    public String description() {
                        return "waiting for region to be size 3";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)region.containsKey((Object)"k1"));
                TestCase.assertTrue((boolean)region.containsKey((Object)"k2"));
                TestCase.assertTrue((boolean)region.containsKey((Object)"k3"));
                TestCase.assertEquals((Object)"v1", (Object)region.getEntry((Object)"k1").getValue());
                TestCase.assertEquals((Object)"v2", (Object)region.getEntry((Object)"k2").getValue());
                TestCase.assertEquals((Object)"v3", (Object)region.getEntry((Object)"k3").getValue());
            }
        };
        this.getSystem().getLogWriter().info("before confirmCommitOnClient");
        vm1.invoke(validateClient);
    }

    public void testBug39526part2() throws CacheException, InterruptedException {
        ConnectionPoolDUnitTest.disconnectAllFromDS();
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setConcurrencyChecksEnabled(false);
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                try {
                    ConnectionPoolDUnitTest.this.startBridgeServer(0);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        this.getSystem().getLogWriter().info("before create server");
        vm0.invoke(createServer);
        final String host0 = ConnectionPoolDUnitTest.getServerHostName(host);
        final int vm0Port = vm0.invokeInt(ConnectionPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createClient = new CacheSerializableRunnable("Create Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                ConnectionPoolDUnitTest.this.getLonerSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setConcurrencyChecksEnabled(false);
                BridgeTestCase.configureConnectionPool(factory, host0, vm0Port, -1, true, -1, -1, null);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                region.registerInterestRegex(".*");
            }
        };
        this.getSystem().getLogWriter().info("before create client");
        vm1.invoke(createClient);
        CacheSerializableRunnable createServerPeer = new CacheSerializableRunnable("Create Server Peer"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                factory.setConcurrencyChecksEnabled(false);
                ConnectionPoolDUnitTest.this.createRegion(name, factory.create());
            }
        };
        this.getSystem().getLogWriter().info("before create server peer");
        vm2.invoke(createServerPeer);
        CacheSerializableRunnable doServerTx = new CacheSerializableRunnable("doServerTx"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                Cache cache = ConnectionPoolDUnitTest.this.getCache();
                CacheTransactionManager txmgr = cache.getCacheTransactionManager();
                txmgr.begin();
                try {
                    region.put((Object)"k1", (Object)"v1");
                    region.put((Object)"k2", (Object)"v2");
                    region.put((Object)"k3", (Object)"v3");
                }
                finally {
                    txmgr.commit();
                }
            }
        };
        this.getSystem().getLogWriter().info("before doServerTx");
        vm2.invoke(doServerTx);
        CacheSerializableRunnable validateClient = new CacheSerializableRunnable("Validate Cache Server Client"){

            @Override
            public void run2() throws CacheException {
                final LocalRegion region = (LocalRegion)ConnectionPoolDUnitTest.this.getRootRegion().getSubregion(name);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.size() == 3;
                    }

                    @Override
                    public String description() {
                        return "waiting for region to be size 3";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)region.containsKey((Object)"k1"));
                TestCase.assertTrue((boolean)region.containsKey((Object)"k2"));
                TestCase.assertTrue((boolean)region.containsKey((Object)"k3"));
                TestCase.assertEquals((Object)"v1", (Object)region.getEntry((Object)"k1").getValue());
                TestCase.assertEquals((Object)"v2", (Object)region.getEntry((Object)"k2").getValue());
                TestCase.assertEquals((Object)"v3", (Object)region.getEntry((Object)"k3").getValue());
            }
        };
        this.getSystem().getLogWriter().info("before confirmCommitOnClient");
        vm1.invoke(validateClient);
        ConnectionPoolDUnitTest.disconnectAllFromDS();
    }

    static {
        port = 0;
        port2 = 0;
        stopTestLifetimeExpire = false;
    }

    public static class DelayListener
    extends CacheListenerAdapter {
        private final int delay;

        public DelayListener(int delay) {
            this.delay = delay;
        }

        private void delay() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ignore) {
                TestCase.fail((String)"interrupted");
            }
        }

        public void afterCreate(EntryEvent event) {
            this.delay();
        }

        public void afterDestroy(EntryEvent event) {
            this.delay();
        }

        public void afterInvalidate(EntryEvent event) {
            this.delay();
        }

        public void afterRegionDestroy(RegionEvent event) {
            this.delay();
        }

        public void afterRegionCreate(RegionEvent event) {
            this.delay();
        }

        public void afterRegionInvalidate(RegionEvent event) {
            this.delay();
        }

        public void afterUpdate(EntryEvent event) {
            this.delay();
        }

        public void afterRegionClear(RegionEvent event) {
            this.delay();
        }

        public void afterRegionLive(RegionEvent event) {
            this.delay();
        }
    }

    protected class BridgeLoaderTestNonSerializable {
        protected BridgeLoaderTestNonSerializable() {
        }
    }

    public static class BridgeServerCacheLoader
    extends TestCacheLoader
    implements Declarable {
        @Override
        public Object load2(LoaderHelper helper) {
            if (helper.getArgument() instanceof Integer) {
                try {
                    Thread.sleep(((Integer)helper.getArgument()).intValue());
                }
                catch (InterruptedException ugh) {
                    TestCase.fail((String)"interrupted");
                }
            }
            return helper.getKey();
        }

        public void init(Properties props) {
        }
    }

    private class GetKey
    extends TestRunnable {
        private final String key;
        private Object result;
        private final String name;
        ConnectionPoolDUnitTest test;
        int repCount;
        private AB timeToStop;

        protected GetKey(String objectName, ConnectionPoolDUnitTest t, String name, AB timeToStop) {
            this.key = objectName;
            this.test = t;
            this.name = name;
            this.timeToStop = timeToStop;
        }

        protected GetKey(String objectName, ConnectionPoolDUnitTest t, String name, int repCount) {
            this.key = objectName;
            this.test = t;
            this.name = name;
            this.repCount = repCount;
        }

        @Override
        public void runTest() throws Throwable {
            if (this.timeToStop != null) {
                this.getUntilStopped();
            } else {
                this.getForRepCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getForRepCount() throws Throwable {
            Region r = this.test.getRootRegion().getSubregion(this.name);
            PoolImpl pi = (PoolImpl)PoolManager.find((String)r.getAttributes().getPoolName());
            try {
                for (int i = 0; i < this.repCount; ++i) {
                    try {
                        String key = this.key + i;
                        if (r.getEntry((Object)key) != null) {
                            r.localInvalidate((Object)key);
                        }
                        this.result = r.get((Object)key);
                        GetKey.assertTrue((String)("GetKey after get " + key + " result=" + this.result), (pi.getConnectedServerCount() >= 1 ? 1 : 0) != 0);
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        GetKey.fail((String)"interrupted");
                        continue;
                    }
                    catch (ServerConnectivityException sce) {
                        DistributedTestCase.fail("While getting value for ACK region", sce);
                        continue;
                    }
                    catch (TimeoutException te) {
                        DistributedTestCase.fail("While getting value for ACK region", te);
                    }
                }
                GetKey.assertTrue((pi.getConnectedServerCount() >= 1 ? 1 : 0) != 0);
            }
            finally {
                pi.releaseThreadLocalConnection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getUntilStopped() throws Throwable {
            Region r = this.test.getRootRegion().getSubregion(this.name);
            PoolImpl pi = (PoolImpl)PoolManager.find((String)r.getAttributes().getPoolName());
            try {
                int i = 0;
                while (!this.timeToStop.get()) {
                    ++i;
                    try {
                        String key = this.key + i;
                        if (r.getEntry((Object)key) != null) {
                            r.localInvalidate((Object)key);
                        }
                        this.result = r.get((Object)key);
                        GetKey.assertTrue((String)("GetKey after get " + key + " result=" + this.result), (pi.getConnectedServerCount() >= 1 ? 1 : 0) != 0);
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        GetKey.fail((String)"interrupted");
                    }
                    catch (ServerConnectivityException sce) {
                        DistributedTestCase.fail("While getting value for ACK region", sce);
                    }
                    catch (TimeoutException te) {
                        DistributedTestCase.fail("While getting value for ACK region", te);
                    }
                }
                GetKey.assertTrue((pi.getConnectedServerCount() >= 1 ? 1 : 0) != 0);
            }
            finally {
                pi.releaseThreadLocalConnection();
            }
        }
    }

    protected class ConnectionPoolDUnitTestSerializable2
    implements Serializable {
        protected String _key;

        protected ConnectionPoolDUnitTestSerializable2(String key) {
            this._key = key;
        }

        public String getKey() {
            return this._key;
        }
    }

    protected class ControlListener
    extends CacheListenerAdapter {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        protected ControlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 0));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 1));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 2));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 3));
                this.CONTROL_LOCK.notifyAll();
            }
        }
    }

    private class EventWrapper {
        public final EntryEvent event;
        public final Object key;
        public final Object val;
        public final Object arg;
        public final int type;

        public EventWrapper(EntryEvent ee, int type) {
            this.event = ee;
            this.key = ee.getKey();
            this.val = ee.getNewValue();
            this.arg = ee.getCallbackArgument();
            this.type = type;
        }

        public String toString() {
            return "EventWrapper: event=" + this.event + ", type=" + this.type;
        }
    }
}

