/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.stats;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class GemFireMemberPRandVMStatsDUnitTest
extends AdminDUnitTestCase {
    public GemFireMemberPRandVMStatsDUnitTest(String name) {
        super(name);
    }

    protected SystemMember getMember() throws Exception {
        GemFireMemberPRandVMStatsDUnitTest.getLogWriter().info("[getMember]");
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberPRandVMStatsDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                props.setProperty("enable-time-statistics", "true");
                props.setProperty("statistic-sampling-enabled", "true");
                GemFireMemberPRandVMStatsDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberPRandVMStatsDUnitTest.getLogWriter().info("Test: Created DS");
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberPRandVMStatsDUnitTest.this.getSystem());
            }
        });
        GemFireMemberPRandVMStatsDUnitTest.getLogWriter().info("Test: Created Cache");
        Thread.sleep(2000L);
        SystemMember[] members = this.tcSystem.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberPRandVMStatsDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberPRandVMStatsDUnitTest.getLogWriter().info("Test: Created Member");
        return members[0];
    }

    protected long getCpu() {
        StatisticsType type = this.getSystem().findType("VMStats");
        GemFireMemberPRandVMStatsDUnitTest.assertNotNull((Object)type);
        Statistics[] stats = this.getSystem().findStatisticsByType(type);
        assert (stats.length != 0);
        Statistics vmStats = stats[0];
        long result = vmStats.getLong("processCpuTime");
        return result;
    }

    protected int getSampleCount() {
        StatisticsType type = this.getSystem().findType("StatSampler");
        GemFireMemberPRandVMStatsDUnitTest.assertNotNull((Object)type);
        Statistics[] stats = this.getSystem().findStatisticsByType(type);
        assert (stats.length != 0);
        Statistics statSampler = stats[0];
        int result = statSampler.getInt("sampleCount");
        return result;
    }

    public void testProcessCPUTime() throws Exception {
        GemFireMemberPRandVMStatsDUnitTest.getLogWriter().info("[testProcessCPUTime]");
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        this.getMember();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                final InternalDistributedSystem s = GemFireMemberPRandVMStatsDUnitTest.this.getSystem();
                final long startTime = GemFireMemberPRandVMStatsDUnitTest.this.getCpu();
                final int startCount = GemFireMemberPRandVMStatsDUnitTest.this.getSampleCount();
                DistributedTestCase.WaitCriterion wcSampleCount = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        if (GemFireMemberPRandVMStatsDUnitTest.this.getSampleCount() != startCount) {
                            return true;
                        }
                        long fac = 1L;
                        for (int i = 0; i < 100; ++i) {
                            fac = fac * (long)i + (long)s.toString().length();
                        }
                        return GemFireMemberPRandVMStatsDUnitTest.this.getSampleCount() != startCount;
                    }

                    @Override
                    public String description() {
                        return "sampleCount " + startCount + " did not change; did the sampler thread die?";
                    }
                };
                DistributedTestCase.WaitCriterion wcCPU = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        if (GemFireMemberPRandVMStatsDUnitTest.this.getCpu() != startTime) {
                            return true;
                        }
                        long fac = 1L;
                        for (int i = 0; i < 100; ++i) {
                            fac = fac * (long)i + (long)s.toString().length();
                        }
                        return GemFireMemberPRandVMStatsDUnitTest.this.getCpu() != startTime;
                    }

                    @Override
                    public String description() {
                        return "cpu time " + startTime + " did not change (is this an intelligent JIT?)";
                    }
                };
                DistributedTestCase.waitForCriterion(wcSampleCount, 3000L, 200L, true);
                DistributedTestCase.waitForCriterion(wcCPU, 60000L, 200L, true);
            }
        });
    }
}

