/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.statalerts;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.statalerts.FunctionDecoratorImpl;
import com.gemstone.gemfire.internal.admin.statalerts.GaugeThresholdDecoratorImpl;
import com.gemstone.gemfire.internal.admin.statalerts.MultiAttrDefinitionImpl;
import com.gemstone.gemfire.internal.admin.statalerts.NumberThresholdDecoratorImpl;
import com.gemstone.gemfire.internal.admin.statalerts.SingleAttrDefinitionImpl;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class StatAlertDefinitionDUnitTest
extends AdminDUnitTestCase {
    protected static MBeanServerConnection mbsc = null;
    protected static ObjectName systemName = null;

    public StatAlertDefinitionDUnitTest(String name) {
        super(name);
    }

    @Override
    public boolean isJMX() {
        return true;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        mbsc = this.agent.getMBeanServer();
        StatAlertDefinitionDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        systemName = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        StatAlertDefinitionDUnitTest.assertNotNull((Object)systemName);
    }

    protected StatAlertDefinition prepareStatAlertDefinition(String name, StatisticInfo[] statisticInfo, boolean applyFunction, short functionId, Number minVal, Number maxVal) {
        Object result = null;
        result = statisticInfo.length == 1 ? new SingleAttrDefinitionImpl(name, statisticInfo[0]) : new MultiAttrDefinitionImpl(name, statisticInfo);
        if (applyFunction) {
            result = new FunctionDecoratorImpl((StatAlertDefinition)result, functionId);
        }
        result = minVal == null ? new NumberThresholdDecoratorImpl((StatAlertDefinition)result, maxVal, true) : new GaugeThresholdDecoratorImpl((StatAlertDefinition)result, minVal, maxVal);
        return result;
    }

    public static void registerStatAlertDefinition(StatAlertDefinition def) throws Exception {
        Object[] params = new Object[]{def};
        String[] signature = new String[]{"com.gemstone.gemfire.internal.admin.StatAlertDefinition"};
        mbsc.invoke(systemName, "updateAlertDefinition", params, signature);
    }

    public static boolean isStatAlertDefinitionCreated(StatAlertDefinition def) throws Exception {
        Object[] params = new Object[]{def};
        String[] signature = new String[]{"com.gemstone.gemfire.internal.admin.StatAlertDefinition"};
        Boolean ret = (Boolean)mbsc.invoke(systemName, "isAlertDefinitionCreated", params, signature);
        return ret;
    }

    public static StatAlertDefinition[] getAllStatAlertDefinitions() throws Exception {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        StatAlertDefinition[] result = (StatAlertDefinition[])mbsc.invoke(systemName, "getAllStatAlertDefinitions", params, signature);
        return result;
    }

    public static void removeStatAlertDefinition(StatAlertDefinition def) throws Exception {
        Object[] params = new Object[]{new Integer(def.getId())};
        String[] signature = new String[]{"java.lang.Integer"};
        mbsc.invoke(systemName, "removeAlertDefinition", params, signature);
    }

    public void testNoop() throws Exception {
    }
}

