/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.memberstatus;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class RegionSubRegionSnapsotDUnitTest
extends AdminDUnitTestCase {
    public static final int MEM_VM = 0;
    private final int noOfEntity = 10;

    public RegionSubRegionSnapsotDUnitTest(String name) {
        super(name);
    }

    protected VM getMemberVM() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    protected SystemMemberCache getMemberCache() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = RegionSubRegionSnapsotDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                RegionSubRegionSnapsotDUnitTest.this.getSystem(props);
            }
        });
        RegionSubRegionSnapsotDUnitTest.pause(2000);
        RegionSubRegionSnapsotDUnitTest.getLogWriter().info("Test: Created DS");
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            RegionSubRegionSnapsotDUnitTest.fail((String)sb.toString());
        }
        RegionSubRegionSnapsotDUnitTest.getLogWriter().info("Test: Created Member");
        SystemMemberCache cache = members[0].getCache();
        RegionSubRegionSnapsotDUnitTest.assertNull((Object)cache);
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)RegionSubRegionSnapsotDUnitTest.this.getSystem());
            }
        });
        RegionSubRegionSnapsotDUnitTest.getLogWriter().info("Test: Created Cache");
        cache = members[0].getCache();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((Object)cache);
        return cache;
    }

    public void testStatusSerialization() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        RegionSubRegionSnapshot snapSot = ((SystemMemberCacheImpl)cache).getRegionSnapshot();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"Snapshot cannot be null", (Object)snapSot);
    }

    public void testStatusSerializationForRootRegion() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        VM vm1 = this.getMemberVM();
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                AttributesFactory factory = new AttributesFactory();
                MembershipAttributes membershipAttributes = new MembershipAttributes(new String[]{"A"}, LossAction.FULL_ACCESS, ResumptionAction.NONE);
                factory.setMembershipAttributes(membershipAttributes);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion("RegionTest", attrs);
                Random generator = new Random();
                for (int i = 0; i < 10; ++i) {
                    int temp = generator.nextInt(200);
                    region.put((Object)String.valueOf(i), (Object)new Integer(temp));
                }
                DistributedTestCase.getLogWriter().info("Created a Region " + region.getFullPath());
            }
        });
        RegionSubRegionSnapshot root = ((SystemMemberCacheImpl)cache).getRegionSnapshot();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"Snapshot cannot be null", (Object)root);
        Set children = root.getSubRegionSnapshots();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"list of sub regions cannot be null", (Object)children);
        RegionSubRegionSnapsotDUnitTest.assertFalse((String)"list of sub regions cannot be empty", (boolean)children.isEmpty());
        Iterator iter = children.iterator();
        RegionSubRegionSnapshot snapsot = (RegionSubRegionSnapshot)iter.next();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"Snapshot cannot be null", (Object)snapsot);
        String path = snapsot.getFullPath().trim();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"Full path of region is incorrect", (String)"/Root/RegionTest/", (String)path);
        int entry = snapsot.getEntryCount();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"no of entries in region is incorrect", (int)10, (int)entry);
        String name = snapsot.getName();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"Name of region is incorrect", (String)"RegionTest", (String)name);
        int subregions = snapsot.getSubRegionSnapshots().size();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"no of subregions is incorrect ", (int)0, (int)subregions);
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"Snapshot cannot be null", (Object)snapsot.toString());
        RegionSubRegionSnapsotDUnitTest.assertFalse((String)"toString() method of snapshot should not be empty", (boolean)snapsot.toString().trim().equals(""));
        RegionSubRegionSnapshot parent = snapsot.getParent();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"parent snapshot of a region is null", (Object)parent);
        parent = root.getParent();
        RegionSubRegionSnapsotDUnitTest.assertNull((String)"parent snapshot of a root region should be null", (Object)parent);
    }

    public void testStatusSerializationForSubRegions() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        VM vm1 = this.getMemberVM();
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                AttributesFactory factory = new AttributesFactory();
                MembershipAttributes membershipAttributes = new MembershipAttributes(new String[]{"A"}, LossAction.FULL_ACCESS, ResumptionAction.NONE);
                factory.setMembershipAttributes(membershipAttributes);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion("RegionTest", attrs);
                Region subregion = region.createSubregion("SubRegionTest", attrs);
                Random generator = new Random();
                for (int i = 0; i < 10; ++i) {
                    int temp = generator.nextInt(200);
                    subregion.put((Object)String.valueOf(i), (Object)new Integer(temp));
                }
                DistributedTestCase.getLogWriter().info("Created a Region " + region.getFullPath());
                DistributedTestCase.getLogWriter().info("Created a SubRegion " + subregion.getFullPath());
            }
        });
        RegionSubRegionSnapshot root = ((SystemMemberCacheImpl)cache).getRegionSnapshot();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"snapshot of a valid region cannot be null", (Object)root);
        Set children = root.getSubRegionSnapshots();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"list of sub regions cannot be null", (Object)children);
        RegionSubRegionSnapsotDUnitTest.assertFalse((String)"list of sub regions cannot be empty", (boolean)children.isEmpty());
        Iterator iter = children.iterator();
        RegionSubRegionSnapshot snapsot = (RegionSubRegionSnapshot)iter.next();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"snapshot cannot be null", (Object)snapsot);
        String path = snapsot.getFullPath();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"Path of region is incorrect ", (String)"/Root/RegionTest/", (String)path);
        String name = snapsot.getName();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"region name is incorrect", (String)"RegionTest", (String)name);
        int subregions = snapsot.getSubRegionSnapshots().size();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"no of subregions is incorrect", (int)1, (int)subregions);
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"toString() method of snapshot should not return null", (Object)snapsot.toString());
        RegionSubRegionSnapsotDUnitTest.assertFalse((String)"toString() method of snapshot should not be empty", (boolean)snapsot.toString().trim().equals(""));
        Set subRegionSnapsots = snapsot.getSubRegionSnapshots();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"snapshot of valid region cannot be null", (Object)subRegionSnapsots);
        iter = subRegionSnapsots.iterator();
        RegionSubRegionSnapshot subRegionSnapsot = (RegionSubRegionSnapshot)iter.next();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"snapshot of valid region cannot be null", (Object)subRegionSnapsot);
        path = subRegionSnapsot.getFullPath();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"region path is incorrect", (String)"/Root/RegionTest/SubRegionTest/", (String)path);
        int entry = subRegionSnapsot.getEntryCount();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"no of entries in region is incorrect", (int)10, (int)entry);
        name = subRegionSnapsot.getName();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"name of region is incorrect", (String)"SubRegionTest", (String)name);
        subregions = subRegionSnapsot.getSubRegionSnapshots().size();
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"no of subregions of a region is incorrect", (int)0, (int)subregions);
        RegionSubRegionSnapshot parent = subRegionSnapsot.getParent();
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"parent snapshot of a region is null", (Object)parent);
        RegionSubRegionSnapsotDUnitTest.assertEquals((String)"parent snapshot of a subregion is incorrect ", (Object)snapsot, (Object)parent);
        RegionSubRegionSnapsotDUnitTest.assertNotNull((String)"Snapshot cannot be null", (Object)subRegionSnapsot.toString());
        RegionSubRegionSnapsotDUnitTest.assertFalse((String)"toString() method of snapshot should not be empty", (boolean)subRegionSnapsot.toString().trim().equals(""));
    }
}

