/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.AgentFactory;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RMIBindSamePortDifferentNICDUnitTest
extends DistributedTestCase {
    private static final long serialVersionUID = 1L;
    private static LogWriter logWriter = RMIBindSamePortDifferentNICDUnitTest.getLogWriter();
    private static Agent agent;
    private static int AGENT_VM1;
    private static int AGENT_VM2;
    private static int[] AGENT_VMS;

    public RMIBindSamePortDifferentNICDUnitTest(String name) {
        super(name);
    }

    public void testNICs() {
        VM vm;
        int i;
        InetAddress ip2;
        List<InetAddress> nicIPs = RMIBindSamePortDifferentNICDUnitTest.getNetworkInterfacesIPs();
        if (nicIPs.size() < 2) {
            logWriter.info("This test needs 2 reachable network interfaces. SKIPPING this test further as no. of available NICs are :: " + nicIPs.size());
            return;
        }
        int reachableIPs = 0;
        for (InetAddress ip2 : nicIPs) {
            try {
                if (!ip2.isReachable(1000)) continue;
                ++reachableIPs;
            }
            catch (IOException ioe) {}
        }
        logWriter.info("No. of interfaces: (Reachable/Total) :: (" + reachableIPs + "/" + nicIPs.size() + ")");
        if (reachableIPs < 2) {
            logWriter.info("This test needs 2 reachable network interfaces. SKIPPING this test further as all are not reachable.");
            return;
        }
        logWriter.info("Available NIC IPs :: " + nicIPs);
        int port = AvailablePortHelper.getRandomAvailableTCPPort();
        ip2 = null;
        Host host = Host.getHost(0);
        logWriter.fine("Starting agents .... ");
        for (i = 0; i < AGENT_VMS.length; ++i) {
            ip2 = nicIPs.get(i);
            vm = host.getVM(AGENT_VMS[i]);
            vm.invoke(RMIBindSamePortDifferentNICDUnitTest.class, "startAgent", new Object[]{ip2, port, vm.getPid()});
        }
        RMIBindSamePortDifferentNICDUnitTest.pause(5000);
        for (i = 0; i < AGENT_VMS.length; ++i) {
            vm = host.getVM(AGENT_VMS[i]);
            ip2 = nicIPs.get(i);
            vm.invoke(RMIBindSamePortDifferentNICDUnitTest.class, "connectJMXClient");
        }
        RMIBindSamePortDifferentNICDUnitTest.pause(1000);
        logWriter.fine("Stopping agents .... ");
        for (i = 0; i < AGENT_VMS.length; ++i) {
            vm = host.getVM(AGENT_VMS[i]);
            vm.invoke(RMIBindSamePortDifferentNICDUnitTest.class, "stopAgent");
        }
    }

    private static String getThisTestName() {
        return RMIBindSamePortDifferentNICDUnitTest.class.getSimpleName();
    }

    public static void startAgent(InetAddress rmiBindAddress, int port, int pid) throws AdminException {
        AgentConfig agentConfig = AgentFactory.defineAgent();
        agentConfig.setRmiBindAddress(rmiBindAddress.getHostAddress());
        agentConfig.setRmiPort(port);
        agentConfig.setHttpEnabled(false);
        agentConfig.setMcastPort(AvailablePortHelper.getRandomAvailableTCPPort());
        agentConfig.setLogFile(RMIBindSamePortDifferentNICDUnitTest.getThisTestName() + "_" + pid + "_jmxagent.log");
        agentConfig.setLogLevel(RMIBindSamePortDifferentNICDUnitTest.getDUnitLogLevel());
        agentConfig.setStateSaveFile(RMIBindSamePortDifferentNICDUnitTest.getThisTestName() + "_" + pid + "_agent.ser");
        agent = AgentFactory.getAgent((AgentConfig)agentConfig);
        agent.start();
        logWriter.info("Started agent started at :: " + rmiBindAddress + ":" + port);
    }

    public static void stopAgent() throws AdminException {
        if (agent != null && agent.getMBeanServer() != null) {
            agent.stop();
        }
        DistributionManager.isDedicatedAdminVM = false;
        logWriter.info("Agent stopped.");
    }

    public static void connectJMXClient() throws Exception {
        if (agent != null) {
            MBeanServer mbsc = agent.getMBeanServer();
            RMIBindSamePortDifferentNICDUnitTest.assertNotNull((String)("Couldn't get MBeanServerConnection from the Agent: " + agent), (Object)mbsc);
            String agentMBeanName = "GemFire:type=Agent";
            ObjectName agentObjName = new ObjectName(agentMBeanName);
            RMIBindSamePortDifferentNICDUnitTest.assertTrue((String)("Couldn't find Agent MBean for Agent :: " + agent), (boolean)mbsc.isRegistered(agentObjName));
            logWriter.fine("Sucessfully connected to Agent :: " + agent);
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            ObjectName adminDSObjName = (ObjectName)mbsc.invoke(agentObjName, "connectToSystem", params, signature);
            RMIBindSamePortDifferentNICDUnitTest.assertTrue((String)("Couldn't invoke connectToSystem on Agent : " + agent), (adminDSObjName != null ? 1 : 0) != 0);
            logWriter.info("Sucessfully invoked connectToSystem on Agent :: " + agent);
        }
    }

    private static List<InetAddress> getNetworkInterfacesIPs() {
        ArrayList<InetAddress> nicIPs = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nic = networkInterfaces.nextElement();
                Enumeration<InetAddress> interfaceIPs = nic.getInetAddresses();
                while (interfaceIPs.hasMoreElements()) {
                    InetAddress interfaceIP = interfaceIPs.nextElement();
                    if (!(interfaceIP instanceof Inet4Address)) continue;
                    nicIPs.add(interfaceIP);
                }
            }
        }
        catch (SocketException e) {
            logWriter.info("Couldn't retrieve info about available NetworkInterfaces", (Throwable)e);
        }
        return nicIPs;
    }

    private void cleanUp() {
        Host host = Host.getHost(0);
        for (int i = 0; i < AGENT_VMS.length; ++i) {
            VM vm = host.getVM(AGENT_VMS[i]);
            try {
                vm.invoke(RMIBindSamePortDifferentNICDUnitTest.class, "stopAgent");
                continue;
            }
            catch (Exception e) {
                logWriter.info("Exception while calling stopAgent in (VM#" + AGENT_VMS[i] + ")", (Throwable)e);
            }
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        RMIBindSamePortDifferentNICDUnitTest.disconnectAllFromDS();
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            RMIBindSamePortDifferentNICDUnitTest.disconnectAllFromDS();
        }
        finally {
            this.cleanUp();
        }
    }

    static {
        AGENT_VM1 = 2;
        AGENT_VM2 = 3;
        AGENT_VMS = new int[]{AGENT_VM1, AGENT_VM2};
    }
}

