/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.jmx.internal.AgentImpl;
import com.gemstone.gemfire.admin.jmx.internal.MemberInfoWithStatsMBean;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import junit.framework.TestCase;

public class MemberInfoWithStatsMBeanDUnitTest
extends AdminDUnitTestCase {
    private static final long serialVersionUID = 1L;
    private static final String KEY_CLIENTS_MAP = "gemfire.member.clients.map";
    private static final String KEY_REGIONS_MAP = "gemfire.member.regions.map";
    private static final String KEY_GATEWAY_COLLECTION = "gemfire.member.gatewayhub.gateways.collection";
    private static final String KEY_GATEWAYENDPOINTS_COLLECTION = "gemfire.member.gateway.endpoints.collection";
    private static final String[] KEYS_MEMBERS = new String[]{"gemfire.member.config.statsamplingenabled.boolean", "gemfire.member.config.timestatsenabled.boolean", "gemfire.member.host.string", "gemfire.member.id.string", "gemfire.member.isgateway.boolean", "gemfire.member.isserver.boolean", "gemfire.member.name.string", "gemfire.member.port.int", "gemfire.member.stat.cpus.int", "gemfire.member.stat.gets.int", "gemfire.member.stat.gettime.long", "gemfire.member.stat.maxmemory.long", "gemfire.member.stat.processcputime.long", "gemfire.member.stat.puts.int", "gemfire.member.stat.puttime.long", "gemfire.member.stat.usedmemory.long", "gemfire.member.type.string", "gemfire.member.uptime.long"};
    private static LogWriter logWriter = MemberInfoWithStatsMBeanDUnitTest.getLogWriter();
    private static int PAUSE_TIME = 15;
    private static ObjectName distributedSystem;
    private static MBeanServerConnection mbsc;
    private boolean recentlyRanGatewayTest = false;
    private static final Set<String> IGNORABLES;
    private static final Properties props;
    private int[] freeUDPPorts = new int[0];
    private static final String WAN_REGION_NAME = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_WAN_Root";
    private static final String DS_REGION_NAME = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_DS_Root";
    private VM[] vmsDS0 = new VM[0];
    private VM[] vmsDS1 = new VM[0];
    private static final int CACHE_VM = 0;
    private static final int CLIENT_VM = 2;
    private static Connection clientConn;

    public MemberInfoWithStatsMBeanDUnitTest(String name) {
        super(name);
    }

    private static void initIgnorableProperties() {
        IGNORABLES.add("gemfire.member.uptime.long");
        IGNORABLES.add("gemfire.member.stat.gettime.long");
        IGNORABLES.add("gemfire.member.stat.puttime.long");
        IGNORABLES.add("gemfire.member.stat.processcputime.long");
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testRegionAndClientDetails() throws Exception {
        String[] members;
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.testRegionAndClientDetails");
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startCache(serverPort);
        MemberInfoWithStatsMBeanDUnitTest.pause(1000 * PAUSE_TIME);
        this.connectClient(serverPort);
        MemberInfoWithStatsMBeanDUnitTest.pause(500 * PAUSE_TIME);
        ObjectName wrapper = ObjectName.getInstance("GemFire:type=MemberInfoWithStatsMBean");
        for (String member : members = this.commonTestCode(wrapper)) {
            this.verifyGetMemberDetails(wrapper, member, false);
        }
        this.disConnectClient();
        MemberInfoWithStatsMBeanDUnitTest.pause(1000 * PAUSE_TIME);
        this.stopCache();
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.testRegionAndClientDetails");
        this.recentlyRanGatewayTest = false;
    }

    public void testGatewayDetails() throws Exception {
        String[] members;
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.testGatewayDetails");
        this.setUpForGatewayTest();
        ObjectName wrapper = ObjectName.getInstance("GemFire:type=MemberInfoWithStatsMBean");
        for (String member : members = this.commonTestCode(wrapper)) {
            this.verifyGetMemberDetails(wrapper, member, true);
        }
        MemberInfoWithStatsMBeanDUnitTest.pause(1000 * PAUSE_TIME);
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.testGatewayDetails");
        this.recentlyRanGatewayTest = true;
    }

    private String[] commonTestCode(ObjectName wrapper) throws Exception {
        boolean isInitialized = this.isMBeanInitialized(wrapper);
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"MemberInfoWithStatsMBean initialized without first call to getMembers operation.", (boolean)isInitialized);
        Object[] members = this.invokeGetMembers(wrapper);
        logWriter.info("MemberInfoWithStatsMBeanDUnitTest.verifyGetMembers(): ids :: " + Arrays.toString(members));
        isInitialized = this.isMBeanInitialized(wrapper);
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)"MemberInfoWithStatsMBean not initialized even after the first call to getMembers operation.", (boolean)isInitialized);
        this.verifyAttributes(wrapper);
        this.verifyGetMembers((String[])members);
        return members;
    }

    private void verifyGetMemberDetails(ObjectName wrapper, String memberId, boolean verifyGatewayDetails) throws AdminException, OperationsException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyGetMemberDetails() ...");
        Map memberDetailsJMX = this.getMemberDetailsJMX(wrapper, memberId);
        Map memberDetailsDirect = this.getMemberDetailsDirect(memberId);
        this.verifyMemberDetails(memberDetailsJMX, memberDetailsDirect);
        if (verifyGatewayDetails) {
            this.verifyGatewayDetails(memberDetailsJMX, memberDetailsDirect);
        } else {
            this.verifyClientsDetails(memberDetailsJMX, memberDetailsDirect);
            this.verifyRegionsDetails(memberDetailsJMX, memberDetailsDirect);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyGetMemberDetails() ...");
    }

    private void verifyClientsDetails(Map memberDetailsJMX, Map memberDetailsDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyClientsDetails() ...");
        Map clientsJmx = (Map)memberDetailsJMX.get(KEY_CLIENTS_MAP);
        Map clientsDirect = (Map)memberDetailsDirect.get(KEY_CLIENTS_MAP);
        boolean isOneNullAndOtherNot = clientsJmx != null && clientsDirect == null || clientsJmx == null && clientsDirect != null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"Client information obtained directly & through JMX is not the same.", (boolean)isOneNullAndOtherNot);
        boolean isEitherNull = clientsDirect == null || clientsJmx == null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)("Non-null maps expected for client information, but obtained directly is: " + clientsDirect + " & through JMX is :" + clientsJmx), (boolean)isEitherNull);
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("No. of clients retrieved through JMX are: " + clientsJmx.size() + " but if retrived directly there are: " + clientsDirect.size()), (clientsJmx.size() == clientsDirect.size() ? 1 : 0) != 0);
        Set entrySet1 = clientsJmx.entrySet();
        Set entrySet2 = clientsDirect.entrySet();
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Client details do not match. Details retrieved thro JMX as: \n" + clientsJmx + " \n and directly as: \n" + clientsDirect), (boolean)entrySet1.equals(entrySet2));
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyClientsDetails() ...");
    }

    private void verifyRegionsDetails(Map memberDetailsJMX, Map memberDetailsDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyRegionsDetails() ...");
        Map regionsJmx = (Map)memberDetailsJMX.get(KEY_REGIONS_MAP);
        Map regionsDirect = (Map)memberDetailsDirect.get(KEY_REGIONS_MAP);
        boolean isOneNullAndOtherNot = regionsJmx != null && regionsDirect == null || regionsJmx == null && regionsDirect != null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"Regions information obtained directly & through JMX is not the same.", (boolean)isOneNullAndOtherNot);
        boolean isEitherNull = regionsDirect == null || regionsJmx == null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)("Non-null maps expected for regions information, but obtained directly is: " + regionsDirect + " & through JMX is :" + regionsJmx), (boolean)isEitherNull);
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("No. of regions retrieved through JMX are: " + regionsJmx.size() + " but if retrived directly there are: " + regionsDirect.size()), (regionsJmx.size() == regionsDirect.size() ? 1 : 0) != 0);
        Set entrySet1 = regionsJmx.entrySet();
        Set entrySet2 = regionsDirect.entrySet();
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Regions details do not match. Details retrieved thro JMX as: \n" + regionsJmx + " \n and directly as: \n" + regionsDirect), (boolean)entrySet1.equals(entrySet2));
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyRegionsDetails() ...");
    }

    private boolean isMBeanInitialized(ObjectName wrapper) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.isMBeanInitialized() ...");
        Integer refreshInterval = (Integer)mbsc.getAttribute(wrapper, "RefreshInterval");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        logWriter.fine("Exiting MemberInfoWithStatsMBeanDUnitTest.isMBeanInitialized() ...");
        return adminDS.getConfig().getRefreshInterval() == refreshInterval.intValue();
    }

    private String[] invokeGetMembers(ObjectName wrapper) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.invokeGetMembers() ...");
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        String[] memberIds = (String[])mbsc.invoke(wrapper, "getMembers", params, signature);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanDUnitTest.invokeGetMembers() ...");
        return memberIds;
    }

    private void verifyAttributes(ObjectName wrapper) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyAttributes() ...");
        String id = (String)mbsc.getAttribute(wrapper, "Id");
        String version = (String)mbsc.getAttribute(wrapper, "Version");
        Integer refreshInterval = (Integer)mbsc.getAttribute(wrapper, "RefreshInterval");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        String actualId = adminDS.getId();
        String actualVersion = GemFireVersion.getGemFireVersion();
        int actualRefreshInterval = adminDS.getConfig().getRefreshInterval();
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("AdminDistributedSystem id shown by MemberInfoWithStatsMBean (as: " + id + ") and actual (as: " + actualId + ") do not match."), (boolean)actualId.equals(id));
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("GemFire Version shown by MemberInfoWithStatsMBean (as: " + version + ") and actual(as: " + actualVersion + ") do not match."), (boolean)actualVersion.equals(version));
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Refresh Interval shown by MemberInfoWithStatsMBean (as: " + refreshInterval + ") and actual (as :" + actualRefreshInterval + ") do not match."), (actualRefreshInterval == refreshInterval ? 1 : 0) != 0);
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyAttributes() ...");
    }

    private void verifyGetMembers(String[] ids) throws AdminException {
        int i;
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyGetMembers() ...");
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        SystemMember[] appVms = adminDS.getSystemMemberApplications();
        CacheVm[] cacheVms = adminDS.getCacheVms();
        int actualMembers = appVms.length + cacheVms.length;
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("No. of members returned by MemberInfoWithStatsMBean are " + ids.length + " but in actual are " + actualMembers), (ids.length == actualMembers ? 1 : 0) != 0);
        List<String> memberIds = Arrays.asList(ids);
        boolean allIdsValid = true;
        for (i = 0; i < cacheVms.length; ++i) {
            if (memberIds.contains(cacheVms[i].getId())) continue;
            allIdsValid = false;
            break;
        }
        if (allIdsValid) {
            for (i = 0; i < appVms.length; ++i) {
                if (memberIds.contains(appVms[i].getId())) continue;
                allIdsValid = false;
                break;
            }
        }
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)"All member ids of existing members do not match with member ids given by GatewayHubMemberInfoWithStatsMBean.", (boolean)allIdsValid);
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyGetMembers() ...");
    }

    private Map getMemberDetailsJMX(ObjectName wrapper, String memberId) throws AdminException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.getMemberDetailsJMX() ...");
        Object[] params = new Object[]{memberId};
        String[] signature = new String[]{String.class.getName()};
        Map memberDetails = (Map)mbsc.invoke(wrapper, "getMemberDetails", params, signature);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanDUnitTest.getMemberDetailsJMX() ...");
        return memberDetails;
    }

    private Map getMemberDetailsDirect(String memberId) throws OperationsException {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.getMemberDetailsDirect() ...");
        MemberInfoWithStatsMBean memberInfoWithStatsMBean = ((AgentImpl)this.agent).memberInfoWithStatsMBean;
        Map memberDetails = memberInfoWithStatsMBean.getMemberDetails(memberId);
        logWriter.fine("Exiting MemberInfoWithStatsMBeanDUnitTest.getMemberDetailsDirect() ...");
        return memberDetails;
    }

    private void verifyMemberDetails(Map mapThroughJmx, Map mapDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyMemberDetails() ...");
        Object jmxVal = null;
        Object dirVal = null;
        boolean areEqual = false;
        for (int i = 0; i < KEYS_MEMBERS.length; ++i) {
            jmxVal = mapThroughJmx.get(KEYS_MEMBERS[i]);
            dirVal = mapDirect.get(KEYS_MEMBERS[i]);
            boolean bl = areEqual = jmxVal != null && dirVal != null && jmxVal.equals(dirVal);
            if (!areEqual && IGNORABLES.contains(KEYS_MEMBERS[i])) continue;
            MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Values obtained through JMX & directly are not the same for: " + KEYS_MEMBERS[i]), (jmxVal != null && dirVal != null && jmxVal.equals(dirVal) ? 1 : 0) != 0);
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyMemberDetails() ...");
    }

    private void verifyGatewayDetails(Map memberDetailsJMX, Map memberDetailsDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyGatewayDetails() ...");
        List gatewaysJmxCol = (List)memberDetailsJMX.get(KEY_GATEWAY_COLLECTION);
        List gatewaysDirectCol = (List)memberDetailsDirect.get(KEY_GATEWAY_COLLECTION);
        boolean isOneNullAndOtherNot = gatewaysJmxCol != null && gatewaysDirectCol == null || gatewaysJmxCol == null && gatewaysDirectCol != null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"Gateway information obtained directly & through JMX is not the same.", (boolean)isOneNullAndOtherNot);
        Boolean isGateway = (Boolean)memberDetailsJMX.get("gemfire.member.isgateway.boolean");
        if (gatewaysJmxCol == null) {
            String memberId = (String)memberDetailsJMX.get("gemfire.member.id.string");
            logWriter.info("No gateway information available for: " + memberId);
            MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)(memberId + " is a GatewayHub but does not have Gateway details."), (boolean)isGateway);
            return;
        }
        MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("No. of gateways retrieved through JMX are: " + gatewaysJmxCol.size() + " but if retrived directly there are: " + gatewaysDirectCol.size()), (gatewaysJmxCol.size() == gatewaysDirectCol.size() ? 1 : 0) != 0);
        for (int i = 0; i < gatewaysJmxCol.size(); ++i) {
            Map gatewaysJmx = (Map)gatewaysJmxCol.get(i);
            Map gatewaysDirect = (Map)gatewaysDirectCol.get(i);
            Set entrySetJmx = gatewaysJmx.entrySet();
            Set entrySetDirect = gatewaysDirect.entrySet();
            MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Gateway details do not match. Details retrieved thro JMX as: \n" + gatewaysJmx + " \n and directly as: \n" + gatewaysDirect), (boolean)entrySetJmx.equals(entrySetDirect));
            this.verifyGatewayEndpointsDetails((List)gatewaysJmx.get(KEY_GATEWAYENDPOINTS_COLLECTION), (List)gatewaysDirect.get(KEY_GATEWAYENDPOINTS_COLLECTION));
        }
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.verifyGatewayDetails() ...");
    }

    private void verifyGatewayEndpointsDetails(List<Map> endpointsJMX, List<Map> endpointsDirect) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyGatewayEndpointsDetails() ...");
        boolean isOneNullAndOtherNot = endpointsJMX != null && endpointsDirect == null || endpointsJMX == null && endpointsDirect != null;
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"Gateway endpoints information obtained directly & through JMX is not the same.", (boolean)isOneNullAndOtherNot);
        MemberInfoWithStatsMBeanDUnitTest.assertFalse((String)"Gateway does not have Endpoint details.", (endpointsJMX == null ? 1 : 0) != 0);
        for (int i = 0; i < endpointsJMX.size(); ++i) {
            Map map1 = endpointsJMX.get(i);
            Map map2 = endpointsDirect.get(i);
            MemberInfoWithStatsMBeanDUnitTest.assertTrue((String)("Gateway endpoint information at index: " + i + " obtained directly & through JMX is not the same."), (boolean)map1.entrySet().equals(map2.entrySet()));
        }
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.verifyGatewayEndpointsDetails() ...");
    }

    private void setUpSystems(int[] freeUDPPorts) throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.vmsDS0 = new VM[]{vm0, vm1};
        this.vmsDS1 = new VM[]{vm2, vm3};
        String hostName = MemberInfoWithStatsMBeanDUnitTest.getServerHostName(host);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int dsPortDS0 = freeUDPPorts[0];
        int dsPortDS1 = freeUDPPorts[1];
        int hubPortDS0 = freeTCPPorts[0];
        int hubPortDS1 = freeTCPPorts[1];
        this.setUpDS("ds0", dsPortDS0, this.vmsDS0, hubPortDS0, "ds1", hostName, hubPortDS1);
        this.setUpDS("ds1", dsPortDS1, this.vmsDS1, hubPortDS1, "ds0", hostName, hubPortDS0);
    }

    private void setUpDS(final String dsName, final int dsPort, VM[] vms, final int hubPortLocal, final String dsNameRemote, final String hostNameRemote, final int hubPortRemote) throws Exception {
        final Properties propsDS = new Properties();
        propsDS.setProperty("mcast-port", String.valueOf(dsPort));
        propsDS.setProperty("locators", "");
        int i = 0;
        while (i < vms.length) {
            final int whichvm = i++;
            VM vm = vms[whichvm];
            vm.invoke(new CacheSerializableRunnable("Set up " + dsName){
                private static final long serialVersionUID = 1L;

                @Override
                public void run2() throws CacheException {
                    String vmName = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_" + dsName + "_vm" + whichvm;
                    propsDS.setProperty("name", vmName);
                    MemberInfoWithStatsMBeanDUnitTest.this.getSystem(propsDS);
                    DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " has joined " + dsName + " with port " + String.valueOf(dsPort));
                    Cache cache = MemberInfoWithStatsMBeanDUnitTest.this.getCache();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setEnableGateway(true);
                    cache.createRegion(MemberInfoWithStatsMBeanDUnitTest.WAN_REGION_NAME, factory.create());
                    factory.setEnableGateway(false);
                    cache.createRegion(MemberInfoWithStatsMBeanDUnitTest.DS_REGION_NAME, factory.create());
                    DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " has created both regions");
                }
            });
        }
        final int whichvm = vms.length - 1;
        VM vm = vms[whichvm];
        vm.invoke(new CacheSerializableRunnable("Set up gateway in " + dsName){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                String vmName = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_" + dsName + "_vm" + whichvm;
                String hubName = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_" + dsName;
                String gatewayName = "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_" + dsNameRemote;
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " is creating " + hubName + " with gateway to " + gatewayName);
                Cache cache = MemberInfoWithStatsMBeanDUnitTest.this.getCache();
                GatewayHub hub = cache.addGatewayHub(hubName, hubPortLocal);
                Gateway gateway = hub.addGateway(gatewayName);
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " adding endpoint [" + gatewayName + ", " + hostNameRemote + ", " + hubPortRemote + "] to " + gatewayName);
                gateway.addEndpoint(gatewayName, hostNameRemote, hubPortRemote);
                File d = new File(gatewayName + "_overflow_" + ProcessMgr.getProcessId());
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " creating queue in " + d + " for " + gatewayName);
                GatewayQueueAttributes queueAttributes = new GatewayQueueAttributes(d.toString(), 100, 100, 1000, false, false, 0);
                queueAttributes.setEnablePersistence(true);
                queueAttributes.setDiskStoreName(MemberInfoWithStatsMBeanDUnitTest.this.getUniqueName());
                File overflowDirectory = new File("overflow_dir_" + dsName + "_vm_" + whichvm);
                overflowDirectory.mkdir();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File[] dirs1 = new File[]{overflowDirectory};
                dsf.setDiskDirs(dirs1).create(MemberInfoWithStatsMBeanDUnitTest.this.getUniqueName());
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hubName + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hubName + " threw " + e, e);
                }
                DistributedTestCase.getLogWriter().info("[MemberInfoWithStatsMBeanDUnitTest] " + vmName + " has created " + hubName + " with gateway to " + gatewayName);
            }
        });
    }

    public static void destroyWanQueues() {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            for (GatewayHub hub : cache.getGatewayHubs()) {
                for (Gateway gateway : hub.getGateways()) {
                    String rq = new StringBuffer(gateway.getGatewayHubId()).append('_').append(gateway.getId()).append("_EVENT_QUEUE").toString();
                    Region wbcl = cache.getRegion(rq);
                    if (wbcl == null) continue;
                    wbcl.localDestroyRegion();
                }
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void setUpForGatewayTest() throws Exception {
        this.setUpSystems(this.freeUDPPorts);
    }

    private void tearDownForGatewayTest() {
        MemberInfoWithStatsMBeanDUnitTest.destroyWanQueues();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(MemberInfoWithStatsMBeanDUnitTest.class, "destroyWanQueues");
            }
        }
    }

    private void startCache(final int serverPort) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.startCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        final Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getDistributedSystemProperties());
        props.put("name", "ClientGatewayHubMemberInfoWithStatsMBeanDUnitTest_vm0");
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-startCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanDUnitTest.this.getSystem(props);
                Cache cacheInstance = MemberInfoWithStatsMBeanDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                RegionAttributes attrs = factory.create();
                cacheInstance.createRegion(MemberInfoWithStatsMBeanDUnitTest.DS_REGION_NAME, attrs);
                CacheServer server = cacheInstance.addCacheServer();
                server.setPort(serverPort);
                try {
                    server.start();
                }
                catch (IOException e) {
                    throw new CacheException("Exception occurred while starting server.", e){
                        private static final long serialVersionUID = 1L;
                    };
                }
                logWriter.info("MemberInfoWithStatsMBeanDUnitTest.startCache :: Created cache & started server in cacheVM(VM#0) at port:" + serverPort);
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.startCache");
    }

    private void stopCache() {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM cacheVM = host.getVM(0);
        cacheVM.invoke(new CacheSerializableRunnable(this.getName() + "-stopCache"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.stopCache");
    }

    private void connectClient(final int serverPort) {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.connectClient");
        final Host host = Host.getHost(0);
        VM clientVM = host.getVM(2);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-connectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanDUnitTest.this.createLonerCache();
                Cache cacheInstance = MemberInfoWithStatsMBeanDUnitTest.this.getCache();
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.addServer(host.getHostName(), serverPort);
                pf.setSubscriptionEnabled(true);
                pf.setReadTimeout(10000);
                pf.setSubscriptionRedundancy(0);
                PoolImpl p = (PoolImpl)pf.create("MemberInfoWithStatsMBeanDUnitTest");
                AttributesFactory factory = new AttributesFactory();
                factory.setPoolName(p.getName());
                factory.setScope(Scope.LOCAL);
                RegionAttributes attrs = factory.create();
                Region region = cacheInstance.createRegion(MemberInfoWithStatsMBeanDUnitTest.DS_REGION_NAME, attrs);
                TestCase.assertNotNull((String)"Region in cache is is null.", (Object)region);
                clientConn = p.acquireConnection();
                TestCase.assertNotNull((String)"Acquired client connecttion is null.", (Object)clientConn);
            }
        });
        logWriter.info("MemberInfoWithStatsMBeanDUnitTest.connectClient :: Started client in clientVM(VM#2) & connected to cacheVM(VM#2).");
    }

    private void disConnectClient() {
        logWriter.fine("Entered MemberInfoWithStatsMBeanDUnitTest.stopCache");
        Host host = Host.getHost(0);
        VM clientVM = host.getVM(2);
        clientVM.invoke(new CacheSerializableRunnable(this.getName() + "-disConnectClient"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                MemberInfoWithStatsMBeanDUnitTest.this.getCache().close();
                CacheTestCase.disconnectFromDS();
                clientConn.destroy();
            }
        });
        logWriter.fine("Exited MemberInfoWithStatsMBeanDUnitTest.stopCache");
    }

    @Override
    public Properties getDistributedSystemProperties() {
        return props;
    }

    public static void initDSProperties(int mcastPort) {
        props.clear();
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        props.setProperty("locators", "");
    }

    @Override
    public void setUp() throws Exception {
        boolean failedSetUp = true;
        try {
            MemberInfoWithStatsMBeanDUnitTest.disconnectAllFromDS();
            this.freeUDPPorts = AvailablePortHelper.getRandomAvailableUDPPorts(2);
            MemberInfoWithStatsMBeanDUnitTest.initDSProperties(this.freeUDPPorts[0]);
            super.setUp();
            failedSetUp = false;
        }
        catch (Exception e) {
            if (failedSetUp) {
                MemberInfoWithStatsMBeanDUnitTest.disconnectAllFromDS();
            }
            throw e;
        }
        mbsc = this.agent.getMBeanServer();
        MemberInfoWithStatsMBeanDUnitTest.assertNotNull((Object)mbsc);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        distributedSystem = (ObjectName)mbsc.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
        MemberInfoWithStatsMBeanDUnitTest.assertNotNull((Object)distributedSystem);
        MemberInfoWithStatsMBeanDUnitTest.initIgnorableProperties();
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            if (this.recentlyRanGatewayTest) {
                this.tearDownForGatewayTest();
            }
        }
        finally {
            MemberInfoWithStatsMBeanDUnitTest.disconnectAllFromDS();
        }
    }

    static {
        IGNORABLES = new HashSet<String>();
        props = new Properties();
    }
}

