/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.jmx.internal.MailManager;
import com.gemstone.gemfire.cache.Cache;

public class MailManagerDUnitTest
extends AdminDUnitTestCase {
    public static final long REFRESH_INTERVAL = 10000L;
    public static final int MEM_VM = 0;
    protected static Cache cache = null;

    public MailManagerDUnitTest(String name) {
        super(name);
    }

    public void testMailManager() throws Exception {
        MailManager mailManager = new MailManager("mailsrv1.gemstone.com", "temp@gemstone.com");
        MailManagerDUnitTest.assertEquals((String)" 'mail from' id of mail manager is not correct", (String)"temp@gemstone.com", (String)mailManager.getMailFromAddress());
        MailManagerDUnitTest.assertEquals((String)" 'mail host' of mail manager is not correct", (String)"mailsrv1.gemstone.com", (String)mailManager.getMailHost());
        mailManager.setMailHost("mailsrv2.gemstone.com");
        MailManagerDUnitTest.assertEquals((String)" 'mail host' of mail manager is not correct", (String)"mailsrv2.gemstone.com", (String)mailManager.getMailHost());
        mailManager.setMailFromAddress("temp1@gemstone.com");
        MailManagerDUnitTest.assertEquals((String)" 'mail from' of mail manager is not correct", (String)"temp1@gemstone.com", (String)mailManager.getMailFromAddress());
        mailManager.addMailToAddress("xyz@gemstone.com");
        mailManager.addMailToAddress("xyz1@gemstone.com");
        mailManager.addMailToAddress("xyz2@gemstone.com");
        MailManagerDUnitTest.assertEquals((String)"No of 'To list' of mail manager is supposed to be 3 ", (int)3, (int)mailManager.getAllToAddresses().length);
        mailManager.removeMailToAddress("xyz1@gemstone.com");
        mailManager.removeMailToAddress("xyz2@gemstone.com");
        MailManagerDUnitTest.assertEquals((String)" 'mail from' of mail manager is not correct", (String)"xyz@gemstone.com", (String)mailManager.getAllToAddresses()[0]);
        MailManagerDUnitTest.assertEquals((String)"No of 'To list' of mail manager is supposed to be 1 ", (int)1, (int)mailManager.getAllToAddresses().length);
        mailManager.addMailToAddress("xyz1@gemstone.com");
        mailManager.addMailToAddress("xyz1@gemstone.com");
        MailManagerDUnitTest.assertEquals((String)"No of 'To list' of mail manager is supposed to be 2 ", (int)2, (int)mailManager.getAllToAddresses().length);
        mailManager.addMailToAddress("xyz2@gemstone.com");
        mailManager.removeAllMailToAddresses();
        MailManagerDUnitTest.assertEquals((String)"No of 'To list' of mail manager is supposed to be 0 ", (int)0, (int)mailManager.getAllToAddresses().length);
        MailManagerDUnitTest.assertNotNull((String)"to string method should not return null ", (Object)mailManager.toString());
    }
}

