/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.internal.Assert;
import java.io.File;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;

class JMXSystemMemberRegion
extends JMXAdminImpl
implements SystemMemberRegion {
    JMXSystemMemberRegion(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    private RuntimeException handleException(Exception ex) {
        if (ex instanceof MBeanException) {
            MBeanException mbe = (MBeanException)ex;
            Throwable cause = mbe.getCause();
            if (cause instanceof RegionNotFoundException) {
                return (RegionNotFoundException)cause;
            }
            if (cause instanceof RegionDestroyedException) {
                return (RegionDestroyedException)cause;
            }
            if (cause instanceof ServiceNotFoundException) {
                return new RegionNotFoundException("MBeanServerConnection.getAttribute() caught " + cause.getMessage());
            }
        } else if (ex instanceof InstanceNotFoundException) {
            return new RegionNotFoundException("MBeanServerConnection.getAttribute() caught " + ex.getMessage());
        }
        String s = "While calling MBeanServerConnection.getAttribute()";
        return new InternalGemFireException(s, (Throwable)ex);
    }

    public String getName() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "name");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getFullPath() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "fullPath");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public Set getSubregionNames() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Set)this.mbs.getAttribute(this.objectName, "subregionNames");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public Set getSubregionFullPaths() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Set)this.mbs.getAttribute(this.objectName, "subregionFullPaths");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getUserAttribute() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "userAttribute");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getCacheLoader() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "cacheLoader");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getCacheWriter() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "cacheWriter");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public EvictionAttributes getEvictionAttributes() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (EvictionAttributes)this.mbs.getAttribute(this.objectName, "evictionAttributes");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public MembershipAttributes getMembershipAttributes() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (MembershipAttributes)this.mbs.getAttribute(this.objectName, "membershipAttributes");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public SubscriptionAttributes getSubscriptionAttributes() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (SubscriptionAttributes)this.mbs.getAttribute(this.objectName, "subscriptionAttributes");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getCacheListener() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "cacheListener");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String[] getCacheListeners() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Object[] params = new String[]{};
            String[] signature = new String[]{};
            return (String[])this.mbs.invoke(this.objectName, "getCacheListeners", params, signature);
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public boolean getEarlyAck() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Boolean value = (Boolean)this.mbs.getAttribute(this.objectName, "earlyAck");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getKeyConstraint() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "keyConstraint");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getValueConstraint() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "valueConstraint");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getRegionTimeToLiveTimeLimit() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "regionTimeToLiveTimeLimit");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public ExpirationAction getRegionTimeToLiveAction() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (ExpirationAction)this.mbs.getAttribute(this.objectName, "regionTimeToLiveAction");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getEntryTimeToLiveTimeLimit() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "entryTimeToLiveTimeLimit");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public ExpirationAction getEntryTimeToLiveAction() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (ExpirationAction)this.mbs.getAttribute(this.objectName, "entryTimeToLiveAction");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getCustomEntryTimeToLive() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "customEntryTimeToLive");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getRegionIdleTimeoutTimeLimit() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "regionIdleTimeoutTimeLimit");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public ExpirationAction getRegionIdleTimeoutAction() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (ExpirationAction)this.mbs.getAttribute(this.objectName, "regionIdleTimeoutAction");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getEntryIdleTimeoutTimeLimit() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "entryIdleTimeoutTimeLimit");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public ExpirationAction getEntryIdleTimeoutAction() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (ExpirationAction)this.mbs.getAttribute(this.objectName, "entryIdleTimeoutAction");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getCustomEntryIdleTimeout() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "customEntryIdleTimeout");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public MirrorType getMirrorType() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (MirrorType)this.mbs.getAttribute(this.objectName, "mirrorType");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public DataPolicy getDataPolicy() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (DataPolicy)this.mbs.getAttribute(this.objectName, "dataPolicy");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public Scope getScope() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Scope)this.mbs.getAttribute(this.objectName, "scope");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getInitialCapacity() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "initialCapacity");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public float getLoadFactor() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Float value = (Float)this.mbs.getAttribute(this.objectName, "loadFactor");
            return value.floatValue();
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getConcurrencyLevel() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "concurrencyLevel");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public boolean getConcurrencyChecksEnabled() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "concurrencyChecksEnabled");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public boolean getStatisticsEnabled() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Boolean value = (Boolean)this.mbs.getAttribute(this.objectName, "statisticsEnabled");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public boolean getPersistBackup() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Boolean value = (Boolean)this.mbs.getAttribute(this.objectName, "persisteBackup");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public DiskWriteAttributes getDiskWriteAttributes() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (DiskWriteAttributes)this.mbs.getAttribute(this.objectName, "diskWriteAttributes");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public File[] getDiskDirs() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (File[])this.mbs.getAttribute(this.objectName, "diskDirs");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getEntryCount() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "entryCount");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getSubregionCount() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Integer value = (Integer)this.mbs.getAttribute(this.objectName, "subregionCount");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public long getLastModifiedTime() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Long value = (Long)this.mbs.getAttribute(this.objectName, "lastModifiedTime");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public long getLastAccessedTime() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Long value = (Long)this.mbs.getAttribute(this.objectName, "lastAccessedTime");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public long getHitCount() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Long value = (Long)this.mbs.getAttribute(this.objectName, "hitCount");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public long getMissCount() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Long value = (Long)this.mbs.getAttribute(this.objectName, "missCount");
            return value;
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public float getHitRatio() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            Float value = (Float)this.mbs.getAttribute(this.objectName, "hitRatio");
            return value.floatValue();
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public PartitionAttributes getPartitionAttributes() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (PartitionAttributes)this.mbs.getAttribute(this.objectName, "partitionAttributes");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void refresh() {
        try {
            this.mbs.invoke(this.objectName, "refresh", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public SystemMemberRegion createSubregion(String name, RegionAttributes attrs) throws AdminException {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

