/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.AgentFactory;
import com.gemstone.gemfire.admin.jmx.CoLocatedAgentDUnitTest;
import com.gemstone.gemfire.admin.jmx.internal.AgentImpl;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import hydra.TestConfig;
import java.io.File;
import javax.management.ObjectName;

public class JMXHelper {
    protected static Agent rmiAgent;

    public static Agent startAgent(AdminDUnitTestCase test, int pid) throws Exception {
        DistributionConfig dsConfig = test.getDistributionConfig();
        AgentConfig config = AgentFactory.defineAgent();
        config.setAutoConnect(false);
        return JMXHelper.startAgent(test, config, dsConfig, pid);
    }

    public static Agent startAgent(AdminDUnitTestCase test, AgentConfig config, int pid) throws Exception {
        DistributionConfig dsConfig = test.getDistributionConfig();
        return JMXHelper.startAgent(test, config, dsConfig, pid);
    }

    private static Agent doAgent(AgentConfig config) throws AdminException {
        System.out.println("AgentConfig.LOG_FILE_NAME=" + config.getLogFile());
        System.out.println("AgentConfig.LOG_LEVEL_NAME=" + config.getLogLevel());
        Agent agent = null;
        try {
            agent = AgentFactory.getAgent((AgentConfig)config);
            agent.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Agent startAgent(AdminDUnitTestCase test, AgentConfig config, DistributionConfig dsConfig, int pid) throws Exception {
        DistributedTestCase.disconnectFromDS();
        DistributionManager.isDedicatedAdminVM = true;
        boolean done = false;
        try {
            config.setMcastPort(dsConfig.getMcastPort());
            config.setMcastAddress(dsConfig.getMcastAddress().getHostName());
            config.setLocators(dsConfig.getLocators());
            config.setBindAddress(DistributedTestCase.getIPLiteral());
            int httpPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            config.setHttpPort(httpPort);
            config.setRmiEnabled(false);
            String testClassName = test.getClass().getName();
            String testName = testClassName.substring(testClassName.lastIndexOf(".") + 1);
            config.setLogFile(testName + "_" + pid + "_jmxagent.log");
            config.setLogLevel(DistributedTestCase.getDUnitLogLevel());
            config.setStateSaveFile(testName + "_" + pid + "_agent.ser");
            System.out.println("AgentConfig.LOG_FILE_NAME=" + config.getLogFile());
            System.out.println("AgentConfig.LOG_LEVEL_NAME=" + config.getLogLevel());
            Agent agent = AgentFactory.getAgent((AgentConfig)config);
            agent.start();
            done = true;
            Agent agent2 = agent;
            return agent2;
        }
        finally {
            if (!done) {
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }

    public static void stopAgent(Agent agent) throws Exception {
        try {
            Log.getLogWriter().info("[JMXHelper] Stopping JMX Agent: " + agent);
            if (agent != null) {
                ObjectName agentName = new ObjectName("GemFire:type=Agent");
                agent.getMBeanServer().invoke(agentName, "stop", new Object[0], new String[0]);
            }
            String agentPropsFile = System.getProperty("gfAgentPropertyFile");
            System.setProperty("gfAgentPropertyFile", "agent.properties");
            if (agentPropsFile != null) {
                new File(agentPropsFile).delete();
            }
            Assert.assertTrue((agent != null && !agent.isConnected() ? 1 : 0) != 0);
        }
        finally {
            DistributionManager.isDedicatedAdminVM = false;
        }
    }

    public static String startRMIAgent(DistributedTestCase test, VM vm) throws Exception {
        Integer pid = vm.getPid();
        return (String)vm.invoke(JMXHelper.class, "startRMIAgent", new Object[]{test, pid});
    }

    public static String startRMIAgentNoAdmin(DistributedTestCase test, VM vm) throws Exception {
        Integer pid = vm.getPid();
        return (String)vm.invoke(JMXHelper.class, "startRMIAgentNoAdmin", new Object[]{test, pid});
    }

    public static String startRMISSLAgent(DistributedTestCase test, VM vm) throws Exception {
        Integer pid = vm.getPid();
        return (String)vm.invoke(JMXHelper.class, "startRMISSLAgent", new Object[]{test, pid});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String startRMIAgent(AdminDUnitTestCase test, int pid) throws Exception {
        DistributionConfig dsConfig = test.getDistributionConfig();
        DistributedTestCase.disconnectFromDS();
        DistributionManager.isDedicatedAdminVM = true;
        boolean done = false;
        try {
            String result = JMXHelper.startRMIAgent(dsConfig, test, pid);
            done = true;
            String string = result;
            return string;
        }
        finally {
            if (!done) {
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }

    protected static String startRMIAgentNoAdmin(CoLocatedAgentDUnitTest test, int pid) throws Exception {
        DistributionConfig dsConfig = test.getDistributionConfig();
        String xmlFile = test.getEntityConfigXMLFile();
        if (xmlFile != null) {
            DistributedTestCase.disconnectFromDS();
        }
        return JMXHelper.startRMIAgent(dsConfig, test, pid, xmlFile);
    }

    static String startRMIAgent(DistributionConfig dsConfig, DistributedTestCase test, int pid) throws Exception {
        return JMXHelper.startRMIAgent(dsConfig, test, pid, null);
    }

    static String startRMIAgent(DistributionConfig dsConfig, DistributedTestCase test, int pid, String xmlFile) throws Exception {
        String hostName = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription().getHostName();
        AgentConfig config = AgentFactory.defineAgent();
        config.setAutoConnect(false);
        if (xmlFile != null) {
            System.out.println("JMX XML config file: " + xmlFile);
            config.setEntityConfigXMLFile(xmlFile);
        }
        config.setMcastPort(dsConfig.getMcastPort());
        config.setMcastAddress(dsConfig.getMcastAddress().getHostName());
        config.setLocators(dsConfig.getLocators());
        config.setBindAddress(DistributedTestCase.getIPLiteral());
        int rmiRegistryPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        int rmiServerPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        config.setRmiEnabled(true);
        config.setRmiRegistryEnabled(true);
        config.setRmiBindAddress(hostName);
        config.setRmiPort(rmiRegistryPort);
        config.setRmiServerPort(rmiServerPort);
        config.setHttpEnabled(false);
        String testClassName = test.getClass().getName();
        String testName = testClassName.substring(testClassName.lastIndexOf(".") + 1);
        config.setLogFile(testName + "_" + pid + "_jmxagent.log");
        config.setLogLevel(DistributedTestCase.getDUnitLogLevel());
        config.setStateSaveFile(testName + "_" + pid + "_agent.ser");
        System.out.println("AgentConfig.LOG_FILE_NAME=" + config.getLogFile());
        System.out.println("AgentConfig.LOG_LEVEL_NAME=" + config.getLogLevel());
        rmiAgent = AgentFactory.getAgent((AgentConfig)config);
        rmiAgent.start();
        Assert.assertTrue((((AgentImpl)rmiAgent).getRMIAddress() != null ? 1 : 0) != 0);
        return ((AgentImpl)rmiAgent).getRMIAddress().toString();
    }

    public static void stopRMIAgent(DistributedTestCase test, VM vm) throws Exception {
        vm.invoke(new SerializableRunnable("Stop RMI Agent"){

            @Override
            public void run() {
                try {
                    JMXHelper.stopAgent(rmiAgent);
                    rmiAgent = null;
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While stopping RMI agent", ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String startRMISSLAgent(AdminDUnitTestCase test, int pid) throws Exception {
        DistributionConfig dsConfig = test.getDistributionConfig();
        DistributedTestCase.disconnectFromDS();
        DistributionManager.isDedicatedAdminVM = true;
        boolean done = false;
        try {
            String hostName = DistributedTestCase.getIPLiteral();
            AgentConfig config = AgentFactory.defineAgent();
            config.setAutoConnect(false);
            config.setMcastPort(dsConfig.getMcastPort());
            config.setMcastAddress(dsConfig.getMcastAddress().getHostName());
            config.setLocators(dsConfig.getLocators());
            int rmiRegistryPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            int rmiServerPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            config.setRmiEnabled(true);
            config.setRmiRegistryEnabled(false);
            config.setRmiBindAddress(hostName);
            config.setRmiPort(rmiRegistryPort);
            config.setRmiServerPort(rmiServerPort);
            config.setHttpEnabled(false);
            config.setAgentSSLEnabled(true);
            String JTESTS = System.getProperty("JTESTS");
            String keyStore = JTESTS + File.separator + "ssl" + File.separator + "trusted.keystore";
            System.setProperty("javax.net.ssl.keyStore", keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", "password");
            System.setProperty("javax.net.ssl.trustStore", keyStore);
            System.setProperty("javax.net.ssl.trustStorePassword", "password");
            String testClassName = test.getClass().getName();
            String testName = testClassName.substring(testClassName.lastIndexOf(".") + 1);
            config.setLogFile(testName + "_" + pid + "_jmxagent.log");
            config.setLogLevel(DistributedTestCase.getDUnitLogLevel());
            config.setStateSaveFile(testName + "_" + pid + "_agent.ser");
            System.out.println("AgentConfig.LOG_FILE_NAME=" + config.getLogFile());
            System.out.println("AgentConfig.LOG_LEVEL_NAME=" + config.getLogLevel());
            rmiAgent = AgentFactory.getAgent((AgentConfig)config);
            rmiAgent.start();
            Assert.assertTrue((((AgentImpl)rmiAgent).getRMIAddress() != null ? 1 : 0) != 0);
            String result = ((AgentImpl)rmiAgent).getRMIAddress().toString();
            done = true;
            String string = result;
            return string;
        }
        finally {
            if (!done) {
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }
}

