/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.CacheServer;
import com.gemstone.gemfire.admin.CacheServerConfig;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.CacheVmConfig;
import com.gemstone.gemfire.admin.SystemMemberType;
import com.gemstone.gemfire.admin.jmx.JMXManagedEntityConfig;
import com.gemstone.gemfire.admin.jmx.JMXSystemMember;
import com.gemstone.gemfire.internal.Assert;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXCacheServer
extends JMXSystemMember
implements CacheVm,
CacheServer {
    JMXCacheServer(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((objectName != null ? 1 : 0) != 0);
    }

    @Override
    public SystemMemberType getType() {
        return SystemMemberType.CACHE_VM;
    }

    public CacheServerConfig getConfig() {
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        return new JMXCacheServerConfig(this.mbs, this.objectName);
    }

    public CacheVmConfig getVmConfig() {
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
        return new JMXCacheServerConfig(this.mbs, this.objectName);
    }

    public void start() {
        try {
            this.mbs.invoke(this.objectName, "start", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While starting";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public void stop() {
        try {
            this.mbs.invoke(this.objectName, "stop", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            String s = "While stopping";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean waitToStart(long timeout) {
        try {
            Boolean b = (Boolean)this.mbs.invoke(this.objectName, "waitToStart", new Object[]{new Long(timeout)}, new String[]{Long.TYPE.getName()});
            return b;
        }
        catch (Exception ex) {
            String s = "While waiting to start";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean waitToStop(long timeout) {
        try {
            Boolean b = (Boolean)this.mbs.invoke(this.objectName, "waitToStop", new Object[]{new Long(timeout)}, new String[]{Long.TYPE.getName()});
            return b;
        }
        catch (Exception ex) {
            String s = "While waiting to stop";
            throw new InternalGemFireException(s, (Throwable)ex);
        }
    }

    public boolean isPrimaryForDurableClient(String durableClientId) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static class JMXCacheServerConfig
    extends JMXManagedEntityConfig
    implements CacheVmConfig,
    CacheServerConfig {
        JMXCacheServerConfig(MBeanServerConnection mbs, ObjectName objectName) {
            super(mbs, objectName);
            Assert.assertTrue((objectName != null ? 1 : 0) != 0);
        }

        public String getCacheXMLFile() {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                return (String)this.mbs.getAttribute(this.objectName, "cacheXMLFile");
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public void setCacheXMLFile(String cacheXml) {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                this.mbs.setAttribute(this.objectName, new Attribute("cacheXMLFile", cacheXml));
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public String getClassPath() {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                return (String)this.mbs.getAttribute(this.objectName, "classPath");
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }

        public void setClassPath(String classpath) {
            try {
                Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
                this.mbs.setAttribute(this.objectName, new Attribute("classPath", classpath));
            }
            catch (Exception ex) {
                throw this.handleException(ex);
            }
        }
    }
}

