/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.admin.GemFireHealthDUnitTest;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import dunit.DistributedTestCase;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class GemFireHealthJMXDUnitTest
extends GemFireHealthDUnitTest {
    public GemFireHealthJMXDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean isJMX() {
        return true;
    }

    public void testBug31675() throws Exception {
        if (this.isSSL() || this.isRMI()) {
            DistributedTestCase.getLogWriter().info("Skipping testBug31675 in SSL and RMI enabled tests");
            return;
        }
        MBeanServer mbs = this.agent.getMBeanServer();
        GemFireHealthJMXDUnitTest.assertNotNull((Object)mbs);
        ObjectName agentName = new ObjectName("GemFire:type=Agent");
        ObjectName systemName = (ObjectName)mbs.invoke(agentName, "manageDistributedSystem", new Object[0], new String[0]);
        GemFireHealthJMXDUnitTest.assertNotNull((Object)systemName);
        String systemId = (String)mbs.getAttribute(systemName, "id");
        systemId = MBeanUtil.makeCompliantMBeanNameProperty((String)systemId);
        GemFireHealthJMXDUnitTest.assertNotNull((Object)systemId);
        ObjectName healthName = (ObjectName)mbs.invoke(systemName, "monitorGemFireHealth", new Object[0], new String[0]);
        ObjectName systemHealthConfigName = new ObjectName("GemFire:type=DistributedSystemHealthConfig,id=" + systemId);
        ObjectName defaultHealthConfigName = new ObjectName("GemFire:type=GemFireHealthConfig,id=" + systemId + ",host=default");
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(healthName));
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(systemHealthConfigName));
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(defaultHealthConfigName));
        this.tcSystem.getGemFireHealth().getHealth();
        mbs.unregisterMBean(healthName);
        mbs.unregisterMBean(systemHealthConfigName);
        mbs.unregisterMBean(defaultHealthConfigName);
        GemFireHealthJMXDUnitTest.assertTrue((!mbs.isRegistered(healthName) ? 1 : 0) != 0);
        GemFireHealthJMXDUnitTest.assertTrue((!mbs.isRegistered(systemHealthConfigName) ? 1 : 0) != 0);
        GemFireHealthJMXDUnitTest.assertTrue((!mbs.isRegistered(defaultHealthConfigName) ? 1 : 0) != 0);
        healthName = (ObjectName)mbs.invoke(systemName, "monitorGemFireHealth", new Object[0], new String[0]);
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(healthName));
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(systemHealthConfigName));
        GemFireHealthJMXDUnitTest.assertTrue((boolean)mbs.isRegistered(defaultHealthConfigName));
        this.tcSystem.getGemFireHealth().getHealth();
    }
}

