/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.CacheServer;
import com.gemstone.gemfire.admin.CacheServerConfig;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributionLocatorConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.internal.DistributedSystemConfigImpl;
import com.gemstone.gemfire.admin.internal.ManagedEntityConfigXmlGenerator;
import com.gemstone.gemfire.admin.internal.ManagedEntityControllerFactory;
import com.gemstone.gemfire.admin.jmx.JMXAdminDistributedSystem;
import com.gemstone.gemfire.admin.jmx.JMXHelper;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class CoLocatedAgentDUnitTest
extends CacheTestCase {
    private String xmlFile = null;

    public CoLocatedAgentDUnitTest(String name) {
        super(name);
    }

    DistributionConfig getDistributionConfig() {
        return this.getSystem().getConfig();
    }

    public String getEntityConfigXMLFile() {
        return this.xmlFile;
    }

    public void testRemoteAccess() throws Exception {
        CoLocatedAgentDUnitTest.disconnectAllFromDS();
        try {
            Host host = Host.getHost(0);
            VM vm = host.getVM(0);
            String rootName = "Root";
            vm.invoke(new CacheSerializableRunnable("Create Cache"){

                @Override
                public void run2() throws CacheException {
                    InternalDistributedSystem system = CoLocatedAgentDUnitTest.this.getSystem();
                    Cache cache = CacheFactory.create((DistributedSystem)system);
                    AttributesFactory factory = new AttributesFactory();
                    cache.createRegion("Root", factory.create());
                }
            });
            String urlString = JMXHelper.startRMIAgentNoAdmin((DistributedTestCase)this, vm);
            JMXServiceURL url = new JMXServiceURL(urlString);
            JMXConnector conn = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbs = conn.getMBeanServerConnection();
            CoLocatedAgentDUnitTest.assertNotNull((Object)mbs);
            ObjectName objectName = new ObjectName("GemFire:type=Agent");
            CoLocatedAgentDUnitTest.assertTrue((boolean)mbs.isRegistered(objectName));
            DistributionConfig dsConfig = this.getSystem().getConfig();
            CoLocatedAgentDUnitTest.disconnectFromDS();
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
            config.setMcastPort(dsConfig.getMcastPort());
            config.setMcastAddress(dsConfig.getMcastAddress().getHostName());
            config.setLocators(dsConfig.getLocators());
            JMXAdminDistributedSystem system = new JMXAdminDistributedSystem(config, mbs, conn, objectName);
            system.connect();
            CoLocatedAgentDUnitTest.assertTrue((boolean)system.waitToBeConnected(20000L));
            SystemMember[] apps = system.getSystemMemberApplications();
            CoLocatedAgentDUnitTest.assertEquals((int)1, (int)apps.length);
            SystemMember app = apps[0];
            CoLocatedAgentDUnitTest.assertTrue((boolean)app.hasCache());
            SystemMemberCache cache = app.getCache();
            Set roots = cache.getRootRegionNames();
            CoLocatedAgentDUnitTest.assertEquals((int)1, (int)roots.size());
            CoLocatedAgentDUnitTest.assertEquals((Object)"Root", roots.iterator().next());
            system.disconnect();
            system.closeRmiConnection();
            JMXHelper.stopRMIAgent(this, vm);
        }
        catch (Exception e) {
            DistributedTestCase.fail("Exception in CoLocatedAgentDUnitTest  testRemoteAcess method", e);
        }
    }

    public void testAgentWithXMLFile() throws Exception {
        if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            return;
        }
        CoLocatedAgentDUnitTest.disconnectAllFromDS();
        try {
            String hostname;
            Host host = Host.getHost(0);
            VM vm = host.getVM(0);
            DistributionConfig dsConfig = this.getSystem().getConfig();
            CoLocatedAgentDUnitTest.disconnectFromDS();
            String command = "ssh {HOST} {CMD}";
            DistributedSystemConfigImpl config = new DistributedSystemConfigImpl(dsConfig, "ssh {HOST} {CMD}");
            AdminDistributedSystem system = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
            DistributionLocatorConfig locator = system.addDistributionLocator().getConfig();
            String string = dsConfig.getLocators();
            int portStartIdx = string.indexOf(91);
            int portEndIdx = string.indexOf(93);
            int bindIdx = string.lastIndexOf(64);
            if (bindIdx < 0) {
                bindIdx = string.lastIndexOf(58);
            }
            if ((hostname = string.substring(0, bindIdx > -1 ? bindIdx : portStartIdx)).indexOf(58) >= 0) {
                bindIdx = string.lastIndexOf(64);
                hostname = string.substring(0, bindIdx > -1 ? bindIdx : portStartIdx);
            }
            String port = string.substring(portStartIdx + 1, portEndIdx);
            locator.setHost(hostname);
            locator.setPort(Integer.parseInt(port));
            CacheServerConfig server = system.addCacheServer().getConfig();
            String classpath = System.getProperty("user.dir");
            server.setClassPath(classpath);
            File file = new File(this.getUniqueName() + ".xml");
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            ManagedEntityConfigXmlGenerator.generate((AdminDistributedSystem)system, (PrintWriter)pw);
            pw.flush();
            this.xmlFile = file.getCanonicalPath();
            system.disconnect();
            String urlString = JMXHelper.startRMIAgentNoAdmin((DistributedTestCase)this, vm);
            JMXServiceURL url = new JMXServiceURL(urlString);
            JMXConnector conn = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbs = conn.getMBeanServerConnection();
            CoLocatedAgentDUnitTest.assertNotNull((Object)mbs);
            ObjectName objectName = new ObjectName("GemFire:type=Agent");
            CoLocatedAgentDUnitTest.assertTrue((boolean)mbs.isRegistered(objectName));
            config = AdminDistributedSystemFactory.defineDistributedSystem();
            config.setMcastPort(dsConfig.getMcastPort());
            config.setMcastAddress(dsConfig.getMcastAddress().getHostName());
            config.setLocators(dsConfig.getLocators());
            system = new JMXAdminDistributedSystem((DistributedSystemConfig)config, mbs, conn, objectName);
            system.connect();
            CoLocatedAgentDUnitTest.assertTrue((boolean)system.waitToBeConnected(20000L));
            CoLocatedAgentDUnitTest.assertEquals((String)"ssh {HOST} {CMD}", (String)system.getRemoteCommand());
            CacheServer[] servers = system.getCacheServers();
            CoLocatedAgentDUnitTest.assertEquals((int)1, (int)servers.length);
            CacheServerConfig serverConfig = servers[0].getConfig();
            CoLocatedAgentDUnitTest.assertEquals((String)classpath, (String)serverConfig.getClassPath());
            system.disconnect();
            ((JMXAdminDistributedSystem)system).closeRmiConnection();
            JMXHelper.stopRMIAgent(this, vm);
            vm.invoke(new SerializableRunnable("Close connection"){

                @Override
                public void run() {
                    InternalDistributedSystem system2 = InternalDistributedSystem.getAnyInstance();
                    while (system2 != null) {
                        system2.disconnect();
                        system2 = InternalDistributedSystem.getAnyInstance();
                    }
                }
            });
        }
        catch (Exception e) {
            DistributedTestCase.fail("CoLocatedAgentDUnitTest:testAgentWithXMFile test failed", e);
        }
    }
}

